/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.struts2.action.UploadedFilesAware;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.unitime.commons.Debug;
import org.unitime.commons.Email;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.backup.BackupProgress;
import org.unitime.timetable.backup.SessionBackupInterface;
import org.unitime.timetable.backup.SessionRestoreInterface;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.DataImportForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.queue.QueueItem;

@Action(value="dataImport", results={@Result(name={"display"}, type="tiles", location="dataImport.tiles"), @Result(name={"input"}, type="tiles", location="dataImport.tiles")}, interceptorRefs={@InterceptorRef(value="actionFileUpload"), @InterceptorRef(value="defaultStack")})
@TilesDefinition(name="dataImport.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Data Exchange"), @TilesPutAttribute(name="body", value="/admin/dataImport.jsp")})
public class DataImportAction
extends UniTimeAction<DataImportForm>
implements UploadedFilesAware {
    private static final long serialVersionUID = 3163553928537551939L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private String log;
    private String remove;
    private String ord;

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getRemove() {
        return this.remove;
    }

    public void setRemove(String remove) {
        this.remove = remove;
    }

    public String getOrd() {
        return this.ord;
    }

    public void setOrd(String ord) {
        this.ord = ord;
    }

    public void withUploadedFiles(List<UploadedFile> uploadedFiles) {
        if (this.form == null) {
            this.form = new DataImportForm();
        }
        if (!uploadedFiles.isEmpty()) {
            ((DataImportForm)this.form).setFile(new File(uploadedFiles.get(0).getAbsolutePath()));
            ((DataImportForm)this.form).setFileFileName(uploadedFiles.get(0).getOriginalName());
            ((DataImportForm)this.form).setFileContentType(uploadedFiles.get(0).getContentType());
        }
    }

    public String execute() throws Exception {
        WebTable table;
        if (this.form == null) {
            this.form = new DataImportForm();
            ((DataImportForm)this.form).setAddress(this.sessionContext.getUser().getEmail());
        } else if (((DataImportForm)this.form).getAddress() == null) {
            ((DataImportForm)this.form).setAddress(this.sessionContext.getUser().getEmail());
        }
        this.sessionContext.checkPermission(Right.DataExchange);
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (MSG.actionImport().equals(((DataImportForm)this.form).getOp())) {
            ((DataImportForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.getSolverServerService().getQueueProcessor().add(new ImportQueItem(session, this.sessionContext.getUser(), (DataImportForm)this.form, this.request));
            }
        }
        if (MSG.actionExport().equals(((DataImportForm)this.form).getOp())) {
            ((DataImportForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.getSolverServerService().getQueueProcessor().add(new ExportQueItem(session, this.sessionContext.getUser(), (DataImportForm)this.form, this.request));
            }
        }
        if (this.getRemove() != null) {
            this.getSolverServerService().getQueueProcessor().remove(this.getRemove());
        }
        if ((table = this.getQueueTable(this.request)) != null) {
            this.request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "dataImport.ord")));
        }
        return "display";
    }

    private WebTable getQueueTable(HttpServletRequest request) {
        WebTable.setOrder(this.sessionContext, "dataImport.ord", this.getOrd(), 1);
        String log = request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        List<QueueItem> queue = this.getSolverServerService().getQueueProcessor().getItems(null, null, "Data Exchange");
        if (queue.isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, MSG.sectionDataExchangeQueue(), "dataImport.action?ord=%%", new String[]{MSG.fieldQueueName(), MSG.fieldQueueStatus(), MSG.fieldQueueProgress(), MSG.fieldQueueOwner(), MSG.fieldQueueSession(), MSG.fieldQueueCreated(), MSG.fieldQueueStarted(), MSG.fieldQueueFinished(), MSG.fieldQueueOutput()}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 3600000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            Object name = item.name();
            if (((String)name).length() > 60) {
                name = ((String)name).substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('" + MSG.questionDeleteDataExchangeItem() + "')) document.location='dataImport.action?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine("onClick=\"document.location='dataImport.action?log=" + item.getId() + "';\"", new String[]{(String)name + (String)(delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.hasOutput() ? "<A href='" + item.getOutputLink() + "'>" + item.getOutputName().substring(item.getOutputName().lastIndexOf(46) + 1).toUpperCase() + "</A>" : ""}, new Comparable[]{Long.valueOf(item.created().getTime()), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log != null && log.equals(item.getId().toString())) {
                request.setAttribute("logname", name);
                request.setAttribute("logid", (Object)item.getId().toString());
                request.setAttribute("log", (Object)item.log());
                line.setBgColor("rgb(168,187,225)");
            }
            if (log != null || item.started() == null || item.finished() != null || !this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId())) continue;
            request.setAttribute("logname", name);
            request.setAttribute("logid", (Object)item.getId().toString());
            request.setAttribute("log", (Object)item.log());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }

    public static class ImportQueItem
    extends DataExchangeQueueItem {
        private static final long serialVersionUID = 1L;

        public ImportQueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request) {
            super(session, owner, form, request, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void executeDataExchange() throws Exception {
            try (FileInputStream fis = new FileInputStream(this.iForm.getFile());){
                if (this.iForm.getFileFileName().toLowerCase().endsWith(".dat")) {
                    SessionRestoreInterface restore = (SessionRestoreInterface)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    restore.restore(fis, this);
                } else if (this.iForm.getFileFileName().toLowerCase().endsWith(".dat.gz") || this.iForm.getFileFileName().toLowerCase().endsWith(".zdat")) {
                    SessionRestoreInterface restore = (SessionRestoreInterface)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    GZIPInputStream gzipInput = new GZIPInputStream(fis);
                    restore.restore(gzipInput, this);
                    gzipInput.close();
                } else if (this.iForm.getFileFileName().toLowerCase().endsWith(".xml.gz") || this.iForm.getFileFileName().toLowerCase().endsWith(".zxml")) {
                    GZIPInputStream gzipInput = new GZIPInputStream(fis);
                    DataExchangeHelper.importDocument(new SAXReader().read((InputStream)gzipInput), this.getOwnerId(), this);
                    gzipInput.close();
                } else if (this.iForm.getFileFileName().toLowerCase().endsWith(".zip")) {
                    ZipInputStream zipInput = new ZipInputStream(fis);
                    ZipEntry ze = null;
                    while ((ze = zipInput.getNextEntry()) != null) {
                        if (ze.isDirectory()) continue;
                        this.setStatus("Importing " + ze.getName() + "...");
                        if (ze.getName().endsWith(".dat")) {
                            SessionRestoreInterface restore = (SessionRestoreInterface)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                            restore.restore(zipInput, this);
                            continue;
                        }
                        DataExchangeHelper.importDocument(new SAXReader().read((InputStream)new NotClosingInputStream(zipInput)), this.getOwnerId(), this);
                    }
                    zipInput.close();
                } else {
                    DataExchangeHelper.importDocument(new SAXReader().read((InputStream)fis), this.getOwnerId(), this);
                }
            }
        }
    }

    public static class ExportQueItem
    extends DataExchangeQueueItem {
        private static final long serialVersionUID = 1L;

        public ExportQueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request) {
            super(session, owner, form, request, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void executeDataExchange() throws Exception {
            DataImportForm.ExportType type = this.iForm.getExportType();
            if (type == DataImportForm.ExportType.SESSION) {
                GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(this.createOutput("session", "dat.gz")));
                try {
                    SessionBackupInterface backup = (SessionBackupInterface)Class.forName(ApplicationProperty.SessionBackupInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    backup.backup(out, this, this.getSessionId());
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            Properties params = new Properties();
            type.setOptions(params);
            Document document = DataExchangeHelper.exportDocument(type.getType(), this.getSession(), params, this);
            if (document == null) {
                this.error("XML document not created: unknown reason.");
            } else {
                try (FileOutputStream fos = new FileOutputStream(this.createOutput(type.getType(), "xml"));){
                    new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
                    fos.flush();
                }
            }
        }
    }

    public static class NotClosingInputStream
    extends InputStream {
        private InputStream iParent;

        public NotClosingInputStream(InputStream in) {
            this.iParent = in;
        }

        @Override
        public int read() throws IOException {
            return this.iParent.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.iParent.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.iParent.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.iParent.available();
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static abstract class DataExchangeQueueItem
    extends QueueItem
    implements DataExchangeHelper.LogWriter,
    BackupProgress {
        private static final long serialVersionUID = 1L;
        DataImportForm iForm;
        String iUrl;
        boolean iImport;
        String iSessionName;
        String iFileName = null;

        public DataExchangeQueueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request, boolean isImport) {
            super(session, owner);
            this.iForm = (DataImportForm)form.clone();
            this.iUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            this.iImport = isImport;
            this.iSessionName = session.getAcademicTerm() + session.getAcademicYear() + session.getAcademicInitiative();
            if (this.iForm.getFile() != null) {
                this.iFileName = this.iForm.getFileFileName();
            }
        }

        @Override
        public String type() {
            return "Data Exchange";
        }

        @Override
        public String name() {
            return this.iImport ? GWT_MSG.itemImportActionName(this.iFileName) : GWT_MSG.itemExportActionName(this.iForm.getExportType().getLabel());
        }

        @Override
        public void println(String message) {
            this.log(message);
        }

        abstract void executeDataExchange() throws Exception;

        @Override
        public void info(String message) {
            super.info(message);
        }

        @Override
        public void warn(String message) {
            super.warn(message);
        }

        @Override
        public void error(String message) {
            super.error(message);
        }

        @Override
        public void setPhase(String phase, double max) {
            super.setStatus(phase, max);
        }

        @Override
        protected void execute() throws Exception {
            try {
                this.log(this.iImport ? "Importing " + this.iForm.getFileFileName() + " (" + this.iForm.getFile().length() + " bytes)..." : "Exporting " + this.iForm.getExportType().getType() + "...");
                Long start = System.currentTimeMillis();
                this.executeDataExchange();
                Long stop = System.currentTimeMillis();
                this.log((this.iImport ? "Import" : "Export") + " finished in " + new DecimalFormat("0.00").format((double)(stop - start) / 1000.0) + " seconds.");
            }
            catch (Exception e) {
                this.error("Unable to " + (String)(this.iImport ? "import " + this.iForm.getFileFileName() : "export") + ": " + e.getMessage());
                Debug.error(e);
                this.setError(e);
            }
            finally {
                Progress.removeInstance((Object)this);
            }
            if (this.iForm.getEmail()) {
                String address = this.iForm.getAddress();
                if (address == null || address.isEmpty()) {
                    address = this.getOwnerEmail();
                }
                if (address != null && !address.isEmpty()) {
                    try {
                        Email mail = Email.createEmail();
                        mail.setSubject("Data " + (this.iImport ? "import" : "export") + " finished.");
                        mail.setHTML(this.log() + "<br><br>This email was automatically generated at " + this.iUrl + ", by UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                        mail.addRecipient(address, this.getOwnerName());
                        if (ApplicationProperty.EmailNotificationDataExchange.isTrue()) {
                            mail.addNotifyCC();
                        }
                        if (!this.iImport && this.hasOutput() && this.output().exists()) {
                            mail.addAttachment(this.output(), this.iSessionName + "_" + this.iForm.getExportType().getType() + "." + this.output().getName().substring(this.output().getName().lastIndexOf(46) + 1));
                        }
                        mail.send();
                    }
                    catch (Exception e) {
                        this.error("Unable to send email: " + e.getMessage());
                        Debug.error(e);
                        this.setError(e);
                    }
                }
            }
        }
    }
}

