/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable;

import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.events.EventExpirationService;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.model.SolverInfo;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LogCleaner;
import org.unitime.timetable.util.MessageLogAppender;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.queue.LocalQueueProcessor;

@Service(value="startupService")
public class StartupService
implements InitializingBean,
DisposableBean {
    private Exception iInitializationException = null;
    private MessageLogAppender iMessageLogAppender = null;

    public void afterPropertiesSet() throws Exception {
        Debug.info("******* UniTime " + Constants.getVersion() + " build on " + Constants.getReleaseDate() + " is starting up *******");
        try {
            Debug.info(" - Initializing Hibernate ... ");
            HibernateUtil.initialize();
            ApplicationConfig.configureLogging();
            Debug.info(" - Creating Message Log Appender ... ");
            this.iMessageLogAppender = new MessageLogAppender();
            LoggerContext ctx = LoggerContext.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            config.addAppender((Appender)this.iMessageLogAppender);
            config.getRootLogger().addAppender((Appender)this.iMessageLogAppender, this.iMessageLogAppender.getMinLevel(), null);
            ctx.updateLoggers();
            this.iMessageLogAppender.start();
            if (RoomAvailability.getInstance() != null) {
                Debug.info(" - Initializing Room Availability Service ... ");
                RoomAvailability.getInstance().startService();
            }
            StudentSectioningPref.updateStudentSectioningPreferences();
            Debug.info(" - Cleaning Logs ...");
            LogCleaner.cleanupLogs();
            Debug.info(" - Starting Event Expiration Service ...");
            EventExpirationService.getInstance().start();
            Debug.info("******* UniTime " + Constants.getVersion() + " build on " + Constants.getReleaseDate() + " initialized successfully *******");
        }
        catch (Exception e) {
            Debug.error("UniTime Initialization Failed : " + e.getMessage(), e);
            this.iInitializationException = e;
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    public Exception getInitializationException() {
        return this.iInitializationException;
    }

    public void destroy() throws Exception {
        try {
            Debug.info("******* UniTime " + Constants.getVersion() + " build on " + Constants.getReleaseDate() + " is going down *******");
            Debug.info(" - Stopping Event Expiration Service ...");
            EventExpirationService.getInstance().interrupt();
            SolverInfo.stopInfoCacheCleanup();
            ApplicationProperties.stopListener();
            if (RoomAvailability.getInstance() != null) {
                Debug.info(" - Stopping Room Availability Service ... ");
                RoomAvailability.getInstance().stopService();
            }
            LocalQueueProcessor.stopProcessor();
            Debug.info(" - Removing Message Log Appender ... ");
            LoggerContext ctx = LoggerContext.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            config.getRootLogger().removeAppender("message-log");
            ctx.updateLoggers();
            this.iMessageLogAppender.stop();
            Debug.info(" - Closing Hibernate ... ");
            HibernateUtil.closeHibernate();
            Debug.info("******* UniTime " + Constants.getVersion() + " shut down successfully *******");
        }
        catch (Exception e) {
            Debug.error("UniTime Shutdown Failed : " + e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("UniTime Shutdown Failed : " + e.getMessage(), e);
        }
    }
}

