/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.localization.messages.PageNames;
import org.unitime.localization.messages.PointInTimeDataReports;
import org.unitime.localization.messages.SecurityMessages;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.resources.Constants;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.Messages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.util.Constants;

public class POHelper
extends ArrayList<Block> {
    private static final long serialVersionUID = -5644853313303107356L;
    private String iLocale;
    private Map<String, String> iPageNames;
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public POHelper(String locale, Map<String, String> pageNames) {
        this.iLocale = locale;
        this.iPageNames = pageNames;
    }

    public void readPOFile(Bundle bundle, Reader reader) throws Exception {
        Block b;
        String line;
        BufferedReader in = new BufferedReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) {
                if (lines.isEmpty()) continue;
                b = new Block(lines);
                if (bundle != null) {
                    b.setPrefix(bundle.getPrefix());
                }
                if (!b.isEmpty()) {
                    this.add(b);
                }
                lines.clear();
                continue;
            }
            lines.add(line);
        }
        if (!lines.isEmpty()) {
            b = new Block(lines);
            if (bundle != null) {
                b.setPrefix(bundle.getPrefix());
            }
            if (!b.isEmpty()) {
                this.add(b);
            }
        }
        in.close();
    }

    public void readProperties(Bundle bundle, File sources, String locale) throws Exception {
        Properties properties = new Properties();
        File f = new File(sources, bundle.getClazz().getName().replace('.', '/') + "_" + locale + ".properties");
        if (f.exists()) {
            properties.load(new FileReader(f));
        }
        Properties enUK = new Properties();
        f = new File(sources, bundle.getClazz().getName().replace('.', '/') + "_en_UK.properties");
        if (f.exists()) {
            enUK.load(new FileReader(f));
        }
        if (PageNames.class.equals((Object)bundle.getClazz())) {
            for (String prop : new TreeSet<String>(this.iPageNames.keySet())) {
                String name = this.iPageNames.get(prop);
                String text = properties.getProperty(prop);
                if ("en".equals(locale) && text == null) {
                    text = name;
                }
                this.add(new Block(bundle.getPrefix() + ":" + prop, name, text));
            }
        }
        for (Method method : bundle.getClazz().getMethods()) {
            boolean doNotTranslate;
            Constants.DefaultStringMapValue dsm;
            Constants.DefaultStringArrayValue dsa;
            Constants.DefaultStringValue ds;
            Constants.DefaultIntValue di;
            Constants.DefaultFloatValue df;
            Constants.DefaultDoubleValue dd;
            Constants.DefaultBooleanValue db;
            String text = properties.getProperty(method.getName());
            String altValue = enUK.getProperty(method.getName());
            String value = null;
            Messages.DefaultMessage dm = method.getAnnotation(Messages.DefaultMessage.class);
            if (dm != null) {
                value = dm.value();
            }
            if ((db = method.getAnnotation(Constants.DefaultBooleanValue.class)) != null) {
                String string = value = db.value() ? "true" : "false";
            }
            if ((dd = method.getAnnotation(Constants.DefaultDoubleValue.class)) != null) {
                value = String.valueOf(dd.value());
            }
            if ((df = method.getAnnotation(Constants.DefaultFloatValue.class)) != null) {
                value = String.valueOf(df.value());
            }
            if ((di = method.getAnnotation(Constants.DefaultIntValue.class)) != null) {
                value = String.valueOf(di.value());
            }
            if ((ds = method.getAnnotation(Constants.DefaultStringValue.class)) != null) {
                value = ds.value();
            }
            if ((dsa = method.getAnnotation(Constants.DefaultStringArrayValue.class)) != null) {
                value = POHelper.array2string(dsa.value());
            }
            if ((dsm = method.getAnnotation(Constants.DefaultStringMapValue.class)) != null) {
                value = POHelper.array2string(dsm.value());
            }
            if ("translateMessage".equals(method.getName())) continue;
            boolean bl = doNotTranslate = method.getAnnotation(Messages.DoNotTranslate.class) != null || method.getAnnotation(Constants.DoNotTranslate.class) != null;
            if (doNotTranslate) {
                if (text == null || text.equals(value)) continue;
                System.err.println("       [" + locale + "] @DoNotTranslate " + bundle.getPrefix() + ":" + method.getName());
                continue;
            }
            if ("en".equals(locale) && text == null) {
                text = value;
            } else if (!(bundle != Bundle.GWTConst && bundle != Bundle.StudentConst || text != null || altValue == null || locale.equals("ar"))) {
                text = altValue;
            }
            Block b = new Block(bundle.getPrefix() + ":" + method.getName(), value, text);
            this.add(b);
        }
    }

    public void readPropertiesFile(Bundle bundle, File file) throws Exception {
        Block b;
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) {
                if (lines.isEmpty()) continue;
                b = new Block(lines);
                if (bundle != null) {
                    b.setPrefix(bundle.getPrefix());
                }
                if (!b.isEmpty()) {
                    this.add(b);
                }
                lines.clear();
                continue;
            }
            lines.add(line);
        }
        if (!lines.isEmpty()) {
            b = new Block(lines);
            if (bundle != null) {
                b.setPrefix(bundle.getPrefix());
            }
            if (!b.isEmpty()) {
                this.add(b);
            }
        }
        in.close();
    }

    public boolean has(Bundle bundle, String method) {
        return this.contains(new Block(bundle.getPrefix() + ":" + method, null, null));
    }

    public String translate(Bundle bundle, String method) {
        String msgctxt = bundle.getPrefix() + ":" + method;
        for (Block b : this) {
            if (!msgctxt.equals(b.msgctxt)) continue;
            return b.msgstr;
        }
        return null;
    }

    public List<Block> getBlocks(Bundle bundle) {
        ArrayList<Block> ret = new ArrayList<Block>();
        for (Block b : this) {
            if (!bundle.getPrefix().equals(b.getPrefix())) continue;
            ret.add(b);
        }
        Collections.sort(ret);
        return ret;
    }

    public void writePropertiesFile(File sources, Bundle bundle) throws Exception {
        Class clazz = bundle.getClazz();
        File folder = new File(sources, clazz.getName().substring(0, clazz.getName().lastIndexOf(46)).replace('.', File.separatorChar));
        File output = new File(folder, clazz.getSimpleName() + "_" + this.iLocale + ".properties");
        Properties old = new Properties();
        if (output.exists()) {
            old.load(new FileReader(output));
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Method method : clazz.getMethods()) {
            boolean doNotTranslate;
            Constants.DefaultStringMapValue dsm;
            Constants.DefaultStringArrayValue dsa;
            Constants.DefaultStringValue ds;
            Constants.DefaultIntValue di;
            Constants.DefaultFloatValue df;
            Constants.DefaultDoubleValue dd;
            Constants.DefaultBooleanValue db;
            String text = old.getProperty(method.getName());
            String value = null;
            Messages.DefaultMessage dm = method.getAnnotation(Messages.DefaultMessage.class);
            if (dm != null) {
                value = dm.value();
            }
            if ((db = method.getAnnotation(Constants.DefaultBooleanValue.class)) != null) {
                String string = value = db.value() ? "true" : "false";
            }
            if ((dd = method.getAnnotation(Constants.DefaultDoubleValue.class)) != null) {
                value = String.valueOf(dd.value());
            }
            if ((df = method.getAnnotation(Constants.DefaultFloatValue.class)) != null) {
                value = String.valueOf(df.value());
            }
            if ((di = method.getAnnotation(Constants.DefaultIntValue.class)) != null) {
                value = String.valueOf(di.value());
            }
            if ((ds = method.getAnnotation(Constants.DefaultStringValue.class)) != null) {
                value = ds.value();
            }
            if ((dsa = method.getAnnotation(Constants.DefaultStringArrayValue.class)) != null) {
                value = POHelper.array2string(dsa.value());
            }
            if ((dsm = method.getAnnotation(Constants.DefaultStringMapValue.class)) != null) {
                value = POHelper.array2string(dsm.value());
            }
            if ("translateMessage".equals(method.getName())) continue;
            String translated = this.translate(bundle, method.getName());
            boolean bl = doNotTranslate = method.getAnnotation(Messages.DoNotTranslate.class) != null || method.getAnnotation(Constants.DoNotTranslate.class) != null;
            if (doNotTranslate && translated == null && text != null) {
                translated = text;
            }
            if (text == null && translated == null) continue;
            blocks.add(new Block(bundle.getPrefix() + ":" + method.getName(), value, translated));
        }
        if (PageNames.class.equals((Object)clazz)) {
            for (String prop : new TreeSet<String>(this.iPageNames.keySet())) {
                String name = this.iPageNames.get(prop);
                String text = old.getProperty(prop);
                String translated = this.translate(bundle, prop);
                if (text == null && translated == null) continue;
                blocks.add(new Block(bundle.getPrefix() + ":" + prop, name, translated));
            }
        }
        Collections.sort(blocks);
        PrintStream out = new PrintStream(output);
        out.println("# Licensed to The Apereo Foundation under one or more contributor license");
        out.println("# agreements. See the NOTICE file distributed with this work for");
        out.println("# additional information regarding copyright ownership.");
        out.println("#");
        out.println("# The Apereo Foundation licenses this file to you under the Apache License,");
        out.println("# Version 2.0 (the \"License\"); you may not use this file except in");
        out.println("# compliance with the License. You may obtain a copy of the License at:");
        out.println("#");
        out.println("# http://www.apache.org/licenses/LICENSE-2.0");
        out.println("#");
        out.println("# Unless required by applicable law or agreed to in writing, software");
        out.println("# distributed under the License is distributed on an \"AS IS\" BASIS,");
        out.println("# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        out.println("#");
        out.println("# See the License for the specific language governing permissions and");
        out.println("# limitations under the License.");
        out.println("#");
        boolean empty = true;
        for (Block b : blocks) {
            if (b.getTranslation() == null && !old.containsKey(b.getMethod())) continue;
            out.println();
            if (b.getDefaultText() != null) {
                out.println("# Default: " + POHelper.unicodeEscape(b.getDefaultText(), false, false).trim());
            }
            if (b.getTranslation() == null) {
                if (b.getDefaultText() != null) {
                    out.println("# FIXME: Translate \"" + POHelper.unicodeEscape(b.getDefaultText(), false, true) + "\"");
                } else {
                    out.println("# FIXME: Translate " + b.getMethod());
                }
                out.println("# " + b.getMethod() + "=");
                continue;
            }
            out.println(b.getMethod() + "=" + POHelper.unicodeEscape(b.getTranslation(), true, true));
            empty = false;
        }
        if (empty) {
            output.delete();
        }
        out.flush();
        out.close();
    }

    public void writePOFile(File file) throws IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        out.println("msgid \"\"");
        out.println("msgstr \"\"");
        out.println("\"MIME-Version: 1.0\\n\"");
        out.println("\"Content-Transfer-Encoding: 8bit\\n\"");
        out.println("\"Content-Type: text/plain; charset=UTF-8\\n\"");
        out.println("\"PO-Revision-Date: " + new Date() + "\\n\"");
        out.println("\"Language: " + this.iLocale + "\\n\"");
        out.println("\"X-Generator: UniTime " + Constants.VERSION + "\\n\"");
        for (Block block : this) {
            block.print(out);
        }
        out.flush();
        out.close();
    }

    public void writePOTFile(File file) throws IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        out.println("msgid \"\"");
        out.println("msgstr \"\"");
        out.println("\"MIME-Version: 1.0\\n\"");
        out.println("\"Content-Transfer-Encoding: 8bit\\n\"");
        out.println("\"Content-Type: text/plain; charset=UTF-8\\n\"");
        out.println("\"PO-Revision-Date: " + new Date() + "\\n\"");
        out.println("\"Language: " + this.iLocale + "\\n\"");
        out.println("\"X-Generator: UniTime " + Constants.VERSION + "\\n\"");
        for (Block block : this) {
            block.printPOT(out);
        }
        out.flush();
        out.close();
    }

    private static String array2string(String[] value) {
        Object ret = "";
        for (String s : value) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + ",";
            }
            ret = (String)ret + s.replace(",", "\\,");
        }
        return ret;
    }

    private static String unicodeEscape(String s, boolean includeColon, boolean spaces) {
        StringBuilder sb = new StringBuilder();
        boolean allspace = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (spaces && c == ' ' && allspace) {
                sb.append("\\");
            } else {
                allspace = false;
            }
            if (spaces && c == ' ' && s.substring(i).trim().isEmpty()) {
                sb.append("\\");
            }
            if (c >> 7 > 0) {
                sb.append("\\u");
                sb.append(hexChar[c >> 12 & 0xF]);
                sb.append(hexChar[c >> 8 & 0xF]);
                sb.append(hexChar[c >> 4 & 0xF]);
                sb.append(hexChar[c & 0xF]);
                continue;
            }
            if (c == ':' && includeColon) {
                sb.append("\\:");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\\' && i + 1 < s.length() && s.charAt(1 + i) == ',' && includeColon) {
                sb.append("\\\\");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void print(PrintWriter out, String tag, String text) {
        if (text == null) {
            out.println(tag + " \"\"");
            return;
        }
        if (text.indexOf(10) >= 0) {
            String[] t = text.split("\n");
            for (int i = 0; i < t.length; ++i) {
                out.println((String)(i == 0 ? tag + " " : "") + "\"" + t[i].replace("\"", "\\\"") + (i + 1 < t.length ? "\\n" : "") + "\"");
            }
        } else {
            out.println(tag + " \"" + text.replace("\"", "\\\"") + "\"");
        }
    }

    public static class Block
    implements Comparable<Block> {
        String msgctxt;
        String msgid;
        String msgstr;
        boolean dnt = false;
        boolean fuzzy = false;

        public Block(String msgctxt, String msgid, String msgstr) {
            this.msgctxt = msgctxt;
            this.msgid = msgid;
            this.msgstr = msgstr;
        }

        public Block(List<String> lines) {
            int tag = -1;
            for (String line : lines) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("msgctxt ")) {
                    line = line.substring("msgctxt ".length());
                    tag = 0;
                } else if (line.startsWith("msgid ")) {
                    line = line.substring("msgid ".length());
                    tag = 1;
                } else if (line.startsWith("msgstr ")) {
                    line = line.substring("msgstr ".length());
                    tag = 2;
                }
                if (!line.startsWith("\"") || !line.endsWith("\"") || tag < 0) continue;
                line = line.substring(1, line.length() - 1);
                line = line.replace("\\\\", "\\");
                line = line.replace("\\ ", " ");
                line = line.replace("\\\\\"", "\\\"");
                switch (tag) {
                    case 0: {
                        if (this.msgctxt == null) {
                            this.msgctxt = line;
                            break;
                        }
                        this.msgctxt = this.msgctxt + line;
                        break;
                    }
                    case 1: {
                        if (this.msgid == null) {
                            this.msgid = line;
                            break;
                        }
                        this.msgid = this.msgid + line;
                        break;
                    }
                    case 2: {
                        this.msgstr = this.msgstr == null ? line : this.msgstr + line;
                    }
                }
            }
            if (!this.isEmpty() && !"".equals(this.msgid) && "".equals(this.msgstr)) {
                this.msgstr = null;
            }
        }

        public boolean isEmpty() {
            return this.msgctxt == null || this.msgctxt.indexOf(58) < 0;
        }

        public boolean hasMessage() {
            if (this.isEmpty()) {
                return false;
            }
            if (this.msgstr != null && !this.msgstr.isEmpty()) {
                return true;
            }
            return this.msgid == null || this.msgid.isEmpty();
        }

        public String getPrefix() {
            return this.msgctxt.substring(0, this.msgctxt.indexOf(58));
        }

        public String getMethod() {
            return this.msgctxt.substring(this.msgctxt.indexOf(58) + 1);
        }

        public void setPrefix(String prefix) {
            if (this.msgctxt == null || this.msgctxt.isEmpty()) {
                return;
            }
            this.msgctxt = this.msgctxt.indexOf(58) < 0 ? prefix + ":" + this.msgctxt : prefix + ":" + this.getMethod();
        }

        public String getDefaultText() {
            return this.msgid;
        }

        public String getTranslation() {
            return this.msgstr;
        }

        public void setTranslation(String msgstr) {
            this.msgstr = msgstr;
        }

        @Override
        public int compareTo(Block b) {
            return this.getMethod().compareTo(b.getMethod());
        }

        public String toString() {
            return this.getMethod() + "=" + this.getTranslation();
        }

        public int hashCode() {
            return this.msgctxt.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Block)) {
                return false;
            }
            return this.msgctxt.equals(((Block)o).msgctxt);
        }

        public void print(PrintWriter out) {
            out.println();
            if (this.fuzzy) {
                out.println("#, fuzzy");
            }
            if (this.dnt) {
                out.println("# \"Do Not Translate\"");
            }
            out.println("msgctxt \"" + this.msgctxt + "\"");
            POHelper.print(out, "msgid", this.msgid);
            POHelper.print(out, "msgstr", this.msgstr);
        }

        public void printPOT(PrintWriter out) {
            out.println();
            if (this.dnt) {
                out.println("# \"Do Not Translate\"");
            }
            out.println("msgctxt \"" + this.msgctxt + "\"");
            POHelper.print(out, "msgid", this.msgid);
            POHelper.print(out, "msgstr", "");
        }
    }

    public static enum Bundle {
        Constants(ConstantsMessages.class, "Constants"),
        Course(CourseMessages.class, "Course"),
        Exams(ExaminationMessages.class, "Exams"),
        Pages(PageNames.class, "Pages"),
        PIT(PointInTimeDataReports.class, "PIT"),
        Security(SecurityMessages.class, "Security"),
        GWTConst(GwtConstants.class, "GWT-Const"),
        GWT(GwtMessages.class, "GWT"),
        Aria(GwtAriaMessages.class, "Aria"),
        StudentConst(StudentSectioningConstants.class, "Student-Const"),
        Students(StudentSectioningMessages.class, "Students"),
        Solver(CPSolverMessages.class, "Solver");

        private Class iClass;
        private String iPrefix;

        private Bundle(Class clazz, String prefix) {
            this.iClass = clazz;
            this.iPrefix = prefix;
        }

        public Class getClazz() {
            return this.iClass;
        }

        public String getPrefix() {
            return this.iPrefix;
        }
    }
}

