/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WikiGet
extends Task {
    private URL iWikiUrl = null;
    private File iOutDir = null;
    private File iImgDir = null;
    private Hashtable iPages = new Hashtable();
    private Hashtable iImages = new Hashtable();
    private HashSet iRemainingPages = new HashSet();
    private HashSet iDonePages = new HashSet();
    private static String sFirstPage = "Main_Page";
    private static String sWikiPrefix = "/";
    private static String sWikiIndex = "/index.php";
    private static String sWikiImagesPrefix = "/images/";
    private static String sWikiSkinsPrefix = "/skins/";
    private static DecimalFormat sDF = new DecimalFormat("000");

    public void setOutput(String outDir) {
        this.iOutDir = new File(outDir);
        this.iOutDir.mkdirs();
        this.iImgDir = new File(this.iOutDir, "img");
        this.iImgDir.mkdirs();
    }

    public void setUrl(String wikiUrl) {
        try {
            this.iWikiUrl = new URL(wikiUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean copy(URL url, File file) {
        try {
            System.out.print("  Get: " + url + " ");
            InputStream is = url.openStream();
            file.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(file);
            byte[] buffer = new byte[16384];
            int read = 0;
            long total = 0L;
            while ((read = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, read);
                total += (long)read;
                System.out.print(".");
            }
            os.flush();
            ((OutputStream)os).close();
            is.close();
            System.out.println(" " + total + " bytes read.");
            return true;
        }
        catch (IOException ex) {
            System.out.println();
            System.err.println("Error: Unable to get " + url + ": " + ex.getMessage());
            return false;
        }
    }

    public boolean copyAndParse(URL url, File file, Parser parser) {
        try {
            System.out.println("  Get: " + url);
            BufferedReader is = new BufferedReader(new InputStreamReader(url.openStream()));
            file.getParentFile().mkdirs();
            if (file.getName().equalsIgnoreCase(".html")) {
                file = new File(file.getParentFile(), "index.html");
            }
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            String line = null;
            while ((line = is.readLine()) != null) {
                if ((line = parser.parse(line)) == null) continue;
                pw.println(line);
            }
            pw.flush();
            pw.close();
            is.close();
            return true;
        }
        catch (Exception ex) {
            System.out.println();
            System.err.println("Error: Unable to get " + url + ": " + ex.getMessage());
            return false;
        }
    }

    public void execute() throws BuildException {
        try {
            if (this.iWikiUrl == null) {
                this.setUrl("http://wiki.unitime.org");
            }
            if (this.iOutDir == null) {
                this.setOutput("." + File.separator + "wiki");
            }
            this.iRemainingPages.add(sFirstPage);
            this.copy(new URL(this.iWikiUrl.toString() + "/skins/monobook/headbg.jpg"), new File(this.iImgDir, "headbg.jpg"));
            while (!this.iRemainingPages.isEmpty()) {
                String page = (String)this.iRemainingPages.iterator().next();
                this.iRemainingPages.remove(page);
                this.iDonePages.add(page);
                System.out.println("Page: " + page);
                URL pageUrl = new URL(this.iWikiUrl.toString() + "/" + page);
                this.copyAndParse(pageUrl, new File(this.iOutDir, this.getPageFileName(page)), new PageParser(pageUrl));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    public String getPageFileName(String pageName) {
        String pageFile = (String)this.iPages.get(pageName);
        if (pageFile != null) {
            return pageFile + ".html";
        }
        pageFile = pageName.replaceAll("\\%[0-9A-F][0-9A-F]", "").replaceAll(":", "").replaceAll("/", "").replaceAll("\\\\", "");
        if (pageFile.length() > 32) {
            pageFile = pageFile.substring(0, 32);
        }
        int idx = 0;
        while (this.iPages.values().contains(pageFile + (idx == 0 ? "" : sDF.format(idx)))) {
            ++idx;
        }
        this.iPages.put(pageName, pageFile + (idx == 0 ? "" : sDF.format(idx)));
        return pageFile + (idx == 0 ? "" : sDF.format(idx)) + ".html";
    }

    public void addPage(String page) {
        if (!this.iDonePages.contains(page)) {
            this.iRemainingPages.add(page);
        }
    }

    public String getImageFileName(URL image) {
        String ext;
        Object imageFile = (String)this.iImages.get(image);
        if (imageFile != null) {
            return imageFile;
        }
        String imageName = new File(image.getFile()).getName();
        String string = ext = imageName.lastIndexOf(46) > 0 ? imageName.substring(imageName.lastIndexOf(46) + 1) : null;
        if (ext != null) {
            if (ext.indexOf(63) > 0) {
                ext = ext.substring(0, ext.indexOf(63));
            }
            if (ext.length() > 10 || ext.indexOf(58) >= 0 || ext.indexOf(37) >= 0 || ext.indexOf(92) >= 0 || ext.indexOf(47) >= 0) {
                imageFile = imageName;
                ext = null;
            } else {
                imageFile = imageName.substring(0, imageName.lastIndexOf(46));
            }
        } else {
            imageFile = imageName;
        }
        imageFile = ((String)imageFile).replaceAll("\\%[0-9A-F][0-9A-F]", "").replaceAll(":", "").replaceAll("/", "").replaceAll("\\\\", "");
        if (((String)imageFile).length() > 32) {
            imageFile = ((String)imageFile).substring(0, 32);
        }
        int idx = 0;
        while (this.iImages.values().contains((String)imageFile + (idx == 0 ? "" : sDF.format(idx)) + (String)(ext == null ? "" : "." + ext))) {
            ++idx;
        }
        imageFile = (String)imageFile + (idx == 0 ? "" : sDF.format(idx)) + (String)(ext == null ? "" : "." + ext);
        this.iImages.put(image, imageFile);
        return imageFile;
    }

    public static String replace(String source, String substring, String newsubstring) {
        int idx = -1;
        int len1 = substring.length();
        int len2 = newsubstring.length();
        StringBuffer sb = new StringBuffer(source);
        while ((idx = sb.toString().indexOf(substring, idx)) >= 0) {
            sb.replace(idx, idx + len1, newsubstring);
            idx += len2;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            WikiGet wg = new WikiGet();
            if (args.length >= 1) {
                wg.setUrl(args[0]);
            }
            if (args.length >= 2) {
                wg.setOutput(args[1]);
            }
            wg.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Parser {
        public String parse(String var1) throws Exception;
    }

    private class PageParser
    implements Parser {
        private URL iURL = null;

        public PageParser(URL url) {
            this.iURL = url;
        }

        private String get(String imageName) {
            try {
                URL imageUrl = null;
                try {
                    imageUrl = new URL(this.iURL, imageName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                if (imageUrl.getHost().equals(WikiGet.this.iWikiUrl.getHost()) && imageUrl.getPath().startsWith(sWikiPrefix) && !imageUrl.getPath().startsWith(sWikiImagesPrefix) && !imageUrl.getPath().startsWith(sWikiSkinsPrefix)) {
                    if (imageUrl.getPath().startsWith(sWikiIndex)) {
                        File imageFile;
                        Object title;
                        int titleIdx;
                        if (imageUrl.getFile().indexOf("gen=js") > 0 && imageUrl.getFile().indexOf("title=") > 0) {
                            titleIdx = imageUrl.getFile().indexOf("title=") + "title=".length();
                            title = imageUrl.getFile().substring(titleIdx, imageUrl.getFile().indexOf(38, titleIdx));
                            if ("-".equals(title)) {
                                title = "site";
                            }
                            if (!((String)title).endsWith(".js")) {
                                title = (String)title + ".js";
                            }
                            if (((String)title).startsWith("MediaWiki:")) {
                                title = ((String)title).substring("MediaWiki:".length());
                            }
                            if ((imageFile = new File(WikiGet.this.iImgDir, (String)title)).exists() || WikiGet.this.copy(new URL(imageUrl.toString().replaceAll("&amp;", "&")), imageFile)) {
                                return WikiGet.this.iImgDir.getName() + "/" + imageFile.getName();
                            }
                        }
                        if ((imageUrl.getFile().indexOf("gen=css") > 0 || imageUrl.getFile().indexOf("action=raw&ctype=text/css") > 0) && imageUrl.getFile().indexOf("title=") > 0) {
                            titleIdx = imageUrl.getFile().indexOf("title=") + "title=".length();
                            title = imageUrl.getFile().substring(titleIdx, imageUrl.getFile().indexOf(38, titleIdx));
                            if ("-".equals(title)) {
                                title = "site";
                            }
                            if (!((String)title).endsWith(".css")) {
                                title = (String)title + ".css";
                            }
                            if (((String)title).startsWith("MediaWiki:")) {
                                title = ((String)title).substring("MediaWiki:".length());
                            }
                            if ((imageFile = new File(WikiGet.this.iImgDir, (String)title)).exists() || WikiGet.this.copy(new URL(imageUrl.toString().replaceAll("&amp;", "&")), imageFile)) {
                                return WikiGet.this.iImgDir.getName() + "/" + imageFile.getName();
                            }
                        }
                        return imageUrl.toString();
                    }
                    String pageName = imageUrl.getPath().substring(sWikiPrefix.length());
                    if (pageName.startsWith("Special:") || pageName.startsWith("User:") || pageName.startsWith("UniTime:")) {
                        return imageUrl.toString();
                    }
                    WikiGet.this.addPage(pageName);
                    return WikiGet.this.getPageFileName(pageName);
                }
                if ("mailto".equalsIgnoreCase(imageUrl.getProtocol())) {
                    return imageName;
                }
                if (!WikiGet.this.iWikiUrl.getHost().equals(imageUrl.getHost())) {
                    return imageUrl.toString();
                }
                if (!imageUrl.getFile().startsWith(sWikiPrefix)) {
                    return imageUrl.toString();
                }
                File imageFile = new File(WikiGet.this.iImgDir, WikiGet.this.getImageFileName(imageUrl));
                if (imageFile.exists()) {
                    return WikiGet.this.iImgDir.getName() + "/" + imageFile.getName();
                }
                if (imageName.toUpperCase().endsWith(".HTML") || imageName.toUpperCase().endsWith(".HTM") ? !WikiGet.this.copyAndParse(imageUrl, imageFile, new PageParser(imageUrl)) : !WikiGet.this.copy(imageUrl, imageFile)) {
                    return imageUrl.toString();
                }
                return WikiGet.this.iImgDir.getName() + "/" + imageFile.getName();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String check(String line, String prefix, String sufix) {
            int pos = -1;
            while ((pos = ((String)line).indexOf(prefix, pos + 1)) >= 0) {
                String imageNameTr;
                int endIdx;
                int begIdx = pos + prefix.length();
                String imageName = ((String)line).substring(begIdx, endIdx = ((String)line).indexOf(sufix, begIdx));
                if (imageName.startsWith("#") || imageName.startsWith("&amp;") || (imageNameTr = this.get(imageName)) == null) continue;
                line = ((String)line).substring(0, begIdx) + imageNameTr + ((String)line).substring(endIdx);
            }
            return line;
        }

        @Override
        public String parse(String line) throws Exception {
            line = this.check(line, "src=\"", "\"");
            line = this.check(line, "src='", "'");
            line = this.check(line, "href=\"", "\"");
            line = this.check(line, "href='", "'");
            line = this.check(line, "url(\"", "\"");
            line = this.check(line, "url('", "'");
            line = this.check(line, "url(", ")");
            line = this.check(line, "@import \"", "\"");
            line = this.check(line, "@import '", "'");
            return line;
        }
    }
}

