/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CreateBaseModelFromXml
extends Task {
    private Hashtable<String, String> iParent = new Hashtable();
    private Set<String> iAbstracts = new HashSet<String>();
    private Hashtable<String, String[]> iIds = new Hashtable();
    private Hashtable<String, String> iRelations = new Hashtable();
    private Hashtable<String, TreeSet<String>> iClassProperties = new Hashtable();
    private SAXReader iSAXReader = null;
    private String iSource = null;
    private String iConfig = "hibernate.cfg.xml";
    private EntityResolver iEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId.equals("-//Hibernate/Hibernate Mapping DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
            }
            if (publicId.equals("-//Hibernate/Hibernate Configuration DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
            }
            return null;
        }
    };

    public CreateBaseModelFromXml() throws DocumentException {
        this.iSAXReader = new SAXReader();
        this.iSAXReader.setEntityResolver(this.iEntityResolver);
    }

    public void setSource(String source) {
        this.iSource = source;
    }

    public void setConfig(String config) {
        this.iConfig = config;
    }

    protected Document read(String resource) throws IOException, DocumentException {
        if (this.iSource == null) {
            return this.iSAXReader.read(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource));
        }
        return this.iSAXReader.read(new File(this.iSource + File.separator + resource));
    }

    public void convert() throws IOException, DocumentException {
        Element classEl;
        Iterator j;
        String pkg;
        Element resRoot;
        Document resDoc;
        this.info("Config: " + (Serializable)(this.iSource == null ? ((Object)((Object)this)).getClass().getClassLoader().getResource(this.iConfig) : this.iSource + File.separator + this.iConfig));
        File workDir = null;
        if (this.iSource == null) {
            workDir = new File(((Object)((Object)this)).getClass().getClassLoader().getResource(this.iConfig).getFile());
            while (workDir.getParentFile() != null && !"WebContent".equals(workDir.getName())) {
                workDir = workDir.getParentFile();
            }
            workDir = new File(workDir.getParentFile(), "JavaSource");
            workDir.mkdirs();
        } else {
            workDir = new File(this.iSource);
        }
        this.info("Working directory: " + workDir);
        this.info("Reading *.hbm.xml ...");
        for (String resource : workDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".hbm.xml");
            }
        })) {
            this.info("Pre-processing " + resource + " ...");
            resDoc = this.read(resource);
            resRoot = resDoc.getRootElement();
            pkg = resRoot.attributeValue("package");
            j = resRoot.elementIterator("class");
            while (j.hasNext()) {
                classEl = (Element)j.next();
                this.preprocess(classEl, null, pkg);
            }
        }
        for (String resource : workDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".hbm.xml");
            }
        })) {
            this.info("Processing " + resource + " ...");
            resDoc = this.read(resource);
            resRoot = resDoc.getRootElement();
            pkg = resRoot.attributeValue("package");
            j = resRoot.elementIterator("class");
            while (j.hasNext()) {
                classEl = (Element)j.next();
                this.importClass(classEl, pkg, workDir, null, null, null, null);
            }
        }
        this.info("All done.");
    }

    private void preprocess(Element classEl, String ext, String pkg) throws IOException {
        String column;
        String name;
        Element setEl;
        Element idEl;
        String className = this.fixType(classEl.attributeValue("name"), pkg);
        if (className.indexOf(46) >= 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        if (ext != null) {
            this.iParent.put(className, ext);
        }
        if ("true".equals(classEl.attributeValue("abstract", "false"))) {
            this.iAbstracts.add(className);
        }
        if ((idEl = classEl.element("id")) != null) {
            String type = this.fixType(idEl.attributeValue("type"), pkg);
            String name2 = this.fixName(idEl.attributeValue("name"));
            this.iIds.put(className, new String[]{type, name2});
        }
        Iterator i = classEl.elementIterator("set");
        while (i.hasNext()) {
            setEl = (Element)i.next();
            if (setEl.element("many-to-many") == null) continue;
            name = setEl.attributeValue("name");
            column = setEl.element("key").attributeValue("column");
            String clazz = this.fixType(setEl.element("many-to-many").attributeValue("class"), pkg);
            clazz = clazz.substring(clazz.lastIndexOf(46) + 1);
            this.info("  set: " + clazz + "." + column + ":" + name);
            this.iRelations.put(clazz + "." + column, name);
        }
        i = classEl.elementIterator("many-to-one");
        while (i.hasNext()) {
            setEl = (Element)i.next();
            name = setEl.attributeValue("name");
            column = setEl.attributeValue("column");
            this.info("  many-to-one: " + className + "." + column + ":" + name);
            this.iRelations.put(className + "." + column, name);
        }
        i = classEl.elementIterator("composite-id");
        while (i.hasNext()) {
            Element cidEl = (Element)i.next();
            Iterator j = cidEl.elementIterator("key-many-to-one");
            while (j.hasNext()) {
                Element setEl2 = (Element)j.next();
                String name3 = setEl2.attributeValue("name");
                String column2 = setEl2.attributeValue("column");
                this.info("  many-to-one: " + className + "." + column2 + ":" + name3);
                this.iRelations.put(className + "." + column2, name3);
            }
        }
        i = classEl.elementIterator("union-subclass");
        while (i.hasNext()) {
            this.preprocess((Element)i.next(), className, pkg);
        }
        i = classEl.elementIterator("subclass");
        while (i.hasNext()) {
            this.preprocess((Element)i.next(), className, pkg);
        }
    }

    private String fixType(String type, String pkg) {
        if (type == null) {
            return null;
        }
        if (((String)type).startsWith("java.lang.")) {
            return ((String)type).substring("java.lang.".length());
        }
        if ("byte[]".equals(type)) {
            return type;
        }
        if (((String)type).indexOf(46) < 0) {
            type = ((String)type).substring(0, 1).toUpperCase() + ((String)type).substring(1);
        }
        if ("Boolean".equals(type)) {
            return type;
        }
        if ("Long".equals(type)) {
            return type;
        }
        if ("Integer".equals(type)) {
            return type;
        }
        if ("String".equals(type)) {
            return type;
        }
        if ("Float".equals(type)) {
            return type;
        }
        if ("Double".equals(type)) {
            return type;
        }
        if (((String)type).equals("java.sql.Date")) {
            return "java.util.Date";
        }
        if (((String)type).equalsIgnoreCase("java.sql.TimeStamp")) {
            return "java.util.Date";
        }
        if (((String)type).endsWith(".XmlBlobType")) {
            return "org.dom4j.Document";
        }
        if (((String)type).endsWith(".XmlClobType")) {
            return "org.dom4j.Document";
        }
        if (((String)type).startsWith("java.")) {
            return type;
        }
        if (((String)type).indexOf(46) < 0) {
            type = pkg + "." + (String)type;
        }
        return type;
    }

    private String fixName(String name) {
        if (name == null) {
            return null;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private File fileFromPackage(File outputFolder, String pkg) {
        File ret = new File(outputFolder, pkg.replace('.', File.separatorChar));
        ret.mkdirs();
        return ret;
    }

    private void license(PrintWriter pw) {
        pw.println("/*");
        pw.println(" * Licensed to The Apereo Foundation under one or more contributor license");
        pw.println(" * agreements. See the NOTICE file distributed with this work for");
        pw.println(" * additional information regarding copyright ownership.");
        pw.println(" *");
        pw.println(" * The Apereo Foundation licenses this file to you under the Apache License,");
        pw.println(" * Version 2.0 (the \"License\"); you may not use this file except in");
        pw.println(" * compliance with the License. You may obtain a copy of the License at:");
        pw.println(" *");
        pw.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        pw.println(" *");
        pw.println(" * Unless required by applicable law or agreed to in writing, software");
        pw.println(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
        pw.println(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        pw.println(" *");
        pw.println(" * See the License for the specific language governing permissions and");
        pw.println(" * limitations under the License.");
        pw.println(" * ");
        pw.println("*/");
    }

    private String annotation(String name, String ... args) {
        String ret = "\t@" + name;
        int i = 0;
        for (String arg : args) {
            if (arg == null || arg.isEmpty()) continue;
            ret = ret + (i == 0 ? "(" : ", ");
            ret = ret + arg;
            ++i;
        }
        if (i > 0) {
            ret = ret + ")";
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private void importClass(Element classEl, String pkg, File outputFolder, String ext, String idClass, String idName, String idType) throws IOException {
        Object x;
        String column;
        Iterator j;
        String name;
        String type;
        Element el;
        Element discriminator;
        String className = this.fixType(classEl.attributeValue("name"), pkg);
        String table = classEl.attributeValue("table");
        StringWriter attributes = new StringWriter();
        PrintWriter pwa = new PrintWriter(attributes);
        StringWriter body = new StringWriter();
        PrintWriter pwb = new PrintWriter(body);
        StringWriter header = new StringWriter();
        PrintWriter pwh = new PrintWriter(header);
        TreeSet<String> imports = new TreeSet<String>();
        StringWriter mainHeader = new StringWriter();
        PrintWriter pwmh = new PrintWriter(mainHeader);
        TreeSet<String> mainImports = new TreeSet<String>();
        if (className.indexOf(46) >= 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        this.info("  " + className + " ...");
        Vector<String[]> manyToOnes = new Vector<String[]>();
        TreeSet<String> properties = new TreeSet<String>();
        Vector<String[]> compositeId = new Vector<String[]>();
        imports.add("jakarta.persistence.MappedSuperclass");
        pwh.println("@MappedSuperclass");
        mainImports.add("jakarta.persistence.Entity");
        pwmh.println("@Entity");
        if (ext == null) {
            mainImports.add("org.hibernate.annotations.Cache");
            mainImports.add("org.hibernate.annotations.CacheConcurrencyStrategy");
            pwmh.println("@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)");
        }
        if (table != null) {
            mainImports.add("jakarta.persistence.Table");
            pwmh.println("@Table(name = \"" + table + "\")");
        }
        if ((discriminator = classEl.element("discriminator")) != null) {
            String column2 = discriminator.attributeValue("column").toLowerCase();
            String type2 = this.fixType(discriminator.attributeValue("type"), pkg);
            if (type2.indexOf(46) >= 0) {
                imports.add(type2);
                type2 = type2.substring(type2.lastIndexOf(46) + 1);
            }
            mainImports.add("jakarta.persistence.Inheritance");
            mainImports.add("jakarta.persistence.InheritanceType");
            mainImports.add("jakarta.persistence.DiscriminatorColumn");
            mainImports.add("jakarta.persistence.DiscriminatorType");
            pwmh.println("@Inheritance(strategy = InheritanceType.SINGLE_TABLE)");
            pwmh.println("@DiscriminatorColumn(name=\"" + column2 + "\", discriminatorType = DiscriminatorType." + type2.toUpperCase() + ")");
        } else {
            String discriminatorValue = classEl.attributeValue("discriminator-value");
            if (discriminatorValue != null) {
                mainImports.add("jakarta.persistence.DiscriminatorValue");
                pwmh.println("@DiscriminatorValue(\"" + discriminatorValue + "\")");
            }
        }
        boolean constructor = true;
        boolean hashCode = true;
        boolean equals = true;
        boolean serializable = true;
        boolean hasProperty = false;
        Iterator i = classEl.elementIterator("id");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = this.fixType(el.attributeValue("type"), pkg);
            if (type.indexOf(46) >= 0) {
                imports.add(type);
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            name = this.fixName(el.attributeValue("name"));
            String column3 = el.attributeValue("column").toLowerCase();
            Object attribute = name.substring(0, 1).toLowerCase() + name.substring(1);
            if ("default".equals(attribute)) {
                attribute = "defaultValue";
            }
            String sequence = null;
            try {
                sequence = el.element("generator").element("param").getTextTrim();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            idName = name;
            idType = type;
            pwa.println("\tprivate " + type + " i" + name + ";");
            properties.add(name);
            pwb.println();
            imports.add("jakarta.persistence.Id");
            pwb.println("\t@Id");
            if (sequence != null) {
                imports.add("org.unitime.commons.annotations.UniqueIdGenerator");
                pwb.println("\t@UniqueIdGenerator(sequence = \"" + sequence + "\")");
            }
            imports.add("jakarta.persistence.Column");
            pwb.println("\t@Column(name=\"" + column3 + "\")");
            pwb.println("\tpublic " + type + " get" + name + "() { return i" + name + "; }");
            pwb.println("\tpublic void set" + name + "(" + type + " " + (String)attribute + ") { i" + name + " = " + (String)attribute + "; }");
            hasProperty = true;
        }
        i = classEl.elementIterator("composite-id");
        while (i.hasNext()) {
            void var40_89;
            StringWriter id1 = new StringWriter();
            PrintWriter pwi1 = new PrintWriter(id1);
            StringWriter id2 = new StringWriter();
            PrintWriter pwi2 = new PrintWriter(id2);
            TreeSet<String> idImports = new TreeSet<String>();
            ArrayList<String[]> cargs = new ArrayList<String[]>();
            idImports.add("java.io.Serializable");
            imports.add("jakarta.persistence.IdClass");
            pwh.println("@IdClass(" + className + "Id.class)");
            Element cidEl = (Element)i.next();
            Iterator j2 = cidEl.elementIterator("key-many-to-one");
            while (j2.hasNext()) {
                Element el2 = (Element)j2.next();
                String type3 = this.fixType(el2.attributeValue("class"), pkg);
                if (type3.indexOf(46) >= 0) {
                    idImports.add(type3);
                    imports.add(type3);
                    type3 = type3.substring(type3.lastIndexOf(46) + 1);
                }
                String string = this.fixName(el2.attributeValue("name"));
                String column4 = el2.attributeValue("column").toLowerCase();
                Object attribute = string.substring(0, 1).toLowerCase() + string.substring(1);
                boolean lazy = "true".equals(el2.attributeValue("lazy")) || "proxy".equals(el2.attributeValue("lazy"));
                boolean eager = "false".equals(el2.attributeValue("lazy"));
                boolean join = "join".equals(el2.attributeValue("fetch"));
                String cascade = el2.attributeValue("cascade");
                boolean notNul = "true".equals(el2.attributeValue("not-null", "true"));
                if (lazy || join || eager) {
                    idImports.add("jakarta.persistence.FetchType");
                }
                if ("all".equals(cascade)) {
                    idImports.add("jakarta.persistence.CascadeType");
                } else if ("save-update".equals(cascade)) {
                    idImports.add("jakarta.persistence.CascadeType");
                } else if ("all-delete-orphan".equals(cascade)) {
                    idImports.add("jakarta.persistence.CascadeType");
                } else if (!"delete-orphan".equals(cascade) && cascade != null && !"none".equals(cascade)) {
                    this.warn("Not-supported cascade type: " + cascade);
                }
                if ("default".equals(attribute)) {
                    attribute = "defaultValue";
                }
                cargs.add(new String[]{type3, "i" + string, attribute});
                pwi1.println("\tprivate " + type3 + " i" + string + ";");
                pwa.println("\tprivate " + type3 + " i" + string + ";");
                properties.add(string);
                compositeId.add(new String[]{type3, string});
                pwb.println();
                imports.add("jakarta.persistence.Id");
                pwb.println("\t@Id");
                imports.add("jakarta.persistence.ManyToOne");
                pwb.println(this.annotation("ManyToOne", "optional = " + (notNul ? "false" : "true"), lazy ? "fetch = FetchType.LAZY" : (join || eager ? "fetch = FetchType.EAGER" : null), "all".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "all-delete-orphan".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "save-update".equals(cascade) ? "cascade = {CascadeType.PERSIST, CascadeType.MERGE}" : null));
                imports.add("jakarta.persistence.JoinColumn");
                pwb.println("\t@JoinColumn(name = \"" + column4 + "\")");
                if (lazy || join || eager || el2.element("cache") != null) {
                    imports.add("org.hibernate.annotations.Cache");
                    imports.add("org.hibernate.annotations.CacheConcurrencyStrategy");
                    pwb.println("\t@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)");
                }
                if ("all-delete-orphan".equals(cascade) || "delete-orphan".equals(cascade)) {
                    imports.add("org.hibernate.annotations.Cascade");
                    pwb.println("\t@Cascade(value = org.hibernate.annotations.CascadeType.DELETE_ORPHAN)");
                }
                pwb.println("\tpublic " + type3 + " get" + string + "() { return i" + string + "; }");
                pwb.println("\tpublic void set" + string + "(" + type3 + " " + (String)attribute + ") { i" + string + " = " + (String)attribute + "; }");
                pwi2.println();
                pwi2.println("\tpublic " + type3 + " get" + string + "() { return i" + string + "; }");
                pwi2.println("\tpublic void set" + string + "(" + type3 + " " + (String)attribute + ") { i" + string + " = " + (String)attribute + "; }");
                hasProperty = true;
            }
            Iterator j3 = cidEl.elementIterator("key-property");
            while (j3.hasNext()) {
                Element el2 = (Element)j3.next();
                Object type2 = this.fixType(el2.attributeValue("type"), pkg);
                if (((String)type2).indexOf(46) >= 0) {
                    idImports.add((String)type2);
                    imports.add((String)type2);
                    type2 = ((String)type2).substring(((String)type2).lastIndexOf(46) + 1);
                }
                String string = this.fixName(el2.attributeValue("name"));
                String length = el2.attributeValue("length");
                String column5 = el2.attributeValue("column");
                Object attribute = string.substring(0, 1).toLowerCase() + string.substring(1);
                if ("default".equals(attribute)) {
                    attribute = "defaultValue";
                }
                compositeId.add(new String[]{type2, string});
                cargs.add(new String[]{type2, "i" + string, attribute});
                pwi1.println("\tprivate " + (String)type2 + " i" + string + ";");
                pwa.println("\tprivate " + (String)type2 + " i" + string + ";");
                properties.add(string);
                pwb.println();
                imports.add("jakarta.persistence.Id");
                pwb.println("\t@Id");
                imports.add("jakarta.persistence.Column");
                pwb.println("\t@Column(name=\"" + column5 + "\"" + (String)(length != null && !length.isEmpty() ? ", length = " + length : "") + ")");
                pwb.println("\tpublic " + (String)type2 + " get" + string + "() { return i" + string + "; }");
                pwb.println("\tpublic void set" + string + "(" + (String)type2 + " " + (String)attribute + ") { i" + string + " = " + (String)attribute + "; }");
                pwi2.println();
                pwi2.println("\tpublic " + (String)type2 + " get" + string + "() { return i" + string + "; }");
                pwi2.println("\tpublic void set" + string + "(" + (String)type2 + " " + (String)attribute + ") { i" + string + " = " + (String)attribute + "; }");
                hasProperty = true;
            }
            pwi1.flush();
            pwi1.close();
            pwi2.flush();
            pwi2.close();
            idType = className + "Id";
            PrintWriter pwc = new PrintWriter(new FileWriter(new File(this.fileFromPackage(outputFolder, pkg + ".base"), className + "Id.java")));
            this.license(pwc);
            pwc.println("package " + pkg + ".base;");
            pwc.println();
            String last = null;
            for (String string : idImports) {
                String top = string.substring(0, string.indexOf(46));
                if (last != null && !last.equals(top)) {
                    pwc.println();
                }
                pwc.println("import " + string + ";");
                last = top;
            }
            pwc.println();
            pwc.println("/**");
            pwc.println(" * Do not change this class. It has been automatically generated using ant create-model.");
            pwc.println(" * @see org.unitime.commons.ant.CreateBaseModelFromXml");
            pwc.println(" */");
            pwc.println("public class " + className + "Id implements Serializable {");
            pwc.println("\tprivate static final long serialVersionUID = 1L;");
            pwc.println();
            pwc.print(id1.getBuffer());
            pwc.println();
            pwc.println("\tpublic " + className + "Id() {}");
            pwc.println();
            pwc.print("\tpublic " + className + "Id(");
            j = cargs.iterator();
            while (j.hasNext()) {
                String[] stringArray = (String[])j.next();
                pwc.print(stringArray[0] + " " + stringArray[2]);
                if (!j.hasNext()) continue;
                pwc.print(", ");
            }
            pwc.println(") {");
            for (String[] stringArray : cargs) {
                pwc.println("\t\t" + stringArray[1] + " = " + stringArray[2] + ";");
            }
            pwc.println("\t}");
            pwc.print(id2.getBuffer());
            pwc.println();
            pwc.println();
            String x2 = className.substring(0, 1).toLowerCase() + className.substring(1);
            pwc.println("\t@Override");
            pwc.println("\tpublic boolean equals(Object o) {");
            pwc.println("\t\tif (o == null || !(o instanceof " + className + "Id)) return false;");
            pwc.println("\t\t" + className + "Id " + x2 + " = (" + className + "Id)o;");
            for (String[] typeName : compositeId) {
                String name3 = typeName[1];
                pwc.println("\t\tif (get" + (String)name3 + "() == null || " + x2 + ".get" + (String)name3 + "() == null || !get" + (String)name3 + "().equals(" + x2 + ".get" + (String)name3 + "())) return false;");
            }
            pwc.println("\t\treturn true;");
            pwc.println("\t}");
            pwc.println();
            pwc.println("\t@Override");
            pwc.println("\tpublic int hashCode() {");
            String string = "";
            Object isNull = "";
            for (String[] typeName : compositeId) {
                void var40_103;
                String name4 = typeName[1];
                if (!var40_89.isEmpty()) {
                    String string2 = (String)var40_89 + " ^ ";
                    isNull = (String)isNull + " || ";
                }
                String string3 = (String)var40_103 + "get" + name4 + "().hashCode()";
                isNull = (String)isNull + "get" + name4 + "() == null";
            }
            pwc.println("\t\tif (" + (String)isNull + ") return super.hashCode();");
            pwc.println("\t\treturn " + (String)var40_89 + ";");
            pwc.println("\t}");
            pwc.println();
            pwc.println("}");
            pwc.flush();
            pwc.close();
        }
        i = classEl.elementIterator("property");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = this.fixType(el.attributeValue("type"), pkg);
            if (type.indexOf(46) >= 0) {
                imports.add(type);
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            name = this.fixName(el.attributeValue("name"));
            boolean notNul = "true".equals(el.attributeValue("not-null"));
            String length = el.attributeValue("length");
            String column6 = el.attributeValue("column");
            String formula = el.attributeValue("formula");
            Object attribute = name.substring(0, 1).toLowerCase() + name.substring(1);
            if ("default".equals(attribute)) {
                attribute = "defaultValue";
            }
            if (column6 != null) {
                pwa.println("\tprivate " + type + " i" + name + ";");
                properties.add(name);
                pwb.println();
                imports.add("jakarta.persistence.Column");
                pwb.println("\t@Column(name = \"" + column6 + "\", nullable = " + (notNul ? "false" : "true") + (String)(length != null && !length.isEmpty() ? ", length = " + length : "") + ")");
                if (type.equals("Boolean")) {
                    pwb.println("\tpublic " + type + " is" + name + "() { return i" + name + "; }");
                    imports.add("jakarta.persistence.Transient");
                    pwb.println("\t@Transient");
                }
                pwb.println("\tpublic " + type + " get" + name + "() { return i" + name + "; }");
                pwb.println("\tpublic void set" + name + "(" + type + " " + (String)attribute + ") { i" + name + " = " + (String)attribute + "; }");
            } else if (formula != null) {
                pwa.println("\tprivate " + type + " i" + name + ";");
                pwb.println();
                imports.add("org.hibernate.annotations.Formula");
                pwb.println("\t@Formula(\"" + formula + "\")");
                if (type.equals("Boolean")) {
                    pwb.println("\tpublic " + type + " is" + name + "() { return i" + name + "; }");
                }
                pwb.println("\tpublic " + type + " get" + name + "() { return i" + name + "; }");
                pwb.println("\tpublic void set" + name + "(" + type + " " + (String)attribute + ") { i" + name + " = " + (String)attribute + "; }");
            } else {
                System.err.println("Unknown " + el.getName() + ": " + el.asXML());
            }
            hasProperty = true;
        }
        if (hasProperty) {
            pwa.println();
        }
        i = classEl.elementIterator("many-to-one");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = this.fixType(el.attributeValue("class"), pkg);
            if (type.indexOf(46) >= 0) {
                imports.add(type);
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            boolean lazy = "true".equals(el.attributeValue("lazy")) || "proxy".equals(el.attributeValue("lazy"));
            boolean eager = "false".equals(el.attributeValue("lazy"));
            boolean join = "join".equals(el.attributeValue("fetch"));
            String cascade = el.attributeValue("cascade");
            String name5 = this.fixName(el.attributeValue("name"));
            boolean notNul = "true".equals(el.attributeValue("not-null"));
            column = el.attributeValue("column");
            String formula = el.attributeValue("formula");
            if (lazy || join || eager) {
                imports.add("jakarta.persistence.FetchType");
            }
            if ("all".equals(cascade)) {
                imports.add("jakarta.persistence.CascadeType");
            } else if ("save-update".equals(cascade)) {
                imports.add("jakarta.persistence.CascadeType");
            } else if ("all-delete-orphan".equals(cascade)) {
                imports.add("jakarta.persistence.CascadeType");
            } else if (!"delete-orphan".equals(cascade) && cascade != null && !"none".equals(cascade)) {
                this.warn("Not-supported cascade type: " + cascade);
            }
            if (column != null) {
                pwa.println("\tprivate " + type + " i" + name5 + ";");
                properties.add(name5);
                pwb.println();
                manyToOnes.add(new String[]{type, name5});
                imports.add("jakarta.persistence.ManyToOne");
                pwb.println(this.annotation("ManyToOne", "optional = " + (notNul ? "false" : "true"), lazy ? "fetch = FetchType.LAZY" : (join || eager ? "fetch = FetchType.EAGER" : null), "all".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "all-delete-orphan".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "save-update".equals(cascade) ? "cascade = {CascadeType.PERSIST, CascadeType.MERGE}" : null));
                imports.add("jakarta.persistence.JoinColumn");
                pwb.println("\t@JoinColumn(name = \"" + column + "\", nullable = " + (notNul ? "false" : "true") + ")");
                if (lazy || eager || join || el.element("cache") != null) {
                    imports.add("org.hibernate.annotations.Cache");
                    imports.add("org.hibernate.annotations.CacheConcurrencyStrategy");
                    pwb.println("\t@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)");
                }
                if ("all-delete-orphan".equals(cascade) || "delete-orphan".equals(cascade)) {
                    imports.add("org.hibernate.annotations.Cascade");
                    pwb.println("\t@Cascade(value = org.hibernate.annotations.CascadeType.DELETE_ORPHAN)");
                }
                if (lazy && this.iAbstracts.contains(type)) {
                    imports.add("org.hibernate.Hibernate");
                    imports.add("org.hibernate.proxy.HibernateProxy");
                    pwb.println("\tpublic " + type + " get" + name5 + "() {");
                    pwb.println("\t\tif (i" + name5 + " != null && i" + name5 + " instanceof HibernateProxy)");
                    pwb.println("\t\t\ti" + name5 + " = (" + type + ") Hibernate.unproxy(i" + name5 + ");");
                    pwb.println("\t\treturn i" + name5 + ";");
                    pwb.println("\t}");
                } else {
                    pwb.println("\tpublic " + type + " get" + name5 + "() { return i" + name5 + "; }");
                }
                pwb.println("\tpublic void set" + name5 + "(" + type + " " + name5.substring(0, 1).toLowerCase() + name5.substring(1) + ") { i" + name5 + " = " + name5.substring(0, 1).toLowerCase() + name5.substring(1) + "; }");
                continue;
            }
            if (formula != null) {
                pwa.println("\tprivate " + type + " i" + name5 + ";");
                pwb.println();
                imports.add("jakarta.persistence.ManyToOne");
                pwb.println(this.annotation("ManyToOne", lazy ? "fetch = FetchType.LAZY" : (join ? "fetch = FetchType.EAGER" : null), "all".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "all-delete-orphan".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "save-update".equals(cascade) ? "cascade = {CascadeType.PERSIST, CascadeType.MERGE}" : null));
                imports.add("org.hibernate.annotations.JoinFormula");
                pwb.println("\t@JoinFormula(\"" + formula + "\")");
                if (lazy || eager || join || el.element("cache") != null) {
                    imports.add("org.hibernate.annotations.Cache");
                    imports.add("org.hibernate.annotations.CacheConcurrencyStrategy");
                    pwb.println("\t@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)");
                }
                if ("all-delete-orphan".equals(cascade) || "delete-orphan".equals(cascade)) {
                    imports.add("org.hibernate.annotations.Cascade");
                    pwb.println("\t@Cascade(value = org.hibernate.annotations.CascadeType.DELETE_ORPHAN)");
                }
                pwb.println("\tpublic " + type + " get" + name5 + "() { return i" + name5 + "; }");
                pwb.println("\tpublic void set" + name5 + "(" + type + " " + name5.substring(0, 1).toLowerCase() + name5.substring(1) + ") { i" + name5 + " = " + name5.substring(0, 1).toLowerCase() + name5.substring(1) + "; }");
                continue;
            }
            System.err.println("Unknown " + el.getName() + ": " + el.asXML());
        }
        i = classEl.elementIterator("set");
        while (i.hasNext()) {
            el = (Element)i.next();
            type = null;
            String name6 = this.fixName(el.attributeValue("name"));
            boolean lazy = "true".equals(el.attributeValue("lazy")) || "proxy".equals(el.attributeValue("lazy"));
            boolean eager = "false".equals(el.attributeValue("lazy"));
            boolean inverse = "true".equals(el.attributeValue("inverse", "false"));
            boolean notNul = "true".equals(el.attributeValue("not-null"));
            String cascade = el.attributeValue("cascade");
            pwb.println();
            if (el.element("many-to-many") != null) {
                column = null;
                try {
                    column = el.element("key").attributeValue("column").toLowerCase();
                }
                catch (NullPointerException formula) {
                    // empty catch block
                }
                String icolumn = el.element("many-to-many").attributeValue("column").toLowerCase();
                String string = el.attributeValue("table").toLowerCase();
                type = this.fixType(el.element("many-to-many").attributeValue("class"), pkg);
                if (type.indexOf(46) >= 0) {
                    imports.add(type);
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
                imports.add("jakarta.persistence.ManyToMany");
                if (lazy || eager) {
                    imports.add("jakarta.persistence.FetchType");
                }
                if ("all".equals(cascade)) {
                    imports.add("jakarta.persistence.CascadeType");
                } else if ("save-update".equals(cascade)) {
                    imports.add("jakarta.persistence.CascadeType");
                } else if ("all-delete-orphan".equals(cascade)) {
                    imports.add("jakarta.persistence.CascadeType");
                } else if (!"delete-orphan".equals(cascade) && cascade != null && !"none".equals(cascade)) {
                    this.warn("Not-supported cascade type: " + cascade);
                }
                if (inverse) {
                    pwb.println(this.annotation("ManyToMany", lazy ? "fetch = FetchType.LAZY" : (eager ? "fetch = FetchType.EAGER" : null), "mappedBy = \"" + this.iRelations.get(className + "." + icolumn) + "\"", "all".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "all-delete-orphan".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "save-update".equals(cascade) ? "cascade = {CascadeType.PERSIST, CascadeType.MERGE}" : null));
                } else {
                    pwb.println(this.annotation("ManyToMany", lazy ? "fetch = FetchType.LAZY" : (eager ? "fetch = FetchType.EAGER" : null), "all".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "all-delete-orphan".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "save-update".equals(cascade) ? "cascade = {CascadeType.PERSIST, CascadeType.MERGE}" : null));
                    imports.add("jakarta.persistence.JoinTable");
                    imports.add("jakarta.persistence.JoinColumn");
                    pwb.println("\t@JoinTable(name = \"" + string + "\",");
                    if (column == null) {
                        pwb.println("\t\tjoinColumns = {");
                        Iterator j3 = el.element("key").elementIterator("column");
                        while (j3.hasNext()) {
                            Element colEl = (Element)j3.next();
                            String col = colEl.attributeValue("name").toLowerCase();
                            pwb.println("\t\t\t@JoinColumn(name = \"" + col + "\")" + (j3.hasNext() ? "," : ""));
                        }
                        pwb.println("\t\t},");
                    } else {
                        pwb.println("\t\tjoinColumns = { @JoinColumn(name = \"" + column + "\") },");
                    }
                    pwb.println("\t\tinverseJoinColumns = { @JoinColumn(name = \"" + icolumn + "\") })");
                }
                if (lazy || eager || el.element("cache") != null) {
                    imports.add("org.hibernate.annotations.Cache");
                    imports.add("org.hibernate.annotations.CacheConcurrencyStrategy");
                    pwb.println("\t@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)");
                }
                if ("all-delete-orphan".equals(cascade) || "delete-orphan".equals(cascade)) {
                    imports.add("org.hibernate.annotations.Cascade");
                    pwb.println("\t@Cascade(value = org.hibernate.annotations.CascadeType.DELETE_ORPHAN)");
                }
            } else if (el.element("one-to-many") != null) {
                column = el.element("key").attributeValue("column").toLowerCase();
                type = this.fixType(el.element("one-to-many").attributeValue("class"), pkg);
                if (type.indexOf(46) >= 0) {
                    imports.add(type);
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
                imports.add("jakarta.persistence.OneToMany");
                if (lazy || eager) {
                    imports.add("jakarta.persistence.FetchType");
                }
                if ("all".equals(cascade)) {
                    imports.add("jakarta.persistence.CascadeType");
                } else if ("save-update".equals(cascade)) {
                    imports.add("jakarta.persistence.CascadeType");
                } else if ("all-delete-orphan".equals(cascade)) {
                    imports.add("jakarta.persistence.CascadeType");
                } else if (!"delete-orphan".equals(cascade) && cascade != null && !"none".equals(cascade)) {
                    this.warn("Not-supported cascade type: " + cascade);
                }
                if (inverse) {
                    pwb.println(this.annotation("OneToMany", lazy ? "fetch = FetchType.LAZY" : (eager ? "fetch = FetchType.EAGER" : null), "mappedBy = \"" + this.iRelations.get(type + "." + column) + "\"", "all".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "all-delete-orphan".equals(cascade) ? "cascade = {CascadeType.ALL}, orphanRemoval = true" : null, "save-update".equals(cascade) ? "cascade = {CascadeType.PERSIST, CascadeType.MERGE}" : null, "delete-orphan".equals(cascade) ? "orphanRemoval = true" : null));
                } else {
                    pwb.println(this.annotation("OneToMany", lazy ? "fetch = FetchType.LAZY" : (eager ? "fetch = FetchType.EAGER" : null), "all".equals(cascade) ? "cascade = {CascadeType.ALL}" : null, "all-delete-orphan".equals(cascade) ? "cascade = {CascadeType.ALL}, orphanRemoval = true" : null, "save-update".equals(cascade) ? "cascade = {CascadeType.PERSIST, CascadeType.MERGE}" : null, "delete-orphan".equals(cascade) ? "orphanRemoval = true" : null));
                    imports.add("jakarta.persistence.JoinColumn");
                    if (column == null) {
                        imports.add("jakarta.persistence.JoinColumns");
                        pwb.println("\t@JoinColumns({");
                        j = el.element("key").elementIterator("column");
                        while (j.hasNext()) {
                            Element element = (Element)j.next();
                            String col = element.attributeValue("name").toLowerCase();
                            pwb.println("\t\t@JoinColumn(name = \"" + col + "\")" + (j.hasNext() ? "," : ""));
                        }
                        pwb.println("\t})");
                    } else {
                        pwb.println("\t@JoinColumn(name = \"" + column + "\", nullable = " + (notNul ? "false" : "true") + ")");
                    }
                }
                if (lazy || eager || el.element("cache") != null) {
                    imports.add("org.hibernate.annotations.Cache");
                    imports.add("org.hibernate.annotations.CacheConcurrencyStrategy");
                    pwb.println("\t@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)");
                }
            } else if (el.element("element") != null) {
                String m2mtable = el.attributeValue("table").toLowerCase();
                String keyColumn = el.element("key").attributeValue("column").toLowerCase();
                String string = el.element("element").attributeValue("column").toLowerCase();
                type = this.fixType(el.element("element").attributeValue("type"), pkg);
                if (type.indexOf(46) >= 0) {
                    imports.add(type);
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
                imports.add("jakarta.persistence.ElementCollection");
                pwb.println("\t@ElementCollection");
                imports.add("jakarta.persistence.CollectionTable");
                imports.add("jakarta.persistence.JoinColumn");
                pwb.println("\t@CollectionTable(name = \"" + m2mtable + "\",");
                pwb.println("\t\tjoinColumns = @JoinColumn(name = \"" + keyColumn + "\")");
                pwb.println("\t)");
                imports.add("jakarta.persistence.Column");
                pwb.println("\t@Column(name = \"" + string + "\")");
            } else {
                System.err.println("Unknown type of set");
            }
            if (type.indexOf(46) >= 0) {
                imports.add(type);
            }
            imports.add("java.util.Set");
            imports.add("java.util.HashSet");
            pwa.println("\tprivate Set<" + type + "> i" + name6 + ";");
            pwb.println("\tpublic Set<" + type + "> get" + name6 + "() { return i" + name6 + "; }");
            pwb.println("\tpublic void set" + name6 + "(Set<" + type + "> " + name6.substring(0, 1).toLowerCase() + name6.substring(1) + ") { i" + name6 + " = " + name6.substring(0, 1).toLowerCase() + name6.substring(1) + "; }");
            pwb.println("\tpublic void addTo" + name6 + "(" + type + " " + type.substring(0, 1).toLowerCase() + type.substring(1) + ") {");
            pwb.println("\t\tif (i" + name6 + " == null) i" + name6 + " = new HashSet<" + type + ">();");
            pwb.println("\t\ti" + name6 + ".add(" + type.substring(0, 1).toLowerCase() + type.substring(1) + ");");
            pwb.println("\t}");
            pwb.println("\t@Deprecated");
            pwb.println("\tpublic void addTo" + name6.substring(0, 1).toLowerCase() + name6.substring(1) + "(" + type + " " + type.substring(0, 1).toLowerCase() + type.substring(1) + ") {");
            pwb.println("\t\taddTo" + name6 + "(" + type.substring(0, 1).toLowerCase() + type.substring(1) + ");");
            pwb.println("\t}");
        }
        if (serializable) {
            imports.add("java.io.Serializable");
        }
        boolean abs = "true".equals(classEl.attributeValue("abstract", "false"));
        if ((ext = this.fixType(ext, pkg)) != null && ext.indexOf(46) >= 0) {
            if (!ext.startsWith(pkg + ".base.")) {
                imports.add(ext);
            }
            ext = ext.substring(ext.lastIndexOf(46) + 1);
        }
        if (idName != null || !compositeId.isEmpty()) {
            imports.add(this.fixType(classEl.attributeValue("name"), pkg));
        }
        if (abs && discriminator == null && "class".equals(classEl.getName())) {
            mainImports.add("jakarta.persistence.Inheritance");
            mainImports.add("jakarta.persistence.InheritanceType");
            pwmh.println("@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)");
        }
        pwa.flush();
        pwa.close();
        pwb.flush();
        pwb.close();
        pwh.flush();
        pwh.close();
        pwmh.flush();
        pwmh.close();
        PrintWriter pw = new PrintWriter(new FileWriter(new File(this.fileFromPackage(outputFolder, pkg + ".base"), "Base" + className + ".java")));
        this.license(pw);
        pw.println("package " + pkg + ".base;");
        pw.println();
        String last = null;
        for (String imp : imports) {
            String top = imp.substring(0, imp.indexOf(46));
            if (last != null && !last.equals(top)) {
                pw.println();
            }
            pw.println("import " + imp + ";");
            last = top;
        }
        pw.println();
        pw.println("/**");
        pw.println(" * Do not change this class. It has been automatically generated using ant create-model.");
        pw.println(" * @see org.unitime.commons.ant.CreateBaseModelFromXml");
        pw.println(" */");
        pw.print(header.getBuffer());
        pw.println("public abstract class Base" + className + (String)(ext == null ? "" : " extends " + ext) + (serializable ? " implements Serializable" : "") + " {");
        pw.println("\tprivate static final long serialVersionUID = 1L;");
        pw.println();
        pw.print(attributes.getBuffer());
        if (constructor) {
            pw.println();
            pw.println("\tpublic Base" + className + "() {");
            pw.println("\t}");
        }
        if (idName != null) {
            x = idName.substring(0, 1).toLowerCase() + idName.substring(1);
            pw.println();
            pw.println("\tpublic Base" + className + "(" + (String)idType + " " + (String)x + ") {");
            pw.println("\t\tset" + idName + "(" + (String)x + ");");
            pw.println("\t}");
        }
        pw.println();
        pw.print(body.getBuffer());
        this.iClassProperties.put(className, properties);
        if (ext != null && this.iClassProperties.containsKey(ext)) {
            properties.addAll((Collection)this.iClassProperties.get(ext));
        }
        if (idName != null) {
            if (idClass == null) {
                idClass = className;
            }
            if (equals) {
                pw.println();
                pw.println("\t@Override");
                pw.println("\tpublic boolean equals(Object o) {");
                pw.println("\t\tif (o == null || !(o instanceof " + className + ")) return false;");
                pw.println("\t\tif (get" + idName + "() == null || ((" + className + ")o).get" + idName + "() == null) return false;");
                pw.println("\t\treturn get" + idName + "().equals(((" + className + ")o).get" + idName + "());");
                pw.println("\t}");
            }
            if (hashCode) {
                pw.println();
                pw.println("\t@Override");
                pw.println("\tpublic int hashCode() {");
                pw.println("\t\tif (get" + idName + "() == null) return super.hashCode();");
                pw.println("\t\treturn get" + idName + "().hashCode();");
                pw.println("\t}");
            }
            pw.println();
            pw.println("\t@Override");
            pw.println("\tpublic String toString() {");
            if (properties.contains("Name")) {
                pw.println("\t\treturn \"" + className + "[\"+get" + idName + "()+\" \"+getName()+\"]\";");
            } else if (properties.contains("Label")) {
                pw.println("\t\treturn \"" + className + "[\"+get" + idName + "()+\" \"+getLabel()+\"]\";");
            } else {
                pw.println("\t\treturn \"" + className + "[\"+get" + idName + "()+\"]\";");
            }
            pw.println("\t}");
        } else if (!compositeId.isEmpty()) {
            x = className.substring(0, 1).toLowerCase() + className.substring(1);
            pw.println();
            pw.println("\t@Override");
            pw.println("\tpublic boolean equals(Object o) {");
            pw.println("\t\tif (o == null || !(o instanceof " + className + ")) return false;");
            pw.println("\t\t" + className + " " + (String)x + " = (" + className + ")o;");
            for (String[] typeName : compositeId) {
                String name7 = typeName[1];
                pw.println("\t\tif (get" + name7 + "() == null || " + (String)x + ".get" + name7 + "() == null || !get" + name7 + "().equals(" + (String)x + ".get" + name7 + "())) return false;");
            }
            pw.println("\t\treturn true;");
            pw.println("\t}");
            pw.println();
            pw.println("\t@Override");
            pw.println("\tpublic int hashCode() {");
            Object xor = "";
            Object isNull = "";
            for (String[] typeName : compositeId) {
                String name8 = typeName[1];
                if (!((String)xor).isEmpty()) {
                    xor = (String)xor + " ^ ";
                    isNull = (String)isNull + " || ";
                }
                xor = (String)xor + "get" + name8 + "().hashCode()";
                isNull = (String)isNull + "get" + name8 + "() == null";
            }
            pw.println("\t\tif (" + (String)isNull + ") return super.hashCode();");
            pw.println("\t\treturn " + (String)xor + ";");
            pw.println("\t}");
            pw.println();
            pw.println("\tpublic String toString() {");
            Object names = "";
            for (String[] typeName : compositeId) {
                String name9 = typeName[1];
                if (!((String)names).isEmpty()) {
                    names = (String)names + " + \", \" + ";
                }
                names = (String)names + "get" + name9 + "()";
            }
            pw.println("\t\treturn \"" + className + "[\" + " + (String)names + " + \"]\";");
            pw.println("\t}");
        }
        pw.println();
        pw.println("\tpublic String toDebugString() {");
        pw.println("\t\treturn \"" + className + "[\" +");
        for (String p : properties) {
            pw.println("\t\t\t\"\\n\t" + p + ": \" + get" + p + "() +");
        }
        pw.println("\t\t\t\"]\";");
        pw.println("\t}");
        pw.println("}");
        pw.flush();
        pw.close();
        Iterator i2 = classEl.elementIterator("union-subclass");
        while (i2.hasNext()) {
            this.importClass((Element)i2.next(), pkg, outputFolder, className, idClass, idName, (String)idType);
        }
        Iterator i3 = classEl.elementIterator("subclass");
        while (i3.hasNext()) {
            this.importClass((Element)i3.next(), pkg, outputFolder, className, idClass, idName, (String)idType);
        }
        File mainFile = new File(this.fileFromPackage(outputFolder, pkg), className + ".java");
        if (!mainFile.exists()) {
            pw = new PrintWriter(new FileWriter(mainFile));
            this.license(pw);
            pw.println("package " + pkg + ";");
            pw.println();
            last = null;
            for (String imp : mainImports) {
                String top = imp.substring(0, imp.indexOf(46));
                if (last != null && !last.equals(top)) {
                    pw.println();
                }
                pw.println("import " + imp + ";");
                last = top;
            }
            pw.println("import " + pkg + ".base.Base" + className + ";");
            pw.println();
            pw.print(mainHeader.getBuffer());
            pw.println("public" + (abs ? " abstract" : "") + " class " + className + " extends Base" + className + " {");
            pw.println();
            pw.println("}");
            pw.flush();
            pw.close();
        } else {
            ArrayList<String> file = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(mainFile));
            String readLine = null;
            Pattern importPattern = Pattern.compile("import ([^;]*);");
            HashSet<String> existingImports = new HashSet<String>();
            boolean needTransient = false;
            while ((readLine = br.readLine()) != null) {
                Matcher importMatcher = importPattern.matcher(readLine);
                if (importMatcher.matches()) {
                    String string = importMatcher.group(1);
                    existingImports.add(string);
                }
                if (readLine.matches("[\t ]*(public|private|protected)[\t ]*[a-zA-Z<>\\., _\\[\\]\\?]+[\t ]+(get|is)[A-Za-z0-9_]+\\(\\).*")) {
                    mainImports.add("jakarta.persistence.Transient");
                    needTransient = true;
                }
                file.add(readLine);
            }
            br.close();
            pw = new PrintWriter(new FileWriter(mainFile));
            boolean printedImports = false;
            boolean bl = false;
            String prev = null;
            for (String line : file) {
                boolean bl2;
                String imp;
                Matcher importMatcher;
                if (!printedImports && importPattern.matcher(line).matches()) {
                    boolean printedAtLeastOne = false;
                    for (String imp2 : mainImports) {
                        if (existingImports.contains(imp2)) continue;
                        pw.println("import " + imp2 + ";");
                        printedAtLeastOne = true;
                    }
                    if (printedAtLeastOne) {
                        pw.println();
                    }
                    printedImports = true;
                }
                if ((importMatcher = importPattern.matcher(line)).matches() && "jakarta.persistence.Transient".equals(imp = importMatcher.group(1)) && !needTransient || !bl2 && line.startsWith("@Entity") || !bl2 && line.startsWith("@Cache") || !bl2 && line.startsWith("@Table") || !bl2 && line.startsWith("@Inheritance") || !bl2 && line.startsWith("@Discriminator") || line.equals("\t@Transient")) continue;
                if (!bl2 && (line.startsWith("public class ") || line.startsWith("public abstract class "))) {
                    pw.print(mainHeader.toString());
                    bl2 = true;
                }
                if (line.matches("[\t ]*(public|private|protected)[\t ]*[a-zA-Z<>\\., _\\[\\]\\?]+[\t ]+(get|is)[A-Za-z0-9_]+\\(\\).*") && !"\t@Transient".equals(prev)) {
                    pw.println("\t@Transient");
                }
                pw.println(line);
                prev = line;
            }
            pw.flush();
            pw.close();
        }
        File f = new File(this.fileFromPackage(outputFolder, pkg + ".base"), "Base" + className + "DAO.java");
        if (f.exists()) {
            f.delete();
        }
        File daoFile = new File(this.fileFromPackage(outputFolder, pkg + ".dao"), className + "DAO.java");
        pw = new PrintWriter(new FileWriter(daoFile));
        this.license(pw);
        pw.println("package " + pkg + ".dao;");
        pw.println();
        pw.println("/**");
        pw.println(" * Do not change this class. It has been automatically generated using ant create-model.");
        pw.println(" * @see org.unitime.commons.ant.CreateBaseModelFromXml");
        pw.println(" */");
        if (idType == null) {
            pw.println("import java.io.Serializable;");
        } else if (((String)idType).endsWith("Id")) {
            pw.println("import " + pkg + ".base." + (String)idType + ";");
        }
        if (!manyToOnes.isEmpty()) {
            pw.println("import java.util.List;");
        }
        pw.println("import " + pkg + "." + className + ";");
        pw.println();
        pw.println("public class " + className + "DAO extends _RootDAO<" + className + "," + (String)(idType == null ? "Serializable" : idType) + "> {");
        pw.println("\tprivate static " + className + "DAO sInstance;");
        pw.println();
        pw.println("\tpublic " + className + "DAO() {}");
        pw.println();
        pw.println("\tpublic static " + className + "DAO getInstance() {");
        pw.println("\t\tif (sInstance == null) sInstance = new " + className + "DAO();");
        pw.println("\t\treturn sInstance;");
        pw.println("\t}");
        pw.println();
        pw.println("\tpublic Class<" + className + "> getReferenceClass() {");
        pw.println("\t\treturn " + className + ".class;");
        pw.println("\t}");
        for (String[] attr : manyToOnes) {
            String type4 = attr[0];
            String name10 = attr[1];
            String x3 = name10.substring(0, 1).toLowerCase() + name10.substring(1);
            String[] stringArray = this.iIds.get(type4);
            String iType = "Long";
            String iName = "UniqueId";
            if (stringArray != null) {
                iType = stringArray[0];
                iName = stringArray[1];
            }
            pw.println();
            pw.println("\t@SuppressWarnings(\"unchecked\")");
            pw.println("\tpublic List<" + className + "> findBy" + name10 + "(org.hibernate.Session hibSession, " + iType + " " + x3 + "Id) {");
            pw.println("\t\treturn hibSession.createQuery(\"from " + className + " x where x." + x3 + "." + iName.substring(0, 1).toLowerCase() + iName.substring(1) + " = :" + x3 + "Id\", " + className + ".class).setParameter(\"" + x3 + "Id\", " + x3 + "Id).list();");
            pw.println("\t}");
        }
        pw.println("}");
        pw.flush();
        pw.close();
    }

    public void execute() throws BuildException {
        try {
            this.convert();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void info(String message) {
        try {
            this.log(message);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public void warn(String message) {
        try {
            this.log(message, 1);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public static void main(String[] args) {
        try {
            new CreateBaseModelFromXml().convert();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

