/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.jgroups.Address;
import org.jgroups.Global;
import org.jgroups.protocols.RTTHeader;
import org.jgroups.util.Average;
import org.jgroups.util.AverageMinMax;

public class RpcStats {
    protected final LongAdder sync_unicasts = new LongAdder();
    protected final LongAdder async_unicasts = new LongAdder();
    protected final LongAdder sync_multicasts = new LongAdder();
    protected final LongAdder async_multicasts = new LongAdder();
    protected final LongAdder sync_anycasts = new LongAdder();
    protected final LongAdder async_anycasts = new LongAdder();
    protected volatile Map<Address, Result> stats;
    protected volatile Map<Address, RTTStat> rtt_stats;

    public RpcStats(boolean extended_stats) {
        this.extendedStats(extended_stats);
    }

    public long unicasts(boolean sync) {
        return sync ? this.sync_unicasts.sum() : this.async_unicasts.sum();
    }

    public long multicasts(boolean sync) {
        return sync ? this.sync_multicasts.sum() : this.async_multicasts.sum();
    }

    public long anycasts(boolean sync) {
        return sync ? this.sync_anycasts.sum() : this.async_anycasts.sum();
    }

    public boolean extendedStats() {
        return this.stats != null;
    }

    public RpcStats extendedStats(boolean f) {
        if (f) {
            if (this.stats == null) {
                this.stats = new ConcurrentHashMap<Address, Result>();
            }
        } else {
            this.stats = null;
        }
        return this;
    }

    public void reset() {
        if (this.stats != null) {
            this.stats.clear();
        }
        if (this.rtt_stats != null) {
            this.rtt_stats.clear();
        }
        for (LongAdder a : List.of(this.sync_unicasts, this.async_unicasts, this.sync_multicasts, this.async_multicasts, this.sync_anycasts, this.async_anycasts)) {
            a.reset();
        }
    }

    public void add(Type type, Address dest, boolean sync, long time) {
        this.update(type, sync);
        this.addToResults(dest, sync, time);
    }

    public void addAnycast(boolean sync, long time, Collection<Address> dests) {
        this.update(Type.ANYCAST, sync);
        if (dests != null) {
            for (Address dest : dests) {
                this.addToResults(dest, sync, time);
            }
        }
    }

    public void addRTTStats(Address sender, RTTHeader hdr) {
        if (hdr == null) {
            return;
        }
        if (this.rtt_stats == null) {
            this.rtt_stats = new ConcurrentHashMap<Address, RTTStat>();
        }
        Address key = sender == null ? Global.NULL_ADDRESS : sender;
        RTTStat rtt_stat = this.rtt_stats.computeIfAbsent(key, k -> new RTTStat());
        rtt_stat.add(hdr);
    }

    public void retainAll(Collection<Address> members) {
        Map<Address, Result> map;
        if (members == null || (map = this.stats) == null) {
            return;
        }
        map.keySet().retainAll(members);
        if (this.rtt_stats != null) {
            this.rtt_stats.keySet().retainAll(members);
        }
    }

    public String printStatsByDest() {
        if (this.stats == null) {
            return "(no stats)";
        }
        StringBuilder sb = new StringBuilder("\n");
        for (Map.Entry<Address, Result> entry : this.stats.entrySet()) {
            Address dst = entry.getKey();
            sb.append(String.format("%s: %s\n", dst == Global.NULL_ADDRESS ? "<all>" : dst, entry.getValue()));
        }
        return sb.toString();
    }

    public String printRTTStatsByDest() {
        if (this.rtt_stats == null) {
            return "(no RTT stats)";
        }
        StringBuilder sb = new StringBuilder("\n");
        for (Map.Entry<Address, RTTStat> entry : this.rtt_stats.entrySet()) {
            Address dst = entry.getKey();
            sb.append(String.format("%s:\n%s\n", dst == Global.NULL_ADDRESS ? "<all>" : dst, entry.getValue()));
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("sync mcasts: %d, async mcasts: %d, sync ucasts: %d, async ucasts: %d, sync acasts: %d, async acasts: %d", this.sync_multicasts.sum(), this.async_multicasts.sum(), this.sync_unicasts.sum(), this.async_unicasts.sum(), this.sync_anycasts.sum(), this.async_anycasts.sum());
    }

    protected void update(Type type, boolean sync) {
        switch (type) {
            case MULTICAST: {
                if (sync) {
                    this.sync_multicasts.increment();
                    break;
                }
                this.async_multicasts.increment();
                break;
            }
            case UNICAST: {
                if (sync) {
                    this.sync_unicasts.increment();
                    break;
                }
                this.async_unicasts.increment();
                break;
            }
            case ANYCAST: {
                if (sync) {
                    this.sync_anycasts.increment();
                    break;
                }
                this.async_anycasts.increment();
            }
        }
    }

    protected void addToResults(Address dest, boolean sync, long time) {
        Map<Address, Result> map = this.stats;
        if (map == null) {
            return;
        }
        if (dest == null) {
            dest = Global.NULL_ADDRESS;
        }
        Result res = map.computeIfAbsent(dest, k -> new Result());
        res.add(sync, time);
    }

    protected static class RTTStat {
        protected final Average total_time = new AverageMinMax().unit(TimeUnit.NANOSECONDS);
        protected final Average down_req_time = new AverageMinMax().unit(TimeUnit.NANOSECONDS);
        protected final Average network_req_time = new AverageMinMax().unit(TimeUnit.NANOSECONDS);
        protected final Average network_rsp_time = new AverageMinMax().unit(TimeUnit.NANOSECONDS);
        protected final Average req_up_time = new AverageMinMax().unit(TimeUnit.NANOSECONDS);
        protected final Average rsp_up_time = new AverageMinMax().unit(TimeUnit.NANOSECONDS);
        protected final Average processing_time = new AverageMinMax().unit(TimeUnit.NANOSECONDS);

        protected RTTStat() {
        }

        protected void add(RTTHeader hdr) {
            if (hdr == null) {
                return;
            }
            long tmp = hdr.totalTime();
            if (tmp > 0L) {
                this.total_time.add(tmp);
            }
            if ((tmp = hdr.downRequest()) > 0L) {
                this.down_req_time.add(tmp);
            }
            if ((tmp = hdr.networkRequest()) > 0L) {
                this.network_req_time.add(tmp);
            }
            if ((tmp = hdr.networkResponse()) > 0L) {
                this.network_rsp_time.add(tmp);
            }
            if ((tmp = hdr.upReq()) > 0L) {
                this.req_up_time.add(tmp);
            }
            if ((tmp = hdr.processingTime()) > 0L) {
                this.processing_time.add(tmp);
            }
            if ((tmp = hdr.upRsp()) > 0L) {
                this.rsp_up_time.add(tmp);
            }
        }

        public String toString() {
            return String.format("  total: %s\n  down-req: %s\n  network req: %s\n  network rsp: %s\n  up-req: %s\n  up-rsp: %s\n  processing time: %s\n", this.total_time.toString(TimeUnit.NANOSECONDS), this.down_req_time.toString(TimeUnit.NANOSECONDS), this.network_req_time.toString(TimeUnit.NANOSECONDS), this.network_rsp_time.toString(TimeUnit.NANOSECONDS), this.req_up_time.toString(TimeUnit.NANOSECONDS), this.rsp_up_time.toString(TimeUnit.NANOSECONDS), this.processing_time.toString(TimeUnit.NANOSECONDS));
        }
    }

    protected static class Result {
        protected long sync;
        protected long async;
        protected final AverageMinMax avg = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);

        protected Result() {
        }

        protected long sync() {
            return this.sync;
        }

        protected long async() {
            return this.async;
        }

        protected double min() {
            return this.avg.min();
        }

        protected double max() {
            return this.avg.max();
        }

        protected synchronized double avg() {
            return this.avg.average();
        }

        protected synchronized void add(boolean sync, long time) {
            if (sync) {
                ++this.sync;
            } else {
                ++this.async;
            }
            if (time > 0L) {
                this.avg.add(time);
            }
        }

        public String toString() {
            return String.format("async: %,d, sync: %,d, round-trip %s", this.async, this.sync, this.avg);
        }
    }

    public static enum Type {
        MULTICAST,
        UNICAST,
        ANYCAST;

    }
}

