/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TCP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArray;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Protocol to discover subgroups existing due to a network partition")
public class MERGE3
extends Protocol {
    @Property(description="Minimum time in ms before sending an info message", type=AttributeType.TIME)
    protected long min_interval = 1000L;
    @Property(description="Interval (in milliseconds) when the next info message will be sent. A random value is picked from range [1..max_interval]", type=AttributeType.TIME)
    protected long max_interval = 10000L;
    @Property(description="The max number of merge participants to be involved in a merge. 0 sets this to unlimited.")
    protected int max_participants_in_merge = 100;
    @Property(description="Interval (in ms) after which we check for view inconsistencies", type=AttributeType.TIME)
    protected long check_interval;
    protected volatile View view;
    protected TimeScheduler timer;
    protected final InfoSender info_sender = new InfoSender();
    protected Future<?> info_sender_future;
    protected Future<?> view_consistency_checker;
    protected final Map<Address, ViewId> views = new HashMap<Address, ViewId>();
    protected final ResponseCollector<View> view_rsps = new ResponseCollector();
    protected boolean transport_supports_multicasting = true;
    protected String cluster_name;
    protected final Consumer<PingData> discovery_rsp_cb = this::sendInfoMessage;
    protected final Event ASYNC_DISCOVERY_EVENT = new Event(13, this.discovery_rsp_cb);
    @ManagedAttribute(description="Whether or not the current member is the coordinator")
    protected volatile boolean is_coord;
    @ManagedAttribute(description="Number of times a MERGE event was sent up the stack", type=AttributeType.SCALAR)
    protected int num_merge_events;

    @ManagedAttribute(description="Number of cached ViewIds")
    public int getViews() {
        return this.views.size();
    }

    public int getNumMergeEvents() {
        return this.num_merge_events;
    }

    @ManagedAttribute(description="Is the view consistency checker task running")
    public synchronized boolean isViewConsistencyCheckerRunning() {
        return this.view_consistency_checker != null && !this.view_consistency_checker.isDone();
    }

    @ManagedAttribute(description="Is the view consistency checker task running")
    public boolean isMergeTaskRunning() {
        return this.isViewConsistencyCheckerRunning();
    }

    @ManagedAttribute(description="Is the info sender task running")
    public synchronized boolean isInfoSenderRunning() {
        return this.info_sender_future != null && !this.info_sender_future.isDone();
    }

    @ManagedOperation(description="Lists the contents of the cached views")
    public String dumpViews() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ViewId, Set<Address>> entry : this.convertViews().entrySet()) {
            sb.append(entry.getKey()).append(": [").append(Util.printListWithDelimiter((Collection)entry.getValue(), ", ", Util.MAX_LIST_PRINT_SIZE)).append("]\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Clears the views cache")
    public void clearViews() {
        Map<Address, ViewId> map = this.views;
        synchronized (map) {
            this.views.clear();
        }
    }

    @ManagedOperation(description="Send INFO")
    public void sendInfo() {
        new InfoSender().run();
    }

    @ManagedOperation(description="Check views for inconsistencies")
    public void checkInconsistencies() {
        new ViewConsistencyChecker().run();
    }

    @Override
    public void init() throws Exception {
        if (this.min_interval >= this.max_interval) {
            throw new IllegalArgumentException("min_interval (" + this.min_interval + ") has to be < max_interval (" + this.max_interval + ")");
        }
        if (this.check_interval == 0L) {
            this.check_interval = this.computeCheckInterval();
        } else if (this.check_interval <= this.max_interval) {
            this.log.warn("set check_interval=%d as it is <= max_interval", this.computeCheckInterval());
            this.check_interval = this.computeCheckInterval();
        }
        if (this.max_interval <= 0L) {
            throw new Exception("max_interval must be > 0");
        }
        this.transport_supports_multicasting = this.getTransport().supportsMulticasting();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.is_coord = false;
        this.stopViewConsistencyChecker();
        this.stopInfoSender();
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    public MERGE3 setMinInterval(long i) {
        if (this.min_interval < 0L || this.min_interval >= this.max_interval) {
            throw new IllegalArgumentException("min_interval (" + this.min_interval + ") has to be < max_interval (" + this.max_interval + ")");
        }
        this.min_interval = i;
        return this;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    public MERGE3 setMaxInterval(long val) {
        if (val <= 0L) {
            throw new IllegalArgumentException("max_interval must be > 0");
        }
        this.max_interval = val;
        this.check_interval = this.computeCheckInterval();
        return this;
    }

    public long getCheckInterval() {
        return this.check_interval;
    }

    public MERGE3 setCheckInterval(long ci) {
        this.check_interval = ci;
        return this;
    }

    public int getMaxParticipantsInMerge() {
        return this.max_participants_in_merge;
    }

    public MERGE3 setMaxParticipantsInMerge(int m) {
        this.max_participants_in_merge = m;
        return this;
    }

    public boolean isCoord() {
        return this.is_coord;
    }

    protected long computeCheckInterval() {
        return (long)((double)this.max_interval * 1.6);
    }

    protected boolean isMergeRunning() {
        Object retval = this.up_prot.up(new Event(100));
        return retval instanceof Boolean && (Boolean)retval != false;
    }

    protected synchronized void startInfoSender() {
        if (this.info_sender_future == null || this.info_sender_future.isDone()) {
            this.info_sender_future = this.timer.scheduleWithDynamicInterval(this.info_sender, this.getTransport() instanceof TCP);
        }
    }

    protected synchronized void stopInfoSender() {
        if (this.info_sender_future != null) {
            this.info_sender_future.cancel(true);
            this.info_sender_future = null;
        }
    }

    protected synchronized void startViewConsistencyChecker() {
        if (this.view_consistency_checker == null || this.view_consistency_checker.isDone()) {
            this.view_consistency_checker = this.timer.scheduleWithDynamicInterval(new ViewConsistencyChecker());
        }
    }

    protected synchronized void stopViewConsistencyChecker() {
        if (this.view_consistency_checker != null) {
            this.view_consistency_checker.cancel(true);
            this.view_consistency_checker = null;
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 80: {
                this.cluster_name = (String)evt.getArg();
                break;
            }
            case 4: 
            case 15: {
                this.stopViewConsistencyChecker();
                this.stopInfoSender();
                break;
            }
            case 6: {
                this.stopViewConsistencyChecker();
                this.stopInfoSender();
                Object ret = this.down_prot.down(evt);
                this.view = (View)evt.getArg();
                this.clearViews();
                if (this.ergonomics && this.max_participants_in_merge > 0) {
                    this.max_participants_in_merge = Math.max(100, this.view.size() / 3);
                }
                this.startInfoSender();
                this.startViewConsistencyChecker();
                Address coord = this.view.getCoord();
                if (Objects.equals(coord, this.local_addr)) {
                    this.is_coord = true;
                } else {
                    this.is_coord = false;
                    this.clearViews();
                }
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Message msg) {
        MergeHeader hdr = (MergeHeader)msg.getHeader(this.getId());
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        return this.handle(hdr, msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            MergeHeader hdr = (MergeHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            it.remove();
            this.handle(hdr, msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    public static List<View> detectDifferentViews(Map<Address, View> map) {
        ArrayList<View> ret = new ArrayList<View>();
        for (View view : map.values()) {
            ViewId vid;
            if (view == null || Util.containsViewId(ret, vid = view.getViewId())) continue;
            ret.add(view);
        }
        return ret;
    }

    public static ByteArray marshal(View view) {
        try {
            return Util.streamableToBuffer(view);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected View readView(byte[] buffer, int offset, int length) {
        try {
            return buffer != null ? Util.streamableFromBuffer(View::new, buffer, offset, length) : null;
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading View from message: %s", this.local_addr, ex);
            return null;
        }
    }

    protected Object handle(MergeHeader hdr, Message msg) {
        Address sender = msg.getSrc();
        switch (hdr.type) {
            case INFO: {
                this.addInfo(sender, hdr.view_id, hdr.logical_name, hdr.physical_addr);
                break;
            }
            case VIEW_REQ: {
                View viewToSend = this.view;
                Message view_rsp = new BytesMessage(sender).setFlag(Message.TransientFlag.DONT_BLOCK).putHeader(this.getId(), MergeHeader.createViewResponse()).setArray(MERGE3.marshal(viewToSend));
                this.log.trace("%s: sending view rsp: %s", this.local_addr, viewToSend);
                this.down_prot.down(view_rsp);
                break;
            }
            case VIEW_RSP: {
                View tmp_view = this.readView(msg.getArray(), msg.getOffset(), msg.getLength());
                this.log.trace("%s: received view rsp from %s: %s", this.local_addr, msg.getSrc(), tmp_view);
                if (tmp_view == null) break;
                this.view_rsps.add(sender, tmp_view);
                break;
            }
            default: {
                this.log.error("Type %s not known", new Object[]{hdr.type});
            }
        }
        return null;
    }

    protected MergeHeader createInfo() {
        PhysicalAddress physical_addr = this.local_addr != null ? (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr)) : null;
        return MergeHeader.createInfo(this.view.getViewId(), NameCache.get(this.local_addr), physical_addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInfo(Address sender, ViewId view_id, String logical_name, PhysicalAddress physical_addr) {
        if (logical_name != null && sender instanceof UUID) {
            NameCache.add(sender, logical_name);
        }
        if (physical_addr != null) {
            this.down(new Event(89, new Tuple<Address, PhysicalAddress>(sender, physical_addr)));
        }
        Map<Address, ViewId> map = this.views;
        synchronized (map) {
            ViewId existing = this.views.get(sender);
            if (existing == null || existing.compareTo(view_id) < 0) {
                this.views.put(sender, view_id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<ViewId, Set<Address>> convertViews() {
        HashMap<ViewId, Set<Address>> retval = new HashMap<ViewId, Set<Address>>();
        Map<Address, ViewId> map = this.views;
        synchronized (map) {
            for (Map.Entry<Address, ViewId> entry : this.views.entrySet()) {
                Address key = entry.getKey();
                ViewId view_id = entry.getValue();
                ConcurrentSkipListSet<Address> existing = (ConcurrentSkipListSet<Address>)retval.get(view_id);
                if (existing == null) {
                    existing = new ConcurrentSkipListSet<Address>();
                    retval.put(view_id, existing);
                }
                existing.add(key);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean differentViewIds() {
        ViewId first = null;
        Map<Address, ViewId> map = this.views;
        synchronized (map) {
            for (ViewId view_id : this.views.values()) {
                if (first == null) {
                    first = view_id;
                    continue;
                }
                if (first.equals(view_id)) continue;
                return true;
            }
        }
        return false;
    }

    protected void sendInfoMessage(PingData data) {
        if (data == null) {
            return;
        }
        Address target = data.getAddress();
        if (this.local_addr.equals(target)) {
            return;
        }
        PhysicalAddress dest = data.getPhysicalAddr();
        if (dest == null) {
            this.log.warn("%s: physical address for %s not found; dropping INFO message to %s", this.local_addr, target, target);
            return;
        }
        MergeHeader hdr = this.createInfo();
        Message info = new EmptyMessage(dest).putHeader(this.getId(), hdr).setFlag(Message.TransientFlag.DONT_BLOCK);
        this.down_prot.down(info);
    }

    public static class MergeHeader
    extends Header {
        protected Type type = Type.INFO;
        protected ViewId view_id;
        protected String logical_name;
        protected PhysicalAddress physical_addr;

        public MergeHeader() {
        }

        public static MergeHeader createInfo(ViewId view_id, String logical_name, PhysicalAddress physical_addr) {
            return new MergeHeader(Type.INFO, view_id, logical_name, physical_addr);
        }

        public static MergeHeader createViewRequest() {
            return new MergeHeader(Type.VIEW_REQ, null, null, null);
        }

        public static MergeHeader createViewResponse() {
            return new MergeHeader(Type.VIEW_RSP, null, null, null);
        }

        protected MergeHeader(Type type, ViewId view_id, String logical_name, PhysicalAddress physical_addr) {
            this.type = type;
            this.view_id = view_id;
            this.logical_name = logical_name;
            this.physical_addr = physical_addr;
        }

        @Override
        public short getMagicId() {
            return 75;
        }

        @Override
        public Supplier<? extends Header> create() {
            return MergeHeader::new;
        }

        @Override
        public int serializedSize() {
            int retval = 1;
            retval += Util.size(this.view_id);
            ++retval;
            if (this.logical_name != null) {
                retval += this.logical_name.length() + 2;
            }
            return retval += Util.size(this.physical_addr);
        }

        @Override
        public void writeTo(DataOutput outstream) throws IOException {
            outstream.writeByte(this.type.ordinal());
            Util.writeViewId(this.view_id, outstream);
            Bits.writeString(this.logical_name, outstream);
            Util.writeAddress(this.physical_addr, outstream);
        }

        @Override
        public void readFrom(DataInput instream) throws IOException, ClassNotFoundException {
            this.type = Type.values()[instream.readByte()];
            this.view_id = Util.readViewId(instream);
            this.logical_name = Bits.readString(instream);
            this.physical_addr = (PhysicalAddress)Util.readAddress(instream);
        }

        @Override
        public String toString() {
            return String.format("%s: %s, logical_name=%s, physical_addr=%s", new Object[]{this.type, this.view_id != null ? "view_id=" + this.view_id : "", this.logical_name, this.physical_addr});
        }

        protected static enum Type {
            INFO,
            VIEW_REQ,
            VIEW_RSP;

        }
    }

    protected class ViewConsistencyChecker
    implements TimeScheduler.Task {
        protected ViewConsistencyChecker() {
        }

        @Override
        public void run() {
            try {
                MergeHeader hdr = MERGE3.this.createInfo();
                MERGE3.this.addInfo(MERGE3.this.local_addr, hdr.view_id, hdr.logical_name, hdr.physical_addr);
                if (!MERGE3.this.differentViewIds()) {
                    MERGE3.this.log.trace("%s: found no inconsistent views: %s", MERGE3.this.local_addr, MERGE3.this.dumpViews());
                    return;
                }
                this._run();
            }
            finally {
                MERGE3.this.clearViews();
            }
        }

        protected void _run() {
            TreeSet<Address> coords = new TreeSet<Address>();
            Map<ViewId, Set<Address>> converted_views = MERGE3.this.convertViews();
            converted_views.keySet().stream().map(ViewId::getCreator).forEach(coords::add);
            coords.addAll(converted_views.values().stream().filter(set -> !set.isEmpty()).map(set -> (Address)set.iterator().next()).collect(Collectors.toList()));
            if (coords.size() <= 1) {
                MERGE3.this.log.trace("%s: cancelling merge as we only have 1 coordinator: %s", MERGE3.this.local_addr, coords);
                return;
            }
            MERGE3.this.log.trace("%s: merge participants are %s", MERGE3.this.local_addr, coords);
            if (MERGE3.this.max_participants_in_merge > 0 && coords.size() > MERGE3.this.max_participants_in_merge) {
                int old_size = coords.size();
                coords.removeIf(next -> coords.size() > MERGE3.this.max_participants_in_merge);
                MERGE3.this.log.trace("%s: reduced %d coords to %d", MERGE3.this.local_addr, old_size, MERGE3.this.max_participants_in_merge);
            }
            MERGE3.this.view_rsps.reset(coords);
            for (Address target : coords) {
                if (target.equals(MERGE3.this.local_addr)) {
                    if (MERGE3.this.view == null) continue;
                    MERGE3.this.view_rsps.add(MERGE3.this.local_addr, MERGE3.this.view);
                    continue;
                }
                Message view_req = new EmptyMessage(target).putHeader(MERGE3.this.getId(), MergeHeader.createViewRequest());
                MERGE3.this.down_prot.down(view_req);
            }
            MERGE3.this.view_rsps.waitForAllResponses(MERGE3.this.check_interval / 10L);
            Map<Address, View> results = MERGE3.this.view_rsps.getResults();
            MERGE3.this.log.trace("%s: got all results: %s", MERGE3.this.local_addr, results);
            HashMap merge_views = new HashMap();
            results.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> merge_views.put((Address)entry.getKey(), (View)entry.getValue()));
            MERGE3.this.view_rsps.reset();
            if (merge_views.size() >= 2) {
                Collection tmp_views = merge_views.values();
                if (Util.allEqual(tmp_views)) {
                    MERGE3.this.log.trace("%s: all views are the same, suppressing sending MERGE up. Views: %s", MERGE3.this.local_addr, tmp_views);
                    return;
                }
                MERGE3.this.up_prot.up(new Event(14, merge_views));
                ++MERGE3.this.num_merge_events;
            } else {
                MERGE3.this.log.trace("%s: %d merged views. Nothing to do", MERGE3.this.local_addr, merge_views.size());
            }
        }

        @Override
        public long nextInterval() {
            return MERGE3.this.check_interval;
        }

        public String toString() {
            return String.format("%s: %s (interval=%dms", MERGE3.class.getSimpleName(), this.getClass().getSimpleName(), MERGE3.this.check_interval);
        }
    }

    protected class InfoSender
    implements TimeScheduler.Task {
        protected InfoSender() {
        }

        @Override
        public void run() {
            if (MERGE3.this.view == null) {
                MERGE3.this.log.warn("%s: view is null, cannot send INFO message", MERGE3.this.local_addr);
                return;
            }
            MergeHeader hdr = MERGE3.this.createInfo();
            if (MERGE3.this.transport_supports_multicasting) {
                Message msg = new EmptyMessage().putHeader(MERGE3.this.getId(), hdr).setFlag(Message.TransientFlag.DONT_LOOPBACK);
                MERGE3.this.down_prot.down(msg);
            } else {
                MERGE3.this.down_prot.down(MERGE3.this.ASYNC_DISCOVERY_EVENT);
            }
        }

        @Override
        public long nextInterval() {
            return Math.max(MERGE3.this.min_interval, Util.random(MERGE3.this.max_interval) + MERGE3.this.max_interval / 2L);
        }

        public String toString() {
            return MERGE3.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }
}

