/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.constraints;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class InstructorConstraint
extends GlobalConstraint<TeachingRequest.Variable, TeachingAssignment> {
    @Override
    public void computeConflicts(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        Instructor.Context context = (Instructor.Context)value.getInstructor().getContext(assignment);
        if (context.getInstructor().getTimePreference(((TeachingRequest.Variable)value.variable()).getRequest()).isProhibited()) {
            conflicts.add(value);
            return;
        }
        for (TeachingAssignment ta : context.getAssignments()) {
            if (((TeachingRequest.Variable)ta.variable()).equals(value.variable()) || conflicts.contains(ta) || !((TeachingRequest.Variable)ta.variable()).getRequest().overlaps(((TeachingRequest.Variable)value.variable()).getRequest())) continue;
            conflicts.add(ta);
        }
        for (TeachingAssignment ta : context.getAssignments()) {
            if (((TeachingRequest.Variable)ta.variable()).equals(value.variable()) || conflicts.contains(ta) || !((TeachingRequest.Variable)ta.variable()).getRequest().isSameCourseViolated(((TeachingRequest.Variable)value.variable()).getRequest()) && !((TeachingRequest.Variable)ta.variable()).getRequest().isSameCommonViolated(((TeachingRequest.Variable)value.variable()).getRequest())) continue;
            conflicts.add(ta);
        }
        float load = ((TeachingRequest.Variable)value.variable()).getRequest().getLoad();
        ArrayList<TeachingAssignment> adepts = new ArrayList<TeachingAssignment>();
        for (TeachingAssignment ta : context.getAssignments()) {
            if (((TeachingRequest.Variable)ta.variable()).equals(value.variable()) || conflicts.contains(ta)) continue;
            adepts.add(ta);
            load += ((TeachingRequest.Variable)ta.variable()).getRequest().getLoad();
        }
        while (load > context.getInstructor().getMaxLoad()) {
            if (adepts.isEmpty()) {
                conflicts.add(value);
                break;
            }
            TeachingAssignment conflict = (TeachingAssignment)ToolBox.random(adepts);
            load -= ((TeachingRequest.Variable)conflict.variable()).getRequest().getLoad();
            adepts.remove(conflict);
            conflicts.add(conflict);
        }
    }

    @Override
    public String getName() {
        return "Instructor Constraint";
    }

    public String toString() {
        return this.getName();
    }
}

