/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.tt;

import java.util.HashSet;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.example.tt.Activity;
import org.cpsolver.ifs.example.tt.Location;
import org.cpsolver.ifs.example.tt.TimetableModel;

public class Resource
extends ConstraintWithContext<Activity, Location, Context> {
    private String iName = null;
    private String iResourceId = null;
    private Set<Integer> iProhibitedSlots = new HashSet<Integer>();
    private Set<Integer> iDiscouragedSlots = new HashSet<Integer>();
    private int iType = 3;
    public static final int TYPE_ROOM = 0;
    public static final int TYPE_INSTRUCTOR = 1;
    public static final int TYPE_CLASS = 2;
    public static final int TYPE_OTHER = 3;

    public Resource(String id, int type, String name) {
        this.iResourceId = id;
        this.iName = name;
        this.iType = type;
    }

    public String getResourceId() {
        return this.iResourceId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public int getType() {
        return this.iType;
    }

    public Set<Integer> getProhibitedSlots() {
        return this.iProhibitedSlots;
    }

    public Set<Integer> getDiscouragedSlots() {
        return this.iDiscouragedSlots;
    }

    public void addProhibitedSlot(int day, int hour) {
        this.iProhibitedSlots.add(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public void addDiscouragedSlot(int day, int hour) {
        this.iDiscouragedSlots.add(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public boolean isProhibitedSlot(int day, int hour) {
        return this.iProhibitedSlots.contains(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public boolean isDiscouragedSlot(int day, int hour) {
        return this.iDiscouragedSlots.contains(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public void addProhibitedSlot(int slot) {
        this.iProhibitedSlots.add(slot);
    }

    public void addDiscouragedSlot(int slot) {
        this.iDiscouragedSlots.add(slot);
    }

    public boolean isProhibitedSlot(int slot) {
        return this.iProhibitedSlots.contains(slot);
    }

    public boolean isDiscouragedSlot(int slot) {
        return this.iDiscouragedSlots.contains(slot);
    }

    public boolean isProhibited(int day, int hour, int length) {
        int slot = ((TimetableModel)this.getModel()).getNrHours() * day + hour;
        for (int i = 0; i < length; ++i) {
            if (!this.iProhibitedSlots.contains(slot + i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void computeConflicts(Assignment<Activity, Location> assignment, Location location, Set<Location> conflicts) {
        Activity activity = (Activity)location.variable();
        if (!location.containResource(this)) {
            return;
        }
        Context context = (Context)this.getContext((Assignment)assignment);
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            Activity conf = context.getActivity(i);
            if (conf == null || activity.equals(conf)) continue;
            conflicts.add(assignment.getValue(conf));
        }
    }

    @Override
    public boolean inConflict(Assignment<Activity, Location> assignment, Location location) {
        Activity activity = (Activity)location.variable();
        if (!location.containResource(this)) {
            return false;
        }
        Context context = (Context)this.getContext((Assignment)assignment);
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            if (context.getActivity(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(Location l1, Location l2) {
        return !l1.containResource(this) || !l2.containResource(this) || !l1.hasIntersection(l2);
    }

    @Override
    public Context createAssignmentContext(Assignment<Activity, Location> assignment) {
        return new Context(assignment);
    }

    public class Context
    implements AssignmentConstraintContext<Activity, Location> {
        private Activity[] iResource;

        public Context(Assignment<Activity, Location> assignment) {
            TimetableModel model = (TimetableModel)Resource.this.getModel();
            this.iResource = new Activity[model.getNrDays() * model.getNrHours()];
            for (int i = 0; i < this.iResource.length; ++i) {
                this.iResource[i] = null;
            }
            for (Location location : assignment.assignedValues()) {
                this.assigned(assignment, location);
            }
        }

        @Override
        public void assigned(Assignment<Activity, Location> assignment, Location location) {
            Activity activity = (Activity)location.variable();
            if (!location.containResource(Resource.this)) {
                return;
            }
            for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
                this.iResource[i] = activity;
            }
        }

        public Activity getActivity(int slot) {
            return this.iResource[slot];
        }

        @Override
        public void unassigned(Assignment<Activity, Location> assignment, Location location) {
            Activity activity = (Activity)location.variable();
            if (!location.containResource(Resource.this)) {
                return;
            }
            for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
                this.iResource[i] = null;
            }
        }
    }
}

