/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.tt;

import org.cpsolver.ifs.example.tt.Activity;
import org.cpsolver.ifs.example.tt.Resource;
import org.cpsolver.ifs.example.tt.TimetableModel;
import org.cpsolver.ifs.model.Value;

public class Location
extends Value<Activity, Location> {
    private int iSlot;
    private Resource[] iResources;
    private int iNrOfDiscouragedSlots = -1;

    public Location(Activity activity, int slot, Resource[] resources) {
        super(activity);
        this.iSlot = slot;
        this.iResources = resources;
        this.iNrOfDiscouragedSlots = this.computeNrOfDiscouragedSlots();
    }

    public Location(Activity activity, int day, int hour, Resource[] resources) {
        super(activity);
        this.iSlot = ((TimetableModel)activity.getModel()).getNrHours() * day + hour;
        this.iResources = resources;
        this.iNrOfDiscouragedSlots = this.computeNrOfDiscouragedSlots();
    }

    public int getSlot() {
        return this.iSlot;
    }

    public Resource[] getResources() {
        return this.iResources;
    }

    public Resource getResource(int idx) {
        return this.iResources[idx];
    }

    public boolean containResource(Resource resource) {
        for (int i = 0; i < this.iResources.length; ++i) {
            if (!this.iResources[i].equals(resource)) continue;
            return true;
        }
        return false;
    }

    public int getNrOfDiscouragedSlots() {
        return this.iNrOfDiscouragedSlots;
    }

    @Override
    public double toDouble() {
        return this.iNrOfDiscouragedSlots;
    }

    public int computeNrOfDiscouragedSlots() {
        Activity a = (Activity)this.variable();
        int ret = 0;
        for (int i = this.getSlot(); i < this.getSlot() + a.getLength(); ++i) {
            if (a.isDiscouragedSlot(i)) {
                ++ret;
            }
            for (int j = 0; j < this.getResources().length; ++j) {
                if (!this.getResource(j).isDiscouragedSlot(i)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public boolean hasIntersection(Location location) {
        int s1 = this.getSlot();
        int l1 = ((Activity)this.variable()).getLength();
        int s2 = location.getSlot();
        int l2 = ((Activity)location.variable()).getLength();
        return s1 + l1 > s2 && s2 + l2 > s1;
    }

    public boolean isProhibited() {
        Activity a = (Activity)this.variable();
        for (int i = this.getSlot(); i < this.getSlot() + a.getLength(); ++i) {
            if (a.isProhibitedSlot(i)) {
                return true;
            }
            for (int j = 0; j < this.getResources().length; ++j) {
                if (!this.getResource(j).isProhibitedSlot(i)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        StringBuffer sb = new StringBuffer(this.getSlot() + "/");
        for (int i = 0; i < this.iResources.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.iResources[i].getName());
        }
        return sb.toString();
    }
}

