/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamRoomSharing;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.ConstraintListener;

public class ExamRoom
extends ConstraintWithContext<Exam, ExamPlacement, ExamRoomContext> {
    private boolean[] iAvailable;
    private int[] iPenalty;
    private String iName;
    private int iSize;
    private int iAltSize;
    private Double iCoordX;
    private Double iCoordY;
    private boolean iHard = true;
    private ExamRoom iParentRoom;
    private List<ExamRoom> iPartitions;
    private Map<Long, Double> iDistanceCache = new HashMap<Long, Double>();

    public ExamRoom(ExamModel model, long id, String name, int size, int altSize, Double coordX, Double coordY) {
        this.iId = id;
        this.iName = name;
        this.iCoordX = coordX;
        this.iCoordY = coordY;
        this.iSize = size;
        this.iAltSize = altSize;
        this.iAvailable = new boolean[model.getNrPeriods()];
        this.iPenalty = new int[model.getNrPeriods()];
        for (int i = 0; i < this.iAvailable.length; ++i) {
            this.iAvailable[i] = true;
            this.iPenalty[i] = 0;
        }
    }

    public void setHard(boolean hard) {
        this.iHard = hard;
    }

    @Override
    public boolean isHard() {
        return this.iHard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDistanceInMeters(ExamRoom other) {
        Map<Long, Double> map = this.iDistanceCache;
        synchronized (map) {
            Double distance = this.iDistanceCache.get(other.getId());
            if (distance == null) {
                distance = ((ExamModel)this.getModel()).getDistanceMetric().getDistanceInMeters(this.getId(), this.getCoordX(), this.getCoordY(), other.getId(), other.getCoordX(), other.getCoordY());
                this.iDistanceCache.put(other.getId(), distance);
            }
            return distance;
        }
    }

    public int getSize() {
        return this.iSize;
    }

    public int getAltSize() {
        return this.iAltSize;
    }

    public Double getCoordX() {
        return this.iCoordX;
    }

    public Double getCoordY() {
        return this.iCoordY;
    }

    public List<ExamPlacement> getPlacements(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        return ((ExamRoomContext)this.getContext((Assignment)assignment)).getPlacements(period.getIndex());
    }

    public boolean isAvailable(ExamPeriod period) {
        return this.iAvailable[period.getIndex()];
    }

    public boolean isAvailable(int period) {
        return this.iAvailable[period];
    }

    public boolean isAvailable() {
        for (boolean a : this.iAvailable) {
            if (!a) continue;
            return true;
        }
        return false;
    }

    public void setAvailable(ExamPeriod period, boolean available) {
        this.iAvailable[period.getIndex()] = available;
    }

    public void setAvailable(int period, boolean available) {
        this.iAvailable[period] = available;
    }

    public int getPenalty(ExamPeriod period) {
        return this.iPenalty[period.getIndex()];
    }

    public int getPenalty(int period) {
        return this.iPenalty[period];
    }

    public void setPenalty(ExamPeriod period, int penalty) {
        this.iPenalty[period.getIndex()] = penalty;
    }

    public void setPenalty(int period, int penalty) {
        this.iPenalty[period] = penalty;
    }

    public ExamRoomSharing getRoomSharing() {
        return ((ExamModel)this.getModel()).getRoomSharing();
    }

    public void computeConflicts(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamPeriod period, Set<ExamPlacement> conflicts) {
        boolean single;
        boolean bl = single = exam.getSize() <= (exam.hasAltSeating() ? this.getAltSize() : this.getSize());
        if (this.getRoomSharing() == null || !single) {
            for (ExamPlacement conflict : ((ExamRoomContext)this.getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                if (((Exam)conflict.variable()).equals(exam)) continue;
                conflicts.add(conflict);
            }
            if (this.getParentRoom() != null && this.getParentRoom().isHard()) {
                for (ExamPlacement conflict : ((ExamRoomContext)this.getParentRoom().getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                    if (((Exam)conflict.variable()).equals(exam)) continue;
                    conflicts.add(conflict);
                }
            }
            if (this.getPartitions() != null) {
                for (ExamRoom partition : this.getPartitions()) {
                    if (!partition.isHard()) continue;
                    for (ExamPlacement conflict : ((ExamRoomContext)partition.getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                        if (((Exam)conflict.variable()).equals(exam)) continue;
                        conflicts.add(conflict);
                    }
                }
            }
        } else {
            if (this.getParentRoom() != null && this.getParentRoom().isHard()) {
                for (ExamPlacement conflict : ((ExamRoomContext)this.getParentRoom().getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                    if (((Exam)conflict.variable()).equals(exam)) continue;
                    conflicts.add(conflict);
                }
            }
            if (this.getPartitions() != null) {
                for (ExamRoom partition : this.getPartitions()) {
                    if (!partition.isHard()) continue;
                    for (ExamPlacement conflict : ((ExamRoomContext)partition.getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                        if (((Exam)conflict.variable()).equals(exam)) continue;
                        conflicts.add(conflict);
                    }
                }
            }
            this.getRoomSharing().computeConflicts(exam, ((ExamRoomContext)this.getContext((Assignment)assignment)).getPlacements(period.getIndex()), this, conflicts);
        }
    }

    public boolean inConflict(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamPeriod period) {
        boolean single;
        boolean bl = single = exam.getSize() <= (exam.hasAltSeating() ? this.getAltSize() : this.getSize());
        if (this.getRoomSharing() == null || !single) {
            for (ExamPlacement conflict : ((ExamRoomContext)this.getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                if (((Exam)conflict.variable()).equals(exam)) continue;
                return true;
            }
            if (this.getParentRoom() != null && this.getParentRoom().isHard()) {
                for (ExamPlacement conflict : ((ExamRoomContext)this.getParentRoom().getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                    if (((Exam)conflict.variable()).equals(exam)) continue;
                    return true;
                }
            }
            if (this.getPartitions() != null) {
                for (ExamRoom partition : this.getPartitions()) {
                    if (!partition.isHard()) continue;
                    for (ExamPlacement conflict : ((ExamRoomContext)partition.getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                        if (((Exam)conflict.variable()).equals(exam)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        if (this.getParentRoom() != null && this.getParentRoom().isHard()) {
            for (ExamPlacement conflict : ((ExamRoomContext)this.getParentRoom().getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                if (((Exam)conflict.variable()).equals(exam)) continue;
                return true;
            }
        }
        if (this.getPartitions() != null) {
            for (ExamRoom partition : this.getPartitions()) {
                if (!partition.isHard()) continue;
                for (ExamPlacement conflict : ((ExamRoomContext)partition.getContext((Assignment)assignment)).getPlacements(period.getIndex())) {
                    if (((Exam)conflict.variable()).equals(exam)) continue;
                    return true;
                }
            }
        }
        return this.getRoomSharing().inConflict(exam, ((ExamRoomContext)this.getContext((Assignment)assignment)).getPlacements(period.getIndex()), this);
    }

    @Override
    public void computeConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPlacement p, Set<ExamPlacement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        if (!p.contains(this)) {
            return;
        }
        if (this.getParentRoom() != null && p.contains(this.getParentRoom())) {
            conflicts.add(p);
            return;
        }
        this.computeConflicts(assignment, (Exam)p.variable(), p.getPeriod(), conflicts);
    }

    @Override
    public boolean inConflict(Assignment<Exam, ExamPlacement> assignment, ExamPlacement p) {
        if (!this.isHard()) {
            return false;
        }
        if (!p.contains(this)) {
            return false;
        }
        if (this.getParentRoom() != null && p.contains(this.getParentRoom())) {
            return false;
        }
        return this.inConflict(assignment, (Exam)p.variable(), p.getPeriod());
    }

    @Override
    public boolean isConsistent(ExamPlacement p1, ExamPlacement p2) {
        return !this.isHard() || p1.getPeriod() != p2.getPeriod() || !p1.contains(this) || !p2.contains(this);
    }

    @Override
    public void assigned(Assignment<Exam, ExamPlacement> assignment, long iteration, ExamPlacement p) {
        if (p.contains(this)) {
            if (!((ExamRoomContext)this.getContext((Assignment)assignment)).getPlacements(p.getPeriod().getIndex()).isEmpty() || this.getParentRoom() != null || this.getPartitions() != null) {
                HashSet<ExamPlacement> confs = new HashSet<ExamPlacement>();
                this.computeConflicts(assignment, p, (Set<ExamPlacement>)confs);
                for (ExamPlacement conf : confs) {
                    assignment.unassign(iteration, (Exam)conf.variable());
                }
                if (this.iConstraintListeners != null) {
                    for (ConstraintListener listener : this.iConstraintListeners) {
                        listener.constraintAfterAssigned(assignment, iteration, this, p, confs);
                    }
                }
            }
            ((ExamRoomContext)this.getContext((Assignment)assignment)).assigned(assignment, p);
        }
    }

    @Override
    public void unassigned(Assignment<Exam, ExamPlacement> assignment, long iteration, ExamPlacement p) {
        if (p.contains(this)) {
            ((ExamRoomContext)this.getContext((Assignment)assignment)).unassigned(assignment, p);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamRoom)) {
            return false;
        }
        ExamRoom r = (ExamRoom)o;
        return this.getId() == r.getId();
    }

    @Override
    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @Override
    public String getName() {
        return this.hasName() ? this.iName : String.valueOf(this.getId());
    }

    public boolean hasName() {
        return this.iName != null && this.iName.length() > 0;
    }

    public String toString() {
        return this.getName();
    }

    public void addPartition(ExamRoom room) {
        room.iParentRoom = this;
        if (this.iPartitions == null) {
            this.iPartitions = new ArrayList<ExamRoom>();
        }
        this.iPartitions.add(room);
    }

    public ExamRoom getParentRoom() {
        return this.iParentRoom;
    }

    public List<ExamRoom> getPartitions() {
        return this.iPartitions;
    }

    @Override
    public int compareTo(Constraint<Exam, ExamPlacement> o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public ExamRoomContext createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new ExamRoomContext(assignment);
    }

    public static boolean checkParents(Collection<ExamRoomPlacement> roomsSoFar, ExamRoomPlacement room) {
        if (room.getRoom().getParentRoom() != null) {
            for (ExamRoomPlacement r : roomsSoFar) {
                if (!r.getRoom().equals(room.getRoom().getParentRoom())) continue;
                return false;
            }
        }
        if (room.getRoom().getPartitions() != null) {
            for (ExamRoomPlacement r : roomsSoFar) {
                if (!room.getRoom().getPartitions().contains(r.getRoom())) continue;
                return false;
            }
        }
        return true;
    }

    public class ExamRoomContext
    implements AssignmentConstraintContext<Exam, ExamPlacement> {
        private List<ExamPlacement>[] iTable;

        public ExamRoomContext(Assignment<Exam, ExamPlacement> assignment) {
            ExamModel model = (ExamModel)ExamRoom.this.getModel();
            this.iTable = new List[model.getNrPeriods()];
            for (int i = 0; i < this.iTable.length; ++i) {
                this.iTable[i] = new ArrayList<ExamPlacement>();
            }
            for (Exam exam : ExamRoom.this.variables()) {
                ExamPlacement placement = assignment.getValue(exam);
                if (placement == null || !placement.contains(ExamRoom.this)) continue;
                this.iTable[placement.getPeriod().getIndex()].add(placement);
            }
        }

        @Override
        public void assigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
            if (placement.contains(ExamRoom.this)) {
                this.iTable[placement.getPeriod().getIndex()].add(placement);
            }
        }

        @Override
        public void unassigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
            if (placement.contains(ExamRoom.this)) {
                this.iTable[placement.getPeriod().getIndex()].remove(placement);
            }
        }

        public List<ExamPlacement> getPlacements(int period) {
            return this.iTable[period];
        }
    }
}

