/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentGroup;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.sectioning.StudentMove;
import org.cpsolver.ifs.assignment.Assignment;

public class StudentSwap
implements StudentMove {
    private TimetableModel iModel;
    private Student iFirstStudent;
    private Student iSecondStudent;
    private Set<Lecture> iFirstLectures;
    private Set<Lecture> iSecondLectures;
    private Configuration iFirstConfig;
    private Configuration iSecondConfig;
    private boolean iAllowed = true;

    public StudentSwap(TimetableModel model, Assignment<Lecture, Placement> assignment, Student firstStudent, Student secondStudent, Long offeringId) {
        this.iModel = model;
        this.iFirstStudent = firstStudent;
        this.iSecondStudent = secondStudent;
        this.iAllowed = this.initSwap(assignment, offeringId);
    }

    public StudentSwap(TimetableModel model, Assignment<Lecture, Placement> assignment, Student student, Collection<Lecture> lectures) {
        this.iModel = model;
        this.iFirstStudent = student;
        this.iSecondStudent = null;
        this.iAllowed = this.initMove(assignment, lectures);
    }

    protected boolean initSwap(Assignment<Lecture, Placement> assignment, Long offeringId) {
        double w1 = this.iFirstStudent.getOfferingWeight(offeringId);
        double w2 = this.iSecondStudent.getOfferingWeight(offeringId);
        this.iFirstLectures = new HashSet<Lecture>();
        for (Lecture lecture : this.iFirstStudent.getLectures()) {
            if (lecture.getConfiguration() == null) {
                return false;
            }
            if (!lecture.getConfiguration().getOfferingId().equals(offeringId) || this.iSecondStudent.getLectures().contains(lecture)) continue;
            this.iFirstLectures.add(lecture);
            if (this.iFirstConfig == null) {
                this.iFirstConfig = lecture.getConfiguration();
            }
            if (!this.iSecondStudent.canEnroll(lecture) || !this.iFirstStudent.canUnenroll(lecture)) {
                return false;
            }
            if (!(w2 - w1 > 0.0) || !(lecture.nrWeightedStudents() - w1 + w2 > 1.0E-4 + (double)lecture.classLimit(assignment))) continue;
            return false;
        }
        this.iSecondLectures = new HashSet<Lecture>();
        for (Lecture lecture : this.iSecondStudent.getLectures()) {
            if (lecture.getConfiguration() == null) {
                return false;
            }
            if (!lecture.getConfiguration().getOfferingId().equals(offeringId) || this.iFirstStudent.getLectures().contains(lecture)) continue;
            this.iSecondLectures.add(lecture);
            if (this.iSecondConfig == null) {
                this.iSecondConfig = lecture.getConfiguration();
            }
            if (!this.iFirstStudent.canEnroll(lecture) || !this.iSecondStudent.canUnenroll(lecture)) {
                return false;
            }
            if (!(w1 - w2 > 0.0) || !(lecture.nrWeightedStudents() - w2 + w1 > 1.0E-4 + (double)lecture.classLimit(assignment))) continue;
            return false;
        }
        return !this.iFirstLectures.isEmpty() && !this.iSecondLectures.isEmpty();
    }

    private boolean initMove(Assignment<Lecture, Placement> assignment, Collection<Lecture> lectures) {
        double w = 0.0;
        this.iFirstLectures = new HashSet<Lecture>();
        this.iSecondLectures = new HashSet<Lecture>();
        for (Lecture lecture : lectures) {
            if (lecture.getConfiguration() == null) {
                return false;
            }
            if (this.iFirstStudent.getLectures().contains(lecture)) continue;
            if (this.iSecondConfig == null) {
                this.iSecondConfig = lecture.getConfiguration();
                w = this.iFirstStudent.getOfferingWeight(this.iSecondConfig);
            }
            this.iSecondLectures.add(lecture);
            if (!(lecture.nrWeightedStudents() + w > 1.0E-4 + (double)lecture.classLimit(assignment))) continue;
            return false;
        }
        if (this.iSecondLectures.isEmpty()) {
            return false;
        }
        this.iFirstLectures = new HashSet<Lecture>();
        for (Lecture lecture : this.iFirstStudent.getLectures()) {
            if (lecture.getConfiguration() == null) {
                return false;
            }
            if (!lecture.getConfiguration().getOfferingId().equals(this.iSecondConfig.getOfferingId()) || lectures.contains(lecture)) continue;
            this.iFirstLectures.add(lecture);
            if (this.iFirstConfig == null) {
                this.iFirstConfig = lecture.getConfiguration();
            }
            if (lecture.getClassLimitConstraint() == null || !(lecture.nrWeightedStudents() < 1.0E-4 + (double)lecture.minClassLimit())) continue;
            return false;
        }
        return !this.iFirstLectures.isEmpty();
    }

    protected void decJenrl(Assignment<Lecture, Placement> assignment, Student student, Lecture l1, Lecture l2) {
        if (l1.equals(l2)) {
            return;
        }
        JenrlConstraint jenrl = l1.jenrlConstraint(l2);
        if (jenrl != null) {
            jenrl.decJenrl(assignment, student);
        }
    }

    protected void incJenrl(Assignment<Lecture, Placement> assignment, Student student, Lecture l1, Lecture l2) {
        if (l1.equals(l2)) {
            return;
        }
        JenrlConstraint jenrl = l1.jenrlConstraint(l2);
        if (jenrl == null) {
            jenrl = new JenrlConstraint();
            jenrl.addVariable(l1);
            jenrl.addVariable(l2);
            this.iModel.addConstraint(jenrl);
        }
        jenrl.incJenrl(assignment, student);
    }

    public double getJenrConflictWeight(List<StudentConflict> criteria, Student student, Placement p1, Placement p2) {
        if (p1 == null || p2 == null) {
            return 0.0;
        }
        if (criteria == null) {
            if (JenrlConstraint.isInConflict(p1, p2, this.iModel.getDistanceMetric(), this.iModel.getStudentWorkDayLimit())) {
                return student.getJenrlWeight((Lecture)p1.variable(), (Lecture)p2.variable());
            }
            return 0.0;
        }
        double weight = 0.0;
        for (StudentConflict sc : criteria) {
            if (!sc.isApplicable(student, (Lecture)p1.variable(), (Lecture)p2.variable()) || !sc.inConflict(p1, p2)) continue;
            weight += sc.getWeight() * student.getJenrlWeight((Lecture)p1.variable(), (Lecture)p2.variable());
        }
        return weight;
    }

    @Override
    public double value(Assignment<Lecture, Placement> assignment) {
        return this.value(this.iModel == null ? null : this.iModel.getStudentConflictCriteria(), assignment);
    }

    private double groupValue(Student student, Student other, Lecture lecture) {
        if (student.getGroups().isEmpty()) {
            return 0.0;
        }
        double ret = 0.0;
        for (StudentGroup g : student.getGroups()) {
            ret += this.groupValue(g, student, other, lecture);
        }
        return ret;
    }

    private double groupValue(StudentGroup group, Student student, Student other, Lecture lecture) {
        int match = 0;
        for (Student s : lecture.students()) {
            if (s.equals(student) || s.equals(other) || !s.getGroups().contains(group)) continue;
            ++match;
        }
        if (match > 0) {
            double total = group.countStudents(lecture.getConfiguration().getOfferingId());
            return 2.0 * (double)match / (total * (total - 1.0)) / (double)group.countOfferings();
        }
        return 0.0;
    }

    private double groupValue(Student student, Student other, Configuration config, Set<Lecture> lectures) {
        double ret = 0.0;
        for (Lecture lecture : lectures) {
            ret += this.groupValue(student, other, lecture);
        }
        return ret / (double)config.countSubparts();
    }

    @Override
    public double value(List<StudentConflict> criteria, Assignment<Lecture, Placement> assignment) {
        Placement p2;
        Placement p1;
        double delta = 0.0;
        for (Lecture l1 : this.iFirstLectures) {
            p1 = assignment.getValue(l1);
            if (p1 == null) continue;
            for (Lecture l2 : this.iFirstStudent.getLectures()) {
                p2 = assignment.getValue(l2);
                if (l1.equals(l2) || p2 == null || this.iFirstLectures.contains(l2) && l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                delta -= this.getJenrConflictWeight(criteria, this.iFirstStudent, p1, p2);
            }
            if (this.iSecondStudent == null) continue;
            for (Lecture l2 : this.iSecondStudent.getLectures()) {
                if (this.iSecondLectures.contains(l2)) continue;
                p2 = assignment.getValue(l2);
                if (l1.equals(l2) || p2 == null) continue;
                delta += this.getJenrConflictWeight(criteria, this.iSecondStudent, p1, p2);
            }
            for (Lecture l2 : this.iFirstLectures) {
                p2 = assignment.getValue(l2);
                if (l1.equals(l2) || p2 == null || l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                delta += this.getJenrConflictWeight(criteria, this.iSecondStudent, p1, p2);
            }
        }
        for (Lecture l1 : this.iSecondLectures) {
            p1 = assignment.getValue(l1);
            if (p1 == null) continue;
            if (this.iSecondStudent != null) {
                for (Lecture l2 : this.iSecondStudent.getLectures()) {
                    p2 = assignment.getValue(l2);
                    if (l1.equals(l2) || p2 == null || this.iSecondLectures.contains(l2) && l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                    delta -= this.getJenrConflictWeight(criteria, this.iSecondStudent, p1, p2);
                }
            }
            for (Lecture l2 : this.iFirstStudent.getLectures()) {
                if (this.iFirstLectures.contains(l2)) continue;
                p2 = assignment.getValue(l2);
                if (l1.equals(l2) || p2 == null) continue;
                delta += this.getJenrConflictWeight(criteria, this.iFirstStudent, p1, p2);
            }
            for (Lecture l2 : this.iSecondLectures) {
                p2 = assignment.getValue(l2);
                if (l1.equals(l2) || p2 == null || l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                delta += this.getJenrConflictWeight(criteria, this.iFirstStudent, p1, p2);
            }
        }
        return delta;
    }

    @Override
    public void assign(Assignment<Lecture, Placement> assignment, long iteration) {
        for (Lecture l1 : this.iFirstLectures) {
            for (Lecture l2 : this.iFirstStudent.getLectures()) {
                if (l1.equals(l2) || this.iFirstLectures.contains(l2) && l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                this.decJenrl(assignment, this.iFirstStudent, l1, l2);
            }
        }
        if (this.iSecondStudent != null) {
            for (Lecture l1 : this.iSecondLectures) {
                for (Lecture l2 : this.iSecondStudent.getLectures()) {
                    if (l1.equals(l2) || this.iSecondLectures.contains(l2) && l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                    this.decJenrl(assignment, this.iSecondStudent, l1, l2);
                }
            }
        }
        for (Lecture l1 : this.iFirstLectures) {
            l1.removeStudent(assignment, this.iFirstStudent);
            this.iFirstStudent.removeLecture(l1);
            if (this.iSecondStudent == null) continue;
            l1.addStudent(assignment, this.iSecondStudent);
            this.iSecondStudent.addLecture(l1);
        }
        for (Lecture l1 : this.iSecondLectures) {
            if (this.iSecondStudent != null) {
                l1.removeStudent(assignment, this.iSecondStudent);
                this.iSecondStudent.removeLecture(l1);
            }
            l1.addStudent(assignment, this.iFirstStudent);
            this.iFirstStudent.addLecture(l1);
        }
        if (this.iSecondStudent != null) {
            for (Lecture l1 : this.iFirstLectures) {
                for (Lecture l2 : this.iSecondStudent.getLectures()) {
                    if (l1.equals(l2) || this.iFirstLectures.contains(l2) && l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                    this.incJenrl(assignment, this.iSecondStudent, l1, l2);
                }
            }
        }
        for (Lecture l1 : this.iSecondLectures) {
            for (Lecture l2 : this.iFirstStudent.getLectures()) {
                if (l1.equals(l2) || this.iSecondLectures.contains(l2) && l1.getClassId().compareTo(l2.getClassId()) >= 0) continue;
                this.incJenrl(assignment, this.iFirstStudent, l1, l2);
            }
        }
        if (!this.iFirstConfig.equals(this.iSecondConfig)) {
            this.iFirstStudent.removeConfiguration(this.iFirstConfig);
            this.iFirstStudent.addConfiguration(this.iSecondConfig);
            if (this.iSecondStudent != null) {
                this.iSecondStudent.removeConfiguration(this.iSecondConfig);
                this.iSecondStudent.addConfiguration(this.iFirstConfig);
            }
        }
    }

    @Override
    public boolean isAllowed() {
        return this.iAllowed;
    }

    @Override
    public Map<Lecture, Placement> assignments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double group(List<StudentConflict> criteria, Assignment<Lecture, Placement> assignment) {
        double value = this.groupValue(this.iFirstStudent, this.iSecondStudent, this.iSecondConfig, this.iSecondLectures) - this.groupValue(this.iFirstStudent, this.iSecondStudent, this.iFirstConfig, this.iFirstLectures);
        if (this.iSecondStudent != null) {
            value += this.groupValue(this.iSecondStudent, this.iFirstStudent, this.iFirstConfig, this.iFirstLectures) - this.groupValue(this.iSecondStudent, this.iFirstStudent, this.iSecondConfig, this.iSecondLectures);
        }
        return value;
    }

    public String toString() {
        return "StudentSwap{" + this.iFirstStudent.getId() + " " + this.iFirstStudent.getGroupNames() + "/" + this.iFirstLectures + "; " + (this.iSecondStudent == null ? "NULL" : this.iSecondStudent.getId() + " " + this.iSecondStudent.getGroupNames()) + "/" + this.iSecondLectures + "}";
    }
}

