/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.cpsolver.coursett.model.Student;

public class StudentGroup
implements Comparable<StudentGroup> {
    private long iId;
    private String iName;
    private double iWeight;
    private List<Student> iStudents = new ArrayList<Student>();

    public StudentGroup(long id, double weight, String name) {
        this.iId = id;
        this.iName = name;
        this.iWeight = weight;
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return this.iName;
    }

    public double getWeight() {
        return this.iWeight;
    }

    public List<Student> getStudents() {
        return this.iStudents;
    }

    public int countStudents(Long offeringId) {
        int ret = 0;
        for (Student student : this.iStudents) {
            if (!student.hasOffering(offeringId)) continue;
            ++ret;
        }
        return ret;
    }

    public void addStudent(Student student) {
        this.iStudents.add(student);
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof StudentGroup && this.getId() == ((StudentGroup)o).getId();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(StudentGroup g) {
        int cmp = this.getName().compareToIgnoreCase(g.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getId() < g.getId() ? -1 : (this.getId() == g.getId() ? 0 : 1);
    }

    public double getAverageEnrollmentWeight(Long offeringId) {
        double total = 0.0;
        int count = 0;
        for (Student student : this.iStudents) {
            if (!student.hasOffering(offeringId)) continue;
            total += student.getOfferingWeight(offeringId);
            ++count;
        }
        return count == 0 ? 0.0 : total / (double)count;
    }

    public int countOfferings() {
        HashSet<Long> offeringIds = new HashSet<Long>();
        for (Student student : this.iStudents) {
            offeringIds.addAll(student.getOfferings());
        }
        return offeringIds.size();
    }
}

