/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.cpsolver.ifs.util.CSVFile;
import org.hibernate.query.Query;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.PdfWebTable;

public class ExamDistributionPrefsTableBuilder {
    public String getDistPrefsTable(HttpServletRequest request, SessionContext context, Long subjectAreaId, String courseNbr, Long examTypeId) throws Exception {
        Object query = "select distinct dp from DistributionPref dp inner join dp.distributionObjects do, Exam x inner join x.owners o where ";
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.trim().length() > 2) {
            query = (String)query + "(" + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr " : "o.course.courseNbr=:courseNbr ") + " or lower(o.course.title) like lower('%' || :courseNbr || '%')) and ";
        } else if (courseNbr != null && !courseNbr.trim().isEmpty()) {
            query = (String)query + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr and " : "o.course.courseNbr=:courseNbr and ");
        }
        query = (String)query + (subjectAreaId == null ? "" : " o.course.subjectArea.uniqueId=:subjectAreaId and ") + "dp.distributionType.examPref = true and do.prefGroup = x and x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId";
        Query q = DistributionPrefDAO.getInstance().getSession().createQuery((String)query, DistributionPref.class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).setParameter("examTypeId", (Object)examTypeId);
        if (subjectAreaId != null) {
            q.setParameter("subjectAreaId", (Object)subjectAreaId);
        }
        if (courseNbr != null && !courseNbr.trim().isEmpty()) {
            q.setParameter("courseNbr", (Object)courseNbr.trim().replaceAll("\\*", "%"));
        }
        List distPrefs = q.setCacheable(true).list();
        return this.toHtmlTable(request, context, distPrefs, null);
    }

    public void getDistPrefsTableAsPdf(OutputStream out, HttpServletRequest request, SessionContext context, Long subjectAreaId, String courseNbr, Long examTypeId) throws Exception {
        Object query = "select distinct dp from DistributionPref dp inner join dp.distributionObjects do, Exam x inner join x.owners o where ";
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.trim().length() > 2) {
            query = (String)query + "(" + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr " : "o.course.courseNbr=:courseNbr ") + " or lower(o.course.title) like lower('%' || :courseNbr || '%')) and ";
        } else if (courseNbr != null && !courseNbr.trim().isEmpty()) {
            query = (String)query + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr and " : "o.course.courseNbr=:courseNbr and ");
        }
        query = (String)query + (subjectAreaId == null ? "" : " o.course.subjectArea.uniqueId=:subjectAreaId and ") + "dp.distributionType.examPref = true and do.prefGroup = x and x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId";
        Query q = DistributionPrefDAO.getInstance().getSession().createQuery((String)query, DistributionPref.class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).setParameter("examTypeId", (Object)examTypeId);
        if (subjectAreaId != null) {
            q.setParameter("subjectAreaId", (Object)subjectAreaId);
        }
        if (courseNbr != null && courseNbr.trim().length() != 0) {
            q.setParameter("courseNbr", (Object)courseNbr.trim().replaceAll("\\*", "%"));
        }
        List distPrefs = q.setCacheable(true).list();
        this.toPdfTable(out, request, context, distPrefs, examTypeId);
    }

    public void getDistPrefsTableAsCsv(PrintWriter out, HttpServletRequest request, SessionContext context, Long subjectAreaId, String courseNbr, Long examTypeId) throws Exception {
        Object query = "select distinct dp from DistributionPref dp inner join dp.distributionObjects do, Exam x inner join x.owners o where ";
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.trim().length() > 2) {
            query = (String)query + "(" + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr " : "o.course.courseNbr=:courseNbr ") + " or lower(o.course.title) like lower('%' || :courseNbr || '%')) and ";
        } else if (courseNbr != null && !courseNbr.trim().isEmpty()) {
            query = (String)query + (courseNbr.indexOf(42) >= 0 ? "o.course.courseNbr like :courseNbr and " : "o.course.courseNbr=:courseNbr and ");
        }
        query = (String)query + (subjectAreaId == null ? "" : " o.course.subjectArea.uniqueId=:subjectAreaId and ") + "dp.distributionType.examPref = true and do.prefGroup = x and x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId";
        Query q = DistributionPrefDAO.getInstance().getSession().createQuery((String)query, DistributionPref.class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).setParameter("examTypeId", (Object)examTypeId);
        if (subjectAreaId != null) {
            q.setParameter("subjectAreaId", (Object)subjectAreaId);
        }
        if (courseNbr != null && courseNbr.trim().length() != 0) {
            q.setParameter("courseNbr", (Object)courseNbr.trim().replaceAll("\\*", "%"));
        }
        List distPrefs = q.setCacheable(true).list();
        this.toCsvTable(out, request, context, distPrefs, examTypeId);
    }

    public String getDistPrefsTable(HttpServletRequest request, SessionContext context, Exam exam) throws Exception {
        return this.toHtmlTable(request, context, exam.effectivePreferences(DistributionPref.class), "Distribution Preferences");
    }

    public String toHtmlTable(HttpServletRequest request, SessionContext context, Collection distPrefs, String title) throws Exception {
        String backId = "PreferenceGroup".equals(request.getParameter("backType")) ? request.getParameter("backId") : null;
        WebTable.setOrder(context, "examDistPrefsTable.ord", request.getParameter("order"), 4);
        WebTable tbl = new WebTable(3, title, "examDistributionPrefs.action?order=%%", new String[]{" Type ", " Exam ", " Class/Course "}, new String[]{"left", "left", "left"}, new boolean[]{true, true, true});
        int nrPrefs = 0;
        for (DistributionPref dp : distPrefs) {
            if (!context.hasPermission(dp, Right.ExaminationDistributionPreferenceDetail)) continue;
            boolean prefEditable = context.hasPermission(dp, Right.ExaminationDistributionPreferenceEdit);
            ++nrPrefs;
            Object examStr = "";
            Object objStr = "";
            Iterator<DistributionObject> i2 = dp.getOrderedSetOfDistributionObjects().iterator();
            while (i2.hasNext()) {
                DistributionObject dO = i2.next();
                Exam exam = (Exam)dO.getPrefGroup();
                examStr = (String)examStr + dO.preferenceText();
                Iterator<ExamOwner> i3 = exam.getOwners().iterator();
                while (i3.hasNext()) {
                    ExamOwner owner = i3.next();
                    objStr = (String)objStr + owner.getLabel();
                    if (!i3.hasNext()) continue;
                    examStr = (String)examStr + "<BR>";
                    objStr = (String)objStr + "<BR>";
                }
                if (!i2.hasNext()) continue;
                examStr = (String)examStr + "<BR>";
                objStr = (String)objStr + "<BR>";
            }
            String distType = dp.getDistributionType().getLabel();
            String prefLevel = dp.getPrefLevel().getPrefName();
            String prefColor = dp.getPrefLevel().prefcolor();
            if (PreferenceLevel.sNeutral.equals(dp.getPrefLevel().getPrefProlog())) {
                prefColor = "gray";
            }
            String onClick = null;
            boolean gray = false;
            if (prefEditable) {
                onClick = "onClick=\"document.location='examDistributionPrefs.action?dp=" + dp.getUniqueId().toString() + "&op=view'\"";
            }
            boolean back = dp.getUniqueId().toString().equals(backId);
            tbl.addLine(onClick, new String[]{(back ? "<A name=\"back\"</A>" : "") + (String)(gray ? "<span style='color:gray;'>" : "<span style='color:" + prefColor + ";font-weight:bold;' title='" + prefLevel + " " + distType + "'>") + distType + "</span>", (gray ? "<span style='color:gray;'>" : "") + (String)examStr + (gray ? "</span>" : ""), (gray ? "<span style='color:gray;'>" : "") + (String)objStr + (gray ? "</span>" : "")}, new Comparable[]{distType, examStr, objStr});
        }
        if (nrPrefs == 0) {
            tbl.addLine(null, new String[]{"No preferences found", "", ""}, null);
        }
        return tbl.printTable(WebTable.getOrder(context, "examDistPrefsTable.ord"));
    }

    protected PdfWebTable generatePdfWebTable(SessionContext context, Collection distPrefs, Long examTypeId) {
        PdfWebTable tbl = new PdfWebTable(4, ((ExamType)ExamTypeDAO.getInstance().get(examTypeId)).getLabel() + " Examination Distribution Preferences", null, new String[]{" Preference ", " Type ", " Exam ", " Class/Course "}, new String[]{"left", "left", "left", "left"}, new boolean[]{true, true, true, true});
        int nrPrefs = 0;
        for (DistributionPref dp : distPrefs) {
            if (!context.hasPermission(dp, Right.ExaminationDistributionPreferenceDetail)) continue;
            ++nrPrefs;
            Object examStr = "";
            Object objStr = "";
            Iterator<DistributionObject> i2 = dp.getOrderedSetOfDistributionObjects().iterator();
            while (i2.hasNext()) {
                DistributionObject dO = i2.next();
                Exam exam = (Exam)dO.getPrefGroup();
                examStr = (String)examStr + dO.preferenceText();
                Iterator<ExamOwner> i3 = exam.getOwners().iterator();
                while (i3.hasNext()) {
                    ExamOwner owner = i3.next();
                    objStr = (String)objStr + owner.getLabel();
                    if (!i3.hasNext()) continue;
                    examStr = (String)examStr + "\n";
                    objStr = (String)objStr + "\n";
                }
                if (!i2.hasNext()) continue;
                examStr = (String)examStr + "\n";
                objStr = (String)objStr + "\n";
            }
            String distType = dp.getDistributionType().getLabel();
            String prefLevel = dp.getPrefLevel().getPrefName();
            tbl.addLine(null, new String[]{prefLevel, distType, examStr, objStr}, new Comparable[]{null, distType, examStr, objStr});
        }
        if (nrPrefs == 0) {
            tbl.addLine(null, new String[]{"No preferences found", "", "", ""}, null);
        }
        return tbl;
    }

    public void toPdfTable(OutputStream out, HttpServletRequest request, SessionContext context, Collection distPrefs, Long examTypeId) throws Exception {
        WebTable.setOrder(context, "examDistPrefsTable.ord", request.getParameter("order"), 4);
        PdfWebTable tbl = this.generatePdfWebTable(context, distPrefs, examTypeId);
        int ord = WebTable.getOrder(context, "examDistPrefsTable.ord");
        ord = (ord > 0 ? 1 : -1) * (1 + Math.abs(ord));
        PdfPTable table = tbl.printPdfTable(ord);
        float width = tbl.getWidth();
        Document doc = new Document(new Rectangle(60.0f + width, 60.0f + 1.3f * width), 30.0f, 30.0f, 30.0f, 30.0f);
        PdfWriter iWriter = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
        doc.open();
        if (tbl.getName() != null) {
            doc.add((Element)new Paragraph(tbl.getName(), PdfFont.getBigFont(true)));
        }
        doc.add((Element)table);
        doc.close();
    }

    public void toCsvTable(PrintWriter writer, HttpServletRequest request, SessionContext context, Collection distPrefs, Long examTypeId) throws Exception {
        WebTable.setOrder(context, "examDistPrefsTable.ord", request.getParameter("order"), 4);
        PdfWebTable tbl = this.generatePdfWebTable(context, distPrefs, examTypeId);
        int ord = WebTable.getOrder(context, "examDistPrefsTable.ord");
        ord = (ord > 0 ? 1 : -1) * (1 + Math.abs(ord));
        CSVFile csv = tbl.printCsvTable(ord);
        if (csv.getHeader() != null) {
            writer.println(csv.getHeader().toString());
        }
        if (csv.getLines() != null) {
            for (CSVFile.CSVLine line : csv.getLines()) {
                writer.println(line.toString());
            }
        }
    }
}

