/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.security.SessionContext;

public class BackTracker {
    public static int MAX_BACK_STEPS = 10;
    public static String BACK_LIST = SessionAttribute.Back.key();
    private static String mark = "-_.!~*'()\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BackItem> getBackList(HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            List back = (List)session.getAttribute(SessionAttribute.Back.key());
            if (back == null) {
                back = Collections.synchronizedList(new ArrayList());
                session.setAttribute(SessionAttribute.Back.key(), back);
            }
            return back;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BackItem> getBackList(SessionContext context) {
        SessionContext sessionContext = context;
        synchronized (sessionContext) {
            List back = (List)context.getAttribute(SessionAttribute.Back);
            if (back == null) {
                back = Collections.synchronizedList(new ArrayList());
                context.setAttribute(SessionAttribute.Back.key(), back);
            }
            return back;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markForBack(HttpServletRequest request, String uri, String title, boolean back, boolean clear) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            List<BackItem> backList = BackTracker.getBackList(request.getSession());
            if (clear) {
                backList.clear();
            }
            if (back) {
                if (uri == null && request.getAttribute("jakarta.servlet.forward.request_uri") == null) {
                    return;
                }
                String titleObj = title == null ? request.getAttribute("title") : title;
                Object requestURI = (String)request.getAttribute("jakarta.servlet.forward.request_uri");
                String queryString = (String)request.getAttribute("jakarta.servlet.forward.query_string");
                if (queryString != null && queryString.length() > 0) {
                    requestURI = (String)requestURI + "?" + queryString;
                }
                if (uri != null) {
                    requestURI = uri;
                }
                if (!backList.isEmpty()) {
                    int found = -1;
                    for (int idx = 0; idx < backList.size(); ++idx) {
                        BackItem lastBack = backList.get(idx);
                        if (!lastBack.getUrl().equals(requestURI)) continue;
                        found = idx;
                        break;
                    }
                    while (found >= 0 && backList.size() > found) {
                        backList.remove(backList.size() - 1);
                    }
                }
                backList.add(new BackItem((String)requestURI, titleObj == null ? null : titleObj.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markForBack(SessionContext context, String uri, String title, boolean back, boolean clear) {
        SessionContext sessionContext = context;
        synchronized (sessionContext) {
            List<BackItem> backList = BackTracker.getBackList(context);
            if (clear) {
                backList.clear();
            }
            if (back) {
                if (!backList.isEmpty()) {
                    int found = -1;
                    for (int idx = 0; idx < backList.size(); ++idx) {
                        BackItem lastBack = backList.get(idx);
                        if (!lastBack.getUrl().equals(uri)) continue;
                        found = idx;
                        break;
                    }
                    while (found >= 0 && backList.size() > found) {
                        backList.remove(backList.size() - 1);
                    }
                }
                backList.add(new BackItem(uri, title));
            }
        }
    }

    public static String encodeURL(String url) {
        StringBuffer encodedUrl = new StringBuffer();
        int len = url.length();
        for (int i = 0; i < len; ++i) {
            char c = url.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                encodedUrl.append(c);
                continue;
            }
            int imark = mark.indexOf(c);
            if (imark >= 0) {
                encodedUrl.append(c);
                continue;
            }
            encodedUrl.append('%');
            encodedUrl.append(Integer.toHexString(c));
        }
        return encodedUrl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBackButton(HttpServletRequest request, int nrBackSteps, String name, String title, String accessKey, String style, String clazz, String backType, String backId) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            List<BackItem> backList = BackTracker.getBackList(request.getSession());
            if (backList.size() < nrBackSteps) {
                return "";
            }
            BackItem backItem = backList.get(backList.size() - nrBackSteps);
            if (backItem.getTitle() != null) {
                title = title.replaceAll("%%", backItem.getTitle());
            }
            Object backUrl = backItem.getUrl();
            if (backId != null && backType != null) {
                backUrl = ((String)backUrl).indexOf(63) > 0 ? (String)backUrl + "&backType=" + backType + "&backId=" + backId + "#back" : (String)backUrl + "?backType=" + backType + "&backId=" + backId + "#back";
            }
            return "<input type='button' value='" + name + "' " + (String)(accessKey == null ? "" : " accesskey=\"" + accessKey + "\"") + (String)(style == null ? "" : " style=\"" + style + "\"") + (String)(clazz == null ? "" : " class=\"" + clazz + "\"") + " title=\"" + title + "\" onClick=\"document.location='back.action?uri=" + BackTracker.encodeURL((String)backUrl) + "';\"/>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGwtBack(HttpServletRequest request, int nrBackSteps) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            List<BackItem> back = BackTracker.getBackList(request.getSession());
            if (back.size() <= 1) {
                return "";
            }
            StringBuffer ret = new StringBuffer("");
            for (int i = Math.max(0, back.size() - MAX_BACK_STEPS); i < back.size(); ++i) {
                BackItem backItem = back.get(i);
                if (ret.length() > 0) {
                    ret.append("&");
                }
                ret.append(BackTracker.encodeURL(backItem.getUrl()) + "|" + backItem.getTitle());
            }
            return "<span id='UniTimeGWT:Back' style='display:none;'>" + ret.toString() + "</span>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackItem getBackItem(SessionContext context, int nrBackSteps) {
        SessionContext sessionContext = context;
        synchronized (sessionContext) {
            List<BackItem> back = BackTracker.getBackList(context);
            if (back.isEmpty()) {
                return null;
            }
            return back.get(Math.max(0, back.size() - nrBackSteps));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasBack(HttpServletRequest request, int nrBackSteps) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            List<BackItem> backList = BackTracker.getBackList(request.getSession());
            return backList.size() >= nrBackSteps;
            {
            }
        }
    }

    public static boolean hasBack(SessionContext context, int nrBackSteps) {
        Vector backList = (Vector)context.getAttribute(SessionAttribute.Back);
        return backList != null && backList.size() >= nrBackSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doBack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            Object uri = request.getParameter("uri");
            List<BackItem> back = BackTracker.getBackList(request.getSession());
            if (back.isEmpty()) {
                if (uri != null) {
                    response.sendRedirect(response.encodeURL((String)uri));
                    return true;
                }
                return false;
            }
            if (uri == null) {
                uri = back.get(back.size() - 1).getUrl();
                back.remove(back.size() - 1);
            } else {
                Object uriNoBack = uri;
                if (((String)uriNoBack).indexOf("backType=") >= 0) {
                    uriNoBack = ((String)uriNoBack).substring(0, ((String)uriNoBack).indexOf("backType=") - 1);
                }
                while (!back.isEmpty() && !((String)uriNoBack).equals(back.get(back.size() - 1).getUrl())) {
                    back.remove(back.size() - 1);
                }
                if (!back.isEmpty()) {
                    back.remove(back.size() - 1);
                }
            }
            if (((String)uri).indexOf("backType=") < 0 && request.getAttribute("backType") != null && request.getAttribute("backId") != null) {
                uri = ((String)uri).indexOf(63) > 0 ? (String)uri + "&backType=" + String.valueOf(request.getAttribute("backType")) + "&backId=" + String.valueOf(request.getAttribute("backId")) + "#back" : (String)uri + "?backType=" + String.valueOf(request.getAttribute("backType")) + "&backId=" + String.valueOf(request.getAttribute("backId")) + "#back";
            }
            response.sendRedirect(response.encodeURL((String)uri));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBackTree(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            List<BackItem> back = BackTracker.getBackList(request.getSession());
            if (back.size() <= 1) {
                return "";
            }
            StringBuffer ret = new StringBuffer();
            for (int i = Math.max(0, back.size() - MAX_BACK_STEPS); i < back.size(); ++i) {
                BackItem backItem = back.get(i);
                if (ret.length() > 0) {
                    ret.append(" &rarr; ");
                }
                ret.append("<span class='item'><A href='back.action?uri=" + BackTracker.encodeURL(backItem.getUrl()) + "'>" + backItem.getTitle() + "</A></span>");
            }
            return "&nbsp;" + ret.toString();
        }
    }

    public static class BackItem
    implements Serializable {
        private static final long serialVersionUID = -1723774866087870562L;
        String iUrl;
        String iTitle;

        public BackItem() {
        }

        public BackItem(String url, String title) {
            this.iUrl = url;
            this.iTitle = title;
        }

        public String getUrl() {
            return this.iUrl;
        }

        public void setUrl(String url) {
            this.iUrl = url;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String toString() {
            return this.getTitle() + " (" + this.getUrl() + ")";
        }

        public int hashCode() {
            return this.getUrl().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof BackItem)) {
                return false;
            }
            return this.getUrl().equals(((BackItem)o).getUrl());
        }
    }
}

