/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import jakarta.activation.DataSource;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.queue.QueueProcessor;

public class QueueOutputFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    protected QueueProcessor getQueueProcessor() {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        SolverServerService solverServerService = (SolverServerService)applicationContext.getBean("solverServerService");
        return solverServerService.getQueueProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String q = request.getParameter("q");
        if (q == null) {
            response.sendError(400, "Q parameter not provided.");
            return;
        }
        DataSource ds = this.getQueueProcessor().getFile(QueryEncoderBackend.decode(q, false));
        if (ds != null) {
            response.setContentType(ds.getContentType());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + ds.getName() + "\"");
            ServletOutputStream out = response.getOutputStream();
            InputStream in = ds.getInputStream();
            try {
                IOUtils.copy((InputStream)ds.getInputStream(), (OutputStream)out);
                out.flush();
            }
            finally {
                in.close();
                out.close();
            }
        } else {
            response.sendError(400, "Output file is not available.");
        }
    }
}

