/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Logger;
import org.unitime.commons.Debug;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import sun.misc.Unsafe;

public final class MemoryCounter {
    public static final MemorySizes sSizes = new MemorySizes();
    private Map iVisited = new IdentityHashMap();
    private Stack iStack = new Stack();

    public synchronized long estimate(Object obj) {
        try {
            return new MemoryCounter().deepSizeOfObject(obj);
        }
        catch (Throwable t) {
            Debug.error("Failed to estimate size of " + obj.getClass().getSimpleName() + ": " + t.getMessage(), t);
            return 0L;
        }
    }

    private boolean skipObject(Object obj) {
        if (obj instanceof String && obj == ((String)obj).intern()) {
            return true;
        }
        if (obj instanceof Thread || obj instanceof Log || obj instanceof Logger || obj instanceof SolverContainer) {
            return true;
        }
        return obj == null || this.iVisited.containsKey(obj);
    }

    private static long roundUpToNearestEightBytes(long result) {
        if (result % 8L != 0L) {
            result += 8L - result % 8L;
        }
        return result;
    }

    public long deepSizeOfObject(Object obj) {
        try {
            long result = this.deepSizeOf(obj);
            while (!this.iStack.isEmpty()) {
                result += this.deepSizeOf(this.iStack.pop());
            }
            return result;
        }
        catch (Throwable e) {
            Debug.error("Unable to estimate size of " + obj.getClass().getSimpleName() + ": " + e.getMessage(), e);
            return 0L;
        }
    }

    private long deepSizeOf(Object obj) {
        Class<?> clazz;
        if (this.skipObject(obj)) {
            return 0L;
        }
        this.iVisited.put(obj, null);
        if (clazz.isArray()) {
            long result = 16L;
            int length = Array.getLength(obj);
            if (length != 0) {
                Class<?> arrayElementClazz = obj.getClass().getComponentType();
                if (arrayElementClazz.isPrimitive()) {
                    result += (long)(length * sSizes.getPrimitiveArrayElementSize(arrayElementClazz));
                } else {
                    for (int i = 0; i < length; ++i) {
                        result += (long)sSizes.getPointerSize() + this.deepSizeOf(Array.get(obj, i));
                    }
                }
            }
            return result;
        }
        long result = 0L;
        for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                for (Field f : clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    if (f.getType().isPrimitive()) {
                        result += (long)sSizes.getPrimitiveFieldSize(f.getType());
                        continue;
                    }
                    result += (long)sSizes.getPointerSize();
                    long offset = UtilUnsafe.UNSAFE.objectFieldOffset(f);
                    Object tempObject = UtilUnsafe.UNSAFE.getObject(obj, offset);
                    if (tempObject == null) continue;
                    this.iStack.add(tempObject);
                }
            }
        }
        return MemoryCounter.roundUpToNearestEightBytes(result += (long)sSizes.getClassSize());
    }

    public static class MemorySizes {
        private final Map primitiveSizes = new IdentityHashMap(){
            private static final long serialVersionUID = 1L;
            {
                this.put(Boolean.TYPE, 1);
                this.put(Byte.TYPE, 1);
                this.put(Character.TYPE, 2);
                this.put(Short.TYPE, 2);
                this.put(Integer.TYPE, 4);
                this.put(Float.TYPE, 4);
                this.put(Double.TYPE, 8);
                this.put(Long.TYPE, 8);
            }
        };

        public int getPrimitiveFieldSize(Class clazz) {
            return (Integer)this.primitiveSizes.get(clazz);
        }

        public int getPrimitiveArrayElementSize(Class clazz) {
            return this.getPrimitiveFieldSize(clazz);
        }

        public int getPointerSize() {
            return 4;
        }

        public int getClassSize() {
            return 8;
        }
    }

    static class UtilUnsafe {
        public static final Unsafe UNSAFE;

        private UtilUnsafe() {
        }

        static {
            Object theUnsafe = null;
            Exception exception = null;
            try {
                Class<?> uc = Class.forName("sun.misc.Unsafe");
                Field f = uc.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                theUnsafe = f.get(uc);
            }
            catch (Exception e) {
                exception = e;
            }
            UNSAFE = (Unsafe)theUnsafe;
            if (UNSAFE == null) {
                throw new Error("Could not obtain access to sun.misc.Unsafe", exception);
            }
        }
    }
}

