/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.util.ImportXmlFile;

public class ExportXmlFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = (Session)SessionDAO.getInstance().getSession().createQuery("from Session s where s.academicTerm || s.academicYear || s.academicInitiative = :session", Session.class).setParameter("session", (Object)args[0]).uniqueResult();
            if (session == null) {
                throw new Exception("Session " + args[0] + " not found.");
            }
            Document document = DataExchangeHelper.exportDocument(args[1], session, ApplicationProperties.getProperties(), null);
            if (document == null) {
                throw new Exception("No XML document has been created.");
            }
            try (FileOutputStream fos = new FileOutputStream(args[2]);){
                new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
                fos.flush();
            }
        }
        catch (Exception e) {
            LogManager.getLogger(ImportXmlFile.class).error("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            HibernateUtil.closeHibernate();
        }
    }
}

