/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class UpdateSequencesFromXml {
    private Hashtable<String, TreeSet<String>> iSequences = new Hashtable();
    private Hashtable<String, String> iIdColumns = new Hashtable();
    private SAXReader iSAXReader = null;
    private String iSource = null;
    private String iConfig = "hibernate.cfg.xml";
    private EntityResolver iEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (publicId.equals("-//Hibernate/Hibernate Mapping DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-mapping-3.0.dtd"));
            }
            if (publicId.equals("-//Hibernate/Hibernate Configuration DTD 3.0//EN")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("org/hibernate/hibernate-configuration-3.0.dtd"));
            }
            return null;
        }
    };

    public UpdateSequencesFromXml() throws DocumentException {
        this.iSAXReader = new SAXReader();
        this.iSAXReader.setEntityResolver(this.iEntityResolver);
    }

    public void setSource(String source) {
        this.iSource = source;
    }

    public void setConfig(String config) {
        this.iConfig = config;
    }

    protected Document read(String resource) throws IOException, DocumentException {
        if (this.iSource == null) {
            return this.iSAXReader.read(this.getClass().getClassLoader().getResourceAsStream(resource));
        }
        return this.iSAXReader.read(new File(this.iSource + File.separator + resource));
    }

    public void load() throws IOException, DocumentException {
        this.info("Config: " + String.valueOf(this.iSource == null ? this.getClass().getClassLoader().getResource(this.iConfig) : this.iSource + File.separator + this.iConfig));
        this.info("Reading hibernate.cfg.xml ...");
        File workDir = null;
        if (this.iSource == null) {
            workDir = new File(this.getClass().getClassLoader().getResource(this.iConfig).getFile());
            while (workDir.getParentFile() != null && !"WebContent".equals(workDir.getName())) {
                workDir = workDir.getParentFile();
            }
            workDir = new File(workDir.getParentFile(), "JavaSource");
            workDir.mkdirs();
        } else {
            workDir = new File(this.iSource);
        }
        this.info("Reading *.hbm.xml ...");
        for (String resource : workDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".hbm.xml");
            }
        })) {
            this.info("Pre-processing " + resource + " ...");
            Document resDoc = this.read(resource);
            Element resRoot = resDoc.getRootElement();
            Iterator j = resRoot.elementIterator("class");
            while (j.hasNext()) {
                Element classEl = (Element)j.next();
                this.checkSequences(classEl, null, null, null);
            }
        }
    }

    public void print() throws IOException, DocumentException {
        Object ret = "";
        for (String sequence : new TreeSet<String>(this.iSequences.keySet())) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + "\nunion all ";
            }
            ret = (String)ret + "select 'DROP SEQUENCE IF EXISTS " + sequence.toUpperCase() + "; CREATE SEQUENCE " + sequence.toUpperCase() + " MINVALUE 1 MAXVALUE 99999999999999999999 INCREMENT BY 1 START WITH ' ||";
            TreeSet<String> tables = this.iSequences.get(sequence);
            if (tables.size() == 1) {
                String table = tables.first();
                String idColumn = this.iIdColumns.get(table);
                ret = (String)ret + " case when max(" + idColumn + ") is not null then max(" + idColumn + " + 1) else 1 end ";
                ret = (String)ret + "|| ' CACHE 20 NOORDER NOCYCLE; GRANT SELECT ON " + sequence.toUpperCase() + " TO webuser;' from " + table;
            } else {
                ret = (String)ret + " case when max(uniqueid) is not null then max(uniqueid + 1) else 1 end ";
                ret = (String)ret + "|| ' CACHE 20 NOORDER NOCYCLE; GRANT SELECT ON " + sequence.toUpperCase() + " TO webuser;' from (";
                boolean first = true;
                for (String table : tables) {
                    String idColumn = this.iIdColumns.get(table);
                    if (first) {
                        ret = (String)ret + "\nselect max(" + idColumn + " + 1) as uniqueid from " + table;
                        first = false;
                        continue;
                    }
                    ret = (String)ret + "\nunion all select max(" + idColumn + " + 1) as uniqueid from " + table;
                }
                ret = (String)ret + "\n)";
            }
            this.info(sequence + ": " + String.valueOf(this.iSequences.get(sequence)));
        }
        this.info((String)ret);
        this.info("All done.");
    }

    private void checkSequences(Element classEl, String parentTable, String parentIdColumn, String parentSequence) throws IOException {
        String table = classEl.attributeValue("table");
        if (table == null) {
            table = parentTable;
        }
        String sequence = null;
        String idColumn = null;
        Iterator i = classEl.elementIterator("id");
        while (i.hasNext()) {
            Element el = (Element)i.next();
            idColumn = el.attributeValue("column").toLowerCase();
            if (el.element("generator") == null) continue;
            Iterator j = el.element("generator").elementIterator("param");
            while (j.hasNext()) {
                Element p = (Element)j.next();
                if (!"sequence".equals(p.attributeValue("name"))) continue;
                sequence = p.getTextTrim();
            }
        }
        if (sequence == null) {
            sequence = parentSequence;
        }
        if (idColumn == null) {
            idColumn = parentIdColumn;
        }
        if (sequence != null && table != null) {
            this.info("  " + table + "." + idColumn + ": " + sequence);
            TreeSet<String> tables = this.iSequences.get(sequence);
            if (tables == null) {
                tables = new TreeSet();
                this.iSequences.put(sequence, tables);
            }
            tables.add(table);
            this.iIdColumns.put(table, idColumn);
        }
        i = classEl.elementIterator("union-subclass");
        while (i.hasNext()) {
            this.checkSequences((Element)i.next(), table, idColumn, sequence);
        }
        i = classEl.elementIterator("subclass");
        while (i.hasNext()) {
            this.checkSequences((Element)i.next(), table, idColumn, sequence);
        }
    }

    public void info(String message) {
        System.out.println(message);
    }

    public void warn(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) {
        try {
            UpdateSequencesFromXml update = new UpdateSequencesFromXml();
            update.load();
            if (new File("../unitime-addons").exists()) {
                update.setSource("../unitime-addons/BannerAddOn/JavaSource");
                update.load();
            }
            update.print();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

