/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.test.AssignFirstAvailableTimePattern;

public class RoomCoordinates {
    protected static Log sLog = LogFactory.getLog(AssignFirstAvailableTimePattern.class);

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session hibSession = new _RootDAO().getSession();
            PrintWriter pw = new PrintWriter("rooms.sql");
            for (Building b : BuildingDAO.getInstance().findAll()) {
                if (b.getCoordinateX() != null && b.getCoordinateY() != null) {
                    pw.println("update building set coordinate_x = " + b.getCoordinateX() + ", coordinate_y = " + b.getCoordinateY() + " where uniqueid = " + b.getUniqueId() + ";");
                }
                for (Room r : RoomDAO.getInstance().findByBuilding(hibSession, b.getUniqueId())) {
                    if (r.getCoordinateX() == null || r.getCoordinateY() == null) continue;
                    pw.println("update room set coordinate_x = " + r.getCoordinateX() + ", coordinate_y = " + r.getCoordinateY() + " where uniqueid = " + r.getUniqueId() + ";");
                }
            }
            pw.flush();
            pw.close();
            hibSession.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

