/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.evaluation.PermissionCheck;
import org.unitime.timetable.security.rights.Right;

@Service(value="unitimePermissionEvaluator")
public class UniTimePermissionEvaluator
implements PermissionEvaluator {
    private static Log sLog = LogFactory.getLog(UniTimePermissionEvaluator.class);
    @Autowired
    PermissionCheck unitimePermissionCheck;

    public boolean hasPermission(Authentication authentication, Object domainObject, Object permission) {
        try {
            UserContext user = (UserContext)authentication.getPrincipal();
            Right right = permission instanceof Right ? (Right)((Object)permission) : Right.valueOf(permission.toString());
            return this.unitimePermissionCheck.hasPermission(user, domainObject, right);
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to evaluate permission " + String.valueOf(permission) + " for " + String.valueOf(domainObject) + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        try {
            UserContext user = (UserContext)authentication.getPrincipal();
            Right right = permission instanceof Right ? (Right)((Object)permission) : Right.valueOf(permission.toString());
            return this.unitimePermissionCheck.hasPermission(user, targetId, targetType, right);
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to evaluate permission " + String.valueOf(permission) + " for " + targetType + "@" + String.valueOf(targetId) + ": " + e.getMessage()));
            return false;
        }
    }
}

