/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.RspList;

public class UniTimeRpcDispatcher
extends RpcDispatcher {
    private static final short PROTOCOL_CUSTOM_CORRELATOR = 1234;

    public UniTimeRpcDispatcher(JChannel channel, Object server_obj) {
        super(channel, server_obj);
        this.setCorrelator(new RpcRequestCorrelator((Protocol)this.prot_adapter, this.req_handler, this.local_addr));
    }

    public <T> RspList<T> callRemoteMethods(Collection<Address> dests, MethodCall method_call, RequestOptions opts) throws Exception {
        if (dests != null && dests.isEmpty()) {
            this.log.trace("destination list of %s() is empty: no need to send message", new Object[]{method_call.getMethodName()});
            return empty_rsplist;
        }
        BytesMessage msg = new BytesMessage(null, (Object)method_call);
        RspList retval = super.castMessage(dests, (Message)msg, opts);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dests=%s, method_call=%s, options=%s, responses: %s", new Object[]{dests, method_call, opts, retval});
        }
        return retval;
    }

    public <T> CompletableFuture<RspList<T>> callRemoteMethodsWithFuture(Collection<Address> dests, MethodCall call, RequestOptions options) throws Exception {
        if (dests != null && dests.isEmpty()) {
            this.log.trace("destination list of %s() is empty: no need to send message", new Object[]{call.getMethodName()});
            return CompletableFuture.completedFuture(empty_rsplist);
        }
        BytesMessage msg = new BytesMessage(null, (Object)call);
        CompletableFuture retval = super.castMessageWithFuture(dests, (Message)msg, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dests=%s, method_call=%s, options=%s", new Object[]{dests, call, options});
        }
        return retval;
    }

    public <T> T callRemoteMethod(Address dest, MethodCall call, RequestOptions options) throws Exception {
        BytesMessage req = new BytesMessage(dest, (Object)call);
        Object retval = super.sendMessage((Message)req, options);
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=%s, method_call=%s, options=%s, retval: %s", new Object[]{dest, call, options, retval});
        }
        if (retval != null && retval instanceof InvocationTargetException) {
            throw (InvocationTargetException)retval;
        }
        return (T)retval;
    }

    public <T> CompletableFuture<T> callRemoteMethodWithFuture(Address dest, MethodCall call, RequestOptions opts) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=%s, method_call=%s, options=%s", new Object[]{dest, call, opts});
        }
        BytesMessage msg = new BytesMessage(dest, (Object)call);
        return super.sendMessageWithFuture((Message)msg, opts);
    }

    static {
        ClassConfigurator.addProtocol((short)1234, RpcRequestCorrelator.class);
    }

    public static class RpcRequestCorrelator
    extends RequestCorrelator {
        public RpcRequestCorrelator(Protocol down_prot, RequestHandler handler, Address local_addr) {
            super(down_prot, handler, local_addr);
        }

        protected void handleResponse(Message rsp, RequestCorrelator.Header hdr) {
            Request req = (Request)this.requests.get(hdr.req_id);
            if (req != null) {
                boolean threw_exception = false;
                Object retval = null;
                try {
                    retval = rsp.getPayload();
                }
                catch (Exception e) {
                    retval = this.wrap_exceptions ? new InvocationTargetException(e) : e;
                    threw_exception = true;
                }
                req.receiveResponse(retval, rsp.getSrc(), hdr.type == 2 || threw_exception);
            }
        }

        protected void sendReply(Message req, long req_id, Object reply, boolean is_exception) {
            Message rsp = RpcRequestCorrelator.makeReply((Message)req).setFlag(req.getFlags(false), false, true);
            try {
                rsp.setPayload(reply);
            }
            catch (Exception e) {
                rsp.setPayload((Object)(this.wrap_exceptions ? new InvocationTargetException(e) : e));
                is_exception = true;
            }
            rsp.clearFlag(new Message.Flag[]{Message.Flag.RSVP});
            this.sendResponse(rsp, req_id, is_exception);
        }
    }
}

