/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.fork.ForkChannel;
import org.jgroups.stack.Protocol;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.jgroups.StudentSolverContainer;
import org.unitime.timetable.solver.jgroups.UniTimeRpcDispatcher;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

public class StudentSolverContainerRemote
extends StudentSolverContainer
implements RemoteSolverContainer<StudentSolverProxy> {
    private static Log sLog = LogFactory.getLog(StudentSolverContainerRemote.class);
    private RpcDispatcher iDispatcher;
    private ForkChannel iChannel;

    public StudentSolverContainerRemote(JChannel channel, short scope) throws Exception {
        this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
        this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
    }

    @Override
    public void setChannel(JChannel channel, short scope) throws Exception {
        ForkChannel oldChannel = this.iChannel;
        if (channel != null) {
            this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
            this.iChannel.connect("UniTime:RPC:Students");
            this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
        }
        if (oldChannel != null && oldChannel.isConnected()) {
            oldChannel.disconnect();
        }
    }

    @Override
    public void start() throws Exception {
        this.iChannel.connect("UniTime:RPC:Students");
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.iChannel.disconnect();
        super.stop();
    }

    @Override
    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    @Override
    public boolean createRemoteSolver(String user, DataProperties config, Address caller) {
        super.createSolver(user, config);
        return true;
    }

    @Override
    public Object invoke(String method, String user, String locale, Class[] types, Object[] args) throws Exception {
        try {
            StudentSolverProxy solver = (StudentSolverProxy)this.iStudentSolvers.get(user);
            if ("exists".equals(method) && types.length == 0) {
                Boolean bl = solver != null;
                return bl;
            }
            if (solver == null) {
                throw new Exception("Solver " + user + " does not exist.");
            }
            if (locale != null) {
                Localization.setLocale(locale);
            }
            Object object = solver.getClass().getMethod(method, types).invoke((Object)solver, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    @Override
    public Object dispatch(Address address, String user, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), user, Localization.getLocale(), method.getParameterTypes(), args}, new Class[]{String.class, String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            if ("exists".equals(method.getName()) && e instanceof SuspectedException) {
                return false;
            }
            sLog.error((Object)("Excution of " + method.getName() + " on solver " + user + " failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public StudentSolverProxy createProxy(Address address, String user) {
        SolverInvocationHandler handler = new SolverInvocationHandler(address, user);
        return (StudentSolverProxy)Proxy.newProxyInstance(StudentSolverProxy.class.getClassLoader(), new Class[]{StudentSolverProxy.class, RemoteSolver.class}, (InvocationHandler)handler);
    }

    public class SolverInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private String iUser;

        private SolverInvocationHandler(Address address, String user) {
            this.iAddress = address;
            this.iUser = user;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public String getUser() {
            return this.iUser;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return StudentSolverContainerRemote.this.dispatch(this.iAddress, this.iUser, method, args);
            }
        }
    }
}

