/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cpsolver.ifs.util.Progress;
import org.hibernate.Session;

public class ParallelInitialization {
    private Lock iLock = new ReentrantLock();
    private List<? extends Task> iTasks = null;
    private int iNrThreads;
    private String iPhase;

    public ParallelInitialization(String phase, int nrThreads, List<? extends Task> tasks) {
        this.iPhase = phase;
        this.iNrThreads = nrThreads;
        this.iTasks = tasks;
    }

    public void execute(Session hibSession, Progress progress) {
        progress.setPhase(this.iPhase, (long)this.iTasks.size());
        if (this.iNrThreads <= 1) {
            for (Task task : this.iTasks) {
                task.setup(hibSession);
                task.execute();
                task.teardown(hibSession);
                progress.incProgress();
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new RuntimeException("The load was interrupted.");
            }
        } else {
            Iterator<? extends Task> iterator = this.iTasks.iterator();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.iNrThreads; ++i) {
                Object executor = new Executor(i, iterator, progress, hibSession);
                ((Thread)executor).start();
                arrayList.add(executor);
            }
            try {
                for (Object executor : arrayList) {
                    ((Thread)executor).join();
                }
            }
            catch (InterruptedException e) {
                for (Executor executor : arrayList) {
                    if (!executor.isAlive()) continue;
                    executor.interrupt();
                }
                Thread.currentThread().interrupt();
            }
            for (Object executor : arrayList) {
                if (((Executor)executor).getException() == null) continue;
                throw new ParallelInitializationException(((Executor)executor).getException());
            }
        }
    }

    public static interface Task {
        public void setup(Session var1);

        public void execute();

        public void teardown(Session var1);
    }

    public class Executor
    extends Thread {
        private Iterator<? extends Task> iIterator;
        private Progress iProgress;
        private Session iHibSession;
        private Exception iException;

        public Executor(int index, Iterator<? extends Task> iterator, Progress progress, Session hibSession) {
            this.setName("Initialization-" + (1 + index));
            this.iIterator = iterator;
            this.iProgress = progress;
            this.iHibSession = hibSession;
        }

        public Exception getException() {
            return this.iException;
        }

        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Task task = this.iIterator.next();
                    ParallelInitialization.this.iLock.lock();
                    try {
                        task.setup(this.iHibSession);
                    }
                    finally {
                        ParallelInitialization.this.iLock.unlock();
                    }
                    task.execute();
                    ParallelInitialization.this.iLock.lock();
                    try {
                        task.teardown(this.iHibSession);
                        this.iProgress.incProgress();
                    }
                    finally {
                        ParallelInitialization.this.iLock.unlock();
                    }
                }
            }
            catch (NoSuchElementException task) {
            }
            catch (Exception e) {
                this.iException = e;
            }
        }
    }

    public static class ParallelInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParallelInitializationException(Exception e) {
            super(e.getMessage(), e);
        }
    }
}

