/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseLocation;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.MeetingDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.course.ui.ClassTimeInfo;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;

public class CommitedClassAssignmentProxy
implements ClassAssignmentProxy {
    private static AssignmentPreferenceInfo sCommitedAssignmentPreferenceInfo = new AssignmentPreferenceInfo();

    @Override
    public Assignment getAssignment(Long classId) {
        return this.getAssignment((Class_)new Class_DAO().get(classId));
    }

    @Override
    public Assignment getAssignment(Class_ clazz) {
        return clazz.getCommittedAssignment();
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Long classId) {
        return sCommitedAssignmentPreferenceInfo;
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) {
        return sCommitedAssignmentPreferenceInfo;
    }

    public Hashtable getAssignmentTable(Collection classesOrClassIds) {
        Hashtable<Long, Assignment> assignments = new Hashtable<Long, Assignment>();
        for (Object classOrClassId : classesOrClassIds) {
            Assignment assignment;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((assignment = classOrClassId instanceof Class_ ? this.getAssignment((Class_)classOrClassId) : this.getAssignment((Long)classOrClassId)) == null) continue;
            assignments.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, assignment);
        }
        return assignments;
    }

    public Hashtable getAssignmentInfoTable(Collection classesOrClassIds) {
        Hashtable<Long, AssignmentPreferenceInfo> infos = new Hashtable<Long, AssignmentPreferenceInfo>();
        for (Object classOrClassId : classesOrClassIds) {
            AssignmentPreferenceInfo info;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((info = classOrClassId instanceof Class_ ? this.getAssignmentInfo((Class_)classOrClassId) : this.getAssignmentInfo((Long)classOrClassId)) == null) continue;
            infos.put(classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId, info);
        }
        return infos;
    }

    @Override
    public boolean hasConflicts(Long offeringId) {
        Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck;
        Collection<RoomAvailabilityInterface.TimeBlock> times;
        ClassTimeInfo period;
        Assignment assignment;
        InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId);
        if (offering == null || offering.isNotOffered().booleanValue()) {
            return false;
        }
        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ clazz : subpart.getClasses()) {
                    Assignment assignment2;
                    if (clazz.isCancelled().booleanValue() || (assignment2 = this.getAssignment(clazz)) == null) continue;
                    if (assignment2.getRooms() != null) {
                        for (Location room : assignment2.getRooms()) {
                            if (!room.isIgnoreRoomCheck().booleanValue()) {
                                for (Assignment assignment3 : room.getCommitedAssignments()) {
                                    if (assignment2.equals(assignment3) || assignment3.getClazz().isCancelled().booleanValue() || !assignment2.overlaps(assignment3) || clazz.canShareRoom(assignment3.getClazz())) continue;
                                    return true;
                                }
                            }
                            if (!(room instanceof Room)) continue;
                            Room r = (Room)room;
                            if (r.getParentRoom() != null && !r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                                for (Assignment a : r.getParentRoom().getCommitedAssignments()) {
                                    if (assignment2.equals(a) || a.getClazz().isCancelled().booleanValue() || !assignment2.overlaps(a) || clazz.canShareRoom(a.getClazz())) continue;
                                    return true;
                                }
                            }
                            for (Object p : r.getPartitions()) {
                                if (((BaseLocation)p).isIgnoreRoomCheck().booleanValue()) continue;
                                for (Assignment a4 : ((Location)p).getCommitedAssignments()) {
                                    if (assignment2.equals(a4) || a4.getClazz().isCancelled().booleanValue() || !assignment2.overlaps(a4) || clazz.canShareRoom(a4.getClazz())) continue;
                                    return true;
                                }
                            }
                        }
                    }
                    if (clazz.getClassInstructors() != null) {
                        for (ClassInstructor instructor : clazz.getClassInstructors()) {
                            if (!instructor.isLead().booleanValue()) continue;
                            for (DepartmentalInstructor departmentalInstructor : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor())) {
                                Object p;
                                p = departmentalInstructor.getClasses().iterator();
                                while (p.hasNext()) {
                                    Assignment a;
                                    ClassInstructor ci = (ClassInstructor)p.next();
                                    if (ci.equals(instructor) || ci.getClassInstructing().equals(clazz) || !ci.isLead().booleanValue() || (a = this.getAssignment(ci.getClassInstructing())) == null || a.getClazz().isCancelled().booleanValue() || !assignment2.overlaps(a) || clazz.canShareInstructor(a.getClazz())) continue;
                                    return true;
                                }
                            }
                            if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                            for (Class_ class_ : Class_DAO.getInstance().getSession().createQuery("select e.clazz from StudentClassEnrollment e where e.student.externalUniqueId = :externalId and e.student.session.uniqueId = :sessionId", Class_.class).setParameter("sessionId", (Object)instructor.getInstructor().getDepartment().getSessionId()).setParameter("externalId", (Object)instructor.getInstructor().getExternalUniqueId()).setCacheable(true).list()) {
                                Assignment a;
                                a = this.getAssignment(class_);
                                if (a == null || a.getClazz().isCancelled().booleanValue() || !assignment2.overlaps(a)) continue;
                                return true;
                            }
                        }
                    }
                    for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
                        Assignment a5 = this.getAssignment(parent);
                        if (a5 == null || a5.getClazz().isCancelled().booleanValue() || !assignment2.overlaps(a5)) continue;
                        return true;
                    }
                    for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
                        Assignment a3;
                        Class_ class_;
                        if (ss.getClasses().size() != 1 || clazz.equals(class_ = ss.getClasses().iterator().next()) || (a3 = this.getAssignment(class_)) == null || a3.getClazz().isCancelled().booleanValue() || !assignment2.overlaps(a3)) continue;
                        return true;
                    }
                }
            }
        }
        Date[] bounds = DatePattern.getBounds(offering.getSessionId());
        boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
        boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
            if (!changePast || ignorePast) {
                return ((Number)MeetingDAO.getInstance().getSession().createQuery("select count(mx) from ClassEvent e inner join e.meetings m, Meeting mx inner join mx.event ex where e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId and type(ex) != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod and mx.meetingDate >= :today", Number.class).setParameter("offeringId", (Object)offeringId).setParameter("today", (Object)today).setCacheable(true).uniqueResult()).intValue() > 0;
            }
            return ((Number)MeetingDAO.getInstance().getSession().createQuery("select count(mx) from ClassEvent e inner join e.meetings m, Meeting mx inner join mx.event ex where e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId and type(ex) != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod", Number.class).setParameter("offeringId", (Object)offeringId).setCacheable(true).uniqueResult()).intValue() > 0;
        }
        if (RoomAvailability.getInstance() != null) {
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    for (Class_ class_ : subpart.getClasses()) {
                        assignment = this.getAssignment(class_);
                        if (assignment == null || assignment.getRooms() == null || assignment.getRooms().isEmpty()) continue;
                        period = new ClassTimeInfo(assignment);
                        for (Location room : assignment.getRooms()) {
                            if (room.isIgnoreRoomCheck().booleanValue() || (times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) == null || times.isEmpty()) continue;
                            timesToCheck = null;
                            if (!changePast || ignorePast) {
                                timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                                for (RoomAvailabilityInterface.TimeBlock time : times) {
                                    if (time.getEndTime().before(today)) continue;
                                    timesToCheck.add(time);
                                }
                            } else {
                                timesToCheck = times;
                            }
                            if (period.overlaps(timesToCheck) == null) continue;
                            return true;
                        }
                    }
                }
            }
        }
        for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                for (Class_ class_ : subpart.getClasses()) {
                    if (class_.isCancelled().booleanValue() || !class_.hasLeadInstructor() || !class_.hasLeadInstructorWithUnavailabilities() && !ApplicationProperty.RoomAvailabilityIncludeInstructors.isTrue() || (assignment = this.getAssignment(class_)) == null) continue;
                    period = new ClassTimeInfo(assignment);
                    for (ClassInstructor ci : class_.getClassInstructors()) {
                        if (!ci.getLead().booleanValue()) continue;
                        if (RoomAvailability.getInstance() != null && (times = RoomAvailability.getInstance().getInstructorAvailability(ci.getInstructor().getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) != null && !times.isEmpty()) {
                            timesToCheck = null;
                            if (!changePast || ignorePast) {
                                timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                                for (RoomAvailabilityInterface.TimeBlock time : times) {
                                    if (time.getEndTime().before(today)) continue;
                                    timesToCheck.add(time);
                                }
                            } else {
                                timesToCheck = times;
                            }
                            if (period.overlaps(timesToCheck) != null) {
                                return true;
                            }
                        }
                        if (!ci.getInstructor().hasUnavailabilities() || (times = ci.getInstructor().listUnavailableDays()) == null || times.isEmpty()) continue;
                        timesToCheck = null;
                        if (!changePast || ignorePast) {
                            timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                            for (RoomAvailabilityInterface.TimeBlock time : times) {
                                if (time.getEndTime().before(today)) continue;
                                timesToCheck.add(time);
                            }
                        } else {
                            timesToCheck = times;
                        }
                        if (period.overlaps(timesToCheck) == null) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public Set<ClassAssignmentProxy.AssignmentInfo> getConflicts(Long classId) {
        if (classId == null) {
            return null;
        }
        Class_ clazz = (Class_)Class_DAO.getInstance().get(classId);
        if (clazz == null || clazz.isCancelled().booleanValue()) {
            return null;
        }
        Assignment assignment = this.getAssignment(clazz);
        if (assignment == null) {
            return null;
        }
        HashSet<ClassAssignmentProxy.AssignmentInfo> conflicts = new HashSet<ClassAssignmentProxy.AssignmentInfo>();
        if (assignment.getRooms() != null) {
            for (Location room : assignment.getRooms()) {
                if (!room.isIgnoreRoomCheck().booleanValue()) {
                    for (Assignment assignment2 : room.getCommitedAssignments()) {
                        if (assignment.equals(assignment2) || assignment2.getClazz().isCancelled().booleanValue() || !assignment.overlaps(assignment2) || clazz.canShareRoom(assignment2.getClazz())) continue;
                        conflicts.add(assignment2);
                    }
                }
                if (!(room instanceof Room)) continue;
                Room r = (Room)room;
                if (r.getParentRoom() != null && !r.getParentRoom().isIgnoreRoomCheck().booleanValue()) {
                    for (Assignment a3 : r.getParentRoom().getCommitedAssignments()) {
                        if (assignment.equals(a3) || a3.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a3) || clazz.canShareRoom(a3.getClazz())) continue;
                        conflicts.add(a3);
                    }
                }
                for (Object p : r.getPartitions()) {
                    if (((BaseLocation)p).isIgnoreRoomCheck().booleanValue()) continue;
                    for (Assignment a4 : ((Location)p).getCommitedAssignments()) {
                        if (assignment.equals(a4) || a4.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a4) || clazz.canShareRoom(a4.getClazz())) continue;
                        conflicts.add(a4);
                    }
                }
            }
        }
        if (clazz.getClassInstructors() != null) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (!instructor.isLead().booleanValue()) continue;
                for (DepartmentalInstructor departmentalInstructor : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor())) {
                    for (ClassInstructor ci : departmentalInstructor.getClasses()) {
                        Assignment a;
                        if (ci.equals(instructor) || ci.getClassInstructing().equals(clazz) || !ci.isLead().booleanValue() || (a = this.getAssignment(ci.getClassInstructing())) == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a) || clazz.canShareInstructor(a.getClazz())) continue;
                        conflicts.add(a);
                    }
                }
                if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                for (Class_ class_ : Class_DAO.getInstance().getSession().createQuery("select e.clazz from StudentClassEnrollment e where e.student.externalUniqueId = :externalId and e.student.session.uniqueId = :sessionId", Class_.class).setParameter("sessionId", (Object)instructor.getInstructor().getDepartment().getSessionId()).setParameter("externalId", (Object)instructor.getInstructor().getExternalUniqueId()).setCacheable(true).list()) {
                    Assignment a = this.getAssignment(class_);
                    if (a == null || a.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a)) continue;
                    conflicts.add(a);
                }
            }
        }
        for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
            Assignment a5 = this.getAssignment(parent);
            if (a5 == null || a5.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a5)) continue;
            conflicts.add(a5);
        }
        LinkedList<Class_> children = new LinkedList<Class_>(clazz.getChildClasses());
        Class_ child = null;
        while ((child = (Class_)children.poll()) != null) {
            Assignment assignment3 = this.getAssignment(child);
            if (assignment3 != null && !assignment3.getClazz().isCancelled().booleanValue() && assignment.overlaps(assignment3)) {
                conflicts.add(assignment3);
            }
            if (child.getChildClasses().isEmpty()) continue;
            children.addAll(child.getChildClasses());
        }
        for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
            Assignment a6;
            if (ss.getClasses().size() != 1 || clazz.equals(child = ss.getClasses().iterator().next()) || (a6 = this.getAssignment(child)) == null || a6.getClazz().isCancelled().booleanValue() || !assignment.overlaps(a6)) continue;
            conflicts.add(a6);
        }
        return conflicts;
    }

    @Override
    public Set<RoomAvailabilityInterface.TimeBlock> getConflictingTimeBlocks(Long classId) {
        List<RoomAvailabilityInterface.TimeBlock> overlaps;
        Collection<RoomAvailabilityInterface.TimeBlock> timesToCheck;
        Collection<RoomAvailabilityInterface.TimeBlock> times;
        ClassTimeInfo period;
        Date today;
        Calendar cal;
        boolean ignorePast;
        boolean changePast;
        Date[] bounds;
        if (classId == null) {
            return null;
        }
        Class_ clazz = (Class_)Class_DAO.getInstance().get(classId);
        if (clazz == null || clazz.isCancelled().booleanValue()) {
            return null;
        }
        TreeSet<RoomAvailabilityInterface.TimeBlock> conflicts = new TreeSet<RoomAvailabilityInterface.TimeBlock>(new RoomAvailabilityInterface.TimeBlockComparator());
        boolean defaultRoomAvailability = RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService;
        Assignment assignment = this.getAssignment(clazz);
        HashSet<Long> ignorePermIds = new HashSet<Long>();
        if (assignment != null && assignment.getRooms() != null && !assignment.getRooms().isEmpty() && RoomAvailability.getInstance() != null) {
            bounds = DatePattern.getBounds(clazz.getSessionId());
            changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            cal = Calendar.getInstance(Locale.US);
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            today = cal.getTime();
            period = new ClassTimeInfo(assignment);
            for (Location room : assignment.getRooms()) {
                if (room.isIgnoreRoomCheck().booleanValue()) {
                    ignorePermIds.add(room.getPermanentId());
                    continue;
                }
                if (defaultRoomAvailability || (times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) == null || times.isEmpty()) continue;
                timesToCheck = null;
                if (!changePast || ignorePast) {
                    timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                    for (RoomAvailabilityInterface.TimeBlock time : times) {
                        if (time.getEndTime().before(today)) continue;
                        timesToCheck.add(time);
                    }
                } else {
                    timesToCheck = times;
                }
                if ((overlaps = period.allOverlaps(timesToCheck)) == null) continue;
                conflicts.addAll(overlaps);
            }
        }
        if (assignment != null && clazz.hasLeadInstructor() && (clazz.hasLeadInstructorWithUnavailabilities() || ApplicationProperty.RoomAvailabilityIncludeInstructors.isTrue())) {
            bounds = DatePattern.getBounds(clazz.getSessionId());
            changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            cal = Calendar.getInstance(Locale.US);
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            today = cal.getTime();
            period = new ClassTimeInfo(assignment);
            for (ClassInstructor ci : clazz.getClassInstructors()) {
                RoomAvailabilityInterface.TimeBlock time;
                if (!ci.getLead().booleanValue()) continue;
                if (RoomAvailability.getInstance() != null && (times = RoomAvailability.getInstance().getInstructorAvailability(ci.getInstructor().getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) != null && !times.isEmpty()) {
                    timesToCheck = null;
                    if (!changePast || ignorePast) {
                        timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                        overlaps = times.iterator();
                        while (overlaps.hasNext()) {
                            time = (RoomAvailabilityInterface.TimeBlock)overlaps.next();
                            if (time.getEndTime().before(today)) continue;
                            timesToCheck.add(time);
                        }
                    } else {
                        timesToCheck = times;
                    }
                    if ((overlaps = period.allOverlaps(timesToCheck)) != null) {
                        conflicts.addAll(overlaps);
                    }
                }
                if (!ci.getInstructor().hasUnavailabilities() || (times = ci.getInstructor().listUnavailableDays()) == null || times.isEmpty()) continue;
                timesToCheck = null;
                if (!changePast || ignorePast) {
                    timesToCheck = new Vector<RoomAvailabilityInterface.TimeBlock>();
                    overlaps = times.iterator();
                    while (overlaps.hasNext()) {
                        time = overlaps.next();
                        if (time.getEndTime().before(today)) continue;
                        timesToCheck.add(time);
                    }
                } else {
                    timesToCheck = times;
                }
                if ((overlaps = period.allOverlaps(timesToCheck)) == null) continue;
                conflicts.addAll(overlaps);
            }
        }
        if (defaultRoomAvailability) {
            EventDateMapping.Class2EventDateMap class2eventDateMap = EventDateMapping.getMapping(clazz.getManagingDept().getSessionId());
            changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            List meetings = null;
            if (!changePast || ignorePast) {
                Calendar cal2 = Calendar.getInstance(Localization.getJavaLocale());
                cal2.set(11, 0);
                cal2.set(12, 0);
                cal2.set(13, 0);
                cal2.set(14, 0);
                Date today2 = cal2.getTime();
                meetings = MeetingDAO.getInstance().getSession().createQuery("select distinct mx from ClassEvent e inner join e.meetings m, Meeting mx inner join mx.event ex where e.clazz.uniqueId = :classId and type(ex) != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod and mx.meetingDate >= :today", Meeting.class).setParameter("classId", (Object)classId).setParameter("today", (Object)today2).setCacheable(true).list();
            } else {
                meetings = MeetingDAO.getInstance().getSession().createQuery("select distinct mx from ClassEvent e inner join e.meetings m, Meeting mx inner join mx.event ex where e.clazz.uniqueId = :classId and type(ex) != ClassEvent and m.approvalStatus = 1 and mx.approvalStatus = 1 and m.locationPermanentId = mx.locationPermanentId and m.meetingDate = mx.meetingDate and m.startPeriod < mx.stopPeriod and m.stopPeriod > mx.startPeriod", Meeting.class).setParameter("classId", (Object)classId).setCacheable(true).list();
            }
            for (Meeting m : meetings) {
                DefaultRoomAvailabilityService.MeetingTimeBlock block;
                if (m.getLocationPermanentId() != null && ignorePermIds.contains(m.getLocationPermanentId()) || (block = new DefaultRoomAvailabilityService.MeetingTimeBlock(m, class2eventDateMap)).getStartTime() == null) continue;
                conflicts.add(block);
            }
            return conflicts;
        }
        return conflicts;
    }
}

