/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;

public class SectioningIssuesReport
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static CourseMessages CMSG = Localization.create(CourseMessages.class);

    public SectioningIssuesReport(StudentSectioningModel model) {
        super(model);
    }

    protected String rooms(SctAssignment section) {
        if (section.getNrRooms() == 0) {
            return "";
        }
        Object ret = "";
        for (RoomLocation r : section.getRooms()) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : ",\n") + r.getName();
        }
        return ret;
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ",\n") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = (String)group + (((String)group).isEmpty() ? "" : ",\n") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ",\n") + instructor.getName();
        }
        return advisors;
    }

    protected XOffering getOffering(Offering offering) {
        return new XOffering(offering, this.getModel().getLinkedSections());
    }

    protected XOffering getOffering(Long offeringId) {
        for (Offering offering : this.getModel().getOfferings()) {
            if (!offeringId.equals(offering.getId())) continue;
            return this.getOffering(offering);
        }
        return null;
    }

    public SectioningRequest.ReschedulingReason check(XStudent student, XOffering offering, XCourseRequest request) {
        if (request.getEnrollment() == null) {
            return null;
        }
        if (!offering.getOfferingId().equals(request.getEnrollment().getOfferingId())) {
            return null;
        }
        List<XSection> sections = offering.getSections(request.getEnrollment());
        XConfig config = offering.getConfig(request.getEnrollment().getConfigId());
        if (sections.size() != config.getSubparts().size()) {
            for (XSection s1 : sections) {
                if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
                return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
            }
            return sections.size() < config.getSubparts().size() ? SectioningRequest.ReschedulingReason.MISSING_CLASS : SectioningRequest.ReschedulingReason.MULTIPLE_ENRLS;
        }
        boolean ignoreBreakTime = this.getModel().getProperties().getPropertyBoolean("ReScheduling.IgnoreBreakTimeConflicts", false);
        for (XSection s1 : sections) {
            for (XSection s2 : sections) {
                if (s1.getSectionId() < s2.getSectionId() && s1.isOverlapping(offering.getDistributions(), s2, ignoreBreakTime)) {
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
                if (s1.getSectionId().equals(s2.getSectionId()) || !s1.getSubpartId().equals(s2.getSubpartId())) continue;
                return SectioningRequest.ReschedulingReason.CLASS_LINK;
            }
            if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
            return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
        }
        if (!offering.isAllowOverlap(student, request.getEnrollment().getConfigId(), request.getEnrollment(), sections)) {
            for (XRequest r : student.getRequests()) {
                XEnrollment e;
                XOffering other;
                if (request.getPriority() <= r.getPriority() || !(r instanceof XCourseRequest) || r.getRequestId().equals(request.getRequestId()) || ((XCourseRequest)r).getEnrollment() == null || (other = this.getOffering((e = ((XCourseRequest)r).getEnrollment()).getOfferingId())) == null) continue;
                List<XSection> assignment = other.getSections(e);
                if (other.isAllowOverlap(student, e.getConfigId(), e, assignment)) continue;
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment, ignoreBreakTime)) continue;
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
            }
        }
        for (XSection section : sections) {
            if (!section.isCancelled()) continue;
            return SectioningRequest.ReschedulingReason.CLASS_CANCELLED;
        }
        return null;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        boolean all = properties.getPropertyBoolean("all", true);
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.colSubpart()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.reportDatePattern()), new CSVFile.CSVField((Object)MSG.colRoom()), new CSVFile.CSVField((Object)MSG.reportProblem()), new CSVFile.CSVField((Object)MSG.reportWaitListing())});
        for (Student student : this.getModel().getStudents()) {
            XStudent xStudent = new XStudent(student, assignment);
            for (Request request : student.getRequests()) {
                SectioningRequest.ReschedulingReason reason;
                Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
                if (enrollment == null || !enrollment.isCourseRequest() || !this.matches(request, enrollment) || (reason = this.check(xStudent, this.getOffering(enrollment.getCourse().getOffering()), new XCourseRequest((CourseRequest)request, enrollment))) == null) continue;
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField(student.getId()));
                line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                line.add(new CSVFile.CSVField((Object)student.getName()));
                line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                line.add(new CSVFile.CSVField((Object)this.group(student)));
                line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                line.add(new CSVFile.CSVField((Object)enrollment.getCourse().getName()));
                Object type = "";
                Object section = "";
                Object time = "";
                Object room = "";
                Object date = "";
                for (Section s : enrollment.getSections()) {
                    type = (String)type + (((String)type).isEmpty() ? "" : "\n") + (s.getSubpart().getName() == null ? s.getSubpart().getInstructionalType() : s.getSubpart().getName());
                    section = (String)section + (((String)section).isEmpty() ? "" : "\n") + s.getName(enrollment.getCourse().getId());
                    time = (String)time + (((String)time).isEmpty() ? "" : "\n") + (String)(s.getTime() == null || s.getTime().getDayCode() == 0 ? "" : s.getTime().getDayHeader() + " " + s.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + s.getTime().getEndTimeHeader(this.isUseAmPm()));
                    date = (String)date + (((String)date).isEmpty() ? "" : "\n") + (s.getTime() == null || s.getTime().getDatePatternName() == null ? "" : s.getTime().getDatePatternName());
                    room = (String)room + (((String)room).isEmpty() ? "" : "\n") + this.rooms((SctAssignment)s);
                }
                line.add(new CSVFile.CSVField(type));
                line.add(new CSVFile.CSVField(section));
                line.add(new CSVFile.CSVField(time));
                line.add(new CSVFile.CSVField(date));
                line.add(new CSVFile.CSVField(room));
                String r = reason.name();
                switch (reason) {
                    case CLASS_CANCELLED: {
                        r = MSG.reschedulingReasonCancelledClass();
                        break;
                    }
                    case TIME_CONFLICT: {
                        r = MSG.reschedulingReasonTimeConflict();
                        break;
                    }
                    case CLASS_LINK: {
                        r = MSG.reschedulingReasonClassLink();
                        break;
                    }
                    case MISSING_CLASS: {
                        r = MSG.reschedulingReasonMissingClass();
                        break;
                    }
                    case MULTIPLE_CONFIGS: {
                        r = MSG.reschedulingReasonMultipleConfigs();
                        break;
                    }
                    case MULTIPLE_ENRLS: {
                        r = MSG.reschedulingReasonMultipleClasses();
                        break;
                    }
                    case NO_REQUEST: {
                        r = MSG.reschedulingReasonNoRequest();
                    }
                }
                line.add(new CSVFile.CSVField((Object)r));
                InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(enrollment.getCourse().getOffering().getId());
                if (!all && !io.effectiveReSchedule()) continue;
                line.add(new CSVFile.CSVField((Object)(io.effectiveWaitList() ? CMSG.waitListEnabledShort() : (io.effectiveReSchedule() ? CMSG.waitListRescheduleShort() : CMSG.waitListDisabledShort()))));
                csv.addLine(line);
            }
        }
        return csv;
    }
}

