/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.unitime.timetable.model.PeriodicTask;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.TaskParameter;
import org.unitime.timetable.model.dao.PeriodicTaskDAO;
import org.unitime.timetable.model.dao.TaskExecutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.rights.Right;

public class TaskOutputFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String e = request.getParameter("e");
        if (e != null) {
            TaskExecution exec = (TaskExecution)TaskExecutionDAO.getInstance().get(Long.valueOf(e));
            if (exec == null) {
                response.sendError(400, "Task execution not found.");
                return;
            }
            if (exec.getOutputFile() == null) {
                response.sendError(400, "Task execution has no output file.");
                return;
            }
            this.getSessionContext().checkPermission(exec.getTask().getSession(), Right.TaskDetail);
            if (exec.getTask().getScript().getPermission() != null) {
                try {
                    Right right = Right.valueOf(exec.getTask().getScript().getPermission().replace(" ", ""));
                    if (!this.getSessionContext().hasPermission(right)) {
                        response.sendError(400, "Missing permission " + exec.getTask().getScript().getPermission());
                        return;
                    }
                }
                catch (IllegalArgumentException ex) {
                    response.sendError(400, "Bad permission " + exec.getTask().getScript().getPermission());
                    return;
                }
            }
            response.setContentType(exec.getOutputContentType());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + exec.getOutputName() + "\"");
            ServletOutputStream out = response.getOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(exec.getOutputFile());
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
            }
            finally {
                ((InputStream)in).close();
                out.close();
            }
            return;
        }
        String t = request.getParameter("t");
        if (t != null) {
            PeriodicTask task = (PeriodicTask)PeriodicTaskDAO.getInstance().get(Long.valueOf(t));
            if (task == null) {
                response.sendError(400, "Task not found.");
                return;
            }
            if (task.getInputFile() == null) {
                response.sendError(400, "Task has no input file.");
                return;
            }
            this.getSessionContext().checkPermission(task.getSession(), Right.TaskDetail);
            if (task.getScript().getPermission() != null) {
                try {
                    Right right = Right.valueOf(task.getScript().getPermission().replace(" ", ""));
                    if (!this.getSessionContext().hasPermission(right)) {
                        response.sendError(400, "Missing permission " + task.getScript().getPermission());
                        return;
                    }
                }
                catch (IllegalArgumentException ex) {
                    response.sendError(400, "Bad permission " + task.getScript().getPermission());
                    return;
                }
            }
            ScriptParameter fp = null;
            for (ScriptParameter scriptParameter : task.getScript().getParameters()) {
                if (!"file".equalsIgnoreCase(scriptParameter.getType())) continue;
                fp = scriptParameter;
                break;
            }
            String name = "unknown.file";
            for (TaskParameter p : task.getParameters()) {
                if (fp == null || !fp.getName().equals(p.getName())) continue;
                name = p.getValue();
            }
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
            ServletOutputStream servletOutputStream = response.getOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(task.getInputFile());
            try {
                IOUtils.copy((InputStream)in, (OutputStream)servletOutputStream);
                servletOutputStream.flush();
            }
            finally {
                ((InputStream)in).close();
                servletOutputStream.close();
            }
            return;
        }
        response.sendError(400, "Task or execution id not provided.");
    }
}

