/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor.survey;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.InstructorCourseRequirementNote;
import org.unitime.timetable.model.InstructorCourseRequirementType;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BasePreference;
import org.unitime.timetable.model.base.BaseRoomPref;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstructorCourseRequirementTypeDAO;
import org.unitime.timetable.model.dao.InstructorSurveyDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.AccessDeniedException;

@GwtRpcImplements(value=InstructorSurveyInterface.InstructorSurveyRequest.class)
public class RequestInstructorSurveyBackend
implements GwtRpcImplementation<InstructorSurveyInterface.InstructorSurveyRequest, InstructorSurveyInterface.InstructorSurveyData> {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final CourseMessages CMSG = Localization.create(CourseMessages.class);

    @Override
    public InstructorSurveyInterface.InstructorSurveyData execute(InstructorSurveyInterface.InstructorSurveyRequest request, SessionContext context) {
        boolean bl;
        if (!context.isAuthenticated() || context.getUser() == null || context.getUser().getCurrentAuthority() == null) {
            throw new AccessDeniedException();
        }
        DepartmentalInstructor instructor = null;
        Long sessionId = null;
        if (request.getInstructorId() != null && (instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(request.getInstructorId())) != null) {
            request.setExternalId(instructor.getExternalUniqueId());
            sessionId = instructor.getDepartment().getSessionId();
        }
        if (sessionId == null) {
            sessionId = context.getUser().getCurrentAcademicSessionId();
            if (request.hasSession()) {
                if ("auto".equals(request.getSession())) {
                    HashSet<Long> sessionIds = new HashSet<Long>();
                    for (UserAuthority userAuthority : context.getUser().getAuthorities()) {
                        if (!context.hasPermissionAnyAuthority(Right.InstructorSurvey, userAuthority.getAcademicSession())) continue;
                        sessionIds.add((Long)userAuthority.getAcademicSession().getQualifierId());
                    }
                    if (sessionIds.size() == 1) {
                        sessionId = (Long)sessionIds.iterator().next();
                    } else if (!sessionIds.isEmpty()) {
                        var6_8 = SessionDAO.getInstance().getSession().createQuery("from Session where uniqueId in :ids order by academicInitiative, sessionBeginDateTime", Session.class).setParameterList("ids", sessionIds, Long.class).setCacheable(true).setMaxResults(1).list().iterator();
                        if (var6_8.hasNext()) {
                            Session session = (Session)((Object)var6_8.next());
                            sessionId = session.getUniqueId();
                        }
                    } else {
                        var6_8 = SessionDAO.getInstance().getSession().createQuery("select session from InstructorSurvey where externalUniqueId = :externalId order by session.academicInitiative, session.sessionBeginDateTime desc", Session.class).setParameter("externalId", (Object)context.getUser().getExternalUserId()).setCacheable(true).setMaxResults(1).list().iterator();
                        if (var6_8.hasNext()) {
                            Session session = (Session)((Object)var6_8.next());
                            sessionId = session.getUniqueId();
                        }
                    }
                } else {
                    try {
                        sessionId = Long.valueOf(request.getSession());
                    }
                    catch (NumberFormatException e) {
                        Number id = (Number)SessionDAO.getInstance().getSession().createQuery("select uniqueId from Session where (academicTerm || academicYear) = :session or (academicTerm || academicYear || academicInitiative) = :session", Number.class).setParameter("session", (Object)request.getSession()).setMaxResults(1).setCacheable(true).uniqueResult();
                        if (id == null) {
                            throw new GwtRpcException(MESSAGES.errorSessionNotFound(request.getSession()));
                        }
                        sessionId = id.longValue();
                    }
                }
            }
        }
        boolean admin = context.hasPermissionAnySession(Right.InstructorSurveyAdmin, new SimpleQualifier("Session", sessionId));
        String externalId = context.getUser().getExternalUserId();
        if (request.getExternalId() != null && !request.getExternalId().isEmpty() && !externalId.equals(request.getExternalId())) {
            context.hasPermissionAnySession(Right.InstructorSurveyAdmin, new SimpleQualifier("Session", sessionId));
            externalId = request.getExternalId();
        }
        boolean bl2 = true;
        InstructorSurvey is = (InstructorSurvey)InstructorSurveyDAO.getInstance().getSession().createQuery("from InstructorSurvey where session.uniqueId = :sessionId and externalUniqueId = :externalId", InstructorSurvey.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setMaxResults(1).uniqueResult();
        ApplicationProperties.setSessionId(sessionId);
        if (!admin || externalId.equals(context.getUser().getExternalUserId())) {
            boolean bl3 = context.hasPermissionAnyAuthority(Right.InstructorSurvey, new SimpleQualifier("Session", sessionId));
            if (is != null && is.getSubmitted() != null && !admin) {
                bl = false;
            }
            if (!bl && is == null) {
                Session session = (Session)SessionDAO.getInstance().get(sessionId);
                throw new GwtRpcException(MESSAGES.errorInstructorSurveyNotAllowed(session == null ? MESSAGES.notApplicable() : session.getLabel()));
            }
        }
        final InstructorSurveyInterface.InstructorSurveyData survey = new InstructorSurveyInterface.InstructorSurveyData();
        survey.setExternalId(externalId);
        survey.setEditable(bl);
        survey.setAdmin(admin);
        survey.setSessionId(sessionId);
        survey.setCanDelete(bl && admin && ApplicationProperty.InstructorSurveyManagersCanDelete.isTrue());
        survey.setCanApply(is != null && is.getSubmitted() != null && instructor != null && context.hasPermission(instructor, Right.InstructorPreferences) && (!is.getPreferences().isEmpty() || !instructor.getPreferences().isEmpty()));
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        for (PreferenceLevel preferenceLevel : PreferenceLevel.getPreferenceLevelList(false)) {
            if (preferenceLevel.getPrefProlog().equals(PreferenceLevel.sNeutral)) continue;
            survey.addPrefLevel(new InstructorSurveyInterface.PrefLevel(preferenceLevel.getUniqueId(), preferenceLevel.getPrefProlog(), preferenceLevel.getAbbreviation(), preferenceLevel.getPrefName(), preferenceLevel.prefcolorNeutralBlack()));
        }
        if (instructor == null) {
            InstructorSurvey x;
            HashSet<Long> sessionIds = new HashSet<Long>();
            for (UserAuthority userAuthority : context.getUser().getAuthorities()) {
                x = InstructorSurvey.getInstructorSurvey(externalId, (Long)userAuthority.getAcademicSession().getQualifierId());
                if (x == null && !context.hasPermissionAnyAuthority(Right.InstructorSurvey, userAuthority.getAcademicSession())) continue;
                sessionIds.add((Long)userAuthority.getAcademicSession().getQualifierId());
            }
            if (!sessionIds.isEmpty()) {
                for (Session session : SessionDAO.getInstance().getSession().createQuery("from Session where uniqueId in :ids order by academicInitiative, sessionBeginDateTime", Session.class).setParameterList("ids", sessionIds, Long.class).setCacheable(true).list()) {
                    survey.addSession(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), session.getLabel(), session.getSessionBeginDateTime()));
                    if (session.getUniqueId().equals(sessionId) || !survey.isEditable() || (x = InstructorSurvey.getInstructorSurvey(survey.getExternalId(), session.getUniqueId())) == null) continue;
                    if (x.getNote() != null && !x.getNote().isEmpty() || !x.getPreferences().isEmpty()) {
                        survey.addSessionWithPreferences(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), session.getLabel(), session.getSessionBeginDateTime()));
                    }
                    if (x.getCourseRequirements().isEmpty()) continue;
                    survey.addSessionWithCourses(new AcademicSessionProvider.AcademicSessionInfo(session.getUniqueId(), session.getAcademicYear(), session.getAcademicTerm(), session.getAcademicInitiative(), session.getLabel(), session.getSessionBeginDateTime()));
                }
            }
        }
        InstructorSurveyInterface.Preferences roomPrefs = new InstructorSurveyInterface.Preferences(-4L, CMSG.propertyRooms());
        InstructorSurveyInterface.Preferences preferences = new InstructorSurveyInterface.Preferences(-1L, CMSG.propertyBuildings());
        InstructorSurveyInterface.Preferences preferences2 = new InstructorSurveyInterface.Preferences(-2L, CMSG.propertyRoomGroups());
        InstructorSurveyInterface.Preferences featurePrefs = new InstructorSurveyInterface.Preferences(-3L, CMSG.propertyRoomFeatures());
        HashMap<Long, InstructorSurveyInterface.Preferences> typedFeaturePrefs = new HashMap<Long, InstructorSurveyInterface.Preferences>();
        for (RoomGroup roomGroup : RoomGroup.getAllGlobalRoomGroups(sessionId)) {
            preferences2.addItem(roomGroup.getUniqueId(), roomGroup.getName(), roomGroup.getDescription());
        }
        for (RoomFeature roomFeature : RoomFeature.getAllGlobalRoomFeatures(sessionId)) {
            if (roomFeature.getFeatureType() != null) {
                if (!roomFeature.getFeatureType().isShowInInstructorSurvey().booleanValue()) continue;
                InstructorSurveyInterface.Preferences fp = (InstructorSurveyInterface.Preferences)typedFeaturePrefs.get(roomFeature.getFeatureType().getUniqueId());
                if (fp == null) {
                    fp = new InstructorSurveyInterface.Preferences(roomFeature.getFeatureType().getUniqueId(), roomFeature.getFeatureType().getLabel() + ":");
                    typedFeaturePrefs.put(roomFeature.getFeatureType().getUniqueId(), fp);
                }
                fp.addItem(roomFeature.getUniqueId(), roomFeature.getLabel(), roomFeature.getDescription());
                continue;
            }
            featurePrefs.addItem(roomFeature.getUniqueId(), roomFeature.getLabel(), roomFeature.getDescription());
        }
        List instructors = DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where externalUniqueId=:id and department.session.uniqueId=:sessionId", DepartmentalInstructor.class).setParameter("id", (Object)externalId).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        for (DepartmentalInstructor di : instructors) {
            if (survey.getFormattedName() == null) {
                survey.setFormattedName(di.getName(nameFormat));
            }
            if (!survey.hasEmail()) {
                survey.setEmail(di.getEmail());
            }
            survey.addDepartment(new InstructorSurveyInterface.InstructorDepartment(di.getDepartment().getUniqueId(), di.getDepartment().getDeptCode(), di.getDepartment().getLabel(), di.getPositionType() == null ? null : new InstructorSurveyInterface.IdLabel(di.getPositionType().getUniqueId(), di.getPositionType().getLabel(), null)));
            if (ApplicationProperty.InstructorSurveyRoomPreferencesDept.isTrue(di.getDepartment().getDeptCode(), true)) {
                for (Location location : di.getAvailableRooms()) {
                    roomPrefs.addItem(location.getUniqueId(), location.getLabel(), location.getDisplayName());
                }
            }
            if (ApplicationProperty.InstructorSurveyBuildingPreferencesDept.isTrue(di.getDepartment().getDeptCode(), true)) {
                for (Building bldg : di.getAvailableBuildings()) {
                    preferences.addItem(bldg.getUniqueId(), bldg.getAbbrName(), null);
                }
            }
            if (ApplicationProperty.InstructorSurveyRoomGroupPreferencesDept.isTrue(di.getDepartment().getDeptCode(), true)) {
                for (RoomGroup g : RoomGroup.getAllDepartmentRoomGroups(di.getDepartment())) {
                    preferences2.addItem(g.getUniqueId(), g.getName() + " (" + g.getDepartment().getDeptCode() + ")", g.getDescription());
                }
            }
            for (DepartmentRoomFeature f : RoomFeature.getAllDepartmentRoomFeatures(di.getDepartment())) {
                if (f.getFeatureType() != null) {
                    InstructorSurveyInterface.Preferences fp = (InstructorSurveyInterface.Preferences)typedFeaturePrefs.get(f.getFeatureType().getUniqueId());
                    if (fp == null) {
                        fp = new InstructorSurveyInterface.Preferences(f.getFeatureType().getUniqueId(), f.getFeatureType().getLabel() + ":");
                        typedFeaturePrefs.put(f.getFeatureType().getUniqueId(), fp);
                    }
                    fp.addItem(f.getUniqueId(), f.getLabel() + " (" + f.getDeptCode() + ")", f.getDescription());
                    continue;
                }
                if (!ApplicationProperty.InstructorSurveyRoomFeaturePreferencesDept.isTrue(di.getDepartment().getDeptCode(), true)) continue;
                featurePrefs.addItem(f.getUniqueId(), f.getLabel() + " (" + f.getDeptCode() + ")", f.getDescription());
            }
        }
        if (survey.getFormattedName() == null) {
            survey.setFormattedName(context.getUser().getName());
        }
        if (!survey.hasEmail()) {
            survey.setEmail(context.getUser().getEmail());
        }
        List list = InstructorCourseRequirementTypeDAO.getInstance().getSession().createQuery("from InstructorCourseRequirementType order by sortOrder", InstructorCourseRequirementType.class).list();
        HashMap<Long, InstructorSurveyInterface.CustomField> customFields = new HashMap<Long, InstructorSurveyInterface.CustomField>();
        for (InstructorCourseRequirementType type : list) {
            Iterator<InstructorSurveyInterface.IdLabel> cf = new InstructorSurveyInterface.CustomField(type.getUniqueId(), type.getReference(), type.getLength());
            customFields.put(type.getUniqueId(), (InstructorSurveyInterface.CustomField)((Object)cf));
            survey.addCustomField((InstructorSurveyInterface.CustomField)((Object)cf));
        }
        InstructorSurveyInterface.InstructorTimePreferencesModel timePref = new InstructorSurveyInterface.InstructorTimePreferencesModel();
        timePref.addMode(new RoomInterface.RoomSharingDisplayMode("|" + this.propertyValue(survey, ApplicationProperty.InstructorSurveyTimePreferencesDept, ApplicationProperty.InstructorSurveyTimePreferences)));
        timePref.setDefaultMode(0);
        timePref.setDefaultEditable(bl);
        boolean noProhobitedTimes = false;
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(false)) {
            Iterator<Object> option = new RoomInterface.RoomSharingOption(timePref.char2id(PreferenceLevel.prolog2char(pref.getPrefProlog())), pref.prefcolor(), "", pref.getPrefName(), true);
            if (instructor == null && bl && PreferenceLevel.sProhibited.equals(pref.getPrefProlog()) && !this.isAllowed(survey, ApplicationProperty.InstructorSurveyTimePreferencesDeptHard, ApplicationProperty.InstructorSurveyTimePreferencesHard)) {
                noProhobitedTimes = true;
                continue;
            }
            if (!PreferenceLevel.sRequired.equals(pref.getPrefProlog())) {
                timePref.addOption((RoomInterface.RoomSharingOption)((Object)option));
            }
            if (!PreferenceLevel.sNeutral.equals(pref.getPrefProlog())) continue;
            timePref.setDefaultOption((RoomInterface.RoomSharingOption)((Object)option));
        }
        timePref.setDefaultHorizontal(true);
        timePref.setNoteEditable(false);
        survey.setTimePrefs(timePref);
        if (preferences.hasItems() && this.isAllowed(survey, ApplicationProperty.InstructorSurveyBuildingPreferencesDept, ApplicationProperty.InstructorSurveyBuildingPreferences)) {
            if (!this.isAllowed(survey, ApplicationProperty.InstructorSurveyBuildingPreferencesDeptHard, ApplicationProperty.InstructorSurveyBuildingPreferencesHard)) {
                for (InstructorSurveyInterface.IdLabel item : preferences.getItems()) {
                    for (InstructorSurveyInterface.PrefLevel p : survey.getPrefLevels()) {
                        if (p.isHard()) continue;
                        item.addAllowedPref(p.getId());
                    }
                }
            }
            survey.addRoomPreference(preferences);
        }
        if (roomPrefs.hasItems() && this.isAllowed(survey, ApplicationProperty.InstructorSurveyRoomPreferencesDept, ApplicationProperty.InstructorSurveyRoomPreferences)) {
            if (!this.isAllowed(survey, ApplicationProperty.InstructorSurveyRoomPreferencesDeptHard, ApplicationProperty.InstructorSurveyRoomPreferencesHard)) {
                for (InstructorSurveyInterface.IdLabel item : roomPrefs.getItems()) {
                    for (InstructorSurveyInterface.PrefLevel p : survey.getPrefLevels()) {
                        if (p.isHard()) continue;
                        item.addAllowedPref(p.getId());
                    }
                }
            }
            survey.addRoomPreference(roomPrefs);
        }
        if (preferences2.hasItems() && this.isAllowed(survey, ApplicationProperty.InstructorSurveyRoomGroupPreferencesDept, ApplicationProperty.InstructorSurveyRoomGroupPreferences)) {
            if (!this.isAllowed(survey, ApplicationProperty.InstructorSurveyRoomGroupPreferencesDeptHard, ApplicationProperty.InstructorSurveyRoomGroupPreferencesHard)) {
                for (InstructorSurveyInterface.IdLabel item : preferences2.getItems()) {
                    for (InstructorSurveyInterface.PrefLevel p : survey.getPrefLevels()) {
                        if (p.isHard()) continue;
                        item.addAllowedPref(p.getId());
                    }
                }
            }
            survey.addRoomPreference(preferences2);
        }
        if (featurePrefs.hasItems() && this.isAllowed(survey, ApplicationProperty.InstructorSurveyRoomFeaturePreferencesDept, ApplicationProperty.InstructorSurveyRoomFeaturePreferences)) {
            if (!this.isAllowed(survey, ApplicationProperty.InstructorSurveyRoomFeaturePreferencesDeptHard, ApplicationProperty.InstructorSurveyRoomFeaturePreferencesHard)) {
                for (InstructorSurveyInterface.IdLabel item : featurePrefs.getItems()) {
                    for (InstructorSurveyInterface.PrefLevel p : survey.getPrefLevels()) {
                        if (p.isHard()) continue;
                        item.addAllowedPref(p.getId());
                    }
                }
            }
            survey.addRoomPreference(featurePrefs);
        }
        if (!typedFeaturePrefs.isEmpty()) {
            if (!this.isAllowed(survey, ApplicationProperty.InstructorSurveyRoomFeaturePreferencesDeptHard, ApplicationProperty.InstructorSurveyRoomFeaturePreferencesHard)) {
                for (InstructorSurveyInterface.Preferences prefs : typedFeaturePrefs.values()) {
                    if (!prefs.hasItems()) continue;
                    for (InstructorSurveyInterface.IdLabel item : prefs.getItems()) {
                        for (InstructorSurveyInterface.PrefLevel p : survey.getPrefLevels()) {
                            if (p.isHard()) continue;
                            item.addAllowedPref(p.getId());
                        }
                    }
                }
            }
            for (InstructorSurveyInterface.Preferences p : new TreeSet(typedFeaturePrefs.values())) {
                survey.addRoomPreference(p);
            }
        }
        InstructorSurveyInterface.Preferences distPref = new InstructorSurveyInterface.Preferences(-1L, CMSG.propertyDistribution());
        boolean hardDistPref = this.isAllowed(survey, ApplicationProperty.InstructorSurveyDistributionPreferencesDeptHard, ApplicationProperty.InstructorSurveyDistributionPreferencesHard);
        for (DistributionType dt : DistributionType.findAll(true, false, true)) {
            InstructorSurveyInterface.IdLabel dp;
            if (!dt.effectiveSurvey()) continue;
            if (dt.getDepartments() != null && !dt.getDepartments().isEmpty()) {
                boolean hasDept = false;
                for (Department d : dt.getDepartments()) {
                    if (!survey.hasDepartment(d.getUniqueId())) continue;
                    hasDept = true;
                    break;
                }
                if (!hasDept) continue;
            }
            if ((dp = distPref.addItem(dt.getUniqueId(), dt.getLabel(), dt.getDescr())) == null) continue;
            boolean hasPref = false;
            if (dt.getAllowedPref() != null && dt.getAllowedPref().length() > 0) {
                for (int i = 0; i < dt.getAllowedPref().length(); ++i) {
                    PreferenceLevel pref = PreferenceLevel.getPreferenceLevel(PreferenceLevel.char2prolog(dt.getAllowedPref().charAt(i)));
                    if (pref.isHard() && !hardDistPref) continue;
                    dp.addAllowedPref(pref.getUniqueId());
                    if (pref.getPrefProlog().equals(PreferenceLevel.sNeutral)) continue;
                    hasPref = true;
                }
            }
            if (hasPref) continue;
            distPref.removeItem(dt.getUniqueId());
        }
        if (distPref.hasItems() && this.isAllowed(survey, ApplicationProperty.InstructorSurveyDistributionPreferencesDept, ApplicationProperty.InstructorSurveyDistributionPreferences)) {
            survey.setDistributionPreferences(distPref);
        }
        if (is != null) {
            Object rp;
            DistributionPref dp;
            RoomFeaturePref fp;
            RoomGroupPref gp;
            BuildingPref bp;
            TimePref tp;
            Set<Building> deptBuildings = instructor == null ? null : instructor.getAvailableBuildings();
            Set<Location> deptRooms = instructor == null ? null : instructor.getAvailableRooms();
            for (Preference p : is.getPreferences()) {
                InstructorSurveyInterface.Problem prob;
                if (p instanceof TimePref) {
                    tp = (TimePref)p;
                    if (noProhobitedTimes && tp.getPreference() != null) {
                        timePref.setPattern(tp.getPreference().replace('P', '4'));
                    } else {
                        timePref.setPattern(tp.getPreference());
                    }
                    timePref.setNote(tp.getNote());
                    continue;
                }
                if (p instanceof BuildingPref) {
                    bp = (BuildingPref)p;
                    prob = deptBuildings == null || deptBuildings.contains(bp.getBuilding()) ? InstructorSurveyInterface.Problem.NOT_APPLIED : InstructorSurveyInterface.Problem.DIFFERENT_DEPT;
                    preferences.addSelection(new InstructorSurveyInterface.Selection(bp.getBuilding().getUniqueId(), bp.getPrefLevel().getUniqueId(), p.getNote()).withProblem(prob));
                    continue;
                }
                if (p instanceof RoomGroupPref) {
                    gp = (RoomGroupPref)p;
                    prob = InstructorSurveyInterface.Problem.NOT_APPLIED;
                    if (gp.getRoomGroup().getDepartment() != null && instructor != null && !instructor.getDepartment().equals(gp.getRoomGroup().getDepartment())) {
                        prob = InstructorSurveyInterface.Problem.DIFFERENT_DEPT;
                    }
                    preferences2.addSelection(new InstructorSurveyInterface.Selection(gp.getRoomGroup().getUniqueId(), gp.getPrefLevel().getUniqueId(), p.getNote()).withProblem(prob));
                    continue;
                }
                if (p instanceof RoomFeaturePref) {
                    fp = (RoomFeaturePref)p;
                    prob = InstructorSurveyInterface.Problem.NOT_APPLIED;
                    if (instructor != null && fp.getRoomFeature() instanceof DepartmentRoomFeature && !instructor.getDepartment().equals(((DepartmentRoomFeature)fp.getRoomFeature()).getDepartment())) {
                        prob = InstructorSurveyInterface.Problem.DIFFERENT_DEPT;
                    }
                    if (fp.getRoomFeature().getFeatureType() != null) {
                        InstructorSurveyInterface.Preferences prefs = (InstructorSurveyInterface.Preferences)typedFeaturePrefs.get(fp.getRoomFeature().getFeatureType().getUniqueId());
                        if (prefs == null) continue;
                        prefs.addSelection(new InstructorSurveyInterface.Selection(fp.getRoomFeature().getUniqueId(), fp.getPrefLevel().getUniqueId(), p.getNote()).withProblem(prob));
                        continue;
                    }
                    featurePrefs.addSelection(new InstructorSurveyInterface.Selection(fp.getRoomFeature().getUniqueId(), fp.getPrefLevel().getUniqueId(), p.getNote()).withProblem(prob));
                    continue;
                }
                if (p instanceof DistributionPref) {
                    dp = (DistributionPref)p;
                    if (!dp.getDistributionType().effectiveSurvey()) continue;
                    distPref.addSelection(new InstructorSurveyInterface.Selection(dp.getDistributionType().getUniqueId(), dp.getPrefLevel().getUniqueId(), p.getNote()));
                    continue;
                }
                if (!(p instanceof RoomPref)) continue;
                rp = (RoomPref)p;
                prob = deptRooms == null || deptRooms.contains(((BaseRoomPref)rp).getRoom()) ? InstructorSurveyInterface.Problem.NOT_APPLIED : InstructorSurveyInterface.Problem.DIFFERENT_DEPT;
                roomPrefs.addSelection(new InstructorSurveyInterface.Selection(((BaseRoomPref)rp).getRoom().getUniqueId(), ((BasePreference)rp).getPrefLevel().getUniqueId(), p.getNote()).withProblem(prob));
            }
            if (instructor != null) {
                for (Preference p : instructor.getPreferences()) {
                    if (p instanceof TimePref) {
                        tp = (TimePref)p;
                        if (timePref.getPattern().equals(tp.getPreference())) {
                            timePref.setProblem(null);
                            continue;
                        }
                        timePref.setProblem(InstructorSurveyInterface.Problem.LEVEL_CHANGED);
                        timePref.setInstructorPattern(tp.getPreference());
                        continue;
                    }
                    if (p instanceof BuildingPref) {
                        bp = (BuildingPref)p;
                        preferences.addInstructorSelection(new InstructorSurveyInterface.Selection(bp.getBuilding().getUniqueId(), bp.getPrefLevel().getUniqueId(), p.getNote()));
                        continue;
                    }
                    if (p instanceof RoomGroupPref) {
                        gp = (RoomGroupPref)p;
                        preferences2.addInstructorSelection(new InstructorSurveyInterface.Selection(gp.getRoomGroup().getUniqueId(), gp.getPrefLevel().getUniqueId(), p.getNote()));
                        continue;
                    }
                    if (p instanceof RoomFeaturePref) {
                        fp = (RoomFeaturePref)p;
                        if (fp.getRoomFeature().getFeatureType() != null) {
                            InstructorSurveyInterface.Preferences prefs = (InstructorSurveyInterface.Preferences)typedFeaturePrefs.get(fp.getRoomFeature().getFeatureType().getUniqueId());
                            if (prefs == null) continue;
                            prefs.addInstructorSelection(new InstructorSurveyInterface.Selection(fp.getRoomFeature().getUniqueId(), fp.getPrefLevel().getUniqueId(), p.getNote()));
                            continue;
                        }
                        featurePrefs.addInstructorSelection(new InstructorSurveyInterface.Selection(fp.getRoomFeature().getUniqueId(), fp.getPrefLevel().getUniqueId(), p.getNote()));
                        continue;
                    }
                    if (p instanceof DistributionPref) {
                        dp = (DistributionPref)p;
                        distPref.addInstructorSelection(new InstructorSurveyInterface.Selection(dp.getDistributionType().getUniqueId(), dp.getPrefLevel().getUniqueId(), p.getNote()));
                        continue;
                    }
                    if (!(p instanceof RoomPref)) continue;
                    rp = (RoomPref)p;
                    roomPrefs.addInstructorSelection(new InstructorSurveyInterface.Selection(((BaseRoomPref)rp).getRoom().getUniqueId(), ((BasePreference)rp).getPrefLevel().getUniqueId(), p.getNote()));
                }
            }
        }
        HashSet<Long> courseIds = new HashSet<Long>();
        if (is != null) {
            survey.setSubmitted(is.getSubmitted());
            if (is.getEmail() != null && !is.getEmail().isEmpty()) {
                survey.setEmail(is.getEmail());
            }
            survey.setApplied(is.getApplied());
            survey.setAppliedDeptCode(is.getAppliedDeptCode());
            if (is.getAppliedDeptCode() != null && !instructors.isEmpty()) {
                for (DepartmentalInstructor di : instructors) {
                    if (!di.getDepartment().getDeptCode().equals(is.getAppliedDeptCode())) continue;
                    survey.setAppliedDeptCode(di.getDepartment().getLabel());
                }
            }
            survey.setChanged(is.getChanged());
            if (is.getChangedBy() != null) {
                TimetableManager manager = TimetableManager.findByExternalId(is.getChangedBy());
                if (manager != null) {
                    survey.setChangedBy(manager.getName(nameFormat));
                } else if (!instructors.isEmpty()) {
                    survey.setChangedBy(((DepartmentalInstructor)instructors.get(0)).getName(nameFormat));
                } else {
                    survey.setChangedBy(is.getChangedBy());
                }
            }
            survey.setNote(is.getNote());
            for (InstructorCourseRequirement r : is.getCourseRequirements()) {
                InstructorSurveyInterface.Course ci = new InstructorSurveyInterface.Course();
                ci.setReqId(r.getUniqueId());
                ci.setId(r.getCourseOffering() == null ? null : r.getCourseOffering().getUniqueId());
                ci.setCourseName(r.getCourseOffering() == null ? r.getCourse() : r.getCourseOffering().getCourseName());
                ci.setCourseTitle(r.getCourseOffering() == null ? null : r.getCourseOffering().getTitle());
                if (r.getCourseOffering() != null) {
                    courseIds.add(r.getCourseOffering().getUniqueId());
                }
                for (InstructorCourseRequirementNote n : r.getNotes()) {
                    InstructorSurveyInterface.CustomField cf = (InstructorSurveyInterface.CustomField)customFields.get(n.getType().getUniqueId());
                    if (cf == null) continue;
                    ci.setCustomField(cf, n.getNote());
                }
                survey.addCourse(ci);
            }
        }
        boolean excludeAuxiliary = ApplicationProperty.InstructorSurveyExcludeAuxiliaryAssignments.isTrue();
        String excludeCourseType = ApplicationProperty.InstructorSurveyExcludeCourseTypes.value();
        for (CourseOffering co : CourseOfferingDAO.getInstance().getSession().createQuery("select distinct co from DepartmentalInstructor i inner join i.classes ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io inner join io.courseOfferings co " + (excludeAuxiliary ? "left outer join ci.responsibility r " : "") + "where co.isControl = true and io.notOffered = false and io.session.uniqueId = :sessionId and i.externalUniqueId=:id and ci.lead = true and c.schedulingSubpart.itype.organized = true" + (String)(excludeAuxiliary ? " and (r is null or bitand(r.options, " + TeachingResponsibility.Option.auxiliary.toggle() + ") = 0)" : ""), CourseOffering.class).setParameter("id", (Object)externalId).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            if (excludeCourseType != null && !excludeCourseType.isEmpty() && co.getCourseType() != null && co.getCourseType().getReference().matches(excludeCourseType) || !courseIds.add(co.getUniqueId())) continue;
            InstructorSurveyInterface.Course ci = new InstructorSurveyInterface.Course();
            ci.setId(co.getUniqueId());
            ci.setCourseName(co.getCourseName());
            ci.setCourseTitle(co.getTitle());
            survey.addCourse(ci);
        }
        if (survey.hasCourses()) {
            Collections.sort(survey.getCourses(), new Comparator<InstructorSurveyInterface.Course>(){

                @Override
                public int compare(InstructorSurveyInterface.Course co1, InstructorSurveyInterface.Course co2) {
                    int cmp = co1.getCourseName().compareTo(co2.getCourseName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    for (InstructorSurveyInterface.CustomField f : survey.getCustomFields()) {
                        String cf2;
                        String cf1 = co1.getCustomField(f);
                        cmp = (cf1 == null ? "" : cf1).compareTo((cf2 = co2.getCustomField(f)) == null ? "" : cf2);
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }
            });
        }
        return survey;
    }

    protected String propertyValue(InstructorSurveyInterface.InstructorSurveyData survey, ApplicationProperty departmentalProperty, ApplicationProperty globalProperty) {
        if (survey.hasDepartments()) {
            for (InstructorSurveyInterface.InstructorDepartment dept : survey.getDepartments()) {
                String value = departmentalProperty.valueOfSession(survey.getSessionId(), dept.getDeptCode());
                if (value == null) continue;
                return value;
            }
        }
        return globalProperty.valueOfSession(survey.getSessionId());
    }

    protected boolean isAllowed(InstructorSurveyInterface.InstructorSurveyData survey, ApplicationProperty departmentalProperty, ApplicationProperty globalProperty) {
        if (survey.hasDepartments()) {
            boolean hasFalse = false;
            for (InstructorSurveyInterface.InstructorDepartment dept : survey.getDepartments()) {
                String value = departmentalProperty.valueOfSession(survey.getSessionId(), dept.getDeptCode());
                if ("true".equalsIgnoreCase(value)) {
                    return true;
                }
                if (!"false".equalsIgnoreCase(value)) continue;
                hasFalse = true;
            }
            if (hasFalse) {
                return false;
            }
        }
        return "true".equalsIgnoreCase(globalProperty.valueOfSession(survey.getSessionId()));
    }
}

