/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor.survey;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.CurriculaServlet;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CurriculaException;
import org.unitime.timetable.gwt.shared.CurriculumInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.NameFormat;

public class CourseSelectionBoxBackend {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    private static void checkPermissions(Long sessionId, SessionContext context) {
        ApplicationProperties.setSessionId(sessionId);
        boolean admin = context.hasPermissionAnySession(Right.InstructorSurveyAdmin, new SimpleQualifier("Session", sessionId));
        if (!admin) {
            context.hasPermissionAnySession(Right.InstructorSurvey, new SimpleQualifier("Session", sessionId));
        }
    }

    private static CourseOffering getCourse(Long sessionId, String courseName, Long courseId) {
        CourseOffering ret;
        block1: {
            CourseOffering co;
            CourseOffering co2;
            if (courseId != null && (co2 = (CourseOffering)CourseOfferingDAO.getInstance().get(courseId)) != null) {
                return co2;
            }
            ret = null;
            Iterator iterator = CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course", CourseOffering.class).setParameter("course", (Object)courseName.toLowerCase()).setParameter("sessionId", (Object)sessionId).setCacheable(true).setMaxResults(1).list().iterator();
            if (!iterator.hasNext()) break block1;
            ret = co = (CourseOffering)iterator.next();
        }
        return ret;
    }

    @GwtRpcImplements(value=InstructorSurveyInterface.ListCurricula.class)
    public static class ListCurriculaBackend
    implements GwtRpcImplementation<InstructorSurveyInterface.ListCurricula, GwtRpcResponseList<CurriculumInterface>> {
        @Override
        public GwtRpcResponseList<CurriculumInterface> execute(final InstructorSurveyInterface.ListCurricula request, SessionContext context) {
            CourseSelectionBoxBackend.checkPermissions(request.getSessionId(), context);
            CurriculaServlet servlet = new CurriculaServlet(){

                @Override
                protected Long getAcademicSessionId() {
                    return request.getSessionId();
                }
            };
            TreeSet<CurriculumInterface> ret = servlet.findCurriculaForACourse(request.getCourse());
            if (ret == null) {
                return null;
            }
            return new GwtRpcResponseList<CurriculumInterface>((Collection<CurriculumInterface>)ret);
        }
    }

    @GwtRpcImplements(value=InstructorSurveyInterface.ListAcademicClassifications.class)
    public static class ListAcademicClassificationsBackend
    implements GwtRpcImplementation<InstructorSurveyInterface.ListAcademicClassifications, GwtRpcResponseList<CurriculumInterface.AcademicClassificationInterface>> {
        @Override
        public GwtRpcResponseList<CurriculumInterface.AcademicClassificationInterface> execute(final InstructorSurveyInterface.ListAcademicClassifications request, SessionContext context) {
            CourseSelectionBoxBackend.checkPermissions(request.getSessionId(), context);
            CurriculaServlet servlet = new CurriculaServlet(){

                @Override
                protected Long getAcademicSessionId() {
                    return request.getSessionId();
                }
            };
            TreeSet<CurriculumInterface.AcademicClassificationInterface> ret = servlet.loadAcademicClassifications();
            if (ret == null) {
                return null;
            }
            return new GwtRpcResponseList<CurriculumInterface.AcademicClassificationInterface>((Collection<CurriculumInterface.AcademicClassificationInterface>)ret);
        }
    }

    @GwtRpcImplements(value=InstructorSurveyInterface.ListClasses.class)
    public static class ListClassesBackend
    implements GwtRpcImplementation<InstructorSurveyInterface.ListClasses, GwtRpcResponseList<ClassAssignmentInterface.ClassAssignment>> {
        @Override
        public GwtRpcResponseList<ClassAssignmentInterface.ClassAssignment> execute(InstructorSurveyInterface.ListClasses request, SessionContext context) {
            Session session;
            CourseSelectionBoxBackend.checkPermissions(request.getSessionId(), context);
            CourseOffering courseOffering = CourseSelectionBoxBackend.getCourse(request.getSessionId(), request.getCourse(), request.getCourseId());
            if (courseOffering == null) {
                throw new CurriculaException(MESSAGES.errorCourseDoesNotExist(request.getCourse()));
            }
            if (!context.hasPermission(Right.HasRole) && (session = (Session)SessionDAO.getInstance().get(request.getSessionId())) != null && !session.canNoRoleReportClass()) {
                throw new SectioningException(MSG.exceptionClassScheduleNotAvaiable());
            }
            GwtRpcResponseList<ClassAssignmentInterface.ClassAssignment> results = new GwtRpcResponseList<ClassAssignmentInterface.ClassAssignment>();
            NameFormat nameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(context.getUser()));
            ArrayList<Class_> classes = new ArrayList<Class_>();
            for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                    classes.addAll(subpart.getClasses());
                }
            }
            Collections.sort(classes, new ClassComparator(5));
            for (Class_ clazz : classes) {
                int maxLimit;
                ClassAssignmentInterface.ClassAssignment a = new ClassAssignmentInterface.ClassAssignment();
                a.setClassId(clazz.getUniqueId());
                a.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim());
                a.setSection(clazz.getClassSuffix(courseOffering));
                a.setExternalId(clazz.getExternalId(courseOffering));
                a.setClassNumber(clazz.getSectionNumberString());
                if (a.getSection() == null) {
                    a.setSection(a.getClassNumber());
                }
                a.addNote(clazz.getSchedulePrintNote());
                Assignment ass = clazz.getCommittedAssignment();
                Placement p = ass == null ? null : ass.getPlacement();
                int minLimit = clazz.getExpectedCapacity();
                int limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
                if (minLimit < maxLimit && p != null) {
                    int roomLimit = (int)Math.floor((float)p.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                    limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                }
                if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                    limit = -1;
                }
                a.setCancelled(clazz.isCancelled());
                a.setLimit(new int[]{clazz.getEnrollment(), limit});
                if (p != null && p.getTimeLocation() != null) {
                    for (DayCode d : DayCode.toDayCodes(p.getTimeLocation().getDayCode())) {
                        a.addDay(d.getIndex());
                    }
                    a.setStart(p.getTimeLocation().getStartSlot());
                    a.setLength(p.getTimeLocation().getLength());
                    a.setBreakTime(p.getTimeLocation().getBreakTime());
                    a.setDatePattern(p.getTimeLocation().getDatePatternName());
                }
                if (p != null && p.getRoomLocations() != null) {
                    for (RoomLocation rm : p.getRoomLocations()) {
                        a.addRoom(rm.getId(), rm.getName());
                    }
                }
                if (p != null && p.getRoomLocation() != null) {
                    a.addRoom(p.getRoomLocation().getId(), p.getRoomLocation().getName());
                }
                if (!clazz.getClassInstructors().isEmpty()) {
                    for (ClassInstructor instr : clazz.getClassInstructors()) {
                        a.addInstructor(nameFormat.format(instr.getInstructor()));
                        a.addInstructoEmail(instr.getInstructor().getEmail());
                    }
                }
                if (clazz.getParentClass() != null) {
                    a.setParentSection(clazz.getParentClass().getClassSuffix(courseOffering));
                }
                a.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
                if (a.getParentSection() == null) {
                    a.setParentSection(courseOffering.getConsentType() == null ? null : courseOffering.getConsentType().getLabel());
                }
                results.add(a);
            }
            return results;
        }
    }

    @GwtRpcImplements(value=InstructorSurveyInterface.RetrieveCourseDetail.class)
    public static class RetrieveCourseDetailBackend
    implements GwtRpcImplementation<InstructorSurveyInterface.RetrieveCourseDetail, InstructorSurveyInterface.CourseDetail> {
        @Override
        public InstructorSurveyInterface.CourseDetail execute(InstructorSurveyInterface.RetrieveCourseDetail request, SessionContext context) {
            CourseSelectionBoxBackend.checkPermissions(request.getSessionId(), context);
            CourseOffering courseOffering = CourseSelectionBoxBackend.getCourse(request.getSessionId(), request.getCourse(), request.getCourseId());
            if (courseOffering == null) {
                throw new CurriculaException(MESSAGES.errorCourseDoesNotExist(request.getCourse()));
            }
            CourseDetailsProvider provider = (CourseDetailsProvider)Customization.CourseDetailsProvider.getProvider();
            return new InstructorSurveyInterface.CourseDetail(provider.getDetails(new AcademicSessionInfo(courseOffering.getSubjectArea().getSession()), courseOffering.getSubjectAreaAbbv(), courseOffering.getCourseNbr()));
        }
    }

    @GwtRpcImplements(value=InstructorSurveyInterface.ListCourseOfferings.class)
    public static class ListCoursesBackend
    implements GwtRpcImplementation<InstructorSurveyInterface.ListCourseOfferings, GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment>> {
        @Override
        public GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment> execute(InstructorSurveyInterface.ListCourseOfferings request, SessionContext context) {
            CourseSelectionBoxBackend.checkPermissions(request.getSessionId(), context);
            GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment> results = new GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment>();
            String excludeCourseType = ApplicationProperty.InstructorSurveyExcludeCourseTypes.value();
            for (CourseOffering c : CourseOfferingDAO.getInstance().getSession().createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' or lower(c.courseNbr) like :q || '%' " + (request.getQuery().length() > 2 ? "or lower(c.title) like '%' || :q || '%'" : "") + ") order by case when lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' then 0 else 1 end,c.subjectArea.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("q", (Object)request.getQuery().toLowerCase()).setParameter("sessionId", (Object)request.getSessionId()).setCacheable(true).setMaxResults(request.getLimit() == null || request.getLimit() < 0 ? Integer.MAX_VALUE : request.getLimit()).list()) {
                if (excludeCourseType != null && !excludeCourseType.isEmpty() && c.getCourseType() != null && c.getCourseType().getReference().matches(excludeCourseType)) continue;
                ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                course.setCourseId(c.getUniqueId());
                course.setSubject(c.getSubjectAreaAbbv());
                course.setCourseNbr(c.getCourseNbr());
                course.setNote(c.getScheduleBookNote());
                course.setTitle(c.getTitle());
                if (c.getCredit() != null) {
                    course.setCreditText(c.getCredit().creditText());
                    course.setCreditAbbv(c.getCredit().creditAbbv());
                }
                course.setHasUniqueName(true);
                course.setHasCrossList(c.getInstructionalOffering().hasCrossList());
                course.setCanWaitList(c.getInstructionalOffering().effectiveWaitList());
                boolean unlimited = false;
                int courseLimit = 0;
                for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                    if (cfg.isUnlimitedEnrollment().booleanValue()) {
                        unlimited = true;
                    }
                    if (cfg.getLimit() == null) continue;
                    courseLimit += cfg.getLimit().intValue();
                }
                if (c.getReservation() != null) {
                    courseLimit = c.getReservation();
                }
                if (courseLimit >= 9999) {
                    unlimited = true;
                }
                course.setLimit(unlimited ? -1 : courseLimit);
                course.setProjected(c.getProjectedDemand());
                course.setEnrollment(c.getEnrollment());
                course.setLastLike(c.getDemand());
                results.add(course);
            }
            return results;
        }
    }
}

