/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.interfaces.ExternalSchedulingSubpartEditAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassEditBackend;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=PrefGroupEditInterface.SubpartEditRequest.class)
public class SubpartEditBackend
implements GwtRpcImplementation<PrefGroupEditInterface.SubpartEditRequest, PrefGroupEditInterface.SubpartEditResponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public PrefGroupEditInterface.SubpartEditResponse execute(PrefGroupEditInterface.SubpartEditRequest request, SessionContext context) {
        Session hibSession = SchedulingSubpartDAO.getInstance().getSession();
        SchedulingSubpart subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(request.getId());
        context.checkPermission(subpart, Right.SchedulingSubpartEdit);
        if (subpart == null) {
            throw new GwtRpcException(MSG.errorNoSubpartId());
        }
        if (request.getOperation() != null) {
            switch (request.getOperation()) {
                case CLEAR_CLASS_PREFS: {
                    context.checkPermission(subpart, Right.SchedulingSubpartEditClearPreferences);
                    ClassEditBackend.doClear(subpart.getPreferences(), Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
                    hibSession.merge((Object)subpart);
                    hibSession.flush();
                    ChangeLog.addChange(null, context, subpart, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.CLEAR_PREF, subpart.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), subpart.getManagingDept());
                    PrefGroupEditInterface.SubpartEditResponse ret = new PrefGroupEditInterface.SubpartEditResponse();
                    ret.setUrl("subpart?id=" + subpart.getUniqueId());
                    return ret;
                }
                case UPDATE: 
                case NEXT: 
                case PREVIOUS: {
                    Transaction tx = hibSession.beginTransaction();
                    try {
                        PrefGroupEditInterface.SubpartEditResponse data = (PrefGroupEditInterface.SubpartEditResponse)request.getPayLoad();
                        subpart.setAutoSpreadInTime(data.isAutoSpreadInTime());
                        subpart.setStudentAllowOverlap(data.isStudentsCanOverlap());
                        subpart.setDatePattern(data.getDatePatternId() == null ? null : (DatePattern)DatePatternDAO.getInstance().get(data.getDatePatternId()));
                        ClassEditBackend.doUpdate(subpart, subpart.getPreferences(), data, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
                        hibSession.merge((Object)subpart);
                        if (data.getCreditFormat() == null) {
                            CourseCreditUnitConfig origConfig = subpart.getCredit();
                            if (origConfig != null) {
                                subpart.setCredit(null);
                                hibSession.remove((Object)origConfig);
                            }
                        } else if (subpart.getCredit() != null) {
                            CourseCreditUnitConfig ccuc = subpart.getCredit();
                            if (ccuc.getCreditFormat().equals(data.getCreditFormat())) {
                                boolean changed = false;
                                if (!ccuc.getCreditType().getUniqueId().equals(data.getCreditTypeId())) {
                                    changed = true;
                                }
                                if (!ccuc.getCreditUnitType().getUniqueId().equals(data.getCreditUnitTypeId())) {
                                    changed = true;
                                }
                                if (ccuc instanceof FixedCreditUnitConfig) {
                                    FixedCreditUnitConfig fixedCreditUnitConfig = (FixedCreditUnitConfig)ccuc;
                                    if (!fixedCreditUnitConfig.getFixedUnits().equals(data.getCreditUnits())) {
                                        changed = true;
                                    }
                                } else if (ccuc instanceof VariableFixedCreditUnitConfig) {
                                    VariableRangeCreditUnitConfig variableRangeCreditUnitConfig;
                                    VariableFixedCreditUnitConfig variableFixedCreditUnitConfig = (VariableFixedCreditUnitConfig)ccuc;
                                    if (!variableFixedCreditUnitConfig.getMinUnits().equals(data.getCreditUnits())) {
                                        changed = true;
                                    }
                                    if (!variableFixedCreditUnitConfig.getMaxUnits().equals(data.getCreditMaxUnits())) {
                                        changed = true;
                                    }
                                    if (variableFixedCreditUnitConfig instanceof VariableRangeCreditUnitConfig && !(variableRangeCreditUnitConfig = (VariableRangeCreditUnitConfig)variableFixedCreditUnitConfig).isFractionalIncrementsAllowed().equals(data.isCreditFractionsAllowed())) {
                                        changed = true;
                                    }
                                }
                                if (changed) {
                                    CourseCreditUnitConfig courseCreditUnitConfig = subpart.getCredit();
                                    subpart.setCredit(null);
                                    hibSession.remove((Object)courseCreditUnitConfig);
                                    subpart.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(data.getCreditFormat(), data.getCreditTypeId(), data.getCreditUnitTypeId(), data.getCreditUnits(), data.getCreditMaxUnits(), (Boolean)data.isCreditFractionsAllowed(), (Boolean)false));
                                    subpart.getCredit().setOwner(subpart);
                                }
                            } else {
                                CourseCreditUnitConfig origConfig = subpart.getCredit();
                                subpart.setCredit(null);
                                hibSession.remove((Object)origConfig);
                                subpart.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(data.getCreditFormat(), data.getCreditTypeId(), data.getCreditUnitTypeId(), data.getCreditUnits(), data.getCreditMaxUnits(), (Boolean)data.isCreditFractionsAllowed(), (Boolean)false));
                                subpart.getCredit().setOwner(subpart);
                            }
                        } else {
                            subpart.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(data.getCreditFormat(), data.getCreditTypeId(), data.getCreditUnitTypeId(), data.getCreditUnits(), data.getCreditMaxUnits(), (Boolean)data.isCreditFractionsAllowed(), (Boolean)false));
                            subpart.getCredit().setOwner(subpart);
                        }
                        if (subpart.getCredit() != null) {
                            if (subpart.getCredit().getUniqueId() == null) {
                                hibSession.persist((Object)subpart.getCredit());
                            } else {
                                hibSession.merge((Object)subpart.getCredit());
                            }
                        }
                        ChangeLog.addChange(null, context, subpart, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.UPDATE, subpart.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), subpart.getManagingDept());
                        String className = ApplicationProperty.ExternalActionSchedulingSubpartEdit.value();
                        if (className != null && className.trim().length() > 0) {
                            ExternalSchedulingSubpartEditAction editAction = (ExternalSchedulingSubpartEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            editAction.performExternalSchedulingSubpartEditAction(subpart, hibSession);
                        }
                        tx.commit();
                        tx = null;
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw new GwtRpcException(e.getMessage(), e);
                    }
                    PrefGroupEditInterface.SubpartEditResponse ret = new PrefGroupEditInterface.SubpartEditResponse();
                    if (request.getOperation() == PrefGroupEditInterface.Operation.PREVIOUS && ((PrefGroupEditInterface.SubpartEditResponse)request.getPayLoad()).getPreviousId() != null) {
                        ret.setUrl("subpartEdit?id=" + ((PrefGroupEditInterface.SubpartEditResponse)request.getPayLoad()).getPreviousId());
                    } else if (request.getOperation() == PrefGroupEditInterface.Operation.NEXT && ((PrefGroupEditInterface.SubpartEditResponse)request.getPayLoad()).getNextId() != null) {
                        ret.setUrl("subpartEdit?id=" + ((PrefGroupEditInterface.SubpartEditResponse)request.getPayLoad()).getNextId());
                    } else {
                        ret.setUrl("subpart?id=" + subpart.getUniqueId());
                    }
                    return ret;
                }
                case DATE_PATTERN: {
                    PrefGroupEditInterface.SubpartEditResponse ret = (PrefGroupEditInterface.SubpartEditResponse)request.getPayLoad();
                    DatePattern datePattern = (DatePattern)DatePatternDAO.getInstance().get(ret.getDatePatternId());
                    if (datePattern == null) {
                        datePattern = subpart.getSession().getDefaultDatePattern();
                    }
                    List<PrefGroupEditInterface.Selection> dateSelections = ret.getDatePreferences() == null ? null : ret.getDatePreferences().getSelections();
                    ClassEditBackend.fillInDatePreferences(ret, subpart, null, datePattern, context, false);
                    if (ret.getDatePreferences() != null && dateSelections != null) {
                        for (PrefGroupEditInterface.Selection selection : dateSelections) {
                            if (ret.getDatePreferences().getItem(selection.getItem()) == null) continue;
                            ret.getDatePreferences().addSelection(selection);
                        }
                    }
                    List<PrefGroupEditInterface.TimeSelection> timeSelections = ret.getTimePreferences() == null ? null : ret.getTimePreferences().getSelections();
                    ClassEditBackend.fillInTimePreferences(ret, subpart, null, datePattern, context, false);
                    if (ret.getTimePreferences() != null && timeSelections != null) {
                        for (PrefGroupEditInterface.TimeSelection timeSelection : timeSelections) {
                            TimePattern tp;
                            PrefGroupEditInterface.TimePatternModel m = ret.getTimePreferences().getItem(timeSelection.getItem());
                            if (m == null && (tp = (TimePattern)TimePatternDAO.getInstance().get(timeSelection.getItem())) != null) {
                                m = ClassEditBackend.createTimePatternModel(subpart, tp, context);
                                m.setValid(false);
                                ret.getTimePreferences().addItem(m);
                            }
                            if (m == null) continue;
                            ret.getTimePreferences().addSelection(timeSelection);
                        }
                    }
                    return ret;
                }
            }
        }
        PrefGroupEditInterface.SubpartEditResponse ret = new PrefGroupEditInterface.SubpartEditResponse();
        ret.setId(request.getId());
        ret.setName(subpart.getSchedulingSubpartLabel());
        ret.setNbrRooms(subpart.getMaxRooms());
        ret.setAutoSpreadInTime(subpart.getAutoSpreadInTime());
        ret.setStudentsCanOverlap(subpart.getStudentAllowOverlap());
        SchedulingSubpart next = subpart.getNextSchedulingSubpart(context, Right.SchedulingSubpartEdit);
        ret.setNextId(next == null ? null : next.getUniqueId());
        SchedulingSubpart previous = subpart.getPreviousSchedulingSubpart(context, Right.SchedulingSubpartEdit);
        ret.setPreviousId(previous == null ? null : previous.getUniqueId());
        ret.setCanClearPrefs(context.hasPermission(subpart, Right.SchedulingSubpartEditClearPreferences));
        ret.addProperty(MSG.filterManager()).add(subpart.getManagingDept().getManagingDeptLabel());
        if (subpart.getParentSubpart() != null) {
            ret.addProperty(MSG.propertyParentSchedulingSubpart()).setText(subpart.getParentSubpart().getSchedulingSubpartLabel());
        }
        DatePattern dp = subpart.getDatePattern();
        DatePattern edp = subpart.getSession().getDefaultDatePattern();
        ret.setSearchableDatePattern(ApplicationProperty.ClassEditSearcheableDatePattern.isTrue());
        if (dp != null) {
            ret.setDatePatternId(dp.getUniqueId());
        } else if (edp != null) {
            ret.setDatePatternId(-edp.getUniqueId().longValue());
        }
        if (edp != null) {
            ret.addDatePattern(-edp.getUniqueId().longValue(), MSG.dropDefaultDatePattern() + " (" + edp.getName() + ")", edp.getDatePatternType() == DatePattern.DatePatternType.PatternSet ? null : edp.getPatternText());
        }
        for (DatePattern datePattern : DatePattern.findAll(subpart.getSessionId(), context.getUser().getCurrentAuthority().hasRight(Right.ExtendedDatePatterns), subpart.getManagingDept(), dp)) {
            ret.addDatePattern(datePattern.getUniqueId(), datePattern.getName(), datePattern.getDatePatternType() == DatePattern.DatePatternType.PatternSet ? null : datePattern.getPatternText());
        }
        ClassEditBackend.fillInPreferences(ret, subpart, context);
        SchedulingSubpart schedulingSubpart = subpart.getParentSubpart();
        if (schedulingSubpart == null || !subpart.getItype().equals(schedulingSubpart.getItype())) {
            if (ApplicationProperty.SubpartCreditEditable.isTrue()) {
                for (CourseCreditType creditType : CourseCreditType.getCourseCreditTypeList()) {
                    ret.addCreditType(creditType.getUniqueId(), creditType.getLabel(), creditType.getReference());
                }
                for (CourseCreditUnitType creditUnitType : CourseCreditUnitType.getCourseCreditUnitTypeList()) {
                    ret.addCreditUnitType(creditUnitType.getUniqueId(), creditUnitType.getLabel(), creditUnitType.getReference());
                }
                for (CourseCreditFormat creditFormat : CourseCreditFormat.getCourseCreditFormatList()) {
                    ret.addCreditFormat(creditFormat.getUniqueId(), creditFormat.getLabel(), creditFormat.getReference());
                }
                CourseCreditUnitConfig courseCreditUnitConfig = subpart.getCredit();
                if (courseCreditUnitConfig != null) {
                    ret.setCreditFormatId(courseCreditUnitConfig.getCourseCreditFormat() == null ? null : courseCreditUnitConfig.getCourseCreditFormat().getUniqueId());
                    ret.setCreditTypeId(courseCreditUnitConfig.getCreditType() == null ? null : courseCreditUnitConfig.getCreditType().getUniqueId());
                    ret.setCreditUnitTypeId(courseCreditUnitConfig.getCreditUnitType() == null ? null : courseCreditUnitConfig.getCreditUnitType().getUniqueId());
                    if (courseCreditUnitConfig instanceof FixedCreditUnitConfig) {
                        ret.setCreditUnits(((FixedCreditUnitConfig)courseCreditUnitConfig).getFixedUnits());
                    } else if (courseCreditUnitConfig instanceof VariableFixedCreditUnitConfig) {
                        ret.setCreditUnits(((VariableFixedCreditUnitConfig)courseCreditUnitConfig).getMinUnits());
                        ret.setCreditMaxUnits(((VariableFixedCreditUnitConfig)courseCreditUnitConfig).getMaxUnits());
                        if (courseCreditUnitConfig instanceof VariableRangeCreditUnitConfig) {
                            ret.setCreditFractionsAllowed(((VariableRangeCreditUnitConfig)courseCreditUnitConfig).isFractionalIncrementsAllowed());
                        }
                    }
                }
            } else {
                CourseCreditUnitConfig courseCreditUnitConfig = subpart.getCredit();
                if (courseCreditUnitConfig != null) {
                    ret.addProperty(MSG.propertySubpartCredit()).add(courseCreditUnitConfig.creditText());
                }
            }
        }
        BackTracker.markForBack(context, "subpart?id=" + subpart.getUniqueId(), MSG.backSubpart(subpart.getSchedulingSubpartLabel()), true, false);
        return ret;
    }
}

