/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingDeleteAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingNotOfferedAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingOfferedAction;
import org.unitime.timetable.interfaces.ExternalLinkLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.OfferingCoordinatorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.server.courses.ExaminationsTableBuilder;
import org.unitime.timetable.server.courses.InstructionalOfferingTableBuilder;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;

@GwtRpcImplements(value=OfferingsInterface.OfferingDetailRequest.class)
public class OfferingDetailBackend
implements GwtRpcImplementation<OfferingsInterface.OfferingDetailRequest, OfferingsInterface.OfferingDetailResponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    /*
     * WARNING - void declaration
     */
    @Override
    public OfferingsInterface.OfferingDetailResponse execute(OfferingsInterface.OfferingDetailRequest request, SessionContext context) {
        try {
            BackTracker.BackItem back;
            InstructionalOffering instructionalOffering;
            List<StudentAccomodation.AccommodationCounter> acc;
            String linkLookupClass;
            TableInterface.CellInterface c;
            context.checkPermission(request.getOfferingId(), "InstructionalOffering", Right.InstructionalOfferingDetail);
            InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(request.getOfferingId());
            OfferingsInterface.OfferingDetailResponse response = new OfferingsInterface.OfferingDetailResponse();
            response.setOfferingId(io.getUniqueId());
            if (request.getAction() == null) {
                BackTracker.markForBack(context, "offering?io=" + request.getOfferingId(), MSG.backInstructionalOffering(io.getCourseName()), true, false);
                OfferingDetailBackend.setLastInstructionalOffering(context, io);
            } else {
                switch (request.getAction()) {
                    case Lock: {
                        context.checkPermission(io, Right.OfferingCanLock);
                        io.getSession().lockOffering(io.getUniqueId());
                        break;
                    }
                    case Unlock: {
                        context.checkPermission(io, Right.OfferingCanUnlock);
                        io.getSession().unlockOffering(io, context.getUser());
                        break;
                    }
                    case MakeOffered: {
                        context.checkPermission(io, Right.OfferingMakeOffered);
                        this.makeOffered(io, context);
                        response.setUrl("instrOfferingConfig?offering=" + io.getUniqueId() + "&op=" + URLEncoder.encode(MSG.actionMakeOffered(), "utf-8"));
                        return response;
                    }
                    case MakeNotOffered: {
                        context.checkPermission(io, Right.OfferingMakeNotOffered);
                        this.makeNotOffered(io, context);
                        if (!ApplicationProperty.MakeNotOfferedStaysOnDetail.isFalse()) break;
                        response.setUrl("offerings#A" + io.getUniqueId());
                        return response;
                    }
                    case Delete: {
                        context.checkPermission(io, Right.OfferingDelete);
                        this.deleteOffering(io, context);
                        context.removeAttribute(SessionAttribute.OfferingsCourseNumber);
                        response.setUrl("offerings");
                        return response;
                    }
                }
            }
            CourseOffering control = io.getControllingCourseOffering();
            response.setSubjectAreaId(control.getSubjectArea().getUniqueId());
            response.setCourseId(control.getUniqueId());
            response.setCourseNumber(control.getCourseNbr());
            response.setName(io.getCourseNameWithTitle());
            response.setOffered(io.isNotOffered() == false);
            response.setCourses(OfferingDetailBackend.createCoursesTable(context, io, true));
            response.addProperty(MSG.propertyEnrollment()).setText(io.getEnrollment() == null ? "0" : io.getEnrollment().toString());
            response.addProperty(MSG.propertyLastEnrollment()).setText(io.getDemand() == null || io.getDemand() == 0 ? "-" : io.getDemand().toString());
            if (io.getProjectedDemand() != null && io.getProjectedDemand() > 0) {
                response.addProperty(MSG.propertyProjectedDemand()).setText(io.getProjectedDemand().toString());
            }
            boolean unlimited = false;
            int offeringLimit = 0;
            for (InstrOfferingConfig config : io.getInstrOfferingConfigs()) {
                if (config.isUnlimitedEnrollment().booleanValue()) {
                    unlimited = true;
                    continue;
                }
                offeringLimit += config.getLimit().intValue();
            }
            if (unlimited) {
                response.addProperty(MSG.titleUnlimitedEnrollment()).setHtml("&infin;").addStyle("font-size: +1");
            } else {
                c = response.addProperty(MSG.titleUnlimitedEnrollment());
                c.setText(String.valueOf(offeringLimit));
                if (io.getCourseOfferings().size() > 1) {
                    int lim = 0;
                    boolean reservationSet = false;
                    for (CourseOffering courseOffering : io.getCourseOfferings()) {
                        if (courseOffering.getReservation() == null) continue;
                        lim += courseOffering.getReservation().intValue();
                        reservationSet = true;
                    }
                    if (reservationSet && io.getLimit() != null && lim < io.getLimit()) {
                        c.addImage().setSource("images/cancel.png").setAlt(MSG.altLimitsDoNotMatch()).setTitle(MSG.titleLimitsDoNotMatch());
                        c.add(MSG.errorReservedSpacesForOfferingsTotal(String.valueOf(lim))).setColor("#FF0000");
                    }
                }
                TreeSet<InstrOfferingConfig> configsWithTooHighLimit = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(null));
                for (InstrOfferingConfig instrOfferingConfig : io.getInstrOfferingConfigs()) {
                    void var12_40;
                    if (instrOfferingConfig.isUnlimitedEnrollment().booleanValue()) continue;
                    Object var12_39 = null;
                    for (SchedulingSubpart subpart : instrOfferingConfig.getSchedulingSubparts()) {
                        int limit = 0;
                        for (Class_ clazz : subpart.getClasses()) {
                            limit += (clazz.getMaxExpectedCapacity() == null ? clazz.getExpectedCapacity() : clazz.getMaxExpectedCapacity()).intValue();
                        }
                        if (var12_40 != null && var12_40.intValue() <= limit) continue;
                        Integer n = limit;
                    }
                    if (var12_40 == null || var12_40.intValue() >= instrOfferingConfig.getLimit()) continue;
                    configsWithTooHighLimit.add(instrOfferingConfig);
                }
                if (!configsWithTooHighLimit.isEmpty()) {
                    if (configsWithTooHighLimit.size() == 1) {
                        c.addImage().setSource("images/cancel.png").setAlt(MSG.altLimitsDoNotMatch()).setTitle(MSG.titleLimitsDoNotMatch());
                        c.add(MSG.errorConfigWithTooHighLimit(((InstrOfferingConfig)configsWithTooHighLimit.first()).getName())).setColor("#FF0000");
                    } else {
                        Object names = "";
                        for (InstrOfferingConfig instrOfferingConfig : configsWithTooHighLimit) {
                            if (!((String)names).isEmpty()) {
                                names = (String)names + ", ";
                            }
                            names = (String)names + instrOfferingConfig.getName();
                        }
                        c.addImage().setSource("images/cancel.png").setAlt(MSG.altLimitsDoNotMatch()).setTitle(MSG.titleLimitsDoNotMatch());
                        c.add(MSG.errorConfigsWithTooHighLimit((String)names)).setColor("#FF0000");
                    }
                }
                if (c.hasItems()) {
                    c.getItems().get(0).addStyle("padding-left: 20px;");
                    if (c.getItems().size() > 2) {
                        c.getItems().get(2).addStyle("padding-left: 20px;");
                    }
                }
            }
            if (!unlimited && io.getSnapshotLimit() != null) {
                response.addProperty(MSG.propertySnapshotLimit()).setText(io.getSnapshotLimit().toString());
            }
            if (Boolean.TRUE.equals(io.isByReservationOnly())) {
                c = response.addProperty(MSG.propertyByReservationOnly());
                c.addImage().setSource("images/accept.png").setTitle(MSG.descriptionByReservationOnly2()).setAlt(MSG.enabled());
                c.add(MSG.descriptionByReservationOnly2()).addStyle("font-style: italic;");
            }
            if (!io.getOfferingCoordinators().isEmpty()) {
                c = response.addProperty(MSG.propertyCoordinators());
                c.setInline(false);
                String instructorNameFormat = context.getUser().getProperty(UserProperty.NameFormat);
                ArrayList<OfferingCoordinator> coordinatorList = new ArrayList<OfferingCoordinator>(io.getOfferingCoordinators());
                Collections.sort(coordinatorList, new OfferingCoordinatorComparator(context));
                for (OfferingCoordinator offeringCoordinator : coordinatorList) {
                    c.add(offeringCoordinator.getInstructor().getName(instructorNameFormat) + (String)(offeringCoordinator.getResponsibility() == null ? (offeringCoordinator.getPercentShare() != 0 ? " (" + offeringCoordinator.getPercentShare() + "%)" : "") : " (" + offeringCoordinator.getResponsibility().getLabel() + (String)(offeringCoordinator.getPercentShare() > 0 ? ", " + offeringCoordinator.getPercentShare() + "%" : "") + ")")).setUrl("instructorDetail.action?instructorId=" + offeringCoordinator.getInstructor().getUniqueId()).setClassName("noFancyLinks");
                }
            }
            if (io.getLastWeekToEnroll() != null) {
                response.addProperty(MSG.propertyLastWeekEnrollment()).setText(MSG.textLastWeekEnrollment(io.getLastWeekToEnroll().toString()));
            }
            if (io.getLastWeekToChange() != null) {
                response.addProperty(MSG.propertyLastWeekChange()).setText(MSG.textLastWeekChange(io.getLastWeekToChange().toString()));
            }
            if (io.getLastWeekToDrop() != null) {
                response.addProperty(MSG.propertyLastWeekDrop()).setText(MSG.textLastWeekDrop(io.getLastWeekToDrop().toString()));
            }
            if (io.getLastWeekToEnroll() != null || io.getLastWeekToChange() != null || io.getLastWeekToDrop() != null) {
                response.addProperty("").setText(MSG.descriptionEnrollmentDeadlines(Localization.getDateFormat("EEEE").format(io.getSession().getSessionBeginDateTime())));
            }
            if (io.getEffectiveWaitListMode() != null) {
                OverrideType prohibitedOverride;
                c = response.addProperty(MSG.propertyWaitListing());
                switch (io.getEffectiveWaitListMode()) {
                    case WaitList: {
                        c.addImage().setSource("images/accept.png").setTitle(MSG.descWaitListEnabled()).setAlt(MSG.waitListEnabled());
                        c.add(MSG.descWaitListEnabled());
                        break;
                    }
                    case ReSchedule: {
                        c.addImage().setSource("images/accept_gold.png").setTitle(MSG.descWaitListReschedule()).setAlt(MSG.waitListReschedule());
                        c.add(MSG.descWaitListReschedule());
                        break;
                    }
                    case Disabled: {
                        c.addImage().setSource("images/cancel.png").setTitle(MSG.descWaitListDisabled()).setAlt(MSG.waitListDisabled());
                        c.add(MSG.descWaitListDisabled());
                    }
                }
                if (io.effectiveWaitList() && (prohibitedOverride = OverrideType.findByReference(ApplicationProperty.OfferingWaitListProhibitedOverride.value())) != null) {
                    String message = null;
                    for (CourseOffering courseOffering : io.getCourseOfferings()) {
                        if (courseOffering.getDisabledOverrides() != null && courseOffering.getDisabledOverrides().contains(prohibitedOverride)) continue;
                        message = (String)(message == null ? "" : message + "\n") + MSG.problemWaitListProhibitedOverride(courseOffering.getCourseName(), prohibitedOverride.getLabel());
                    }
                    if (message != null) {
                        TableInterface.CellInterface cellInterface = c.add(null).setInline(false);
                        cellInterface.addImage().setSource("images/cancel.png").setTitle(message);
                        cellInterface.add(message).setColor("#FF0000").addStyle("white-space: pre;");
                    }
                }
            }
            if ((linkLookupClass = ApplicationProperty.CourseCatalogLinkProvider.value()) != null && !linkLookupClass.isEmpty()) {
                try {
                    ExternalLinkLookup lookup = (ExternalLinkLookup)Class.forName(linkLookupClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Map results = lookup.getLink(io);
                    if (results != null) {
                        response.addProperty(MSG.propertyCourseCatalog()).setText((String)results.get("label")).setUrl((String)results.get("href"));
                    }
                }
                catch (Exception e) {
                    Debug.error("Failed to get catalog link: " + e.getMessage(), e);
                }
            }
            if ((acc = StudentAccomodation.getAccommodations(io)) != null && !acc.isEmpty()) {
                TableInterface.CellInterface c2 = response.addProperty(MSG.propertyAccommodations());
                TableInterface tableInterface = new TableInterface();
                for (StudentAccomodation.AccommodationCounter accommodationCounter : acc) {
                    tableInterface.addProperty(accommodationCounter.getAccommodation().getName() + ":").setText(String.valueOf(accommodationCounter.getCount()));
                }
                c2.setTable(tableInterface);
            }
            ClassAssignmentProxy proxy = this.classAssignmentService.getAssignment();
            try {
                if (proxy != null && proxy.hasConflicts(io.getUniqueId())) {
                    TableInterface.CellInterface cellInterface = response.addProperty("");
                    cellInterface.addImage().setSource("images/warning.png").setTitle(MSG.warnOfferingHasConflictingClasses());
                    cellInterface.add(MSG.warnOfferingHasConflictingClasses()).setColor("#FF0000").addStyle("padding-left: 2px;");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ApplicationProperty.OfferingShowClassNotes.isTrue()) {
                TableInterface tableInterface = new TableInterface();
                ArrayList<InstrOfferingConfig> arrayList = new ArrayList<InstrOfferingConfig>(io.getInstrOfferingConfigs());
                Collections.sort(arrayList, new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
                for (InstrOfferingConfig config : arrayList) {
                    ArrayList<SchedulingSubpart> subparts = new ArrayList<SchedulingSubpart>(config.getSchedulingSubparts());
                    Collections.sort(subparts, new SchedulingSubpartComparator());
                    for (SchedulingSubpart subpart : subparts) {
                        ArrayList<Class_> classes = new ArrayList<Class_>(subpart.getClasses());
                        Collections.sort(classes, new ClassComparator(3));
                        for (Class_ clazz : classes) {
                            if (clazz.getNotes() == null || clazz.getNotes().isEmpty()) continue;
                            tableInterface.addProperty(subpart.getItypeDesc().trim() + " " + clazz.getSectionNumberString()).setText(clazz.getNotes()).addStyle("white-space: pre-wrap;");
                        }
                    }
                }
                if (tableInterface.hasProperties()) {
                    if (io.getNotes() != null && !io.getNotes().isEmpty()) {
                        tableInterface.addProperty(io.getCourseName()).setText(io.getNotes()).addStyle("white-space: pre-wrap;");
                    }
                    response.addProperty(MSG.propertyRequestsNotes()).setTable(tableInterface);
                } else if (io.getNotes() != null && !io.getNotes().isEmpty()) {
                    response.addProperty(MSG.propertyRequestsNotes()).setText(io.getNotes()).addStyle("white-space: pre-wrap;");
                }
            } else if (io.getNotes() != null && !io.getNotes().isEmpty()) {
                response.addProperty(MSG.propertyRequestsNotes()).setText(io.getNotes()).addStyle("white-space: pre-wrap;");
            }
            if (context.hasPermission(Right.InstructorScheduling)) {
                for (DepartmentalInstructor departmentalInstructor : io.getDepartment().getInstructors()) {
                    if (departmentalInstructor.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(departmentalInstructor.getTeachingPreference().getPrefProlog())) continue;
                    response.addOperation("teachingRequests");
                    break;
                }
            }
            response.setNextId((instructionalOffering = io.getNextInstructionalOffering(context)) == null ? null : instructionalOffering.getUniqueId());
            InstructionalOffering instructionalOffering2 = io.getPreviousInstructionalOffering(context);
            response.setPreviousId(instructionalOffering2 == null ? null : instructionalOffering2.getUniqueId());
            InstructionalOfferingTableBuilder instructionalOfferingTableBuilder = new InstructionalOfferingTableBuilder(context, request.getBackType(), request.getBackId());
            instructionalOfferingTableBuilder.generateConfigTablesForInstructionalOffering(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), io, response);
            ExaminationsTableBuilder examBuilder = new ExaminationsTableBuilder(context, request.getBackType(), request.getBackId());
            if (request.getExamId() != null && !request.getExamId().isEmpty()) {
                examBuilder.setBackId(request.getBackId());
                examBuilder.setBackType("Exam");
            }
            response.setExaminations(examBuilder.createExamsTable("InstructionalOffering", io.getUniqueId(), this.examinationSolverService.getSolver()));
            DistributionsTableBuilder distBuilder = new DistributionsTableBuilder(context, request.getBackType(), request.getBackId());
            response.setDistributions(distBuilder.getDistPrefsTableForInstructionalOffering(io));
            if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DisplayLastChanges))) {
                response.setLastChanges(OfferingDetailBackend.getLastChanges(io));
            }
            if (InstructorCourseRequirement.hasRequirementsForOffering(io)) {
                response.addOperation("instructor-survey");
            }
            if (context.hasPermission(Right.CurriculumView)) {
                response.addOperation("curricula");
            }
            if (context.hasPermission(Right.Reservations)) {
                response.addOperation("reservations");
                if (context.hasPermission(io, Right.ReservationOffering) && context.hasPermission(Right.ReservationAdd)) {
                    response.addOperation("reservations-editable");
                }
            }
            if (!io.isNotOffered().booleanValue() && context.hasPermission(Right.InstructorScheduling) && context.hasPermission(Right.InstructorAssignmentPreferences)) {
                for (DepartmentalInstructor di : io.getDepartment().getInstructors()) {
                    if (di.getTeachingPreference() == null || PreferenceLevel.sProhibited.equals(di.getTeachingPreference().getPrefProlog())) continue;
                    response.addOperation("teaching-requests");
                    break;
                }
            }
            if (context.hasPermission(Right.ExaminationAdd)) {
                response.addOperation("add-exam");
            }
            if ((back = BackTracker.getBackItem(context, 2)) != null) {
                response.addOperation("back");
                response.setBackTitle(back.getTitle());
                response.setBackUrl(back.getUrl());
            }
            if (response.getPreviousId() != null && context.hasPermission(response.getPreviousId(), "InstructionalOffering", Right.InstructionalOfferingDetail)) {
                response.addOperation("previous");
            }
            if (response.getNextId() != null && context.hasPermission(response.getNextId(), "InstructionalOffering", Right.InstructionalOfferingDetail)) {
                response.addOperation("next");
            }
            if (context.hasPermission(io, Right.OfferingCanLock)) {
                response.addOperation("lock");
            }
            if (context.hasPermission(io, Right.OfferingCanUnlock)) {
                response.addOperation("unlock");
            }
            if (context.hasPermission(io, Right.InstrOfferingConfigAdd)) {
                response.addOperation("add-config");
            }
            if (context.hasPermission(io, Right.InstructionalOfferingCrossLists)) {
                response.addOperation("cross-list");
            }
            if (context.hasPermission(io, Right.OfferingMakeOffered)) {
                response.addOperation("make-offered");
            }
            if (context.hasPermission(io, Right.OfferingDelete)) {
                response.addOperation("delete");
            }
            if (context.hasPermission(io, Right.OfferingMakeNotOffered)) {
                response.addOperation("make-not-offered");
            }
            response.setConfirms(JavascriptFunctions.isJsConfirm(context));
            return response;
        }
        catch (GwtRpcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    public static TableInterface createCoursesTable(SessionContext context, InstructionalOffering io, boolean showButtons) {
        ArrayList<CourseOffering> offerings = new ArrayList<CourseOffering>(io.getCourseOfferings());
        Collections.sort(offerings, new CourseOfferingComparator(2));
        boolean hasCourseTypes = false;
        boolean hasExtId = false;
        boolean hasRes = false;
        boolean hasCred = false;
        boolean hasNote = false;
        boolean hasDemandsFrom = false;
        boolean hasAlt = false;
        boolean hasDisOvrd = false;
        boolean hasEnrollment = false;
        boolean hasDemand = false;
        boolean hasProjDemand = false;
        for (CourseOffering co : offerings) {
            if (co.getCourseType() != null) {
                hasCourseTypes = true;
            }
            if (ApplicationProperty.CourseOfferingShowExternalIds.isTrue() && co.getExternalUniqueId() != null && !co.getExternalUniqueId().isEmpty()) {
                hasExtId = true;
            }
            if (co.getReservation() != null) {
                hasRes = true;
            }
            if (co.getCredit() != null) {
                hasCred = true;
            }
            if (co.getScheduleBookNote() != null && !co.getScheduleBookNote().isEmpty()) {
                hasNote = true;
            }
            if (co.getDemandOffering() != null) {
                hasDemandsFrom = true;
            }
            if (co.getAlternativeOffering() != null) {
                hasAlt = true;
            }
            if (!co.getDisabledOverrides().isEmpty()) {
                hasDisOvrd = true;
            }
            if (io.getCourseOfferings().size() <= 1) continue;
            if (co.getEnrollment() != null && co.getEnrollment() > 0) {
                hasEnrollment = true;
            }
            if (co.getDemand() != null && co.getDemand() > 0) {
                hasDemand = true;
            }
            if (co.getProjectedDemand() == null || co.getProjectedDemand() <= 0) continue;
            hasProjDemand = true;
        }
        boolean hasUrl = ApplicationProperty.CustomizationCourseLink.value() != null && !ApplicationProperty.CustomizationCourseLink.value().isEmpty();
        TableInterface table = new TableInterface();
        table.setName(io.getCourseNameWithTitle());
        TableInterface.LineInterface header = table.addHeader();
        header.addCell();
        if (hasCourseTypes) {
            header.addCell(MSG.columnCourseType());
        }
        header.addCell(MSG.columnTitle());
        if (hasExtId) {
            header.addCell(MSG.columnExternalId());
        }
        if (hasRes) {
            header.addCell(MSG.columnReserved()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        }
        if (hasEnrollment) {
            header.addCell(MSG.columnEnrollment()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        }
        if (hasDemand) {
            header.addCell(MSG.columnCrossListsLastTerm()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        }
        if (hasProjDemand) {
            header.addCell(MSG.columnCrossListsProjected()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        }
        if (hasCred) {
            header.addCell(MSG.columnCredit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        }
        if (hasNote) {
            header.addCell(MSG.columnScheduleOfClassesNote());
        }
        if (hasDemandsFrom) {
            header.addCell(MSG.columnDemandsFrom());
        }
        if (hasAlt) {
            header.addCell(MSG.columnAlternativeCourse());
        }
        header.addCell(MSG.columnConsent());
        if (hasDisOvrd) {
            header.addCell(MSG.columnDisabledOverrides());
        }
        if (hasUrl) {
            header.addCell(MSG.columnCourseCatalog());
        }
        if (showButtons) {
            header.addCell();
        }
        for (TableInterface.CellInterface h : header.getCells()) {
            h.setClassName("WebTableHeader");
        }
        for (CourseOffering co : offerings) {
            TableInterface.LineInterface line = table.addLine();
            line.setClassName("BottomBorderGray");
            if (co.isIsControl().booleanValue()) {
                line.addCell().setImage().setSource("images/accept.png").setAlt(MSG.altControllingCourse()).setTitle(MSG.titleControllingCourse());
            } else {
                line.addCell();
            }
            if (hasCourseTypes) {
                if (co.getCourseType() != null) {
                    line.addCell(co.getCourseType().getReference()).setTitle(co.getCourseType().getLabel());
                } else {
                    line.addCell();
                }
            }
            line.addCell(co.getCourseNameWithTitle());
            if (hasExtId) {
                line.addCell(co.getExternalUniqueId());
            }
            if (hasRes) {
                line.addCell(co.getReservation() == null ? "" : co.getReservation().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            }
            if (hasEnrollment) {
                line.addCell(co.getEnrollment() == null ? "" : co.getEnrollment().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            }
            if (hasDemand) {
                line.addCell(co.getDemand() == null ? "" : co.getDemand().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            }
            if (hasProjDemand) {
                line.addCell(co.getProjectedDemand() == null ? "" : co.getProjectedDemand().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            }
            if (hasCred) {
                if (co.getCredit() != null) {
                    line.addCell(co.getCredit().creditAbbv()).setTitle(co.getCredit().creditText()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                } else {
                    line.addCell();
                }
            }
            if (hasNote) {
                line.addCell().setHtml(co.getScheduleBookNote()).addStyle("white-space: pre-wrap;");
            }
            if (hasDemandsFrom) {
                line.addCell(co.getDemandOffering() == null ? "" : co.getDemandOffering().getCourseName());
            }
            if (hasAlt) {
                line.addCell(co.getAlternativeOffering() == null ? "" : co.getAlternativeOffering().getCourseName());
            }
            if (co.getConsentType() == null) {
                line.addCell(MSG.noConsentRequired());
            } else {
                line.addCell(co.getConsentType().getAbbv()).setTitle(co.getConsentType().getLabel());
            }
            if (hasDisOvrd) {
                TableInterface.CellInterface c = line.addCell();
                for (OverrideType ot : co.getDisabledOverrides()) {
                    if (c.hasItems()) {
                        c.add(", ");
                    }
                    c.add(ot.getReference()).setTitle(ot.getLabel());
                }
            }
            if (hasUrl) {
                line.addCell().addCourseLink().setCourseId(co.getUniqueId());
            }
            if (!showButtons) continue;
            TableInterface.CellInterface buttons = line.addCell().setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            if (!context.hasPermission(co, Right.EditCourseOffering) && !context.hasPermission(co, Right.EditCourseOfferingCoordinators) && !context.hasPermission(co, Right.EditCourseOfferingNote)) continue;
            buttons.addButton().setUrl("courseOffering?offering=" + co.getUniqueId() + "&op=editCourseOffering").setText(MSG.actionEditCourseOffering()).setTitle(MSG.titleEditCourseOffering());
        }
        return table;
    }

    protected static int printLastChangeTableRow(TableInterface table, ChangeLog lastChange) {
        if (lastChange == null) {
            return 0;
        }
        TableInterface.LineInterface line = table.addLine();
        line.addCell(lastChange.getSourceTitle());
        line.addCell(lastChange.getObjectTitle());
        line.addCell(lastChange.getOperationTitle());
        line.addCell(lastChange.getManager().getShortName());
        line.addCell(ChangeLog.sDF.format(lastChange.getTimeStamp()));
        return 1;
    }

    protected static ChangeLog combine(ChangeLog c1, ChangeLog c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return c1.compareTo(c2) < 0 ? c2 : c1;
    }

    public static TableInterface getLastChanges(InstructionalOffering io) {
        if (io == null) {
            return null;
        }
        TableInterface table = new TableInterface();
        int nrChanges = 0;
        table.setName(MSG.columnLastChanges());
        TableInterface.LineInterface header = table.addHeader();
        header.addCell(MSG.columnPage());
        header.addCell(MSG.columnObject());
        header.addCell(MSG.columnOperation());
        header.addCell(MSG.columnManager());
        header.addCell(MSG.columnDate());
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
        }
        HashSet<Long> configIds = new HashSet<Long>();
        HashSet<Long> subpartIds = new HashSet<Long>();
        HashSet<Long> classIds = new HashSet<Long>();
        HashSet<Long> offeringIds = new HashSet<Long>();
        HashSet<Long> curriculumIds = new HashSet<Long>();
        for (InstrOfferingConfig ioc : io.getInstrOfferingConfigs()) {
            configIds.add(ioc.getUniqueId());
            for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                subpartIds.add(ss.getUniqueId());
                for (Class_ c : ss.getClasses()) {
                    classIds.add(c.getUniqueId());
                }
            }
        }
        for (CourseOffering co : io.getCourseOfferings()) {
            offeringIds.add(co.getUniqueId());
        }
        curriculumIds.addAll(InstructionalOfferingDAO.getInstance().getSession().createQuery("select c.classification.curriculum.uniqueId from CurriculumCourse c where c.course.instructionalOffering.uniqueId = :offeringId", Long.class).setParameter("offeringId", (Object)io.getUniqueId()).setCacheable(true).list());
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(io, ChangeLog.Source.CROSS_LIST));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, OfferingDetailBackend.combine(ChangeLog.findLastChange(io, ChangeLog.Source.MAKE_OFFERED), ChangeLog.findLastChange(io, ChangeLog.Source.MAKE_NOT_OFFERED)));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(CourseOffering.class.getName(), offeringIds, ChangeLog.Source.COURSE_OFFERING_EDIT));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, OfferingDetailBackend.combine(ChangeLog.findLastChange(InstructionalOffering.class.getName(), io.getUniqueId(), ChangeLog.Source.RESERVATION), ChangeLog.findLastChange(Class_.class.getName(), classIds, ChangeLog.Source.RESERVATION)));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, OfferingDetailBackend.combine(ChangeLog.findLastChange(io, ChangeLog.Source.INSTR_CFG_EDIT), ChangeLog.findLastChange(InstrOfferingConfig.class.getName(), configIds, ChangeLog.Source.INSTR_CFG_EDIT)));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(InstrOfferingConfig.class.getName(), configIds, ChangeLog.Source.CLASS_SETUP));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(InstrOfferingConfig.class.getName(), configIds, ChangeLog.Source.CLASS_INSTR_ASSIGN));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(SchedulingSubpart.class.getName(), subpartIds, ChangeLog.Source.SCHEDULING_SUBPART_EDIT));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(Class_.class.getName(), classIds, ChangeLog.Source.CLASS_EDIT));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(io, ChangeLog.Source.DIST_PREF_EDIT));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(CourseOffering.class.getName(), offeringIds, ChangeLog.Source.CURRICULA));
        nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, OfferingDetailBackend.combine(ChangeLog.findLastChange(Curriculum.class.getName(), curriculumIds, ChangeLog.Source.CURRICULA), ChangeLog.findLastChange(Curriculum.class.getName(), curriculumIds, ChangeLog.Source.CURRICULUM_EDIT)));
        if ((nrChanges += OfferingDetailBackend.printLastChangeTableRow(table, ChangeLog.findLastChange(Class_.class.getName(), classIds, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT))) > 0) {
            return table;
        }
        return null;
    }

    public static void setLastInstructionalOffering(SessionContext sessionContext, InstructionalOffering offering) {
        if (offering == null) {
            return;
        }
        String subjectAreaIds = (String)sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
        String subjectAreaId = offering.getControllingCourseOffering().getSubjectArea().getUniqueId().toString();
        if (subjectAreaIds == null) {
            sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
        } else {
            boolean contain = false;
            for (String s : subjectAreaIds.split(",")) {
                if (!s.equals(subjectAreaId)) continue;
                contain = true;
                break;
            }
            if (!contain && sessionContext.hasPermission(offering.getControllingCourseOffering().getDepartment(), Right.InstructionalOfferings)) {
                sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
            }
        }
        if (sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber) != null && !sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber).toString().isEmpty()) {
            sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)offering.getControllingCourseOffering().getCourseNbr());
        }
    }

    protected void makeOffered(InstructionalOffering io, SessionContext context) {
        try {
            Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
            io.setNotOffered(false);
            hibSession.merge((Object)io);
            ChangeLog.addChange(hibSession, context, io, ChangeLog.Source.MAKE_OFFERED, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            if (context.hasPermission(io, Right.OfferingCanLock)) {
                io.getSession().lockOffering(io.getUniqueId());
            }
            hibSession.flush();
            hibSession.clear();
            String className = ApplicationProperty.ExternalActionInstructionalOfferingOffered.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingOfferedAction offeredAction = (ExternalInstructionalOfferingOfferedAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                offeredAction.performExternalInstructionalOfferingOfferedAction(io, hibSession);
            }
        }
        catch (Exception e) {
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected void makeNotOffered(InstructionalOffering io, SessionContext context) {
        try {
            String className;
            Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
            io.deleteAllDistributionPreferences(hibSession);
            io.deleteAllClasses(hibSession);
            for (CourseOffering co : io.getCourseOfferings()) {
                Event.deleteFromEvents(hibSession, co);
                Exam.deleteFromExams(hibSession, co);
            }
            Event.deleteFromEvents(hibSession, io);
            Exam.deleteFromExams(hibSession, io);
            Iterator<Comparable> i = io.getReservations().iterator();
            while (i.hasNext()) {
                Reservation r = (Reservation)i.next();
                hibSession.remove((Object)r);
                i.remove();
            }
            i = io.getTeachingRequests().iterator();
            while (i.hasNext()) {
                TeachingRequest tr = (TeachingRequest)i.next();
                hibSession.remove((Object)tr);
                i.remove();
            }
            io.setNotOffered(true);
            hibSession.merge((Object)io);
            ChangeLog.addChange(hibSession, context, io, ChangeLog.Source.MAKE_NOT_OFFERED, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            hibSession.flush();
            hibSession.clear();
            if (context.hasPermission(io, Right.OfferingCanUnlock)) {
                io.getSession().unlockOffering(io, context.getUser());
            }
            if ((className = ApplicationProperty.ExternalActionInstructionalOfferingNotOffered.value()) != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingNotOfferedAction notOfferedAction = (ExternalInstructionalOfferingNotOfferedAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                notOfferedAction.performExternalInstructionalOfferingNotOfferedAction(io, hibSession);
            }
        }
        catch (Exception e) {
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected void deleteOffering(InstructionalOffering io, SessionContext context) {
        Transaction tx = null;
        try {
            Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
            tx = hibSession.beginTransaction();
            io.deleteAllDistributionPreferences(hibSession);
            Event.deleteFromEvents(hibSession, io);
            Exam.deleteFromExams(hibSession, io);
            String className = ApplicationProperty.ExternalActionInstructionalOfferingDelete.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstructionalOfferingDeleteAction deleteAction = (ExternalInstructionalOfferingDeleteAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                deleteAction.performExternalInstructionalOfferingDeleteAction(io, hibSession);
            }
            ChangeLog.addChange(hibSession, context, io, ChangeLog.Source.OFFERING_DETAIL, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
            for (CourseOffering co : io.getCourseOfferings()) {
                co.getSubjectArea().getCourseOfferings().remove(co);
                hibSession.remove((Object)co);
            }
            hibSession.remove((Object)io);
            tx.commit();
            hibSession.flush();
            hibSession.clear();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }
}

