/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import jakarta.persistence.FlushModeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstrOfferingConfigInterface;
import org.unitime.timetable.interfaces.ExternalInstrOffrConfigChangeAction;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.ClassDurationTypeDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.duration.DurationModel;

@GwtRpcImplements(value=InstrOfferingConfigInterface.class)
public class InstrOfferingConfigBackend
implements GwtRpcImplementation<InstrOfferingConfigInterface, InstrOfferingConfigInterface> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    Permission.PermissionDepartment permissionDepartment;

    @Override
    public InstrOfferingConfigInterface execute(InstrOfferingConfigInterface request, SessionContext context) {
        switch (request.getOperation()) {
            case LOAD: {
                if (request.getConfigId() == null) {
                    context.checkPermission(request.getOfferingId(), "InstructionalOffering", Right.InstrOfferingConfigAdd);
                } else {
                    context.checkPermission(request.getConfigId(), "InstrOfferingConfig", Right.InstrOfferingConfigEdit);
                }
                return this.load(request, context);
            }
            case SAVE: {
                if (request.getConfigId() == null) {
                    context.checkPermission(request.getOfferingId(), "InstructionalOffering", Right.InstrOfferingConfigAdd);
                } else {
                    context.checkPermission(request.getConfigId(), "InstrOfferingConfig", Right.InstrOfferingConfigEdit);
                }
                return this.save(request, context);
            }
            case DELETE: {
                context.checkPermission(request.getConfigId(), "InstrOfferingConfig", Right.InstrOfferingConfigDelete);
                return this.delete(request, context);
            }
        }
        throw new GwtRpcException("Operation " + String.valueOf(request.getOperation()) + " not supported.");
    }

    protected InstrOfferingConfigInterface load(InstrOfferingConfigInterface request, SessionContext context) {
        List<ClassDurationType> cdts;
        InstructionalOffering io;
        InstrOfferingConfig ioc = request.getConfigId() == null ? null : (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(request.getConfigId());
        InstructionalOffering instructionalOffering = io = ioc != null ? ioc.getInstructionalOffering() : (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(request.getOfferingId());
        if ((MSG.actionMakeOffered().equals(request.getOp()) || "make-offered".equals(request.getOp())) && !io.getInstrOfferingConfigs().isEmpty()) {
            ioc = io.getInstrOfferingConfigs().iterator().next();
        }
        InstrOfferingConfigInterface form = new InstrOfferingConfigInterface();
        form.setDisplayOptionForMaxLimit(CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.VariableClassLimits)));
        form.setDisplayMaxLimit(false);
        form.setConfigId(ioc == null ? null : ioc.getUniqueId());
        form.setLimit(ioc == null ? 0 : ioc.getLimit());
        form.setUnlimited(ioc == null ? false : ioc.isUnlimitedEnrollment());
        form.setOfferingId(io.getUniqueId());
        form.setInstructionalMethodId(ioc == null || ioc.getInstructionalMethod() == null ? -1L : ioc.getInstructionalMethod().getUniqueId());
        form.setInstructionalMethodEditable(ioc == null ? true : ApplicationProperty.WaitListCanChangeInstructionalMethod.isTrue() || !ioc.getInstructionalOffering().effectiveReScheduleNow() || ioc.getEnrollment() == 0);
        form.setDurationTypeId(ioc == null || ioc.getClassDurationType() == null ? -1L : ioc.getClassDurationType().getUniqueId());
        form.setCanDelete(ioc != null && context.hasPermission(ioc, Right.InstrOfferingConfigDelete));
        form.setCourseId(io.getControllingCourseOffering().getUniqueId());
        form.setCourseName(io.getCourseNameWithTitle());
        form.setConfigName(ioc == null ? InstrOfferingConfig.getGeneratedName(io) : ioc.getName());
        form.setDisplayCourseLink(ApplicationProperty.CustomizationCourseLink.value() != null && !ApplicationProperty.CustomizationCourseLink.value().isEmpty());
        form.setCheckLimits(ApplicationProperty.ConfigEditCheckLimits.isTrue());
        form.setMaxNumberOfClasses(ApplicationProperty.SubpartMaxNumClasses.intValue());
        Department contrDept = io.getControllingCourseOffering().getSubjectArea().getDepartment();
        form.addDepartment(-1L, "-", MSG.subpartMultipleManagers(), false);
        form.addDepartment(contrDept.getUniqueId(), contrDept.getDeptCode(), MSG.dropDeptDepartment());
        for (Department d : Department.findAllExternal(io.getSessionId())) {
            form.addDepartment(d.getUniqueId(), d.getDeptCode(), d.getExternalMgrLabel(), context.hasPermission(d, Right.InstrOfferingConfigEditDepartment) && this.permissionDepartment.check(context.getUser(), contrDept, DepartmentStatusType.Status.OwnerEdit, d, DepartmentStatusType.Status.ManagerEdit));
        }
        List<InstructionalMethod> ims = InstructionalMethod.findAll();
        if (!ims.isEmpty()) {
            InstructionalMethod defaultType = io.getSession().getDefaultInstructionalMethod();
            if (defaultType == null) {
                form.addInstructionalMethod(-1L, "", MSG.selectNoInstructionalMethod());
            } else {
                form.addInstructionalMethod(-1L, defaultType.getReference(), MSG.defaultInstructionalMethod(defaultType.getLabel()));
            }
            for (InstructionalMethod instructionalMethod : ims) {
                if (!instructionalMethod.isVisible().booleanValue() && (ioc == null || !instructionalMethod.equals(ioc.getInstructionalMethod()))) continue;
                form.addInstructionalMethod(instructionalMethod.getUniqueId(), instructionalMethod.getReference(), instructionalMethod.getLabel());
            }
        }
        if (!(cdts = ClassDurationType.findAll()).isEmpty()) {
            ClassDurationType defaultType = io.getSession().getDefaultClassDurationType();
            if (defaultType == null) {
                form.addDurationType(-1L, "", MSG.systemDefaultDurationType());
            } else {
                form.addDurationType(-1L, defaultType.getReference(), MSG.sessionDefault(defaultType.getLabel()));
            }
            for (ClassDurationType type : cdts) {
                if (!type.isVisible().booleanValue() && (ioc == null || !type.equals(ioc.getClassDurationType()))) continue;
                form.addDurationType(type.getUniqueId(), type.getReference(), type.getLabel());
            }
        }
        for (InstrOfferingConfig instrOfferingConfig : io.getInstrOfferingConfigs()) {
            form.addConfig(instrOfferingConfig.getUniqueId(), instrOfferingConfig.getName());
        }
        for (ItypeDesc itypeDesc : InstrOfferingConfigDAO.getInstance().getSession().createQuery("from ItypeDesc order by itype", ItypeDesc.class).setCacheable(true).list()) {
            form.addInstructionalType(itypeDesc.getItype().longValue(), itypeDesc.getAbbv(), itypeDesc.getDesc().trim(), itypeDesc.getBasic());
        }
        if (form.getDurationTypes().size() <= 1) {
            ClassDurationType dtype;
            ClassDurationType classDurationType = dtype = ioc == null ? io.getSession().getDefaultClassDurationType() : ioc.getEffectiveDurationType();
            if (dtype != null && dtype.isVisible().booleanValue()) {
                form.setDurationTypeEditable(false);
            } else {
                form.setDurationTypeEditable(true);
            }
        } else {
            form.setDurationTypeEditable(true);
        }
        if (ioc != null) {
            ArrayList<SchedulingSubpart> subparts = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
            Collections.sort(subparts, new SchedulingSubpartComparator());
            for (SchedulingSubpart subpart : subparts) {
                if (subpart.getParentSubpart() != null) continue;
                this.addSubpartLines(form, subpart, context, 0);
            }
        }
        return form;
    }

    protected void addSubpartLines(InstrOfferingConfigInterface form, SchedulingSubpart subpart, SessionContext context, int indent) {
        InstrOfferingConfigInterface.SubpartLine parent;
        InstrOfferingConfigInterface.SubpartLine line = this.toLine(subpart, context);
        line.setIndent(indent);
        form.addSubpartLine(line);
        if (!ToolBox.equals((Object)line.getMinClassLimit(), (Object)line.getMaxClassLimit())) {
            form.setDisplayOptionForMaxLimit(true);
            form.setDisplayMaxLimit(true);
        }
        if (!line.isEditable()) {
            line.setLocked(true);
            parent = form.getSubpartLine(line.getParentId());
            while (parent != null) {
                parent.setEditable(false);
                parent = form.getSubpartLine(parent.getParentId());
            }
        }
        if (!line.isCanDelete()) {
            parent = form.getSubpartLine(line.getParentId());
            while (parent != null) {
                parent.setCanDelete(false);
                parent = form.getSubpartLine(parent.getParentId());
            }
        }
        ArrayList<SchedulingSubpart> children = new ArrayList<SchedulingSubpart>(subpart.getChildSubparts());
        Collections.sort(children, new SchedulingSubpartComparator());
        for (SchedulingSubpart child : children) {
            this.addSubpartLines(form, child, context, indent + 1);
        }
    }

    protected InstrOfferingConfigInterface.SubpartLine toLine(SchedulingSubpart subpart, SessionContext context) {
        InstrOfferingConfigInterface.SubpartLine line;
        block6: {
            block5: {
                line = new InstrOfferingConfigInterface.SubpartLine();
                line.setSubpartId(subpart.getUniqueId());
                line.setIType(subpart.getItype().getItype());
                line.setLabel(subpart.getItype().getDesc().trim());
                if (subpart.getClasses() != null && !subpart.getClasses().isEmpty()) {
                    line.setMinClassLimit(subpart.getMinClassLimit());
                    line.setMaxClassLimit(subpart.getMaxClassLimit());
                    if (line.getMinClassLimit() < 0) {
                        line.setMinClassLimit(subpart.getInstrOfferingConfig().getLimit());
                    }
                    if (line.getMaxClassLimit() < 0) {
                        line.setMaxClassLimit(subpart.getInstrOfferingConfig().getLimit());
                    }
                    line.setNumberOfClasses(subpart.getClasses() == null ? 0 : subpart.getClasses().size());
                    line.setNumberOfRooms(subpart.getMaxRooms());
                    line.setRoomRatio(Float.valueOf(subpart.getMaxRoomRatio()));
                    line.setSplitAttendance(subpart.isRoomSplitAttendance());
                } else {
                    line.setNumberOfRooms(1);
                    line.setRoomRatio(Float.valueOf(1.0f));
                    line.setSplitAttendance(false);
                }
                line.setMinutesPerWeek(subpart.getMinutesPerWk());
                boolean mixedManaged = subpart.hasMixedManagedClasses();
                line.setDepartmentId(mixedManaged ? null : subpart.getManagingDept().getUniqueId());
                line.setParentId(subpart.getParentSubpart() == null ? null : subpart.getParentSubpart().getUniqueId());
                if (context.hasPermission(subpart, Right.InstrOfferingConfigEditSubpart) && !mixedManaged) break block5;
                line.setEditable(false);
                line.setCanDelete(false);
                if (!mixedManaged) break block6;
                line.setDepartmentId(-1L);
                break block6;
            }
            for (Class_ c : subpart.getClasses()) {
                if (context.hasPermission(c, Right.ClassDelete)) continue;
                line.setCanDelete(false);
                break;
            }
        }
        return line;
    }

    protected InstrOfferingConfigInterface save(InstrOfferingConfigInterface form, SessionContext context) {
        Session hibSession = InstrOfferingConfigDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            hibSession.setFlushMode(FlushModeType.COMMIT);
            tx = hibSession.beginTransaction();
            InstructionalOffering io = null;
            InstrOfferingConfig ioc = null;
            if (form.getConfigId() != null) {
                ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(form.getConfigId(), hibSession);
                io = ioc.getInstructionalOffering();
            } else {
                io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(form.getOfferingId(), hibSession);
                ioc = new InstrOfferingConfig();
                ioc.setInstructionalOffering(io);
                io.addToInstrOfferingConfigs(ioc);
                ioc.setSchedulingSubparts(new HashSet<SchedulingSubpart>());
            }
            ioc.setName(form.getConfigName());
            ioc.setLimit(form.isUnlimited() != false ? 0 : form.getLimit());
            ioc.setUnlimitedEnrollment(form.isUnlimited());
            if (form.isDurationTypeEditable()) {
                ioc.setClassDurationType(form.getDurationTypeId() == null || form.getDurationTypeId() < 0L ? null : (ClassDurationType)ClassDurationTypeDAO.getInstance().get(form.getDurationTypeId(), hibSession));
            }
            if (form.isInstructionalMethodEditable()) {
                ioc.setInstructionalMethod(form.getInstructionalMethodId() == null || form.getInstructionalMethodId() < 0L ? null : (InstructionalMethod)InstructionalMethodDAO.getInstance().get(form.getInstructionalMethodId(), hibSession));
            }
            if (ioc.getUniqueId() == null) {
                hibSession.persist((Object)ioc);
            } else {
                hibSession.merge((Object)ioc);
            }
            this.addOrUpdateSubparts(form, ioc, hibSession, context);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).validateConfigChangeCanOccur(ioc.getInstructionalOffering(), hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            hibSession.merge((Object)ioc);
            ioc.getInstructionalOffering().computeLabels(hibSession);
            ChangeLog.addChange(hibSession, context, ioc, ChangeLog.Source.INSTR_CFG_EDIT, form.getConfigId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            tx.commit();
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(ioc.getInstructionalOffering(), hibSession);
            }
            return new InstrOfferingConfigInterface(InstrOfferingConfigInterface.Operation.SAVE, ioc.getInstructionalOffering().getUniqueId(), ioc.getUniqueId());
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    private static boolean isParent(Class_ clazz, Class_ parent) {
        SchedulingSubpart parentSubpart = parent.getSchedulingSubpart();
        while (parentSubpart != null) {
            if (parentSubpart.isParentOf(clazz.getSchedulingSubpart())) {
                return parent.isParentOf(clazz);
            }
            parentSubpart = parentSubpart.getParentSubpart();
            parent = parent.getParentClass();
        }
        return false;
    }

    protected static Department getDepartment(DistributionPref dp, SessionContext context) {
        Department owningDept = null;
        ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>(dp.getDistributionObjects());
        Collections.sort(distributionObjects);
        for (DistributionObject relatedObject : distributionObjects) {
            if (relatedObject.getPrefGroup() instanceof SchedulingSubpart) {
                SchedulingSubpart subpart = (SchedulingSubpart)relatedObject.getPrefGroup();
                if (owningDept == null) {
                    owningDept = subpart.getManagingDept();
                    continue;
                }
                if (owningDept.equals(subpart.getManagingDept())) continue;
                if (owningDept.getDistributionPrefPriority() < subpart.getManagingDept().getDistributionPrefPriority()) {
                    owningDept = subpart.getManagingDept();
                    continue;
                }
                if (owningDept.getDistributionPrefPriority() != subpart.getManagingDept().getDistributionPrefPriority() || context.getUser().getCurrentAuthority().hasQualifier(owningDept) || !context.getUser().getCurrentAuthority().hasQualifier(subpart.getManagingDept())) continue;
                owningDept = subpart.getManagingDept();
                continue;
            }
            if (!(relatedObject.getPrefGroup() instanceof Class_)) continue;
            Class_ clazz = (Class_)relatedObject.getPrefGroup();
            if (owningDept == null) {
                owningDept = clazz.getManagingDept();
                continue;
            }
            if (owningDept.equals(clazz.getManagingDept())) continue;
            if (owningDept.getDistributionPrefPriority() < clazz.getManagingDept().getDistributionPrefPriority()) {
                owningDept = clazz.getManagingDept();
                continue;
            }
            if (owningDept.getDistributionPrefPriority() != clazz.getManagingDept().getDistributionPrefPriority() || context.getUser().getCurrentAuthority().hasQualifier(owningDept) || !context.getUser().getCurrentAuthority().hasQualifier(clazz.getManagingDept())) continue;
            owningDept = clazz.getManagingDept();
        }
        return owningDept;
    }

    protected static boolean hasPreference(Preference p, Department currentManagingDept) {
        if (p instanceof TimePref) {
            return true;
        }
        if (p instanceof RoomPref) {
            Location loc = ((RoomPref)p).getRoom();
            for (RoomDept rd : loc.getRoomDepts()) {
                if (!rd.getDepartment().equals(currentManagingDept)) continue;
                return true;
            }
        } else if (p instanceof BuildingPref) {
            Building b = ((BuildingPref)p).getBuilding();
            for (RoomDept rd : currentManagingDept.getRoomDepts()) {
                if (!(rd.getRoom() instanceof Room) || !((Room)rd.getRoom()).getBuilding().equals(b)) continue;
                return true;
            }
        } else {
            if (p instanceof RoomFeaturePref) {
                RoomFeature rf = ((RoomFeaturePref)p).getRoomFeature();
                return !(rf instanceof DepartmentRoomFeature) || ((DepartmentRoomFeature)rf).getDepartment().equals(currentManagingDept);
            }
            if (p instanceof RoomGroupPref) {
                RoomGroup rg = ((RoomGroupPref)p).getRoomGroup();
                return rg.isGlobal() != false || currentManagingDept.equals(rg.getDepartment());
            }
        }
        return false;
    }

    protected static boolean toBeWeakened(Preference p, boolean weaken) {
        if (!weaken) {
            return false;
        }
        if (p instanceof TimePref) {
            TimePref tp = (TimePref)p;
            if (tp.getTimePattern().isExactTime()) {
                return false;
            }
            TimePatternModel m = tp.getTimePatternModel();
            return m.hasProgibitedPreferences() || m.hasRequiredPreferences();
        }
        return PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog()) || PreferenceLevel.sProhibited.equals(p.getPrefLevel().getPrefProlog());
    }

    protected static void updatePreferences(PreferenceGroup gr, Department controllingDept, Department currentManagingDept, Session hibSession, SessionContext context) {
        if (ApplicationProperty.ClearPreferencesWhenManagingDepartmentIsChanged.isTrue()) {
            Set<TimePref> timePrefs = gr.getTimePreferences();
            gr.getPreferences().clear();
            boolean weaken = true;
            if (!currentManagingDept.isExternalManager().booleanValue()) {
                weaken = false;
            }
            if (weaken && Boolean.TRUE.equals(currentManagingDept.isAllowReqTime())) {
                weaken = false;
            }
            if (weaken && Boolean.TRUE.equals(controllingDept.isAllowReqTime())) {
                weaken = false;
            }
            for (TimePref timePref : timePrefs) {
                TimePattern timePattern = timePref.getTimePattern();
                if (timePattern.isExactTime()) continue;
                TimePref tp = new TimePref();
                tp.setOwner(gr);
                tp.setPrefLevel(timePref.getPrefLevel());
                tp.setTimePattern(timePattern);
                tp.setPreference(timePref.getPreference());
                if (weaken) {
                    tp.weakenHardPreferences();
                }
                gr.addToPreferences(tp);
            }
            if (gr instanceof Class_) {
                ((Class_)gr).deleteAllDistributionPreferences(hibSession);
            } else if (gr instanceof SchedulingSubpart) {
                RoomGroup rg;
                SchedulingSubpart subpart = (SchedulingSubpart)gr;
                subpart.deleteAllDistributionPreferences(hibSession);
                if (currentManagingDept.equals(controllingDept) && !subpart.getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() && subpart.getMaxRooms() > 0 && (rg = RoomGroup.getGlobalDefaultRoomGroup(controllingDept.getSession())) != null) {
                    RoomGroupPref rgp = new RoomGroupPref();
                    rgp.setOwner(subpart);
                    rgp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    rgp.setRoomGroup(rg);
                    subpart.addToPreferences(rgp);
                }
            }
            return;
        }
        boolean weakenTime = true;
        boolean weakenRoom = true;
        if (!currentManagingDept.isExternalManager().booleanValue()) {
            weakenTime = false;
            weakenRoom = false;
        }
        if (weakenTime && (Boolean.TRUE.equals(currentManagingDept.isAllowReqTime()) || Boolean.TRUE.equals(controllingDept.isAllowReqTime()))) {
            weakenTime = false;
        }
        if (weakenRoom && (Boolean.TRUE.equals(currentManagingDept.isAllowReqRoom()) || Boolean.TRUE.equals(controllingDept.isAllowReqRoom()))) {
            weakenRoom = false;
        }
        Iterator<Preference> i = gr.getPreferences().iterator();
        while (i.hasNext()) {
            Preference p = i.next();
            if (p instanceof TimePref) {
                TimePref tp = (TimePref)p;
                if (!weakenTime || tp.getTimePattern().isExactTime()) continue;
                tp.weakenHardPreferences();
                hibSession.merge((Object)tp);
                continue;
            }
            if (!InstrOfferingConfigBackend.hasPreference(p, currentManagingDept)) {
                i.remove();
                continue;
            }
            if (!InstrOfferingConfigBackend.toBeWeakened(p, weakenRoom)) continue;
            p.weakenHardPreferences();
            hibSession.merge((Object)p);
        }
        for (DistributionObject distObj : gr.getDistributionObjects()) {
            DistributionPref dp = distObj.getDistributionPref();
            Department oldDepartment = (Department)dp.getOwner();
            Department newDepartment = InstrOfferingConfigBackend.getDepartment(dp, context);
            if (newDepartment == null || newDepartment.equals(oldDepartment)) continue;
            dp.setOwner(newDepartment);
            boolean weakenDist = true;
            if (!newDepartment.isExternalManager().booleanValue()) {
                weakenDist = false;
            }
            if (weakenDist && Boolean.TRUE.equals(newDepartment.isAllowReqDistribution())) {
                weakenDist = false;
            }
            if (weakenDist) {
                dp.weakenHardPreferences();
            }
            hibSession.merge((Object)dp);
        }
    }

    private void addOrUpdateSubparts(InstrOfferingConfigInterface form, InstrOfferingConfig ioc, Session hibSession, SessionContext context) {
        HashMap<Long, SchedulingSubpart> tmpSubpartToRealSubpart = new HashMap<Long, SchedulingSubpart>();
        HashMap<Long, SchedulingSubpart> deletedSubparts = new HashMap<Long, SchedulingSubpart>();
        HashMap<Long, Department> origSubpartManagingDept = new HashMap<Long, Department>();
        HashMap<Long, ArrayList<Class_>> oldClasses = new HashMap<Long, ArrayList<Class_>>();
        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
            deletedSubparts.put(ss.getUniqueId(), ss);
            ArrayList<Class_> classes = new ArrayList<Class_>(ss.getClasses());
            Collections.sort(classes, new ClassComparator(5));
            oldClasses.put(ss.getUniqueId(), classes);
            origSubpartManagingDept.put(ss.getUniqueId(), ss.getManagingDept());
        }
        for (InstrOfferingConfigInterface.SubpartLine line : form.getSubpartLines()) {
            SchedulingSubpart ss;
            if (line.getSubpartId() < 0L) {
                ss = new SchedulingSubpart();
                ss.setChildSubparts(new HashSet<SchedulingSubpart>());
                ss.setClasses(new HashSet<Class_>());
                ss.setItype((ItypeDesc)ItypeDescDAO.getInstance().get(line.getIType(), hibSession));
                ss.setAutoSpreadInTime(ApplicationProperty.SchedulingSubpartAutoSpreadInTimeDefault.isTrue());
                ss.setStudentAllowOverlap(ApplicationProperty.SchedulingSubpartStudentOverlapsDefault.isTrue());
                ss.setMinutesPerWk(line.getMinutesPerWeek());
                if (line.getParentId() != null) {
                    SchedulingSubpart parent = (SchedulingSubpart)tmpSubpartToRealSubpart.get(line.getParentId());
                    ss.setParentSubpart(parent);
                    parent.addToChildSubparts(ss);
                }
                ss.setInstrOfferingConfig(ioc);
                ioc.addToSchedulingSubparts(ss);
                hibSession.persist((Object)ss);
                tmpSubpartToRealSubpart.put(line.getSubpartId(), ss);
                continue;
            }
            if (line.isEditable()) {
                SchedulingSubpart newParent;
                ss = (SchedulingSubpart)deletedSubparts.remove(line.getSubpartId());
                ss.setMinutesPerWk(line.getMinutesPerWeek());
                SchedulingSubpart origParent = ss.getParentSubpart();
                SchedulingSubpart schedulingSubpart = newParent = line.getParentId() == null ? null : (SchedulingSubpart)tmpSubpartToRealSubpart.get(line.getParentId());
                if (!ToolBox.equals((Object)origParent, (Object)newParent)) {
                    ss.setParentSubpart(newParent);
                    if (newParent != null) {
                        newParent.addToChildSubparts(ss);
                    }
                    if (origParent != null) {
                        origParent.getChildSubparts().remove(ss);
                    }
                }
                if (ApplicationProperty.ConfigEditDeleteTimePrefs.isTrue()) {
                    DurationModel model = ioc.getDurationModel();
                    Iterator<Preference> i = ss.getPreferences().iterator();
                    while (i.hasNext()) {
                        Preference pref = i.next();
                        if (!(pref instanceof TimePref) || model.isValidCombination(ss.getMinutesPerWk(), ss.effectiveDatePattern(), ((TimePref)pref).getTimePattern())) continue;
                        i.remove();
                    }
                }
                hibSession.merge((Object)ss);
                tmpSubpartToRealSubpart.put(line.getSubpartId(), ss);
                continue;
            }
            ss = (SchedulingSubpart)deletedSubparts.remove(line.getSubpartId());
            tmpSubpartToRealSubpart.put(line.getSubpartId(), ss);
        }
        HashMap tmpSubpartToClasses = new HashMap();
        for (InstrOfferingConfigInterface.SubpartLine line : form.getSubpartLines()) {
            SchedulingSubpart ss = (SchedulingSubpart)tmpSubpartToRealSubpart.get(line.getSubpartId());
            if (line.isEditable()) {
                RoomGroup rg;
                ArrayList<Class_> adepts;
                Long managingDeptId = line.getDepartmentId();
                if (managingDeptId != null && managingDeptId < 0L) {
                    managingDeptId = null;
                }
                if ((adepts = (ArrayList<Class_>)oldClasses.get(ss.getUniqueId())) == null) {
                    adepts = new ArrayList<Class_>();
                }
                if (ss.getClasses().size() < line.getNumberOfClasses()) {
                    for (int i = ss.getClasses().size(); i < line.getNumberOfClasses(); ++i) {
                        Class_ newClass = new Class_();
                        newClass.setSchedulingSubpart(ss);
                        ss.addToClasses(newClass);
                        newClass.setControllingDept(ss.getControllingDept());
                        newClass.setExpectedCapacity(line.getMinClassLimit() == null || ioc.isUnlimitedEnrollment() != false ? 0 : line.getMinClassLimit());
                        newClass.setNbrRooms(ioc.isUnlimitedEnrollment() != false ? 0 : line.getNumberOfRooms());
                        newClass.setMaxExpectedCapacity(line.getMaxClassLimit() == null || ioc.isUnlimitedEnrollment() != false ? 0 : line.getMaxClassLimit());
                        newClass.setRoomRatio(Float.valueOf(ioc.isUnlimitedEnrollment() != false ? 1.0f : line.getRoomRatio().floatValue()));
                        newClass.setDisplayInstructor(true);
                        newClass.setEnabledForStudentScheduling(true);
                        newClass.setCancelled(false);
                        newClass.setRoomsSplitAttendance(line.getSplitAttendance());
                        newClass.setEnrollment(0);
                        newClass.setAssignments(new HashSet<Assignment>());
                        newClass.setPreferences(new HashSet<Preference>());
                        if (managingDeptId != null) {
                            newClass.setManagingDept((Department)DepartmentDAO.getInstance().get(managingDeptId, hibSession), context.getUser(), hibSession);
                        } else {
                            newClass.setManagingDept(ioc.getDepartment(), context.getUser(), hibSession);
                        }
                        hibSession.persist((Object)newClass);
                        adepts.add(newClass);
                    }
                }
                if (managingDeptId == null) {
                    managingDeptId = ioc.getDepartment().getUniqueId();
                }
                ArrayList<Class_> classes = new ArrayList<Class_>(line.getNumberOfClasses());
                tmpSubpartToClasses.put(line.getSubpartId(), classes);
                InstrOfferingConfigInterface.SubpartLine parent = form.getSubpartLine(line.getParentId());
                List parentClasses = parent == null ? null : (List)tmpSubpartToClasses.get(parent.getSubpartId());
                int childrenPerParent = -1;
                if (parent != null) {
                    childrenPerParent = line.getNumberOfClasses() / parent.getNumberOfClasses();
                }
                for (int i = 0; i < line.getNumberOfClasses(); ++i) {
                    Class_ parentClass = parentClasses == null ? null : (Class_)parentClasses.get(i / childrenPerParent);
                    Class_ adept = null;
                    AdeptComparator ac = new AdeptComparator(parentClasses, i / childrenPerParent);
                    for (Class_ c : adepts) {
                        if (!ac.isBetter(c, adept)) continue;
                        adept = c;
                    }
                    if (ApplicationProperty.ConfigEditDeleteTimePrefs.isTrue()) {
                        DurationModel model = ioc.getDurationModel();
                        Iterator<Preference> j = adept.getPreferences().iterator();
                        while (j.hasNext()) {
                            Preference pref = j.next();
                            if (!(pref instanceof TimePref) || model.isValidCombination(ss.getMinutesPerWk(), ss.effectiveDatePattern(), ((TimePref)pref).getTimePattern())) continue;
                            j.remove();
                        }
                    }
                    if (!adept.getManagingDept().getUniqueId().equals(managingDeptId)) {
                        Department managingDept = (Department)DepartmentDAO.getInstance().get(managingDeptId, hibSession);
                        adept.setManagingDept(managingDept, context.getUser(), hibSession);
                        InstrOfferingConfigBackend.updatePreferences(adept, ioc.getDepartment(), managingDept, hibSession, context);
                    }
                    if (managingDeptId != null) {
                        adept.setManagingDept((Department)DepartmentDAO.getInstance().get(managingDeptId, hibSession), context.getUser(), hibSession);
                    } else {
                        adept.setManagingDept(ioc.getDepartment(), context.getUser(), hibSession);
                    }
                    adept.setExpectedCapacity(line.getMinClassLimit() == null || ioc.isUnlimitedEnrollment() != false ? 0 : line.getMinClassLimit());
                    adept.setMaxExpectedCapacity(line.getMaxClassLimit() == null || ioc.isUnlimitedEnrollment() != false ? 0 : line.getMaxClassLimit());
                    adept.setNbrRooms(ioc.isUnlimitedEnrollment() != false ? 0 : line.getNumberOfRooms());
                    adept.setRoomRatio(Float.valueOf(ioc.isUnlimitedEnrollment() != false ? 1.0f : line.getRoomRatio().floatValue()));
                    adept.setRoomsSplitAttendance(line.getSplitAttendance());
                    if (adept.getParentClass() != null) {
                        adept.getParentClass().getChildClasses().remove(adept);
                    }
                    adept.setParentClass(parentClass);
                    if (parentClass != null) {
                        parentClass.addToChildClasses(adept);
                    }
                    hibSession.merge((Object)adept);
                    adepts.remove(adept);
                    classes.add(adept);
                }
                for (Class_ c : adepts) {
                    if (c.getParentClass() != null) {
                        c.getParentClass().getChildClasses().remove(c);
                    }
                    if (c.getPreferences() != null) {
                        c.getPreferences().removeAll(c.getPreferences());
                    }
                    c.deleteAllDependentObjects(hibSession, false);
                    ss.getClasses().remove(c);
                    hibSession.remove((Object)c);
                }
                Department currentManagingDept = ss.getManagingDept();
                Department origManagingDept = (Department)origSubpartManagingDept.get(ss.getUniqueId());
                if (origManagingDept != null && !currentManagingDept.equals(origManagingDept)) {
                    InstrOfferingConfigBackend.updatePreferences(ss, ioc.getDepartment(), currentManagingDept, hibSession, context);
                    hibSession.merge((Object)ss);
                    continue;
                }
                if (line.getSubpartId() >= 0L || ioc.isUnlimitedEnrollment().booleanValue() || ss.getManagingDept().isExternalManager().booleanValue() || line.getNumberOfRooms() <= 0 || (rg = RoomGroup.getGlobalDefaultRoomGroup(ioc.getSession())) == null) continue;
                RoomGroupPref rgp = new RoomGroupPref();
                rgp.setOwner(ss);
                rgp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                rgp.setRoomGroup(rg);
                ss.addToPreferences(rgp);
                hibSession.merge((Object)ss);
                continue;
            }
            ArrayList<Class_> classes = new ArrayList<Class_>(ss.getClasses());
            Collections.sort(classes, new ClassComparator(5));
            tmpSubpartToClasses.put(line.getSubpartId(), classes);
        }
        for (SchedulingSubpart ss : deletedSubparts.values()) {
            for (Class_ c : new ArrayList<Class_>(ss.getClasses())) {
                if (c.getParentClass() != null && !deletedSubparts.containsKey(c.getParentClass().getSchedulingSubpart().getUniqueId())) {
                    Class_ parent = c.getParentClass();
                    parent.getChildClasses().remove(c);
                }
                if (c.getPreferences() != null) {
                    c.getPreferences().removeAll(c.getPreferences());
                }
                c.deleteAllDependentObjects(hibSession, false);
                c.getSchedulingSubpart().getClasses().remove(c);
                hibSession.remove((Object)c);
            }
            if (ss.getParentSubpart() != null && !deletedSubparts.containsKey(ss.getParentSubpart().getUniqueId())) {
                ss.getParentSubpart().getChildSubparts().remove(ss);
            }
            ss.deleteAllDistributionPreferences(hibSession);
            ioc.getSchedulingSubparts().remove(ss);
            hibSession.remove((Object)ss);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected InstrOfferingConfigInterface delete(InstrOfferingConfigInterface form, SessionContext context) {
        Session hibSession = InstrOfferingConfigDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            hibSession.setFlushMode(FlushModeType.COMMIT);
            tx = hibSession.beginTransaction();
            InstrOfferingConfig ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(form.getConfigId(), hibSession);
            InstructionalOffering io = ioc.getInstructionalOffering();
            Event.deleteFromEvents(hibSession, ioc);
            Exam.deleteFromExams(hibSession, ioc);
            for (SchedulingSubpart schedulingSubpart : ioc.getSchedulingSubparts()) {
                for (Class_ class_ : schedulingSubpart.getClasses()) {
                    class_.deleteTeachingRequests(hibSession);
                    class_.deleteClassInstructors(hibSession);
                    class_.deleteAssignments(hibSession);
                    Exam.deleteFromExams(hibSession, class_);
                    Event.deleteFromEvents(hibSession, class_);
                }
            }
            HashSet<DistributionPref> distPrefs = new HashSet<DistributionPref>();
            for (SchedulingSubpart s : ioc.getSchedulingSubparts()) {
                for (Class_ c : s.getClasses()) {
                    for (DistributionObject distObj : c.getDistributionObjects()) {
                        DistributionPref dp = distObj.getDistributionPref();
                        dp.getDistributionObjects().remove(distObj);
                        hibSession.remove((Object)distObj);
                        distPrefs.add(dp);
                    }
                }
                for (DistributionObject distObj : s.getDistributionObjects()) {
                    DistributionPref dp = distObj.getDistributionPref();
                    dp.getDistributionObjects().remove(distObj);
                    hibSession.remove((Object)distObj);
                    distPrefs.add(dp);
                }
            }
            for (SchedulingSubpart s : ioc.getSchedulingSubparts()) {
                for (Class_ c : s.getClasses()) {
                    hibSession.remove((Object)c);
                }
                hibSession.remove((Object)s);
            }
            for (DistributionPref dp : distPrefs) {
                if (dp.getDistributionObjects().isEmpty()) {
                    hibSession.remove((Object)dp);
                    continue;
                }
                boolean bl = true;
                for (DistributionObject distObj : new TreeSet<DistributionObject>(dp.getDistributionObjects())) {
                    void var10_23;
                    distObj.setSequenceNumber((int)(++var10_23));
                    hibSession.merge((Object)distObj);
                }
                hibSession.merge((Object)dp);
            }
            io.getInstrOfferingConfigs().remove(ioc);
            hibSession.remove((Object)ioc);
            io.computeLabels(hibSession);
            ChangeLog.addChange(hibSession, context, io, io.getCourseName() + " [" + ioc.getName() + "]", ChangeLog.Source.INSTR_CFG_EDIT, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
            hibSession.merge((Object)io);
            String string = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (string != null && string.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).validateConfigChangeCanOccur(io, hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            tx.commit();
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(io, hibSession);
            }
            return new InstrOfferingConfigInterface(InstrOfferingConfigInterface.Operation.DELETE, io.getUniqueId(), null);
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    private static class AdeptComparator {
        Class_ iParentClass;
        List<Class_> iParentClasses;
        int iIndex;

        private AdeptComparator(List<Class_> parentClasses, int index) {
            this.iParentClasses = parentClasses;
            this.iIndex = index;
            this.iParentClass = this.iParentClasses == null ? null : this.iParentClasses.get(index);
        }

        public boolean isBetter(Class_ c, Class_ adept) {
            boolean aa;
            if (adept == null) {
                return true;
            }
            if (this.iParentClass != null) {
                boolean pa;
                boolean pc = InstrOfferingConfigBackend.isParent(c, this.iParentClass);
                if (pc != (pa = InstrOfferingConfigBackend.isParent(adept, this.iParentClass))) {
                    return pc;
                }
                if (!pc && !pa) {
                    boolean ia;
                    boolean ic = this.iParentClasses.indexOf(c.getParentClass()) < this.iIndex;
                    boolean bl = ia = this.iParentClasses.indexOf(adept.getParentClass()) < this.iIndex;
                    if (ia != ic) {
                        return ic;
                    }
                }
            }
            if (c.isCancelled() != adept.isCancelled()) {
                return c.isCancelled();
            }
            if (c.getEnrollment() != adept.getEnrollment()) {
                return c.getEnrollment() > adept.getEnrollment();
            }
            boolean ac = c.getCommittedAssignment() != null;
            boolean bl = aa = adept.getCommittedAssignment() != null;
            if (ac != aa) {
                return ac;
            }
            return false;
        }
    }
}

