/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=OfferingsInterface.DistributionsFilterRequest.class)
public class DistributionsFilterBackend
implements GwtRpcImplementation<OfferingsInterface.DistributionsFilterRequest, OfferingsInterface.DistributionsFilterResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);
    protected static GwtMessages GWT = Localization.create(GwtMessages.class);

    @Override
    public OfferingsInterface.DistributionsFilterResponse execute(OfferingsInterface.DistributionsFilterRequest request, SessionContext context) {
        context.checkPermission(Right.DistributionPreferences);
        OfferingsInterface.DistributionsFilterResponse filter = new OfferingsInterface.DistributionsFilterResponse();
        FilterInterface.FilterParameterInterface preference = new FilterInterface.FilterParameterInterface();
        preference.setName("prefLevel");
        preference.setType("list");
        preference.setMultiSelect(true);
        preference.setCollapsible(true);
        preference.setLabel(MESSAGES.propertyDistributionPreference());
        for (PreferenceLevel preferenceLevel : PreferenceLevel.getPreferenceLevelList(false)) {
            preference.addOption(preferenceLevel.getPrefId().toString(), preferenceLevel.getPrefName());
        }
        preference.setDefaultValue(context.getUser().getProperty("Distributions.prefLevel", ""));
        filter.addParameter(preference);
        FilterInterface.FilterParameterInterface type = new FilterInterface.FilterParameterInterface();
        type.setName("distType");
        type.setType("list");
        type.setMultiSelect(true);
        type.setCollapsible(true);
        type.setLabel(MESSAGES.propertyDistributionType());
        for (DistributionType distributionType : DistributionType.findAll(false, false, true)) {
            type.addOption(distributionType.getUniqueId().toString(), distributionType.getLabel());
        }
        type.setDefaultValue(context.getUser().getProperty("Distributions.distType", ""));
        filter.addParameter(type);
        FilterInterface.FilterParameterInterface filterParameterInterface = new FilterInterface.FilterParameterInterface();
        filterParameterInterface.setName("structure");
        filterParameterInterface.setType("list");
        filterParameterInterface.setMultiSelect(true);
        filterParameterInterface.setCollapsible(true);
        filterParameterInterface.setLabel(MESSAGES.propertyDistributionStructure());
        for (DistributionPref.Structure str : DistributionPref.Structure.values()) {
            filterParameterInterface.addOption(str.name(), str.getName());
        }
        filterParameterInterface.addOption("instructor", MESSAGES.columnInstructor());
        filterParameterInterface.setDefaultValue(context.getUser().getProperty("Distributions.structure", ""));
        filter.addParameter(filterParameterInterface);
        FilterInterface.FilterParameterInterface filterParameterInterface2 = new FilterInterface.FilterParameterInterface();
        filterParameterInterface2.setName("subjectArea");
        filterParameterInterface2.setType("list");
        filterParameterInterface2.setMultiSelect(true);
        filterParameterInterface2.setCollapsible(false);
        filterParameterInterface2.setLabel(MESSAGES.filterSubject());
        for (SubjectArea subject : SubjectArea.getAllSubjectAreas(context.getUser().getCurrentAcademicSessionId())) {
            filterParameterInterface2.addOption(subject.getUniqueId().toString(), subject.getLabel());
        }
        filterParameterInterface2.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsSubjectArea));
        filterParameterInterface2.setEnterToSubmit(true);
        filter.addParameter(filterParameterInterface2);
        FilterInterface.FilterParameterInterface courseNbr = new FilterInterface.FilterParameterInterface();
        courseNbr.setName("courseNbr");
        courseNbr.setLabel(MESSAGES.filterCourseNumber());
        courseNbr.setType("courseNumber");
        courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsCourseNumber));
        courseNbr.setCollapsible(false);
        courseNbr.setConfig("subjectId=${subjectArea};notOffered=false;");
        courseNbr.setEnterToSubmit(true);
        filter.addParameter(courseNbr);
        if (filterParameterInterface2.getDefaultValue() == null && courseNbr.getDefaultValue() == null) {
            filterParameterInterface2.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesSubjectAreas));
            courseNbr.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassesCourseNumber));
        }
        filter.setSticky(CommonValues.Yes.eq(UserProperty.StickyTables.get(context.getUser())));
        filter.setMaxSubjectsToSearchAutomatically(ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue());
        filter.setCanAdd(context.hasPermission(Right.DistributionPreferenceAdd));
        filter.setSessionId(context.getUser().getCurrentAcademicSessionId());
        BackTracker.markForBack(context, null, null, false, true);
        return filter;
    }
}

