/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.hibernate.query.Query;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.CourseOfferingInterface;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.OverrideTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=CourseOfferingInterface.CourseOfferingPropertiesRequest.class)
public class CourseOfferingPropertiesBackend
implements GwtRpcImplementation<CourseOfferingInterface.CourseOfferingPropertiesRequest, CourseOfferingInterface.CourseOfferingPropertiesInterface> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    Logger logger = Logger.getLogger("UpdateCourseOfferingBackend");

    @Override
    public CourseOfferingInterface.CourseOfferingPropertiesInterface execute(CourseOfferingInterface.CourseOfferingPropertiesRequest request, SessionContext context) {
        Boolean courseOfferingNumberMustBeUnique;
        if (request.hasSessionId()) {
            context = new EventAction.EventContext(context, request.getSessionId());
        }
        if (request.getCourseOfferingId() != null) {
            if (!(context.hasPermission(request.getCourseOfferingId(), Right.EditCourseOffering) || context.hasPermission(request.getCourseOfferingId(), Right.EditCourseOfferingCoordinators) || context.hasPermission(request.getCourseOfferingId(), Right.EditCourseOfferingNote))) {
                context.checkPermission(request.getCourseOfferingId(), Right.EditCourseOffering);
            }
        } else {
            context.checkPermission(Right.AddCourseOffering);
        }
        CourseOfferingInterface.CourseOfferingPropertiesInterface response = new CourseOfferingInterface.CourseOfferingPropertiesInterface();
        if (context.getUser() != null) {
            Session session = (Session)SessionDAO.getInstance().get(request.hasSessionId() ? request.getSessionId() : context.getUser().getCurrentAcademicSessionId());
            response.setAcademicSession(new CourseOfferingInterface.AcademicSessionInterface(session.getUniqueId(), session.getAcademicTerm() + " " + session.getAcademicYear()));
            response.setWkEnrollDefault(session.getLastWeekToEnroll());
            response.setWkChangeDefault(session.getLastWeekToChange());
            response.setWkDropDefault(session.getLastWeekToDrop());
            response.setWeekStartDayOfWeek(Localization.getDateFormat("EEEE").format(session.getSessionBeginDateTime()));
        }
        int j = 0;
        Long tempSubjId = 0L;
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
            if (!context.hasPermission(subject, Right.AddCourseOffering)) continue;
            CourseOfferingInterface.SubjectAreaInterface subjectArea = new CourseOfferingInterface.SubjectAreaInterface();
            subjectArea.setId(subject.getUniqueId());
            subjectArea.setAbbreviation(subject.getSubjectAreaAbbreviation());
            subjectArea.setLabel(subject.getTitle());
            response.addSubjectArea(subjectArea);
            if (j == 0) {
                tempSubjId = subject.getUniqueId();
            }
            ++j;
        }
        response.setPrefRowsAdded(2);
        for (CourseCreditFormat courseCreditFormat : CourseCreditFormat.getCourseCreditFormatList()) {
            CourseOfferingInterface.CourseCreditFormatInterface courseCreditFormatObject = new CourseOfferingInterface.CourseCreditFormatInterface();
            courseCreditFormatObject.setId(courseCreditFormat.getUniqueId());
            courseCreditFormatObject.setReference(courseCreditFormat.getReference());
            courseCreditFormatObject.setLabel(courseCreditFormat.getLabel());
            response.addCourseCreditFormat(courseCreditFormatObject);
        }
        for (CourseCreditType courseCreditType : CourseCreditType.getCourseCreditTypeList()) {
            CourseOfferingInterface.CourseCreditTypeInterface courseCreditTypeObject = new CourseOfferingInterface.CourseCreditTypeInterface();
            courseCreditTypeObject.setId(courseCreditType.getUniqueId());
            courseCreditTypeObject.setLabel(courseCreditType.getLabel());
            response.addCourseCreditType(courseCreditTypeObject);
        }
        for (CourseCreditUnitType courseCreditUnitType : CourseCreditUnitType.getCourseCreditUnitTypeList()) {
            CourseOfferingInterface.CourseCreditUnitTypeInterface courseCreditUnitTypeObject = new CourseOfferingInterface.CourseCreditUnitTypeInterface();
            courseCreditUnitTypeObject.setId(courseCreditUnitType.getUniqueId());
            courseCreditUnitTypeObject.setLabel(courseCreditUnitType.getLabel());
            response.addCourseCreditUnitType(courseCreditUnitTypeObject);
        }
        for (OfferingConsentType offeringConsentType : OfferingConsentType.getConsentTypeList()) {
            CourseOfferingInterface.OfferingConsentTypeInterface offeringConsentTypeObject = new CourseOfferingInterface.OfferingConsentTypeInterface();
            offeringConsentTypeObject.setId(offeringConsentType.getUniqueId());
            offeringConsentTypeObject.setLabel(offeringConsentType.getLabel());
            response.addOfferingConsentType(offeringConsentTypeObject);
        }
        for (TeachingResponsibility teachingResponsibility : TeachingResponsibility.getCoordinatorTeachingResponsibilities()) {
            CourseOfferingInterface.ResponsibilityInterface responsibility = new CourseOfferingInterface.ResponsibilityInterface();
            responsibility.setId(teachingResponsibility.getUniqueId());
            responsibility.setLabel(teachingResponsibility.getLabel());
            response.addResponsibility(responsibility);
        }
        TeachingResponsibility tr = TeachingResponsibility.getDefaultCoordinatorTeachingResponsibility();
        if (tr != null) {
            response.setDefaultTeachingResponsibilityId(tr.getUniqueId().toString());
        } else {
            response.setDefaultTeachingResponsibilityId("");
        }
        if (request.getSubjAreaId() == null) {
            request.setSubjAreaId(tempSubjId);
        }
        if (request.getSubjAreaId() != null) {
            SubjectArea subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(request.getSubjAreaId());
            response.setSubjectAreaEffectiveFundingDept(subjectArea.getEffectiveFundingDept().getUniqueId());
            StringBuffer queryClause = new StringBuffer("");
            if (subjectArea.getDepartment().getUniqueId() != null) {
                queryClause.append(" and i.department.uniqueId = " + subjectArea.getDepartment().getUniqueId());
            }
            String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
            Long acadSessionId = context.getUser().getCurrentAcademicSessionId();
            StringBuffer query = new StringBuffer();
            query.append("select distinct i from DepartmentalInstructor i ");
            query.append(" where i.department.session.uniqueId = :acadSessionId ");
            query.append(queryClause);
            DepartmentalInstructorDAO idao = DepartmentalInstructorDAO.getInstance();
            org.hibernate.Session hibSession = idao.getSession();
            Query q = hibSession.createQuery(query.toString(), DepartmentalInstructor.class);
            q.setFetchSize(5000);
            q.setCacheable(true);
            q.setParameter("acadSessionId", (Object)acadSessionId);
            List list = q.list();
            if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
                Collections.sort(list, new DepartmentalInstructorComparator(instructorNameFormat));
            } else {
                Collections.sort(list, new DepartmentalInstructorComparator());
            }
            for (DepartmentalInstructor di : list) {
                String name = di.getName(instructorNameFormat);
                CourseOfferingInterface.InstructorInterface instructorObject = new CourseOfferingInterface.InstructorInterface();
                instructorObject.setId(di.getUniqueId());
                instructorObject.setLabel(name);
                response.addInstructor(instructorObject);
            }
            TreeSet<Department> fundingDeptSet = new TreeSet<Department>();
            Department subjectFundingDepartment = subjectArea.getFundingDept();
            Department subjectDepartment = subjectArea.getDepartment();
            if (subjectFundingDepartment != null) {
                fundingDeptSet.add(subjectFundingDepartment);
                if (!subjectFundingDepartment.getUniqueId().equals(subjectDepartment.getUniqueId())) {
                    fundingDeptSet.add(subjectDepartment);
                }
            } else {
                fundingDeptSet.add(subjectDepartment);
            }
            if (request.getIsEdit().booleanValue()) {
                Long courseOfferingId = request.getCourseOfferingId();
                CourseOffering courseOffering = CourseOffering.findByUniqueId(courseOfferingId);
                InstructionalOffering instructionalOffering = courseOffering.getInstructionalOffering();
                Set<Object> courseOfferings = new HashSet();
                courseOfferings = instructionalOffering.getCourseOfferings();
                for (Object childCourseOffering : courseOfferings) {
                    Department fundingDept = ((BaseCourseOffering)childCourseOffering).getSubjectArea().getFundingDept();
                    if (fundingDept == null) continue;
                    fundingDeptSet.add(fundingDept);
                }
                for (OfferingCoordinator oc : instructionalOffering.getOfferingCoordinators()) {
                    if (oc.getInstructor().getDepartment().equals(instructionalOffering.getDepartment())) continue;
                    CourseOfferingInterface.InstructorInterface instructorObject = new CourseOfferingInterface.InstructorInterface();
                    instructorObject.setId(oc.getInstructor().getUniqueId());
                    instructorObject.setLabel(oc.getInstructor().getName(instructorNameFormat) + " (" + oc.getInstructor().getDepartment().getDeptCode() + ")");
                    response.addInstructor(instructorObject);
                }
            }
            StringBuffer queryClause2 = new StringBuffer("");
            queryClause2.append(" and i.externalFundingDept = true");
            StringBuffer query2 = new StringBuffer();
            query2.append("select distinct i from Department i ");
            query2.append(" where i.session.uniqueId = :acadSessionId ");
            query2.append(queryClause2);
            DepartmentDAO departmentDao = DepartmentDAO.getInstance();
            org.hibernate.Session hibSession2 = departmentDao.getSession();
            Query q2 = hibSession2.createQuery(query2.toString(), Department.class);
            q2.setFetchSize(5000);
            q2.setCacheable(true);
            q2.setParameter("acadSessionId", (Object)acadSessionId);
            List result2 = q2.list();
            Collections.sort(result2);
            for (Department dept : result2) {
                fundingDeptSet.add(dept);
            }
            if (!fundingDeptSet.isEmpty()) {
                for (Department dept : fundingDeptSet) {
                    CourseOfferingInterface.DepartmentInterface fundingDepartmentObject = new CourseOfferingInterface.DepartmentInterface();
                    fundingDepartmentObject.setId(dept.getUniqueId());
                    fundingDepartmentObject.setLabel(dept.getLabel());
                    response.addFundingDepartment(fundingDepartmentObject);
                }
            }
        }
        Boolean courseOfferingNumberUpperCase = ApplicationProperty.CourseOfferingNumberUpperCase.isTrue() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        String courseNbrRegex = ApplicationProperty.CourseOfferingNumberPattern.value();
        String courseNbrInfo = ApplicationProperty.CourseOfferingNumberPatternInfo.value();
        if (ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue()) {
            courseOfferingNumberMustBeUnique = true;
            if (request.getCourseNumber() != null && request.getSubjAreaId() != null) {
                CourseOffering course = CourseOffering.findBySessionSubjAreaIdCourseNbr(response.getAcademicSession().getId(), request.getSubjAreaId(), request.getCourseNumber());
                if (course != null) {
                    response.setInstructionalOfferingId(course.getInstructionalOffering().getUniqueId().toString());
                } else {
                    response.setInstructionalOfferingId(null);
                }
            }
        } else {
            courseOfferingNumberMustBeUnique = false;
        }
        response.setCourseNbrRegex(courseNbrRegex);
        response.setCourseNbrInfo(courseNbrInfo);
        response.setCourseOfferingMustBeUnique(courseOfferingNumberMustBeUnique);
        response.setCourseOfferingNumberUpperCase(courseOfferingNumberUpperCase);
        response.setCoursesFundingDepartmentsEnabled(ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue());
        Boolean allowAlternativeCourseOfferings = ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue();
        response.setAllowAlternativeCourseOfferings(allowAlternativeCourseOfferings);
        String courseUrlProvider = ApplicationProperty.CustomizationCourseLink.value();
        response.setCourseUrlProvider(courseUrlProvider);
        response.setCanEditExternalIds(ApplicationProperty.CourseOfferingEditExternalIds.isTrue());
        response.setCanShowExternalIds(ApplicationProperty.CourseOfferingShowExternalIds.isTrue());
        List<CourseOffering> courseOfferingsDemand = this.setupCourseOfferings(context, new CourseFilter(){

            @Override
            public boolean accept(CourseOffering course) {
                return course.getDemand() != null && course.getDemand() > 0;
            }
        });
        for (CourseOffering courseOffering : courseOfferingsDemand) {
            CourseOfferingInterface courseOffering2 = new CourseOfferingInterface();
            courseOffering2.setId(courseOffering.getUniqueId());
            courseOffering2.setLabel(courseOffering.getCourseNameWithTitle());
            response.addCourseDemands(courseOffering2);
        }
        if (allowAlternativeCourseOfferings.booleanValue()) {
            Iterator altCourseOfferings = this.setupCourseOfferings(context, new CourseFilter(){

                @Override
                public boolean accept(CourseOffering course) {
                    return course.getInstructionalOffering().isNotOffered() == false;
                }
            });
            Iterator<CourseOffering> iterator = altCourseOfferings.iterator();
            while (iterator.hasNext()) {
                CourseOffering co2 = iterator.next();
                CourseOfferingInterface courseOffering = new CourseOfferingInterface();
                courseOffering.setId(co2.getUniqueId());
                courseOffering.setLabel(co2.getCourseNameWithTitle());
                response.addAltCourseOffering(courseOffering);
            }
        }
        for (CourseType courseType : CourseTypeDAO.getInstance().getSession().createQuery("from CourseType order by reference", CourseType.class).setCacheable(true).list()) {
            CourseOfferingInterface.CourseTypeInterface courseTypeObject = new CourseOfferingInterface.CourseTypeInterface();
            courseTypeObject.setId(courseType.getUniqueId());
            courseTypeObject.setLabel(courseType.getLabel());
            response.addCourseType(courseTypeObject);
        }
        for (OverrideType overrideType : OverrideTypeDAO.getInstance().findAll()) {
            CourseOfferingInterface.OverrideTypeInterface overrideTypeObject = new CourseOfferingInterface.OverrideTypeInterface();
            overrideTypeObject.setId(overrideType.getUniqueId());
            overrideTypeObject.setName(overrideType.getLabel());
            overrideTypeObject.setReference(overrideType.getReference());
            response.addOverrideType(overrideTypeObject);
        }
        response.setWaitListDefault(InstructionalOffering.getDefaultWaitListMode().ordinal());
        CourseOfferingInterface.WaitListInterface waitListDefault = new CourseOfferingInterface.WaitListInterface();
        switch (InstructionalOffering.getDefaultWaitListMode()) {
            case WaitList: {
                waitListDefault.setLabel(MSG.waitListDefaultEnabled());
                waitListDefault.setValue("");
                response.addWaitList(waitListDefault);
                break;
            }
            case Disabled: {
                waitListDefault.setLabel(MSG.waitListDefaultDisabled());
                waitListDefault.setValue("");
                response.addWaitList(waitListDefault);
                break;
            }
            case ReSchedule: {
                waitListDefault.setLabel(MSG.waitListDefaultReschedule());
                waitListDefault.setValue("");
                response.addWaitList(waitListDefault);
            }
        }
        CourseOfferingInterface.WaitListInterface waitListInterface = new CourseOfferingInterface.WaitListInterface();
        waitListInterface.setLabel(MSG.waitListEnabled());
        waitListInterface.setValue(String.valueOf(InstructionalOffering.OfferingWaitListMode.WaitList.ordinal()));
        response.addWaitList(waitListInterface);
        CourseOfferingInterface.WaitListInterface waitListReSchedule = new CourseOfferingInterface.WaitListInterface();
        waitListReSchedule.setLabel(MSG.waitListReschedule());
        waitListReSchedule.setValue(String.valueOf(InstructionalOffering.OfferingWaitListMode.ReSchedule.ordinal()));
        response.addWaitList(waitListReSchedule);
        CourseOfferingInterface.WaitListInterface waitListDisabled = new CourseOfferingInterface.WaitListInterface();
        waitListDisabled.setLabel(MSG.waitListDisabled());
        waitListDisabled.setValue(String.valueOf(InstructionalOffering.OfferingWaitListMode.Disabled.ordinal()));
        response.addWaitList(waitListDisabled);
        return response;
    }

    private List<CourseOffering> setupCourseOfferings(SessionContext context, CourseFilter filter) {
        ArrayList<CourseOffering> list = new ArrayList<CourseOffering>();
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
            for (CourseOffering co : subject.getCourseOfferings()) {
                if (filter != null && !filter.accept(co)) continue;
                list.add(co);
            }
        }
        Collections.sort(list, new CourseOfferingComparator());
        return list;
    }

    private static interface CourseFilter {
        public boolean accept(CourseOffering var1);
    }
}

