/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.net.URLEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassesTableBuilder;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=OfferingsInterface.ClassesRequest.class)
public class ClassesBackend
implements GwtRpcImplementation<OfferingsInterface.ClassesRequest, OfferingsInterface.OfferingsResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public OfferingsInterface.OfferingsResponse execute(OfferingsInterface.ClassesRequest request, SessionContext context) {
        context.checkPermission(Right.Classes);
        String subjectArea = request.getFilter().getParameterValue("subjectArea");
        if (subjectArea == null || subjectArea.isEmpty()) {
            throw new GwtRpcException(MESSAGES.errorSubjectRequired());
        }
        OfferingsInterface.OfferingsResponse response = new OfferingsInterface.OfferingsResponse();
        ClassesTableBuilder builder = new ClassesTableBuilder(context, request.getBackType(), request.getBackId());
        for (FilterInterface.FilterParameterInterface p : request.getFilter().getParameters()) {
            if ("subjectArea".equals(p.getName())) {
                context.setAttribute(SessionAttribute.ClassesSubjectAreas, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if ("courseNbr".equals(p.getName())) {
                context.setAttribute(SessionAttribute.ClassesCourseNumber, (Object)(p.getValue() != null ? p.getValue() : p.getDefaultValue()));
                continue;
            }
            if (p.getValue() == null) continue;
            context.getUser().setProperty("ClassList." + p.getName(), p.getValue());
        }
        String courseNbr = request.getFilter().getParameterValue("courseNbr");
        try {
            Object subjects = "";
            int count = 0;
            for (String id : subjectArea.split(",")) {
                SubjectArea sa = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(id));
                if (sa == null) continue;
                context.checkPermission(sa.getDepartment(), Right.Classes);
                if (++count == 1) {
                    subjects = (String)subjects + sa.getSubjectAreaAbbreviation();
                    continue;
                }
                if (count <= 3) {
                    subjects = (String)subjects + ", " + sa.getSubjectAreaAbbreviation();
                    continue;
                }
                if (count != 4) continue;
                subjects = (String)subjects + "\u2026";
            }
            BackTracker.markForBack(context, "classSearch?subjectArea=" + request.getFilter().getParameterValue("subjectArea") + "&courseNbr=" + (courseNbr == null ? "" : URLEncoder.encode(courseNbr, "utf-8")), MESSAGES.backClasses((String)subjects + (String)(courseNbr == null || courseNbr.isEmpty() ? "" : " " + courseNbr)), true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        builder.generateTableForClasses(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), request.getFilter(), subjectArea.split(","), response);
        if (response.isEmpty()) {
            throw new GwtRpcException(MESSAGES.errorNoRecords());
        }
        return response;
    }
}

