/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.server.courses.ExaminationsTableBuilder;
import org.unitime.timetable.server.courses.SubpartDetailBackend;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;

@GwtRpcImplements(value=OfferingsInterface.ClassDetailRequest.class)
public class ClassDetailBackend
implements GwtRpcImplementation<OfferingsInterface.ClassDetailRequest, OfferingsInterface.ClassDetailReponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtMessages GWT = Localization.create(GwtMessages.class);
    protected static final GwtConstants CONST = Localization.create(GwtConstants.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public OfferingsInterface.ClassDetailReponse execute(OfferingsInterface.ClassDetailRequest request, SessionContext context) {
        ClassAssignmentProxy.AssignmentInfo a;
        ClassAssignmentProxy proxy;
        List<StudentAccomodation.AccommodationCounter> acc;
        Session hibSession = SchedulingSubpartDAO.getInstance().getSession();
        Class_ clazz = (Class_)Class_DAO.getInstance().get(request.getClassId(), hibSession);
        context.checkPermission(clazz, Right.ClassDetail);
        if (clazz == null) {
            throw new GwtRpcException(MSG.errorNoClassId());
        }
        if (request.getAction() == null) {
            BackTracker.markForBack(context, "clazz?id=" + request.getClassId(), MSG.backClass(clazz.getClassLabel()), true, false);
        } else {
            switch (request.getAction()) {
                // Empty switch
            }
        }
        OfferingsInterface.ClassDetailReponse response = new OfferingsInterface.ClassDetailReponse();
        response.setConfirms(JavascriptFunctions.isJsConfirm(context));
        SchedulingSubpart ss = clazz.getSchedulingSubpart();
        InstrOfferingConfig ioc = ss.getInstrOfferingConfig();
        InstructionalOffering io = ioc.getInstructionalOffering();
        response.setClassId(clazz.getUniqueId());
        response.setClassName(clazz.getSectionNumberString());
        response.setSubpartId(ss.getUniqueId());
        Object label = ss.getItype().getAbbv();
        for (SchedulingSubpart parent = ss.getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
            label = parent.getItype().getAbbv() + " - " + (String)label;
        }
        if (io.hasMultipleConfigurations()) {
            label = (String)label + " [" + ioc.getName() + "]";
        }
        response.setSubparName((String)label);
        response.setOfferingId(ss.getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
        response.setCourseName(ss.getCourseNameWithTitle());
        Class_ next = clazz.getNextClass(context, Right.ClassDetail);
        response.setNextId(next == null ? null : next.getUniqueId());
        Class_ previous = clazz.getPreviousClass(context, Right.ClassDetail);
        response.setPreviousId(previous == null ? null : previous.getUniqueId());
        response.setProperties(ClassDetailBackend.getProperties(clazz, context));
        DatePattern datePattern = clazz.getDatePattern();
        if (datePattern != null) {
            c = response.addProperty(MSG.propertyDatePattern()).add(datePattern.getName()).add("");
            if (datePattern.getDatePatternType() != DatePattern.DatePatternType.PatternSet) {
                c.addClick().setTitle(MSG.sectPreviewOfDatePattern(datePattern.getName())).addWidget().setId("UniTimeGWT:DatePattern").setContent(datePattern.getPatternText());
                c.setImage().setSource("images/calendar.png").addStyle("cursor: pointer; padding-left: 5px; vertical-align: bottom;");
            }
        } else {
            datePattern = clazz.effectiveDatePattern();
            if (datePattern != null) {
                c = response.addProperty(MSG.propertyDatePattern()).add(MSG.dropDefaultDatePattern() + " (" + datePattern.getName() + ")").add("");
                if (datePattern.getDatePatternType() != DatePattern.DatePatternType.PatternSet) {
                    c.addClick().setTitle(MSG.sectPreviewOfDatePattern(datePattern.getName())).addWidget().setId("UniTimeGWT:DatePattern").setContent(datePattern.getPatternText());
                    c.setImage().setSource("images/calendar.png").addStyle("cursor: pointer; padding-left: 5px; vertical-align: bottom;");
                }
            }
        }
        TableInterface.CellInterface cDi = response.addProperty(MSG.propertyDisplayInstructors());
        if (clazz.isDisplayInstructor().booleanValue()) {
            cDi.addImage().setSource("images/accept.png").setAlt(MSG.titleInstructorDisplayed()).setTitle(MSG.titleInstructorDisplayed());
        } else {
            cDi.addImage().setSource("images/cross.png").setAlt(MSG.titleInstructorNotDisplayed()).setTitle(MSG.titleInstructorNotDisplayed());
        }
        TableInterface.CellInterface cSS = response.addProperty(MSG.propertyEnabledForStudentScheduling());
        if (clazz.isEnabledForStudentScheduling().booleanValue()) {
            cSS.addImage().setSource("images/accept.png").setAlt(MSG.titleEnabledForStudentScheduling()).setTitle(MSG.titleEnabledForStudentScheduling());
        } else {
            cSS.addImage().setSource("images/cross.png").setAlt(MSG.titleNotEnabledForStudentScheduling()).setTitle(MSG.titleNotEnabledForStudentScheduling());
        }
        if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
            response.addProperty(MSG.propertyStudentScheduleNote()).setHtml(clazz.getSchedulePrintNote()).addStyle("white-space: pre-wrap;");
        }
        if (clazz.getNotes() != null && !clazz.getNotes().isEmpty()) {
            response.addProperty(MSG.propertyRequestsNotes()).setHtml(clazz.getNotes()).addStyle("white-space: pre-wrap;");
        }
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        if (!clazz.getClassInstructors().isEmpty()) {
            List<TeachingResponsibility> responsibilities = TeachingResponsibility.getInstructorTeachingResponsibilities();
            TableInterface table = new TableInterface();
            TableInterface.LineInterface header = table.addHeader();
            header.addCell(MSG.columnInstructorName());
            header.addCell(MSG.columnInstructorShare()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            header.addCell(MSG.columnInstructorCheckConflicts()).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
            if (!responsibilities.isEmpty()) {
                header.addCell(MSG.columnTeachingResponsibility());
            }
            for (TableInterface.CellInterface cell : header.getCells()) {
                cell.setClassName("WebTableHeader");
                cell.setText(cell.getText().replace("<br>", "\n"));
            }
            for (ClassInstructor ci : new TreeSet<ClassInstructor>(clazz.getClassInstructors())) {
                TableInterface.LineInterface line = table.addLine();
                line.setURL("instructorDetail.action?instructorId=" + ci.getInstructor().getUniqueId() + "&deptId=" + ci.getInstructor().getDepartment().getUniqueId());
                line.addCell(ci.getInstructor().getName(nameFormat));
                line.addCell(ci.getPercentShare().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                if (ci.isLead().booleanValue()) {
                    line.addCell().setTextAlignment(TableInterface.CellInterface.Alignment.CENTER).addImage().setSource("images/accept.png").setTitle(MSG.toolTipInstructorLead());
                } else {
                    line.addCell();
                }
                if (responsibilities.isEmpty()) continue;
                line.addCell(ci.getResponsibility() == null ? null : ci.getResponsibility().getLabel());
            }
            table.setStyle("width: 50%;");
            response.addProperty(MSG.propertyInstructors()).setTable(table);
        }
        if ((acc = StudentAccomodation.getAccommodations(clazz)) != null && !acc.isEmpty()) {
            TableInterface.CellInterface c = response.addProperty(MSG.propertyAccommodations());
            TableInterface table = new TableInterface();
            for (StudentAccomodation.AccommodationCounter ac : acc) {
                table.addProperty(ac.getAccommodation().getName() + ":").setText(String.valueOf(ac.getCount()));
            }
            c.setTable(table);
        }
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DisplayLastChanges))) {
            ChangeLog cl = ChangeLog.findLastChange(clazz);
            if (cl != null) {
                response.addProperty(GWT.propLastChange()).add(cl.getShortLabel());
            } else {
                response.addProperty(GWT.propLastChange()).add(GWT.notApplicable()).addStyle("font-style: italic;");
            }
        }
        if (!((proxy = this.classAssignmentService.getAssignment()) == null || (a = proxy.getAssignment(clazz)) == null || !a.isCommitted() || a.getDatePattern() == null || a.getDatePattern().equals(clazz.effectiveDatePattern()) || a.getDatePattern().getParents() != null && a.getDatePattern().getParents().contains(clazz.effectiveDatePattern()))) {
            response.getProperties().getProperties().add(0, new TableInterface.PropertyInterface().setCell(new TableInterface.CellInterface().setText(MSG.datePatternCommittedIsDifferent(clazz.getClassLabel(), a.getDatePattern().getName(), clazz.effectiveDatePattern().getName())).setColor("red")));
        }
        response.setConflicts(ClassDetailBackend.getConflictTable(context, proxy, clazz));
        response.setEventConflicts(ClassDetailBackend.getEventConflictTable(context, proxy, clazz));
        if (clazz.getNbrRooms() == 0) {
            response.setPreferences(ClassDetailBackend.getPreferenceTable(context, clazz, Preference.Type.DATE, Preference.Type.TIME, Preference.Type.ROOM));
        } else {
            response.setPreferences(ClassDetailBackend.getPreferenceTable(context, clazz, Preference.Type.DATE, Preference.Type.TIME, Preference.Type.ROOM_GROUP, Preference.Type.ROOM, Preference.Type.BUILDING, Preference.Type.ROOM_FEATURE));
        }
        if (context.hasPermission(Right.ClassAssignments)) {
            ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(context, this.courseTimetablingSolverService.getSolver(), clazz.getUniqueId(), true);
            if (ca != null) {
                response.setTimetable(ClassDetailBackend.getAssignmentTable(context, this.courseTimetablingSolverService.getSolver(), ca));
            } else {
                ClassAssignmentProxy.AssignmentInfo assignment;
                ClassAssignmentProxy cap = this.classAssignmentService.getAssignment();
                if (cap != null && (assignment = cap.getAssignment(clazz)) != null && assignment.getUniqueId() != null && (ca = ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(context, assignment.getUniqueId(), true)) != null) {
                    response.setTimetable(ClassDetailBackend.getAssignmentTable(context, this.courseTimetablingSolverService.getSolver(), ca));
                }
            }
        }
        ExaminationsTableBuilder examBuilder = new ExaminationsTableBuilder(context, null, null);
        response.setExaminations(examBuilder.createExamsTable("Class_", clazz.getUniqueId(), this.examinationSolverService.getSolver()));
        DistributionsTableBuilder distBuilder = new DistributionsTableBuilder(context, null, null);
        response.setDistributions(distBuilder.getDistPrefsTableForClass(clazz));
        BackTracker.BackItem back = BackTracker.getBackItem(context, 2);
        if (back != null) {
            response.addOperation("back");
            response.setBackTitle(back.getTitle());
            response.setBackUrl(back.getUrl() + (back.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + clazz.getUniqueId() + "&backType=PreferenceGroup");
        }
        if (response.getPreviousId() != null && context.hasPermission(response.getPreviousId(), "Class_", Right.ClassDetail)) {
            response.addOperation("previous");
        }
        if (response.getNextId() != null && context.hasPermission(response.getNextId(), "Class_", Right.ClassDetail)) {
            response.addOperation("next");
        }
        if (context.hasPermission(Right.ExaminationAdd)) {
            response.addOperation("add-exam");
        }
        if (context.hasPermission(clazz.getManagingDept(), Right.DistributionPreferenceAdd) && context.hasPermission(clazz, Right.DistributionPreferenceClass)) {
            if (ApplicationProperty.LegacyDistributions.isTrue()) {
                response.addOperation("add-distribution-legacy");
            } else {
                response.addOperation("add-distribution");
            }
        }
        if (context.hasPermission(clazz, Right.ClassEdit)) {
            response.addOperation("edit");
        }
        if (context.hasPermission(clazz, Right.ClassAssignment)) {
            response.addOperation("assign");
        }
        return response;
    }

    public static TableInterface getProperties(Class_ clazz, SessionContext context) {
        Department d;
        TableInterface.CellInterface c;
        TableInterface response = new TableInterface();
        if (clazz.isCancelled().booleanValue()) {
            response.addProperty("").setText(MSG.classNoteCancelled(clazz.getClassLabel())).setColor("red").addStyle("font-weight: bold;");
        }
        response.addProperty(MSG.filterManager()).add(clazz.getManagingDept().getManagingDeptLabel());
        if (clazz.getParentClass() != null) {
            c = response.addProperty(MSG.propertyParentClass()).setText(clazz.getParentClass().getClassLabel());
            if (context.hasPermission(clazz.getParentClass(), Right.ClassDetail)) {
                c.setUrl("clazz?id=" + clazz.getParentClass().getUniqueId());
                c.setClassName("link");
            }
        }
        if (clazz.getClassSuffix() != null && !clazz.getClassSuffix().isEmpty()) {
            response.addProperty(MSG.propertyExternalId()).add(clazz.getClassSuffix());
        }
        if (clazz.getEnrollment() != null) {
            response.addProperty(MSG.propertyEnrollment()).add(clazz.getEnrollment().toString());
        }
        if (clazz.getNbrRooms() > 0) {
            if (clazz.getExpectedCapacity() == clazz.getMaxExpectedCapacity()) {
                response.addProperty(MSG.propertyClassLimit()).add(clazz.getExpectedCapacity().toString());
            } else {
                response.addProperty(MSG.propertyMinimumClassLimit()).add(clazz.getExpectedCapacity().toString());
                response.addProperty(MSG.propertyMaximumClassLimit()).add(clazz.getMaxExpectedCapacity().toString());
            }
        }
        if (clazz.getSnapshotLimit() != null) {
            response.addProperty(MSG.propertySnapshotLimit()).add(clazz.getSnapshotLimit().toString());
        }
        response.addProperty(MSG.propertyNumberOfRooms()).add(clazz.getNbrRooms().toString());
        if (clazz.getNbrRooms() != 0) {
            c = response.addProperty(MSG.propertyRoomRatio());
            c.add(clazz.getRoomRatio().toString());
            c.add("( " + MSG.propertyMinimumRoomCapacity() + " " + clazz.getMinRoomLimit()).addStyle("padding-left: 20px;");
            if (clazz.getNbrRooms() > 1) {
                if (clazz.isRoomsSplitAttendance().booleanValue()) {
                    c.add(" " + MSG.descClassMultipleRoomsSplitAttendance());
                } else {
                    c.add(" " + MSG.descClassMultipleRoomsAlternativeAttendance());
                }
            }
            c.add(")");
        }
        if (clazz.getNbrRooms() > 1) {
            response.addProperty(MSG.propertyRoomSplitAttendance()).add(clazz.isRoomsSplitAttendance() != false ? MSG.descriptionClassMultipleRoomsSplitAttendance() : MSG.descriptionClassMultipleRoomsAlternativeAttendance(), true);
        }
        if (clazz.getLms() != null) {
            response.addProperty(MSG.propertyLms()).add(clazz.getLms().getLabel());
        }
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue() && (d = clazz.getEffectiveFundingDept()) != null) {
            response.addProperty(MSG.propertyFundingDept()).add(d.getLabel());
        }
        return response;
    }

    public static TableInterface.CellInterface toCell(ClassAssignmentDetails other) {
        TableInterface.CellInterface c = new TableInterface.CellInterface();
        c.add(other.getClazz().getName()).setUrl("clazz?id=" + other.getClazz().getClassId()).setClassName("link");
        c.add(" ");
        c.addItem(other.getTime().toCell());
        c.add(" ");
        c.add(other.getTime().getDatePatternName()).setColor(PreferenceLevel.int2color(other.getTime().getDatePatternPreference()));
        for (int i = 0; i < other.getRoom().length; ++i) {
            if (i > 0) {
                c.add(", ");
            } else {
                c.add(" ");
            }
            ClassAssignmentDetails.RoomInfo room = other.getRoom()[i];
            c.addItem(room.toCell());
        }
        return c;
    }

    public static TableInterface getAssignmentTable(SessionContext context, SolverProxy solver, ClassAssignmentDetails ca) {
        ClassAssignmentDetails.RoomInfo[] e;
        TableInterface.CellInterface c;
        TableInterface table = new TableInterface();
        table.setName(MSG.sectionTitleTimetable());
        if (ca.getTime() == null) {
            table.addProperty((String)null).setText(MSG.messageNotAssigned()).addStyle("font-style: italic;");
        } else {
            table.addProperty(MSG.propertyDate()).add(ca.getAssignedTime().getDatePatternName()).setColor(PreferenceLevel.int2color(ca.getAssignedTime().getDatePatternPreference()));
            table.addProperty(MSG.propertyTime()).addItem(ca.getAssignedTime().toCell());
            if (ca.getAssignedRoom() != null) {
                c = table.addProperty(MSG.propertyRoom());
                for (Serializable serializable : ca.getAssignedRoom()) {
                    if (c.hasItems()) {
                        c.add(", ");
                    }
                    c.addItem(((ClassAssignmentDetails.RoomInfo)serializable).toCell());
                }
            }
        }
        if (ca.getInstructor() != null) {
            c = table.addProperty(MSG.propertyInstructor());
            for (ClassAssignmentDetails.InstructorInfo instructorInfo : ca.getInstructor()) {
                if (c.hasItems()) {
                    c.add(", ");
                }
                c.add(instructorInfo.getName()).setUrl("instructorDetail.action?instructorId=" + instructorInfo.getId()).setClassName("link");
            }
            if (!ca.getBtbInstructors().isEmpty()) {
                e = ca.getBtbInstructors().elements();
                while (e.hasMoreElements()) {
                    ClassAssignmentDetails.BtbInstructorInfo btb = (ClassAssignmentDetails.BtbInstructorInfo)e.nextElement();
                    TableInterface.CellInterface o = table.addProperty("");
                    try {
                        ClassAssignmentDetails classAssignmentDetails = ClassAssignmentDetails.createClassAssignmentDetails(context, solver, btb.getOtherClassId(), false);
                        o.add(PreferenceLevel.int2string(btb.getPreference())).setColor(PreferenceLevel.int2color(btb.getPreference()));
                        o.add(" ");
                        o.addItem(ClassDetailBackend.toCell(classAssignmentDetails));
                    }
                    catch (Exception exception) {
                        Debug.error(exception);
                    }
                }
            }
        }
        if (ca.getInitialTime() != null) {
            c = table.addProperty(MSG.propertyInitialAssignment());
            if (ca.isInitial()) {
                c.add(MSG.messageThisOne()).addStyle("font-style: italic;");
            } else {
                c.addItem(ca.getInitialTime().toCell());
                c.add(" ");
                c.add(ca.getInitialTime().getDatePatternName()).setColor(PreferenceLevel.int2color(ca.getInitialTime().getDatePatternPreference()));
                for (ClassAssignmentDetails.RoomInfo roomInfo : ca.getInitialRoom()) {
                    if (c.hasItems() && c.getItems().size() > 3) {
                        c.add(", ");
                    } else {
                        c.add(" ");
                    }
                    c.addItem(roomInfo.toCell());
                }
            }
        }
        if (!ca.getStudentConflicts().isEmpty()) {
            c = table.addProperty(MSG.propertyStudentConflicts());
            Collections.sort(ca.getStudentConflicts(), new ClassAssignmentDetails.StudentConflictInfoComparator(context, solver));
            e = ca.getStudentConflicts().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.StudentConflictInfo std = (ClassAssignmentDetails.StudentConflictInfo)e.nextElement();
                if (std.getOther() == null) {
                    std.createOther(context, solver);
                }
                ClassAssignmentDetails other = std.getOther();
                TableInterface.CellInterface cellInterface = c.add(null).setInline(false);
                ArrayList<String> props = new ArrayList<String>();
                if (std.getInfo().isCommited()) {
                    props.add(GWT.studentConflictCommitted());
                }
                if (std.getInfo().isFixed()) {
                    props.add(GWT.studentConflictFixed());
                } else if (std.getInfo().isHard()) {
                    props.add(GWT.studentConflictHard());
                }
                if (std.getInfo().isDistance()) {
                    props.add(GWT.studentConflictDistance());
                }
                if (std.getInfo().isCommited()) {
                    other.getClazz().setPref(PreferenceLevel.sRequired);
                }
                if (std.getInfo().isImportant()) {
                    props.add(GWT.studentConflictImportant());
                }
                if (std.getInfo().isInstructor()) {
                    props.add(GWT.studentConflictInstructor());
                }
                cellInterface.add(new DecimalFormat("0").format(std.getInfo().getJenrl()));
                cellInterface.add("\u00d7 ");
                cellInterface.addItem(ClassDetailBackend.toCell(other));
                if (!props.isEmpty()) {
                    cellInterface.add(" " + String.valueOf(props)).addStyle("font-style: italic;");
                }
                if (std.getInfo().getCurriculumText() == null || std.getInfo().getCurriculumText().isEmpty()) continue;
                cellInterface.add(" " + std.getInfo().getCurriculumText()).addStyle("font-style: italic;");
            }
        }
        if (ca.hasViolatedGroupConstraint()) {
            c = table.addProperty(MSG.propertyViolatedConstraints());
            e = ca.getGroupConstraints().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.DistributionInfo gc = (ClassAssignmentDetails.DistributionInfo)e.nextElement();
                if (gc.getInfo().isSatisfied()) continue;
                TableInterface.CellInterface g = c.add(null);
                g.add(PreferenceLevel.prolog2string(gc.getInfo().getPreference())).setColor(PreferenceLevel.prolog2color(gc.getInfo().getPreference()));
                g.add(" " + gc.getInfo().getName());
                Enumeration enumeration = gc.getClassIds().elements();
                while (enumeration.hasMoreElements()) {
                    Long classId = (Long)enumeration.nextElement();
                    ClassAssignmentDetails other = ClassAssignmentDetails.createClassAssignmentDetails(context, solver, classId, false);
                    g.addItem(ClassDetailBackend.toCell(other).setInline(false));
                }
            }
        }
        return table;
    }

    public static TableInterface getConflictTable(SessionContext context, ClassAssignmentProxy proxy, Class_ clazz) {
        Set<ClassAssignmentProxy.AssignmentInfo> conflicts;
        Set<ClassAssignmentProxy.AssignmentInfo> set = conflicts = proxy == null ? null : proxy.getConflicts(clazz.getUniqueId());
        if (conflicts == null || conflicts.isEmpty()) {
            return null;
        }
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        TreeSet<ClassAssignmentProxy.AssignmentInfo> orderedConflicts = new TreeSet<ClassAssignmentProxy.AssignmentInfo>(new Comparator<ClassAssignmentProxy.AssignmentInfo>(){
            ClassComparator cc = new ClassComparator(5);

            @Override
            public int compare(ClassAssignmentProxy.AssignmentInfo a1, ClassAssignmentProxy.AssignmentInfo a2) {
                return this.cc.compare(a1.getClazz(), a2.getClazz());
            }
        });
        orderedConflicts.addAll(conflicts);
        boolean hasSnapshotLimit = false;
        for (ClassAssignmentProxy.AssignmentInfo assignmentInfo : orderedConflicts) {
            if (assignmentInfo.getClazz().getSnapshotLimit() == null) continue;
            hasSnapshotLimit = true;
            break;
        }
        boolean hasConflictingInstructors = false;
        block1: for (ClassAssignmentProxy.AssignmentInfo assignment : orderedConflicts) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (!instructor.isLead().booleanValue() || instructor.getInstructor().getExternalUniqueId() == null) continue;
                for (StudentClassEnrollment e : assignment.getClazz().getStudentEnrollments()) {
                    if (!instructor.getInstructor().getExternalUniqueId().equals(e.getStudent().getExternalUniqueId())) continue;
                    hasConflictingInstructors = true;
                    break block1;
                }
            }
        }
        TableInterface tableInterface = new TableInterface();
        tableInterface.setName(MSG.sectionTitleClassConflicts());
        TableInterface.LineInterface header = tableInterface.addHeader();
        header.addCell(MSG.columnClass());
        header.addCell(MSG.columnExternalId());
        header.addCell(MSG.columnDemand()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        if (hasSnapshotLimit) {
            header.addCell(MSG.columnSnapshotLimit()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
        }
        header.addCell(MSG.columnInstructor());
        header.addCell(MSG.columnDatePattern());
        header.addCell(MSG.columnAssignedTime());
        header.addCell(MSG.columnAssignedRoom());
        if (hasConflictingInstructors) {
            header.addCell(MSG.columnEnrollmentConflict());
        }
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
        }
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        for (ClassAssignmentProxy.AssignmentInfo assignment : orderedConflicts) {
            String suffix = assignment.getClazz().getClassSuffix();
            DatePattern dp = assignment.getDatePattern();
            TimeLocation t = assignment.getTimeLocation();
            Object time = "";
            if (t != null) {
                Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
                for (int i = 0; i < CONST.shortDays().length; ++i) {
                    int idx;
                    int n = idx = firstDay == null ? i : (i + firstDay) % 7;
                    if ((Constants.DAY_CODES[idx] & t.getDayCode()) == 0) continue;
                    time = (String)time + CONST.shortDays()[idx];
                }
                time = (String)time + " " + t.getStartTimeHeader(CONST.useAmPm()) + "-" + t.getEndTimeHeader(CONST.useAmPm());
            }
            TableInterface.CellInterface room = new TableInterface.CellInterface();
            for (Location r : assignment.getRooms()) {
                if (room.hasItems()) {
                    room.add(", ");
                }
                TableInterface.CellInterface c = room.add(r.getLabel());
                c.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + r.getUniqueId() + "', '');");
                c.setMouseOut("$wnd.hideGwtRoomHint();");
            }
            TableInterface.CellInterface instr = new TableInterface.CellInterface();
            TableInterface.CellInterface enrolled = new TableInterface.CellInterface();
            for (ClassInstructor ci : assignment.getClazz().getClassInstructors()) {
                TableInterface.CellInterface c = instr.add(ci.getInstructor().getName(nameFormat)).setInline(false);
                Object title = ci.getInstructor().getNameLastFirst();
                title = (String)title + " (" + (String)(ci.getResponsibility() == null ? "" : ci.getResponsibility().getLabel() + " ") + ci.getPercentShare() + "%" + (String)(ci.isLead() != false ? ", " + MSG.toolTipInstructorLead() : "") + ")";
                if (!ci.getClassInstructing().isDisplayInstructor().booleanValue()) {
                    c.addStyle("font-style: italic;");
                    title = (String)title + MSG.toolTipInstructorDoNotDisplay();
                }
                if (ci.isLead().booleanValue()) {
                    c.addStyle("font-weight: bold;");
                }
                c.setTitle((String)title);
                if (ci.getResponsibility() != null && ci.getResponsibility().getAbbreviation() != null && !ci.getResponsibility().getAbbreviation().isEmpty()) {
                    c.add(" (" + ci.getResponsibility().getAbbreviation() + ")");
                }
                if (!ci.isLead().booleanValue() || ci.getInstructor().getExternalUniqueId() == null) continue;
                for (StudentClassEnrollment e : assignment.getClazz().getStudentEnrollments()) {
                    if (!ci.getInstructor().getExternalUniqueId().equals(e.getStudent().getExternalUniqueId())) continue;
                    enrolled.add(e.getStudent().getName(nameFormat)).setInline(false);
                }
            }
            TableInterface.LineInterface line = tableInterface.addLine();
            line.setURL("clazz?id=" + assignment.getClazz().getUniqueId());
            line.addCell(assignment.getClazz().getClassLabel());
            line.addCell(suffix);
            line.addCell(assignment.getClazz().getEnrollment().toString());
            if (hasSnapshotLimit) {
                line.addCell(assignment.getClazz().getSnapshotLimit() == null ? null : assignment.getClazz().getSnapshotLimit().toString());
            }
            line.addCell(instr);
            if (dp == null) {
                line.addCell();
            } else {
                line.addCell(dp.getName()).setTitle(dateFormat.format(dp.getStartDate()) + " - " + dateFormat.format(dp.getEndDate()));
            }
            line.addCell((String)time);
            line.addCell(room);
            if (!hasConflictingInstructors) continue;
            line.addCell(enrolled);
        }
        return tableInterface;
    }

    public static TableInterface getEventConflictTable(SessionContext context, ClassAssignmentProxy proxy, Class_ clazz) {
        Set<RoomAvailabilityInterface.TimeBlock> ec;
        Set<RoomAvailabilityInterface.TimeBlock> set = ec = proxy == null ? null : proxy.getConflictingTimeBlocks(clazz.getUniqueId());
        if (ec == null || ec.isEmpty()) {
            return null;
        }
        TableInterface table = new TableInterface();
        table.setName(MSG.sectionTitleEventConflicts());
        TableInterface.LineInterface header = table.addHeader();
        header.addCell(MSG.columnEventName());
        header.addCell(MSG.columnEventType());
        header.addCell(MSG.columnEventDate());
        header.addCell(MSG.columnEventTime());
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
        }
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_MEETING);
        Formats.Format<Date> timeFormat = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        for (RoomAvailabilityInterface.TimeBlock block : ec) {
            DefaultRoomAvailabilityService.MeetingTimeBlock mtb;
            TableInterface.LineInterface line = table.addLine();
            if (block instanceof DefaultRoomAvailabilityService.MeetingTimeBlock && (mtb = (DefaultRoomAvailabilityService.MeetingTimeBlock)block).getEventId() != null && context.hasPermission(mtb.getEventId(), Right.EventDetail)) {
                line.setURL("events#event=" + mtb.getEventId());
            }
            line.addCell(block.getEventName());
            line.addCell(block.getEventType());
            line.addCell(dateFormat.format(block.getStartTime()));
            line.addCell(timeFormat.format(block.getStartTime()) + " - " + timeFormat.format(block.getEndTime()));
        }
        return table;
    }

    public static TableInterface getPreferenceTable(SessionContext context, Class_ clazz, Preference.Type ... types) {
        TableInterface preferences = SubpartDetailBackend.getPreferenceTable(context, clazz, types);
        if (preferences != null && clazz.getNbrRooms() > 0) {
            if (clazz.hasRoomIndexedPrefs()) {
                TableInterface table = new TableInterface();
                for (int roomIndex = 0; roomIndex < clazz.getNbrRooms(); ++roomIndex) {
                    TableInterface.CellInterface cell = table.addProperty(MSG.itemOnlyRoom(1 + roomIndex) + ":");
                    List<RoomLocation> roomLocations = TimetableDatabaseLoader.computeRoomLocations(clazz, roomIndex);
                    if (roomLocations.isEmpty()) {
                        cell.add(MSG.warnNoRoomsAreAvaliable()).setColor("red").addStyle("font-weight: bold;");
                        continue;
                    }
                    int idx = 0;
                    for (RoomLocation rl : roomLocations) {
                        if (idx > 0) {
                            cell.add(", ");
                        }
                        if (idx == 6) {
                            cell = cell.add(MSG.moreAvailableRooms(roomLocations.size() - 6)).setDots(true);
                        }
                        TableInterface.CellInterface c = cell.add(rl.getName());
                        c.setColor(PreferenceLevel.int2color(rl.getPreference()));
                        c.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + rl.getId() + "', '" + PreferenceLevel.int2string(rl.getPreference()) + "');");
                        c.setMouseOut("$wnd.hideGwtRoomHint();");
                        ++idx;
                    }
                }
                preferences.getProperties().add(preferences.getProperties().size() - 1, new TableInterface.PropertyInterface().setName(MSG.propertyAvailableRooms()).setCell(new TableInterface.CellInterface().setTable(table)));
            } else {
                List<RoomLocation> roomLocations = TimetableDatabaseLoader.computeRoomLocations(clazz);
                TableInterface.CellInterface cell = new TableInterface.CellInterface();
                preferences.getProperties().add(preferences.getProperties().size() - 1, new TableInterface.PropertyInterface().setName(MSG.propertyAvailableRooms()).setCell(cell));
                if (roomLocations.isEmpty()) {
                    cell.add(MSG.warnNoRoomsAreAvaliable()).setColor("red").addStyle("font-weight: bold;");
                } else {
                    if (roomLocations.size() < clazz.getNbrRooms()) {
                        cell.add(MSG.warnNotEnoughtRoomsAreAvaliable() + " ").setColor("red").addStyle("font-weight: bold;");
                    }
                    int idx = 0;
                    for (RoomLocation rl : roomLocations) {
                        if (idx > 0) {
                            cell.add(", ");
                        }
                        if (idx == 6) {
                            cell = cell.add(MSG.moreAvailableRooms(roomLocations.size() - 6)).setDots(true);
                        }
                        TableInterface.CellInterface c = cell.add(rl.getName());
                        c.setColor(PreferenceLevel.int2color(rl.getPreference()));
                        c.setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + rl.getId() + "', '" + PreferenceLevel.int2string(rl.getPreference()) + "');");
                        c.setMouseOut("$wnd.hideGwtRoomHint();");
                        ++idx;
                    }
                }
            }
        }
        return preferences;
    }
}

