/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=OfferingsInterface.ClassAssignmentsFilterRequest.class)
public class ClassAssignmentsFilterBackend
implements GwtRpcImplementation<OfferingsInterface.ClassAssignmentsFilterRequest, OfferingsInterface.ClassAssignmentsFilterResponse> {
    protected static CourseMessages MESSAGES = Localization.create(CourseMessages.class);
    protected static GwtMessages GWT = Localization.create(GwtMessages.class);

    @Override
    public OfferingsInterface.ClassAssignmentsFilterResponse execute(OfferingsInterface.ClassAssignmentsFilterRequest request, SessionContext context) {
        context.checkPermission(Right.ClassAssignments);
        OfferingsInterface.ClassAssignmentsFilterResponse filter = new OfferingsInterface.ClassAssignmentsFilterResponse();
        FilterInterface.FilterParameterInterface manager = new FilterInterface.FilterParameterInterface();
        manager.setName("filterManager");
        manager.setLabel(MESSAGES.filterManager());
        manager.setType("list");
        manager.setMultiSelect(true);
        manager.addOption("-2", MESSAGES.dropDeptDepartment());
        for (Department department : Department.findAllExternal(context.getUser().getCurrentAcademicSessionId())) {
            manager.addOption(department.getUniqueId().toString(), department.getExternalMgrAbbv() + " - " + department.getExternalMgrLabel());
        }
        manager.setDefaultValue(context.getUser().getProperty("ClassAssignments.filterManager"));
        manager.setMaxLinesToShow(3);
        filter.addParameter(manager);
        FilterInterface.FilterParameterInterface itype = new FilterInterface.FilterParameterInterface();
        itype.setName("filterIType");
        itype.setLabel(MESSAGES.filterInstructionalType());
        itype.addOption("", MESSAGES.dropITypeAll());
        for (ItypeDesc t : ItypeDesc.findAll(true)) {
            itype.addOption(t.getItype().toString(), t.getDesc());
        }
        itype.setDefaultValue(context.getUser().getProperty("ClassAssignments.filterIType", ""));
        filter.addParameter(itype);
        FilterInterface.FilterParameterInterface filterParameterInterface = new FilterInterface.FilterParameterInterface();
        filterParameterInterface.setName("filterInstructor");
        filterParameterInterface.setLabel(MESSAGES.filterInstructor());
        filterParameterInterface.setType("text");
        filterParameterInterface.setDefaultValue(context.getUser().getProperty("ClassAssignments.filterInstructor", ""));
        filter.addParameter(filterParameterInterface);
        FilterInterface.FilterParameterInterface days = new FilterInterface.FilterParameterInterface();
        days.setName("filterDayCode");
        days.setLabel(MESSAGES.filterAssignedTime());
        days.setType("dayCode");
        days.setDefaultValue(context.getUser().getProperty("ClassAssignments.filterDayCode", ""));
        filter.addParameter(days);
        FilterInterface.FilterParameterInterface startTime = new FilterInterface.FilterParameterInterface();
        startTime.setName("filterStartTime");
        startTime.setLabel(MESSAGES.filterAssignedTime());
        startTime.setType("time");
        startTime.setDefaultValue(context.getUser().getProperty("ClassAssignments.filterStartTime", ""));
        startTime.setPrefix(GWT.propFrom());
        startTime.setComposite(true);
        filter.addParameter(startTime);
        FilterInterface.FilterParameterInterface endTime = new FilterInterface.FilterParameterInterface();
        endTime.setName("filterEndTime");
        endTime.setLabel(MESSAGES.filterAssignedTime());
        endTime.setType("time");
        endTime.setDefaultValue(context.getUser().getProperty("ClassAssignments.filterEndTime", ""));
        endTime.setPrefix(GWT.propTo());
        endTime.setComposite(true);
        filter.addParameter(endTime);
        FilterInterface.FilterParameterInterface room = new FilterInterface.FilterParameterInterface();
        room.setName("filterAssignedRoom");
        room.setLabel(MESSAGES.filterAssignedRoom());
        room.setType("text");
        room.setDefaultValue(context.getUser().getProperty("ClassAssignments.filterAssignedRoom", ""));
        filter.addParameter(room);
        FilterInterface.FilterParameterInterface sortBy = new FilterInterface.FilterParameterInterface();
        sortBy.setName("sortBy");
        sortBy.setLabel(MESSAGES.filterSortBy());
        sortBy.setType("list");
        for (String name : ClassCourseComparator.getNames()) {
            sortBy.addOption(name, name);
        }
        sortBy.setDefaultValue(context.getUser().getProperty("ClassAssignments.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)));
        filter.addParameter(sortBy);
        FilterInterface.FilterParameterInterface sortByKeepSubparts = this.createToggle(context, "sortByKeepSubparts", MESSAGES.checkSortWithinSubparts(), true);
        sortByKeepSubparts.setLabel(MESSAGES.filterSortBy());
        filter.addParameter(sortByKeepSubparts);
        FilterInterface.FilterParameterInterface crossList = this.createToggle(context, "showCrossListedClasses", MESSAGES.showCrossListedClasses(), false);
        crossList.setLabel(MESSAGES.filterCrossList());
        filter.addParameter(crossList);
        FilterInterface.FilterParameterInterface includeCancelledClasses = this.createToggle(context, "includeCancelledClasses", MESSAGES.showCancelledClasses(), false);
        includeCancelledClasses.setLabel(MESSAGES.filterCancelledClasses());
        filter.addParameter(includeCancelledClasses);
        FilterInterface.FilterParameterInterface subjectArea = new FilterInterface.FilterParameterInterface();
        subjectArea.setName("subjectArea");
        subjectArea.setType("list");
        subjectArea.setMultiSelect(true);
        subjectArea.setCollapsible(false);
        subjectArea.setLabel(MESSAGES.filterSubject());
        for (SubjectArea subject : SubjectArea.getAllSubjectAreas(context.getUser().getCurrentAcademicSessionId())) {
            subjectArea.addOption(subject.getUniqueId().toString(), subject.getLabel());
        }
        subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.ClassAssignmentsSubjectAreas));
        if (subjectArea.getDefaultValue() == null) {
            subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsSubjectArea));
        }
        subjectArea.setEnterToSubmit(true);
        filter.addParameter(subjectArea);
        filter.setSticky(CommonValues.Yes.eq(UserProperty.StickyTables.get(context.getUser())));
        filter.setMaxSubjectsToSearchAutomatically(ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue());
        filter.setCanExport(context.hasPermission(Right.ClassAssignmentsExportCsv));
        filter.setCanExportPdf(context.hasPermission(Right.ClassAssignmentsExportPdf));
        filter.setSessionId(context.getUser().getCurrentAcademicSessionId());
        BackTracker.markForBack(context, null, null, false, true);
        return filter;
    }

    protected FilterInterface.FilterParameterInterface createToggle(SessionContext context, String name, String label, Boolean defaultValue) {
        FilterInterface.FilterParameterInterface toggle = new FilterInterface.FilterParameterInterface();
        toggle.setName(name);
        toggle.setLabel(MESSAGES.filterOptionalColumns());
        toggle.setType("boolean");
        toggle.setSuffix(label);
        toggle.setDefaultValue(context.getUser().getProperty("ClassAssignments." + name, defaultValue == null ? null : (defaultValue != false ? "1" : "0")));
        return toggle;
    }
}

