/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentAccomodationDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=accommodations]")
public class StudentAccommodations
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentAccommodation(), MESSAGES.pageStudentAccommodations());
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAccommodations')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 80, 10, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 50, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldStudents(), SimpleEditInterface.FieldType.students, 200, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1, 2);
        for (StudentAccomodation accomodation : StudentAccomodationDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(accomodation.getUniqueId());
            r.setField(0, accomodation.getExternalUniqueId());
            r.setField(1, accomodation.getAbbreviation());
            r.setField(2, accomodation.getName());
            Object students = "";
            for (Student student : new TreeSet<Student>(accomodation.getStudents())) {
                if (!((String)students).isEmpty()) {
                    students = (String)students + "\n";
                }
                students = (String)students + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
            }
            r.setField(3, (String)students, accomodation.getExternalUniqueId() == null);
            r.setDeletable(accomodation.getExternalUniqueId() == null);
        }
        data.setEditable(context.hasPermission(Right.StudentAccommodationEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAccommodationEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        for (StudentAccomodation accomodation : StudentAccomodationDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(accomodation.getUniqueId());
            if (r == null) {
                this.delete(accomodation, context, hibSession, studentIds);
                continue;
            }
            this.update(accomodation, r, context, hibSession, studentIds);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession, studentIds);
        }
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        StudentAccomodation accomodation = new StudentAccomodation();
        accomodation.setExternalUniqueId(record.getField(0));
        accomodation.setAbbreviation(record.getField(1));
        accomodation.setName(record.getField(2));
        accomodation.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        accomodation.setStudents(new HashSet<Student>());
        if (record.getField(3) != null) {
            Object students = "";
            for (String s : record.getField(3).split("\\n")) {
                Student student;
                if (s.indexOf(32) >= 0) {
                    s = s.substring(0, s.indexOf(32));
                }
                if (s.trim().isEmpty() || (student = Student.findByExternalId(context.getUser().getCurrentAcademicSessionId(), s.trim())) == null) continue;
                accomodation.getStudents().add(student);
                student.getAccomodations().add(accomodation);
                if (!((String)students).isEmpty()) {
                    students = (String)students + "\n";
                }
                students = (String)students + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
                studentIds.add(student.getUniqueId());
            }
            record.setField(3, (String)students, true);
        }
        hibSession.persist((Object)accomodation);
        record.setUniqueId(accomodation.getUniqueId());
        ChangeLog.addChange(hibSession, context, accomodation, accomodation.getAbbreviation() + " " + accomodation.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAccommodationEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.save(record, context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void update(StudentAccomodation accomodation, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        if (accomodation == null) {
            return;
        }
        boolean changed = !ToolBox.equals((Object)accomodation.getExternalUniqueId(), (Object)record.getField(0)) || !ToolBox.equals((Object)accomodation.getAbbreviation(), (Object)record.getField(1)) || !ToolBox.equals((Object)accomodation.getName(), (Object)record.getField(2));
        accomodation.setExternalUniqueId(record.getField(0));
        accomodation.setAbbreviation(record.getField(1));
        accomodation.setName(record.getField(2));
        if (accomodation.getExternalUniqueId() == null && record.getField(3) != null) {
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Student s : accomodation.getStudents()) {
                students.put(s.getExternalUniqueId(), s);
            }
            for (String line : record.getField(3).split("\\n")) {
                Student student;
                String extId = (line.indexOf(32) >= 0 ? line.substring(0, line.indexOf(32)) : line).trim();
                if (extId.isEmpty() || students.remove(extId) != null || (student = Student.findByExternalId(context.getUser().getCurrentAcademicSessionId(), extId)) == null) continue;
                accomodation.getStudents().add(student);
                student.getAccomodations().add(accomodation);
                changed = true;
                studentIds.add(student.getUniqueId());
            }
            if (!students.isEmpty()) {
                for (Student student : students.values()) {
                    studentIds.add(student.getUniqueId());
                    student.getAccomodations().remove(accomodation);
                }
                accomodation.getStudents().removeAll(students.values());
                changed = true;
            }
            Object newStudents = "";
            for (Student student : new TreeSet<Student>(accomodation.getStudents())) {
                if (!((String)newStudents).isEmpty()) {
                    newStudents = (String)newStudents + "\n";
                }
                newStudents = (String)newStudents + student.getExternalUniqueId() + " " + student.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle);
            }
            record.setField(3, (String)newStudents, accomodation.getExternalUniqueId() == null);
        }
        hibSession.merge((Object)accomodation);
        if (changed) {
            ChangeLog.addChange(hibSession, context, accomodation, accomodation.getAbbreviation() + " " + accomodation.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAccommodationEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.update((StudentAccomodation)StudentAccomodationDAO.getInstance().get(record.getUniqueId()), record, context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }

    protected void delete(StudentAccomodation accomodation, SessionContext context, org.hibernate.Session hibSession, Set<Long> studentIds) {
        if (accomodation == null) {
            return;
        }
        if (accomodation.getStudents() != null) {
            for (Student student : accomodation.getStudents()) {
                studentIds.add(student.getUniqueId());
                student.getAccomodations().remove(accomodation);
            }
        }
        ChangeLog.addChange(hibSession, context, accomodation, accomodation.getAbbreviation() + " " + accomodation.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)accomodation);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentAccommodationEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        HashSet<Long> studentIds = new HashSet<Long>();
        this.delete((StudentAccomodation)StudentAccomodationDAO.getInstance().get(record.getUniqueId()), context, hibSession, studentIds);
        if (!studentIds.isEmpty()) {
            StudentSectioningQueue.studentChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), studentIds);
        }
    }
}

