/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashSet;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.PosMajorDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=major]")
public class Majors
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageMajor(), MESSAGES.pageMajors());
    }

    @Override
    @PreAuthorize(value="checkPermission('Majors')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> areas = new ArrayList<SimpleEditInterface.ListItem>();
        for (AcademicArea area : AcademicAreaDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            areas.add(new SimpleEditInterface.ListItem(area.getUniqueId().toString(), area.getAcademicAreaAbbreviation() + " - " + area.getTitle()));
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 100, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldAcademicArea(), SimpleEditInterface.FieldType.list, 300, areas, new SimpleEditInterface.Flag[0]));
        data.setSortBy(3, 1, 2);
        for (PosMajor major : PosMajorDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(major.getUniqueId());
            r.setField(0, major.getExternalUniqueId());
            r.setField(1, major.getCode());
            r.setField(2, major.getName());
            r.setDeletable(major.getExternalUniqueId() == null && !major.isUsed(hibSession));
            for (AcademicArea area : major.getAcademicAreas()) {
                r.setField(3, area.getUniqueId().toString());
            }
        }
        data.setEditable(context.hasPermission(Right.MajorEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('MajorEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (PosMajor major : PosMajorDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(major.getUniqueId());
            if (r == null) {
                this.delete(major, context, hibSession);
                continue;
            }
            this.update(major, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('MajorEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        PosMajor major = new PosMajor();
        major.setExternalUniqueId(record.getField(0));
        major.setCode(record.getField(1));
        major.setName(record.getField(2));
        major.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        major.setAcademicAreas(new HashSet<AcademicArea>());
        for (String areaId : record.getValues(3)) {
            AcademicArea area = (AcademicArea)AcademicAreaDAO.getInstance().get(Long.valueOf(areaId), hibSession);
            major.getAcademicAreas().add(area);
            area.getPosMajors().add(major);
        }
        hibSession.persist((Object)major);
        record.setUniqueId(major.getUniqueId());
        ChangeLog.addChange(hibSession, context, major, major.getCode() + " " + major.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(PosMajor major, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (major == null) {
            return;
        }
        boolean changed = !ToolBox.equals((Object)major.getExternalUniqueId(), (Object)record.getField(0)) || !ToolBox.equals((Object)major.getCode(), (Object)record.getField(1)) || !ToolBox.equals((Object)major.getName(), (Object)record.getField(2));
        major.setExternalUniqueId(record.getField(0));
        major.setCode(record.getField(1));
        major.setName(record.getField(2));
        HashSet<AcademicArea> delete = new HashSet<AcademicArea>(major.getAcademicAreas());
        for (String areaId : record.getValues(3)) {
            AcademicArea area = (AcademicArea)AcademicAreaDAO.getInstance().get(Long.valueOf(areaId), hibSession);
            if (delete.remove(area)) continue;
            major.getAcademicAreas().add(area);
            area.getPosMajors().add(major);
            changed = true;
        }
        for (AcademicArea area : delete) {
            major.getAcademicAreas().remove(area);
            area.getPosMajors().remove(major);
            changed = true;
        }
        hibSession.merge((Object)major);
        if (changed) {
            ChangeLog.addChange(hibSession, context, major, major.getCode() + " " + major.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('MajorEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((PosMajor)PosMajorDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(PosMajor major, SessionContext context, org.hibernate.Session hibSession) {
        if (major == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, major, major.getCode() + " " + major.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)major);
    }

    @Override
    @PreAuthorize(value="checkPermission('MajorEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((PosMajor)PosMajorDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

