/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.solver.service.SolverServerService;

@Service(value="gwtAdminTable[type=logging]")
public class Loggers
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverServerService solverServerService;

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageLoggingLevel(), MESSAGES.pageLoggingLevels());
    }

    @Override
    @PreAuthorize(value="checkPermission('ApplicationConfig')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> levels = new ArrayList<SimpleEditInterface.ListItem>();
        levels.add(new SimpleEditInterface.ListItem(Level.ALL.name(), MESSAGES.levelAll()));
        levels.add(new SimpleEditInterface.ListItem(Level.TRACE.name(), MESSAGES.levelTrace()));
        levels.add(new SimpleEditInterface.ListItem(Level.DEBUG.name(), MESSAGES.levelDebug()));
        levels.add(new SimpleEditInterface.ListItem(Level.INFO.name(), MESSAGES.levelInfo()));
        levels.add(new SimpleEditInterface.ListItem(Level.WARN.name(), MESSAGES.levelWarning()));
        levels.add(new SimpleEditInterface.ListItem(Level.ERROR.name(), MESSAGES.levelError()));
        levels.add(new SimpleEditInterface.ListItem(Level.FATAL.name(), MESSAGES.levelFatal()));
        levels.add(new SimpleEditInterface.ListItem(Level.OFF.name(), MESSAGES.levelOff()));
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldLogger(), SimpleEditInterface.FieldType.text, 400, 1024, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldLevel(), SimpleEditInterface.FieldType.list, 100, levels, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(0, 1);
        long id = 0L;
        SimpleEditInterface.Record root = data.addRecord(id++, false);
        root.setField(0, " root", false);
        root.setField(1, LogManager.getRootLogger().getLevel().name());
        LoggerContext cx = LoggerContext.getContext((boolean)false);
        for (Map.Entry e : cx.getConfiguration().getLoggers().entrySet()) {
            String name = (String)e.getKey();
            Level level = ((LoggerConfig)e.getValue()).getLevel();
            if (level == null || name.isEmpty()) continue;
            ApplicationConfig config = ApplicationConfig.getConfig("log4j.logger." + name);
            SimpleEditInterface.Record record = data.addRecord(id++, ApplicationProperties.getDefaultProperties().getProperty("log4j.logger." + name) == null && config != null);
            record.setField(0, name, false);
            record.setField(1, level.name());
        }
        data.setEditable(context.hasPermission(Right.ApplicationConfig));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('ApplicationConfig')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        HashMap<String, SimpleEditInterface.Record> records = new HashMap<String, SimpleEditInterface.Record>();
        for (SimpleEditInterface.Record r : data.getRecords()) {
            boolean root;
            if (r.isEmpty(data)) continue;
            boolean bl = root = r.getUniqueId() != null && r.getUniqueId() == 0L;
            if (root) {
                this.update(r, context, hibSession);
                continue;
            }
            records.put(r.getField(0), r);
        }
        LoggerContext cx = LoggerContext.getContext((boolean)false);
        for (Map.Entry e : cx.getConfiguration().getLoggers().entrySet()) {
            String name = (String)e.getKey();
            Level level = ((LoggerConfig)e.getValue()).getLevel();
            if (level == null || name.isEmpty()) continue;
            SimpleEditInterface.Record r = (SimpleEditInterface.Record)records.get(name);
            if (r == null) {
                this.delete(name, context, hibSession);
                continue;
            }
            this.update(r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ApplicationConfig')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update(record, context, hibSession);
        record.setUniqueId(System.currentTimeMillis());
    }

    @Override
    @PreAuthorize(value="checkPermission('ApplicationConfig')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        boolean root = record.getUniqueId() != null && record.getUniqueId() == 0L;
        Level level = Level.getLevel((String)record.getField(1));
        this.solverServerService.setLoggingLevel(root ? null : record.getField(0), level == null ? null : level.name());
        record.setUniqueId(root ? 0L : System.currentTimeMillis());
        String defaultValue = ApplicationProperties.getDefaultProperties().getProperty((String)(root ? "log4j.rootLogger" : "log4j.logger." + record.getField(0)));
        if (defaultValue != null && defaultValue.indexOf(44) > 0) {
            defaultValue = defaultValue.substring(0, defaultValue.indexOf(44)).trim();
        }
        ApplicationConfig config = ApplicationConfig.getConfig((String)(root ? "log4j.logger.root" : "log4j.logger." + record.getField(0)));
        if (level.toString().equalsIgnoreCase(defaultValue)) {
            if (config != null) {
                hibSession.remove((Object)config);
            }
        } else {
            if (config == null) {
                config = new ApplicationConfig();
                config.setKey((String)(root ? "log4j.logger.root" : "log4j.logger." + record.getField(0)));
                config.setDescription(MESSAGES.descriptionLoggingLevelFor(record.getField(0)));
            }
            config.setValue(level.toString());
            hibSession.merge((Object)config);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ApplicationConfig')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        boolean root = record.getUniqueId() != null && record.getUniqueId() == 0L;
        this.solverServerService.setLoggingLevel(root ? null : record.getField(0), null);
        ApplicationConfig config = ApplicationConfig.getConfig((String)(root ? "log4j.logger.root" : "log4j.logger." + record.getField(0)));
        if (config != null) {
            hibSession.remove((Object)config);
        }
    }

    protected void delete(String name, SessionContext context, Session hibSession) {
        boolean root = " root".equals(name);
        this.solverServerService.setLoggingLevel(root ? null : name, null);
        ApplicationConfig config = ApplicationConfig.getConfig((String)(root ? "log4j.logger.root" : "log4j.logger." + name));
        if (config != null) {
            hibSession.remove((Object)config);
        }
    }
}

