/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashSet;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseTimetableManager;
import org.unitime.timetable.model.dao.DepartmentStatusTypeDAO;
import org.unitime.timetable.model.dao.ExamStatusDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

@Service(value="gwtAdminTable[type=examStatus]")
public class ExaminationStatuses
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageExaminationStatus(), MESSAGES.pageExaminationStatuses());
    }

    @Override
    @PreAuthorize(value="checkPermission('ExaminationStatuses')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        Long sessionId = context.getUser().getCurrentAcademicSessionId();
        ArrayList<SimpleEditInterface.ListItem> managers = new ArrayList<SimpleEditInterface.ListItem>();
        NameFormat nf = NameFormat.fromReference(context.getUser().getProperty(UserProperty.NameFormat));
        for (Object m : ExamStatusDAO.getInstance().getSession().createQuery("select distinct m from TimetableManager m inner join m.departments d inner join m.managerRoles mr where d.session.uniqueId = :sessionId and mr.role.enabled = true and :prmExMgr in elements(mr.role.rights) and :prmAdmin not in elements(mr.role.rights) order by m.lastName, m.firstName", TimetableManager.class).setParameter("sessionId", (Object)sessionId).setParameter("prmExMgr", (Object)Right.ExaminationSolver.name()).setParameter("prmAdmin", (Object)Right.StatusIndependent.name()).setCacheable(true).list()) {
            managers.add(new SimpleEditInterface.ListItem(((BaseTimetableManager)m).getUniqueId().toString(), nf.format((NameInterface)m)));
        }
        ArrayList<SimpleEditInterface.ListItem> states = new ArrayList<SimpleEditInterface.ListItem>();
        states.add(new SimpleEditInterface.ListItem("-1", MESSAGES.examStatusDefault()));
        for (DepartmentStatusType t : DepartmentStatusType.findAll(DepartmentStatusType.Apply.ExamStatus.toInt())) {
            states.add(new SimpleEditInterface.ListItem(t.getUniqueId().toString(), t.getLabel()));
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldType(), SimpleEditInterface.FieldType.text, 160, 60, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldStatus(), SimpleEditInterface.FieldType.list, 250, states, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldManager(), SimpleEditInterface.FieldType.multi, 300, managers, new SimpleEditInterface.Flag[0]));
        data.setSortBy(0);
        data.setAddable(false);
        boolean independent = context.hasPermission(Right.StatusIndependent);
        for (ExamType xtype : ExamTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(xtype.getUniqueId(), false);
            ExamStatus s = ExamStatus.findStatus(sessionId, xtype.getUniqueId());
            boolean editable = true;
            if (!independent && s != null && !s.getManagers().isEmpty()) {
                editable = false;
                for (TimetableManager m : s.getManagers()) {
                    if (!context.getUser().getCurrentAuthority().hasQualifier(m)) continue;
                    editable = true;
                    break;
                }
            }
            r.setField(0, xtype.getLabel());
            r.setField(1, s == null || s.getStatus() == null ? "-1" : s.getStatus().getUniqueId().toString(), editable);
            r.setField(2, null, editable && independent);
            if (s == null) continue;
            for (TimetableManager m : s.getManagers()) {
                r.addToField(2, m.getUniqueId().toString());
            }
        }
        data.setEditable(context.hasPermission(Right.ExaminationStatusEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('ExaminationStatusEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (ExamType type : ExamTypeDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) continue;
            this.update(type, r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ExaminationStatusEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
    }

    protected void update(ExamType type, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (type == null) {
            return;
        }
        ExamStatus status = ExamStatus.findStatus(context.getUser().getCurrentAcademicSessionId(), type.getUniqueId());
        boolean changed = false;
        if (status == null) {
            status = new ExamStatus();
            status.setType(type);
            status.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()));
            status.setManagers(new HashSet<TimetableManager>());
            changed = true;
        }
        if (!ToolBox.equals((Object)(status.getStatus() == null ? "-1" : status.getStatus().getUniqueId().toString()), (Object)record.getField(1))) {
            status.setStatus("-1".equals(record.getField(1)) ? null : (DepartmentStatusType)DepartmentStatusTypeDAO.getInstance().get(Long.valueOf(record.getField(1))));
            changed = true;
        }
        HashSet<TimetableManager> managers = new HashSet<TimetableManager>(status.getManagers());
        for (String id : record.getValues(2)) {
            TimetableManager m = (TimetableManager)TimetableManagerDAO.getInstance().get(Long.valueOf(id));
            if (managers.remove(m)) continue;
            status.getManagers().add(m);
            changed = true;
        }
        if (!managers.isEmpty()) {
            status.getManagers().removeAll(managers);
            changed = true;
        }
        if (!changed) {
            return;
        }
        hibSession.merge((Object)status);
        ChangeLog.addChange(hibSession, context, status.getType(), status.getType().getLabel() + (String)(status.getStatus() == null ? "" : ": " + status.getStatus().getLabel()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('ExaminationStatusEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((ExamType)ExamTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    @Override
    @PreAuthorize(value="checkPermission('ExaminationStatusEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
    }
}

