/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.stereotype.Service;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;

@Service(value="permissionDepartment")
public class SimpleDepartmentPermission
implements Permission.PermissionDepartment {
    @Override
    public boolean check(UserContext user, Department department) {
        return this.check(user, department, new DepartmentStatusType.Status[0]) && this.checkStatus(department.effectiveStatusType());
    }

    @Override
    public boolean check(UserContext user, Department department, DepartmentStatusType.Status ... status) {
        if (user == null || user.getCurrentAuthority() == null || department == null) {
            return false;
        }
        UserAuthority authority = user.getCurrentAuthority();
        if (!authority.hasRight(Right.SessionIndependent) && !authority.hasQualifier(department.getSession())) {
            return false;
        }
        if (!authority.hasRight(Right.DepartmentIndependent) && !authority.hasQualifier(department)) {
            return false;
        }
        if (status.length > 0 && !authority.hasRight(Right.StatusIndependent)) {
            DepartmentStatusType type = department.effectiveStatusType();
            if (type == null) {
                return false;
            }
            for (DepartmentStatusType.Status s : status) {
                if (!type.can(s)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Class<Department> type() {
        return Department.class;
    }

    public boolean checkStatus(DepartmentStatusType status) {
        return true;
    }

    @Override
    public boolean check(UserContext user, Department controllingDepartment, DepartmentStatusType.Status ownerStatus, Department managingDepartment, DepartmentStatusType.Status managerStatus) {
        UserAuthority authority;
        if (user == null || user.getCurrentAuthority() == null || controllingDepartment == null) {
            return false;
        }
        if (managingDepartment == null) {
            managingDepartment = controllingDepartment;
        }
        if (!(authority = user.getCurrentAuthority()).hasRight(Right.SessionIndependent) && !authority.hasQualifier(controllingDepartment.getSession())) {
            return false;
        }
        if (!(authority.hasRight(Right.DepartmentIndependent) || authority.hasQualifier(controllingDepartment) || authority.hasQualifier(managingDepartment))) {
            return false;
        }
        if (!(ownerStatus == null && managerStatus == null || authority.hasRight(Right.StatusIndependent))) {
            DepartmentStatusType type = managingDepartment.effectiveStatusType(controllingDepartment);
            if (ownerStatus != null && authority.hasQualifier(controllingDepartment) && type.can(ownerStatus)) {
                return true;
            }
            return managerStatus != null && authority.hasQualifier(managingDepartment) && type.can(managerStatus);
        }
        return true;
    }
}

