/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseChangeLog;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class StudentExamReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(StudentExamReport.class);
    Hashtable<Long, Student> iStudents = null;
    Hashtable<Long, ClassEvent> iClass2event = null;
    Hashtable<Long, Location> iLocations = null;

    public StudentExamReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legactReportStudentExaminationSchedule(), session, examType, subjectAreas, exams);
    }

    public StudentExamReport(int mode, OutputStream out, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, out, MSG.legactReportStudentExaminationSchedule(), session, examType, subjectAreas, exams);
    }

    private void generateCache() {
        if (this.iStudents == null) {
            sLog.info((Object)MSG.statusLoadingStudents());
            this.iStudents = new Hashtable();
            for (Student s : StudentDAO.getInstance().getSession().createQuery("select s from Student s where s.session.uniqueId=:sessionId", Student.class).setParameter("sessionId", (Object)this.getSession().getUniqueId()).setCacheable(true).list()) {
                this.iStudents.put(s.getUniqueId(), s);
            }
        }
        if (this.iClass2event == null) {
            sLog.info((Object)MSG.statusLoadingClassEvents());
            this.iClass2event = new Hashtable();
            if (this.hasSubjectAreas()) {
                for (SubjectArea subject : this.getSubjectAreas()) {
                    for (Object[] o : SessionDAO.getInstance().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId=:subjectAreaId", Object[].class).setParameter("subjectAreaId", (Object)subject.getUniqueId()).setCacheable(true).list()) {
                        this.iClass2event.put((Long)o[0], (ClassEvent)o[1]);
                    }
                }
            } else {
                for (Object[] o : SessionDAO.getInstance().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.session.uniqueId=:sessionId", Object[].class).setParameter("sessionId", (Object)this.getSession().getUniqueId()).setCacheable(true).list()) {
                    this.iClass2event.put((Long)o[0], (ClassEvent)o[1]);
                }
            }
        }
        if (this.iLocations == null) {
            sLog.info((Object)MSG.statusLoadingLocations());
            this.iLocations = new Hashtable();
            for (Location location : SessionDAO.getInstance().getSession().createQuery("select r from Room r where r.session.uniqueId=:sessionId and r.permanentId is not null", Location.class).setParameter("sessionId", (Object)this.getSession().getUniqueId()).setCacheable(true).list()) {
                this.iLocations.put(location.getPermanentId(), location);
            }
            for (Location location : SessionDAO.getInstance().getSession().createQuery("select r from NonUniversityLocation r where r.session.uniqueId=:sessionId and r.permanentId is not null", Location.class).setParameter("sessionId", (Object)this.getSession().getUniqueId()).setCacheable(true).list()) {
                this.iLocations.put(location.getPermanentId(), location);
            }
        }
    }

    public boolean isOfSubjectArea(TreeSet<ExamInfo.ExamSectionInfo> sections) {
        for (ExamInfo.ExamSectionInfo section : sections) {
            if (!this.hasSubjectArea(section)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void printReport() throws DocumentException {
        this.generateCache();
        sLog.info((Object)MSG.statusPrintingReport());
        Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>> sections = new Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                for (Long studentId : section.getStudentIds()) {
                    Student student = this.iStudents.get(studentId);
                    TreeSet<ExamInfo.ExamSectionInfo> sectionsThisStudent = (TreeSet<ExamInfo.ExamSectionInfo>)sections.get(student);
                    if (sectionsThisStudent == null) {
                        sectionsThisStudent = new TreeSet<ExamInfo.ExamSectionInfo>();
                        sections.put(student, sectionsThisStudent);
                    }
                    sectionsThisStudent.add(section);
                }
            }
        }
        this.printHeader();
        int index = 0;
        for (Student student : new TreeSet(sections.keySet())) {
            ChangeLog last;
            TreeSet sectionsThisStudent = (TreeSet)sections.get(student);
            if (!this.isOfSubjectArea(sectionsThisStudent)) continue;
            if (this.iSince != null && ((last = this.getLastChange(sectionsThisStudent)) == null || this.iSince.compareTo(last.getTimeStamp()) > 0)) {
                sLog.debug((Object)MSG.logNoChangesFoundFor(student.getName(DepartmentalInstructor.sNameFormatLastFist)));
                continue;
            }
            if (index > 0) {
                this.newPage();
            }
            this.printReport(student, sectionsThisStudent);
            if (++index % 100 != 0) continue;
            sLog.debug((Object)("  " + index + " students printed"));
        }
        this.lastPage();
    }

    public void printReport(Long studentId) throws DocumentException {
        TreeSet<ExamInfo.ExamSectionInfo> sections = new TreeSet<ExamInfo.ExamSectionInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!section.getStudentIds().contains(studentId)) continue;
                sections.add(section);
            }
        }
        if (sections.isEmpty()) {
            return;
        }
        Student student = (Student)StudentDAO.getInstance().get(studentId);
        this.printHeader();
        this.printReport(student, sections);
        this.lastPage();
    }

    public void printReport(Student student, TreeSet<ExamInfo.ExamSectionInfo> sections) throws DocumentException {
        String name = student.getName(DepartmentalInstructor.sNameFormatLastFist);
        String shortName = student.getName(DepartmentalInstructor.sNameFormatLastInitial).toUpperCase();
        this.setPageName(shortName);
        this.setCont(shortName);
        this.println(this.rpad(MSG.lrPropStudent(), 12), new AbstractReport.Cell(name).withColSpan(9));
        if (student.getEmail() != null) {
            this.println(this.rpad(MSG.lrPropEmail(), 12), new AbstractReport.Cell(student.getEmail()).withColSpan(9));
        }
        if (this.iClassSchedule) {
            StudentClassComparator scc = new StudentClassComparator(student);
            TreeSet<Class_> allClasses = new TreeSet<Class_>(scc);
            for (StudentClassEnrollment sce : student.getClassEnrollments()) {
                allClasses.add(sce.getClazz());
            }
            if (!allClasses.isEmpty()) {
                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDates(), 25), this.rpad(MSG.lrTime(), 15), this.rpad(MSG.lrRoom(), 11), this.rpad(MSG.lrInstructor(), 45)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 15), this.lpad("", '-', 11), this.lpad("", '-', 45)));
                this.println();
                this.println(this.mpad(MSG.lrSectClassSchedule(), this.getNrCharsPerLine()).withColSpan(10));
                this.printHeader(false);
                for (Class_ clazz : allClasses) {
                    ClassEvent event;
                    Object instructor = "";
                    if (clazz.isDisplayInstructor().booleanValue()) {
                        for (ClassInstructor ci : new TreeSet<ClassInstructor>(clazz.getClassInstructors())) {
                            if (((String)instructor).length() > 0) {
                                instructor = (String)instructor + ", ";
                            }
                            instructor = (String)instructor + ci.getInstructor().getName(DepartmentalInstructor.sNameFormatLastInitial);
                        }
                    }
                    CourseOffering correctedCourse = scc.getCourse(clazz);
                    String subject = correctedCourse.getSubjectAreaAbbv();
                    String course = correctedCourse.getCourseNbr();
                    String itype = this.getItype(correctedCourse, clazz);
                    String string = this.iUseClassSuffix && clazz.getClassSuffix() != null ? clazz.getClassSuffix() : clazz.getSectionNumberString();
                    ClassEvent classEvent = event = this.iClass2event == null ? clazz.getEvent() : this.iClass2event.get(clazz.getUniqueId());
                    if (event == null && this.iClass2event != null && !this.hasSubjectArea(subject)) {
                        event = clazz.getEvent();
                    }
                    if (event == null || event.getMeetings().isEmpty()) {
                        this.println(this.rpad(subject, 7), this.rpad(course, 8), this.iItype ? this.rpad(itype, 6) : NULL, this.rpad(string, 9), this.rpad(MSG.lrArrangedHours(), 53).withColSpan(3), this.rpad((String)instructor, 45));
                        continue;
                    }
                    Event.MultiMeeting last = null;
                    String lastTime = null;
                    String lastDate = null;
                    AbstractReport.Cell lastLoc = null;
                    for (Event.MultiMeeting meeting : event.getMultiMeetings()) {
                        AbstractReport.Cell loc;
                        Location location;
                        ArrayList<AbstractReport.Cell> line = new ArrayList<AbstractReport.Cell>();
                        if (last == null) {
                            line.add(this.rpad(subject, 7));
                            line.add(this.rpad(course, 8));
                            line.add(this.iItype ? this.rpad(itype, 6) : NULL);
                            line.add(this.rpad(string, 9));
                        } else {
                            line.add(this.rpad("", 26 + (this.iItype ? 7 : 0)).withColSpan(this.iItype ? 4 : 3));
                        }
                        String date = this.getMeetingDate(meeting);
                        String time = this.getMeetingTime(meeting.getMeetings().first());
                        if (last == null || !time.equals(lastTime) || !date.equals(lastDate)) {
                            line.add(this.rpad(date.equals(lastDate) ? "" : date, 25));
                            line.add(this.rpad(time.equals(lastTime) ? "" : time, 15));
                        } else {
                            line.add(this.rpad("", 41).withColSpan(2));
                        }
                        Long permId = meeting.getMeetings().first().getLocationPermanentId();
                        Location location2 = permId == null ? null : (location = this.iLocations == null ? meeting.getMeetings().first().getLocation() : this.iLocations.get(permId));
                        if (location == null && this.iLocations != null && !this.hasSubjectArea(subject)) {
                            location = meeting.getMeetings().first().getLocation();
                        }
                        AbstractReport.Cell cell = loc = location == null ? this.rpad("", 11) : this.formatRoom(location);
                        if (last == null || !loc.equals(lastLoc)) {
                            line.add(loc);
                        } else {
                            line.add(this.rpad("", 11));
                        }
                        if (last == null) {
                            line.add(this.rpad((String)instructor, 45));
                        } else {
                            line.add(this.rpad("", 45));
                        }
                        lastLoc = loc;
                        lastTime = time;
                        lastDate = date;
                        last = meeting;
                        this.println(line.toArray(new AbstractReport.Cell[line.size()]));
                        if (!this.iNewPage) continue;
                        last = null;
                        lastTime = null;
                        lastDate = null;
                        lastLoc = null;
                    }
                }
            }
        }
        this.setHeaderLine(new AbstractReport.Line[0]);
        if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
            this.newPage();
        }
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrMeetingTimes(), 36), this.rpad(MSG.lrDateAndTime(), 30), this.rpad(MSG.lrRoom(), 11)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 36), this.lpad("", '-', 30), this.lpad("", '-', 11)));
        this.println();
        this.println(this.mpad(MSG.lrSectExaminationSchedule(), this.getNrCharsPerLine()).withColSpan(10));
        this.printHeader(false);
        this.iSubjectPrinted = false;
        String lastSubject = null;
        this.iCoursePrinted = false;
        String lastCourse = null;
        this.iITypePrinted = false;
        String lastItype = null;
        this.iPeriodPrinted = false;
        String lastSection = null;
        for (ExamInfo.ExamSectionInfo section : sections) {
            if (this.iSubjectPrinted && !section.getSubject().equals(lastSubject)) {
                this.iSubjectPrinted = false;
                this.iCoursePrinted = false;
                this.iITypePrinted = false;
                this.iPeriodPrinted = false;
            }
            if (this.iCoursePrinted && !section.getCourseNbr().equals(lastCourse)) {
                this.iCoursePrinted = false;
                this.iITypePrinted = false;
                this.iPeriodPrinted = false;
            }
            if (this.iITypePrinted && !section.getItype().equals(lastItype)) {
                this.iITypePrinted = false;
                this.iPeriodPrinted = false;
            }
            if (this.iPeriodPrinted && !section.getSection().equals(lastSection)) {
                this.iPeriodPrinted = false;
            }
            if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iITypePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(this.iPeriodPrinted ? "" : section.getSection(), 9), this.rpad(this.getMeetingTime(section), 36), this.rpad(section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength(), 30), new AbstractReport.Cell(section.getExamAssignment() == null ? "" : this.iNoRoom));
            } else {
                if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                    this.newPage();
                }
                boolean firstRoom = true;
                for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                    AbstractReport.Cell[] cellArray = new AbstractReport.Cell[7];
                    cellArray[0] = this.rpad(!firstRoom || this.iSubjectPrinted ? "" : section.getSubject(), 7);
                    cellArray[1] = this.rpad(!firstRoom || this.iCoursePrinted ? "" : section.getCourseNbr(), 8);
                    cellArray[2] = this.iItype ? this.rpad(!firstRoom || this.iITypePrinted ? "" : section.getItype(), 6) : NULL;
                    cellArray[3] = this.rpad(!firstRoom || this.iPeriodPrinted ? "" : section.getSection(), 9);
                    AbstractReport.Cell cell = cellArray[4] = !firstRoom ? this.rpad("", 36) : this.rpad(this.getMeetingTime(section), 36);
                    cellArray[5] = this.rpad(!firstRoom ? "" : (section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength()), 30);
                    cellArray[6] = this.formatRoom(room);
                    this.println(cellArray);
                    firstRoom = false;
                }
            }
            if (this.iNewPage) {
                this.iPeriodPrinted = false;
                this.iCoursePrinted = false;
                this.iITypePrinted = false;
                this.iSubjectPrinted = false;
                lastSection = null;
                lastCourse = null;
                lastItype = null;
                lastSubject = null;
                continue;
            }
            this.iPeriodPrinted = true;
            this.iCoursePrinted = true;
            this.iITypePrinted = true;
            this.iSubjectPrinted = true;
            lastSubject = section.getSubject();
            lastItype = section.getItype();
            lastCourse = section.getCourseNbr();
            lastSection = section.getSection();
        }
        boolean headerPrinted = false;
        lastSubject = null;
        for (ExamInfo.ExamSectionInfo section : sections) {
            boolean bl = this.iSubjectPrinted = !this.iNewPage && lastSubject != null && lastSubject.equals(section.getSubject());
            ExamAssignmentInfo exam = section.getExamAssignmentInfo();
            if (exam == null || exam.getPeriod() == null) continue;
            this.iCoursePrinted = false;
            if (this.iDirect) {
                for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                    if (!directConflict.getStudents().contains(student.getUniqueId())) continue;
                    this.iPeriodPrinted = false;
                    if (directConflict.getOtherExam() != null) {
                        for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!other.getStudentIds().contains(student.getUniqueId())) continue;
                            if (!headerPrinted) {
                                this.setHeaderLine(new AbstractReport.Line[0]);
                                if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                    this.newPage();
                                }
                                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                                if (!this.iNewPage) {
                                    this.println();
                                }
                                this.println(this.mpad(MSG.lrSectExaminationConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                                this.printHeader(false);
                                this.setCont(MSG.lrExaminationConflicts(shortName));
                                headerPrinted = true;
                            }
                            this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : section.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrDIRECT(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                            lastSubject = section.getSubject();
                        }
                        continue;
                    }
                    if (directConflict.getOtherEventId() == null) continue;
                    if (!headerPrinted) {
                        this.setHeaderLine(new AbstractReport.Line[0]);
                        if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                            this.newPage();
                        }
                        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                        if (!this.iNewPage) {
                            this.println();
                        }
                        this.println(this.mpad(MSG.lrSectExaminationConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                        this.printHeader(false);
                        this.setCont(MSG.lrExaminationConflicts(shortName));
                        headerPrinted = true;
                    }
                    if (directConflict.isOtherClass()) {
                        this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : section.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrCLASS(), 6), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8), this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) : NULL, this.rpad(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString(), 9), this.getMeetingTime(directConflict.getOtherEventTime()));
                    } else {
                        this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : section.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrEVENT(), 6), this.rpad(directConflict.getOtherEventName(), this.iItype ? 33 : 26), this.getMeetingTime(directConflict.getOtherEventTime()));
                    }
                    this.iPeriodPrinted = !this.iNewPage;
                    this.iStudentPrinted = this.iPeriodPrinted;
                    this.iCoursePrinted = this.iPeriodPrinted;
                    this.iSubjectPrinted = this.iPeriodPrinted;
                    lastSubject = section.getSubject();
                }
            }
            if (this.iM2d) {
                for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                    if (!moreThanTwoADayConflict.getStudents().contains(student.getUniqueId())) continue;
                    this.iPeriodPrinted = false;
                    for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                        for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                            if (!other.getStudentIds().contains(student.getUniqueId())) continue;
                            if (!headerPrinted) {
                                this.setHeaderLine(new AbstractReport.Line[0]);
                                if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                    this.newPage();
                                }
                                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                                if (!this.iNewPage) {
                                    this.println();
                                }
                                this.println(this.mpad(MSG.lrSectExaminationConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                                this.printHeader(false);
                                this.setCont(MSG.lrExaminationConflicts(shortName));
                                headerPrinted = true;
                            }
                            this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : section.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrMore2DAY(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                            lastSubject = section.getSubject();
                        }
                    }
                }
            }
            if (!this.iBtb) continue;
            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                if (!backToBackConflict.getStudents().contains(student.getUniqueId())) continue;
                this.iPeriodPrinted = false;
                for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                    if (!other.getStudentIds().contains(student.getUniqueId())) continue;
                    if (!headerPrinted) {
                        this.setHeaderLine(new AbstractReport.Line[0]);
                        if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                            this.newPage();
                        }
                        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                        if (!this.iNewPage) {
                            this.println();
                        }
                        this.println(this.mpad(MSG.lrSectExaminationConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                        this.printHeader(false);
                        this.setCont(MSG.lrExaminationConflicts(shortName));
                        headerPrinted = true;
                    }
                    this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : section.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrBTB(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                    this.iPeriodPrinted = !this.iNewPage;
                    this.iStudentPrinted = this.iPeriodPrinted;
                    this.iCoursePrinted = this.iPeriodPrinted;
                    this.iSubjectPrinted = this.iPeriodPrinted;
                    lastSubject = section.getSubject();
                }
            }
        }
        this.setHeaderLine(new AbstractReport.Line[0]);
        this.setCont(null);
    }

    public ChangeLog getLastChange(TreeSet<ExamInfo.ExamSectionInfo> sections) {
        BaseChangeLog lastChange = null;
        for (ExamInfo.ExamSectionInfo section : sections) {
            ChangeLog c = ChangeLog.findLastChange(section.getExam().getExam());
            if (c == null || lastChange != null && lastChange.getTimeStamp().compareTo(c.getTimeStamp()) >= 0) continue;
            lastChange = c;
        }
        return lastChange;
    }

    public Hashtable<Student, File> printStudentReports(String filePrefix, InstructorExamReport.FileGenerator gen) throws DocumentException, IOException {
        this.generateCache();
        sLog.info((Object)MSG.statusPrintingIndividualStudentReports());
        Hashtable<Student, File> files = new Hashtable<Student, File>();
        Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>> sections = new Hashtable<Student, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                for (Long studentId : section.getStudentIds()) {
                    Student student = this.iStudents.get(studentId);
                    TreeSet<ExamInfo.ExamSectionInfo> sectionsThisStudent = (TreeSet<ExamInfo.ExamSectionInfo>)sections.get(student);
                    if (sectionsThisStudent == null) {
                        sectionsThisStudent = new TreeSet<ExamInfo.ExamSectionInfo>();
                        sections.put(student, sectionsThisStudent);
                    }
                    sectionsThisStudent.add(section);
                }
            }
        }
        for (Student student : new TreeSet(sections.keySet())) {
            ChangeLog last;
            TreeSet sectionsThisStudent = (TreeSet)sections.get(student);
            if (!this.isOfSubjectArea(sectionsThisStudent)) continue;
            if (this.iSince != null && ((last = this.getLastChange(sectionsThisStudent)) == null || this.iSince.compareTo(last.getTimeStamp()) > 0)) {
                sLog.debug((Object)MSG.logNoChangesFoundFor(student.getName(DepartmentalInstructor.sNameFormatLastFist)));
                continue;
            }
            sLog.debug((Object)MSG.logGeneratingFileFor(student.getName(DepartmentalInstructor.sNameFormatLastFist)));
            File file = gen.generate(filePrefix + "_" + (student.getExternalUniqueId() != null ? student.getExternalUniqueId() : student.getLastName()), this.getExtension());
            this.open(file);
            this.printHeader();
            this.printReport(student, sectionsThisStudent);
            this.lastPage();
            this.close();
            files.put(student, file);
        }
        return files;
    }

    public static class StudentClassComparator
    implements Comparator<Class_> {
        private Student iStudent;

        public StudentClassComparator(Student student) {
            this.iStudent = student;
        }

        public CourseOffering getCourse(Class_ clazz) {
            CourseOffering correctedCourse = clazz.getSchedulingSubpart().getControllingCourseOffering();
            for (StudentClassEnrollment sce : this.iStudent.getClassEnrollments()) {
                if (!sce.getCourseOffering().getInstructionalOffering().equals(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering())) continue;
                correctedCourse = sce.getCourseOffering();
                break;
            }
            return correctedCourse;
        }

        @Override
        public int compare(Class_ c1, Class_ c2) {
            CourseOffering co1 = this.getCourse(c1);
            CourseOffering co2 = this.getCourse(c2);
            int cmp = co1.getSubjectAreaAbbv().compareTo(co2.getSubjectAreaAbbv());
            if (cmp != 0) {
                return cmp;
            }
            cmp = co1.getCourseNbr().compareTo(co2.getCourseNbr());
            if (cmp != 0) {
                return cmp;
            }
            if (this.isParentOf(c1, c2)) {
                return -1;
            }
            if (this.isParentOf(c2, c1)) {
                return 1;
            }
            if (cmp != 0) {
                return cmp;
            }
            cmp = c1.getSchedulingSubpart().getItype().compareTo(c2.getSchedulingSubpart().getItype());
            if (cmp != 0) {
                return cmp;
            }
            return c1.getUniqueId().compareTo(c2.getUniqueId());
        }

        public boolean isParentOf(Class_ c1, Class_ c2) {
            if (c2.getParentClass() != null) {
                if (c2.getParentClass().equals(c1)) {
                    return true;
                }
                return this.isParentOf(c1, c2.getParentClass());
            }
            return false;
        }
    }
}

