/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.enrollment;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.enrollment.PdfEnrollmentAuditReport;

public class MissingCourseEnrollmentsAuditReport
extends PdfEnrollmentAuditReport {
    public MissingCourseEnrollmentsAuditReport(int mode, File file, Session session, TreeSet<SubjectArea> subjectAreas, String subTitle) throws DocumentException, IOException {
        super(mode, MissingCourseEnrollmentsAuditReport.getTitle(), file, session, subjectAreas, subTitle);
    }

    public MissingCourseEnrollmentsAuditReport(int mode, File file, Session session) throws DocumentException, IOException {
        super(mode, MissingCourseEnrollmentsAuditReport.getTitle(), file, session);
    }

    @Override
    public void printReport() throws DocumentException {
        this.setHeaderLine(this.buildHeaderString());
        List results = this.getAuditResults(this.getSubjectAreas());
        Vector<AbstractReport.Line> lines = new Vector<AbstractReport.Line>();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            MissingCourseEnrollmentsAuditResult result = new MissingCourseEnrollmentsAuditResult((Object[])it.next());
            lines.add(this.buildLineString(result));
        }
        this.printHeader();
        for (AbstractReport.Line str : lines) {
            this.printLine(str);
        }
        if (!lines.isEmpty()) {
            this.lastPage();
        }
    }

    public static String getTitle() {
        return MSG.reportMissingCourseEnrollmentsAudit();
    }

    private AbstractReport.Line buildLineString(MissingCourseEnrollmentsAuditResult result) {
        return new AbstractReport.Line(this.buildBaseAuditLine(result), new AbstractReport.Line(this.rpad(result.itypeString(), ' ', itypeLength)));
    }

    private AbstractReport.Line[] buildHeaderString() {
        AbstractReport.Line[] baseHdr = this.getBaseHeader();
        return new AbstractReport.Line[]{new AbstractReport.Line(baseHdr[0], new AbstractReport.Line(this.rpad(MSG.lrMissing(), ' ', itypeLength))), new AbstractReport.Line(baseHdr[1], new AbstractReport.Line(this.rpad(MSG.lrSubpart(), ' ', itypeLength))), new AbstractReport.Line(baseHdr[2], new AbstractReport.Line(this.rpad("", '-', itypeLength)))};
    }

    @Override
    protected String createQueryString(TreeSet<SubjectArea> subjectAreas) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct s.externalUniqueId, s.lastName, s.firstName, s.middleName,").append(" sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr, sce.courseOffering.title,").append(" ss.itype.abbv,").append(" ( select count(sce1) from StudentClassEnrollment sce1").append(" where sce1.clazz.schedulingSubpart.uniqueId = ss.uniqueId and sce1.student.uniqueId = s.uniqueId ) ").append(" from Student s inner join s.classEnrollments as sce, SchedulingSubpart ss").append(" where  ss.instrOfferingConfig.uniqueId = sce.clazz.schedulingSubpart.instrOfferingConfig.uniqueId").append(" and s.session.uniqueId = :sessId");
        if (subjectAreas != null && !subjectAreas.isEmpty()) {
            sb.append(" and sce.courseOffering.subjectArea.uniqueId in (");
            boolean first = true;
            for (SubjectArea sa : subjectAreas) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(" ");
                sb.append(sa.getUniqueId().toString());
            }
            sb.append(" ) ");
        }
        sb.append(" and 0 = ( select count(sce1) from StudentClassEnrollment sce1").append(" where sce1.clazz.schedulingSubpart.uniqueId = ss.uniqueId and sce1.student.uniqueId = s.uniqueId )").append(" order by sce.courseOffering.subjectArea.subjectAreaAbbreviation, sce.courseOffering.courseNbr,").append(" sce.courseOffering.title, ss.itype.abbv");
        if (this.isShowId()) {
            sb.append(", s.externalUniqueId");
        } else if (this.isShowName()) {
            sb.append(", s.lastName, s.firstName, s.middleName");
        }
        return sb.toString();
    }

    private class MissingCourseEnrollmentsAuditResult
    extends PdfEnrollmentAuditReport.EnrollmentAuditResult {
        private String itype;

        public MissingCourseEnrollmentsAuditResult(Object[] result) {
            super(MissingCourseEnrollmentsAuditReport.this, result);
            if (result[7] != null) {
                this.itype = result[7].toString();
            }
        }

        public String itypeString() {
            return this.itype;
        }
    }
}

