/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;

public class NotifyStudentAction
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private Long iStudentId;
    private XStudent iStudent;
    private XOffering iOldOffering;
    private XCourseId iOldCourseId;
    private XEnrollment iOldEnrollment;
    private XStudent iOldStudent;
    private String iSourceAction = "other";
    private XOffering iFailedOffering;
    private XCourseId iFailedCourseId;
    private XEnrollment iFailedEnrollment;
    private XEnrollment iDropEnrollment;
    private SectioningException iFailure;
    private SectioningRequest.ReschedulingReason iReason;
    private StudentSectioningStatus.NotificationType iNotificationType;
    private boolean iSkipWhenNoChange = false;

    public NotifyStudentAction forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public NotifyStudentAction forStudent(XStudent student) {
        this.iStudent = student;
        this.iStudentId = student == null ? null : student.getStudentId();
        return this;
    }

    public NotifyStudentAction fromAction(String actionName) {
        this.iSourceAction = actionName;
        return this;
    }

    public NotifyStudentAction withType(StudentSectioningStatus.NotificationType notificationType) {
        this.iNotificationType = notificationType;
        return this;
    }

    public NotifyStudentAction oldEnrollment(XOffering oldOffering, XCourseId oldCourseId, XEnrollment oldEnrollment) {
        this.iOldOffering = oldOffering;
        this.iOldCourseId = oldCourseId;
        this.iOldEnrollment = oldEnrollment;
        return this;
    }

    public NotifyStudentAction failedEnrollment(XOffering failedOffering, XCourseId failedCourseId, XEnrollment failedEnrollment, Exception failure) {
        this.iFailedOffering = failedOffering;
        this.iFailedCourseId = failedCourseId;
        this.iFailedEnrollment = failedEnrollment;
        this.iFailure = failure == null ? null : (failure instanceof SectioningException ? (SectioningException)failure : new SectioningException(failure.getMessage(), failure));
        return this;
    }

    public NotifyStudentAction dropEnrollment(XEnrollment dropEnrollment) {
        this.iDropEnrollment = dropEnrollment;
        return this;
    }

    public NotifyStudentAction oldStudent(XStudent oldStudent) {
        this.iOldStudent = oldStudent;
        return this;
    }

    public NotifyStudentAction rescheduling(SectioningRequest.ReschedulingReason reason) {
        this.iReason = reason;
        return this;
    }

    public NotifyStudentAction skipWhenNoChange(boolean skipWhenNoChange) {
        this.iSkipWhenNoChange = skipWhenNoChange;
        return this;
    }

    public Long getStudentId() {
        return this.iStudent.getStudentId();
    }

    @Override
    public Boolean execute(OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        XStudent student;
        XStudent xStudent = this.iStudent != null ? this.iStudent : (student = this.iStudentId != null ? server.getStudent(this.iStudentId) : null);
        if (student != null) {
            XCourse course;
            XCourseRequest cr;
            if (this.iFailedOffering != null) {
                String message = "Student " + student.getName() + " (" + student.getStudentId() + ") not changed.";
                String courseName = this.iFailedCourseId != null ? this.iFailedCourseId.getCourseName() : (this.iFailedEnrollment == null ? this.iFailedOffering.getName() : this.iFailedOffering.getCourse(this.iFailedEnrollment.getCourseId()).getCourseName());
                XCourseRequest request = null;
                for (XRequest xRequest : student.getRequests()) {
                    XCourseRequest cr2;
                    XCourseId id;
                    if (!(xRequest instanceof XCourseRequest) || (id = (cr2 = (XCourseRequest)xRequest).getCourseIdByOfferingId(this.iFailedOffering.getOfferingId())) == null || this.iFailedCourseId != null && !id.equals(this.iFailedCourseId) || this.iFailedEnrollment != null && !id.getCourseId().equals(this.iFailedEnrollment.getCourseId())) continue;
                    courseName = id.getCourseName();
                    request = cr2;
                    break;
                }
                message = message + "\n  Failed assignment:";
                XOffering offering2 = server.getOffering(this.iFailedOffering.getOfferingId());
                if (offering2 == null || request == null || request.getEnrollment() == null) {
                    message = message + "\n    " + (request == null ? this.iFailedOffering.toString() : request.toString()) + " NOT ASSIGNED";
                } else {
                    message = message + "\n    " + String.valueOf(request);
                    if (request.getEnrollment().getApproval() != null) {
                        message = message + " (approved by " + request.getEnrollment().getApproval().getName() + ")";
                    }
                    for (XSection section : offering2.getSections(request.getEnrollment())) {
                        message = message + "\n      " + courseName + " " + section.toString(request.getEnrollment().getCourseId());
                    }
                }
                if (this.iFailure != null) {
                    message = message + "\n  Error: " + this.iFailure.getMessage();
                    if (this.iFailure.hasErrors()) {
                        for (ClassAssignmentInterface.ErrorMessage error : this.iFailure.getErrors()) {
                            message = message + "\n    " + String.valueOf(error);
                        }
                    }
                }
                helper.debug(message);
                if (this.isEmailEnabled(server, helper)) {
                    server.execute(server.createAction(StudentEmail.class).forStudent(student).fromAction(this.iSourceAction).failedEnrollment(this.iFailedOffering, this.iFailedCourseId, this.iFailedEnrollment, this.iFailure).dropEnrollment(this.iDropEnrollment).oldEnrollment(this.iOldOffering, this.iOldCourseId, this.iOldEnrollment).rescheduling(this.iReason).withType(this.iNotificationType).skipWhenNoChange(this.iSkipWhenNoChange), helper.getUser(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                        @Override
                        public void onFailure(Throwable exception) {
                            helper.error("Failed to notify student: " + exception.getMessage(), exception);
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                        }
                    });
                }
                return true;
            }
            if (this.iOldOffering != null) {
                if (this.iOldEnrollment != null && !this.iOldOffering.getOfferingId().equals(this.iOldEnrollment.getOfferingId())) {
                    this.iOldOffering = server.getOffering(this.iOldEnrollment.getOfferingId());
                }
                String message = "Student " + student.getName() + " (" + student.getStudentId() + ") changed.";
                String courseName = this.iOldCourseId != null ? this.iOldCourseId.getCourseName() : (this.iOldEnrollment == null ? this.iOldOffering.getName() : this.iOldOffering.getCourse(this.iOldEnrollment.getCourseId()).getCourseName());
                XCourseRequest request = null;
                for (XRequest xRequest : student.getRequests()) {
                    XCourseRequest cr3;
                    XCourseId id;
                    if (!(xRequest instanceof XCourseRequest) || (id = (cr3 = (XCourseRequest)xRequest).getCourseIdByOfferingId(this.iOldOffering.getOfferingId())) == null || this.iOldCourseId != null && !id.equals(this.iOldCourseId) || this.iOldEnrollment != null && !id.getCourseId().equals(this.iOldEnrollment.getCourseId())) continue;
                    courseName = id.getCourseName();
                    request = cr3;
                    break;
                }
                message = message + "\n  Previous assignment:";
                if (this.iOldEnrollment != null) {
                    message = message + "\n    " + (request == null ? this.iOldOffering.toString() : request.toString());
                    if (this.iOldEnrollment.getApproval() != null) {
                        message = message + " (approved by " + this.iOldEnrollment.getApproval().getName() + ")";
                    }
                    for (XSection xSection : this.iOldOffering.getSections(this.iOldEnrollment)) {
                        message = message + "\n      " + courseName + " " + xSection.toString(this.iOldEnrollment.getCourseId());
                    }
                } else {
                    message = message + "\n    " + (request == null ? this.iOldOffering.toString() : request.toString()) + " NOT ASSIGNED";
                }
                message = message + "\n  New assignment:";
                XOffering offering = server.getOffering(this.iOldOffering.getOfferingId());
                if (offering == null || request == null || request.getEnrollment() == null) {
                    message = message + "\n    " + (request == null ? this.iOldOffering.toString() : request.toString()) + " NOT ASSIGNED";
                } else {
                    message = message + "\n    " + String.valueOf(request);
                    if (request.getEnrollment().getApproval() != null) {
                        message = message + " (approved by " + request.getEnrollment().getApproval().getName() + ")";
                    }
                    for (XSection section : offering.getSections(request.getEnrollment())) {
                        message = message + "\n      " + courseName + " " + section.toString(request.getEnrollment().getCourseId());
                    }
                }
                helper.debug(message);
                if (this.isEmailEnabled(server, helper)) {
                    server.execute(server.createAction(StudentEmail.class).forStudent(student).fromAction(this.iSourceAction).oldEnrollment(this.iOldOffering, this.iOldCourseId, this.iOldEnrollment).dropEnrollment(this.iDropEnrollment).rescheduling(this.iReason).withType(this.iNotificationType).skipWhenNoChange(this.iSkipWhenNoChange), helper.getUser(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                        @Override
                        public void onFailure(Throwable exception) {
                            helper.error("Failed to notify student: " + exception.getMessage(), exception);
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                        }
                    });
                }
                return true;
            }
            String message = "Student " + student.getName() + " (" + student.getStudentId() + ") changed.";
            if (this.iOldStudent != null) {
                message = message + "\n  Previous schedule:";
                for (XRequest r : this.iOldStudent.getRequests()) {
                    XOffering xOffering;
                    message = message + "\n    " + String.valueOf(r);
                    if (!(r instanceof XCourseRequest)) continue;
                    cr = (XCourseRequest)r;
                    if (cr.getEnrollment() == null) {
                        message = message + " NOT ASSIGNED";
                        continue;
                    }
                    if (cr.getEnrollment().getApproval() != null) {
                        message = message + " (approved by " + cr.getEnrollment().getApproval().getName() + ")";
                    }
                    if ((xOffering = server.getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                    course = xOffering.getCourse(cr.getEnrollment().getCourseId());
                    for (XSection section : xOffering.getSections(cr.getEnrollment())) {
                        message = message + "\n      " + (course == null ? xOffering.getName() : course.getCourseName()) + " " + section.toString(cr.getEnrollment().getCourseId());
                    }
                }
            }
            message = message + "\n  New schedule:";
            for (XRequest r : student.getRequests()) {
                XOffering xOffering;
                message = message + "\n    " + String.valueOf(r);
                if (!(r instanceof XCourseRequest)) continue;
                cr = (XCourseRequest)r;
                if (cr.getEnrollment() == null) {
                    message = message + " NOT ASSIGNED";
                    continue;
                }
                if (cr.getEnrollment().getApproval() != null) {
                    message = message + " (approved by " + cr.getEnrollment().getApproval().getName() + ")";
                }
                if ((xOffering = server.getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                course = xOffering.getCourse(cr.getEnrollment().getCourseId());
                for (XSection section : xOffering.getSections(cr.getEnrollment())) {
                    message = message + "\n      " + (course == null ? xOffering.getName() : course.getCourseName()) + " " + section.toString(cr.getEnrollment().getCourseId());
                }
            }
            helper.debug(message);
            if (this.isEmailEnabled(server, helper)) {
                server.execute(server.createAction(StudentEmail.class).forStudent(student).fromAction(this.iSourceAction).oldStudent(this.iOldStudent).rescheduling(this.iReason).withType(this.iNotificationType).skipWhenNoChange(this.iSkipWhenNoChange), helper.getUser(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                    @Override
                    public void onFailure(Throwable exception) {
                        helper.error("Failed to notify student: " + exception.getMessage(), exception);
                    }

                    @Override
                    public void onSuccess(Boolean result) {
                    }
                });
            }
            return true;
        }
        return false;
    }

    public static boolean checkNotificationDates(AcademicSessionInfo session) {
        if (session.getNotificationsBeginDate() != null || session.getNotificationsEndDate() != null) {
            Date now = new Date();
            if (session.getNotificationsBeginDate() != null && now.before(session.getNotificationsBeginDate())) {
                return false;
            }
            if (session.getNotificationsEndDate() != null) {
                Calendar c = Calendar.getInstance(Locale.US);
                c.setTime(session.getNotificationsEndDate());
                c.add(6, 1);
                if (!now.before(c.getTime())) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isEmailEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String checkDates = ApplicationProperty.OnlineSchedulingEmailCheckDatesOverride.value(this.iSourceAction);
        if (checkDates == null) {
            checkDates = ApplicationProperty.OnlineSchedulingEmailCheckDates.value();
        }
        if ("true".equalsIgnoreCase(checkDates) && !NotifyStudentAction.checkNotificationDates(server.getAcademicSession())) {
            return false;
        }
        String override = ApplicationProperty.OnlineSchedulingEmailConfirmationOverride.value(this.iSourceAction);
        if (override != null) {
            return "true".equalsIgnoreCase(override);
        }
        return server.getAcademicSession().isSectioningEnabled() && ApplicationProperty.OnlineSchedulingEmailConfirmation.isTrue();
    }

    @Override
    public String name() {
        return "notify";
    }
}

