/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.HardDistanceConflicts;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.OnlineConfig;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSection;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.expectations.MinimizeConflicts;
import org.cpsolver.studentsct.online.expectations.NeverOverExpected;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.online.selection.BestPenaltyCriterion;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.SuggestionSelection;
import org.cpsolver.studentsct.reservation.IndividualRestriction;
import org.cpsolver.studentsct.reservation.Reservation;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XDummyReservation;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XRestriction;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class FindAssignmentAction
implements OnlineSectioningAction<List<ClassAssignmentInterface>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private CourseRequestInterface iRequest;
    private Collection<ClassAssignmentInterface.ClassAssignment> iAssignment;
    private Collection<ClassAssignmentInterface.ClassAssignment> iSpecialRegistration;
    private boolean iCanRequirePreferences = true;

    public FindAssignmentAction forRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public FindAssignmentAction withAssignment(Collection<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iAssignment = assignment;
        return this;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public Collection<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iAssignment;
    }

    public FindAssignmentAction withSpecialRegistration(Collection<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iSpecialRegistration = assignment;
        return this;
    }

    public Collection<ClassAssignmentInterface.ClassAssignment> getSpecialRegistration() {
        return this.iSpecialRegistration;
    }

    public FindAssignmentAction withCanRequire(boolean canRequire) {
        this.iCanRequirePreferences = canRequire;
        return this;
    }

    public boolean isCanRequirePreferences() {
        return this.iCanRequirePreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String override;
        void var21_38;
        long t0 = System.currentTimeMillis();
        OverExpectedCriterion overExpected = server.getOverExpectedCriterion();
        if ((this.getRequest().areSpaceConflictsAllowed() || this.getRequest().areTimeConflictsAllowed() || this.getRequest().areLinkedConflictsAllowed() || this.getSpecialRegistration() != null) && server.getConfig().getPropertyBoolean("OverExpected.MinimizeConflicts", false)) {
            overExpected = new MinimizeConflicts(server.getConfig(), overExpected);
        }
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), overExpected);
        model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        if (this.getRequest().getStudentId() != null) {
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getRequest().getStudentId()));
        }
        Student student = new Student(this.getRequest().getStudentId() == null ? -1L : this.getRequest().getStudentId());
        HashSet<IdPair> enrolled = null;
        ClassAssignmentInterface unavailabilities = null;
        List<GetAssignment.CourseSection> providedUnavailabilities = null;
        OnlineSectioningServer.Lock readLock = server.readLock();
        try {
            CourseRequest cr;
            XStudent original;
            boolean checkDeadlines = server.getConfig().getPropertyBoolean("FindAssignment.CheckDeadlines", false) && !this.getRequest().areDeadlineConflictsAllowed();
            Integer currentDateIndex = null;
            if (server.getConfig().getPropertyBoolean("FindAssignment.AvoidPastSections", true)) {
                currentDateIndex = Days.daysBetween((ReadablePartial)new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()), (ReadablePartial)new LocalDate()).getDays() + server.getConfig().getPropertyInt("FindAssignment.AvoidPastOffset", 0);
            }
            boolean onlineOnlyFilter = true;
            if (helper.hasAdminPermission() && server.getConfig().getPropertyBoolean("Load.OnlineOnlyAdminOverride", false)) {
                onlineOnlyFilter = false;
            } else if (helper.hasAvisorPermission() && server.getConfig().getPropertyBoolean("Load.OnlineOnlyAdvisorOverride", false)) {
                onlineOnlyFilter = false;
            }
            XStudent xStudent = original = this.getRequest().getStudentId() == null ? null : server.getStudent(this.getRequest().getStudentId());
            if (original != null) {
                unavailabilities = new ClassAssignmentInterface();
                providedUnavailabilities = GetAssignment.fillUnavailabilitiesIn(unavailabilities, original, server, helper, null);
                Collections.reverse(unavailabilities.getCourseAssignments());
                student.setExternalId(original.getExternalId());
                student.setName(original.getName());
                student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
                student.setAllowDisabled(original.isAllowDisabled());
                if (server instanceof StudentSolver) {
                    student.setMaxCredit(original.getMaxCredit());
                }
                student.setClassFirstDate(original.getClassStartDate());
                student.setClassLastDate(original.getClassEndDate());
                student.setBackToBackPreference(original.getBackToBackPreference());
                student.setModalityPreference(original.getModalityPreference());
                action.getStudentBuilder().setUniqueId(original.getStudentId()).setExternalId(original.getExternalId()).setName(original.getName());
                enrolled = new HashSet<IdPair>();
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XEnrollment xEnrollment = ((XCourseRequest)xRequest).getEnrollment();
                    for (Long s : xEnrollment.getSectionIds()) {
                        enrolled.add(new IdPair(xEnrollment.getCourseId(), s));
                    }
                }
                OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XCourseRequest cr2 = (XCourseRequest)xRequest;
                    XOffering offering = server.getOffering(cr2.getEnrollment().getOfferingId());
                    for (XSection xSection : offering.getSections(cr2.getEnrollment())) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(xSection, cr2.getEnrollment()));
                    }
                }
                action.addEnrollment(enrollment);
            }
            HashMap<Long, Section> classTable = new HashMap<Long, Section>();
            HashSet<XDistribution> hashSet = new HashSet<XDistribution>();
            if (this.getAssignment() != null) {
                this.getRequest().moveActiveSubstitutionsUp();
            }
            for (CourseRequestInterface.Request c : this.getRequest().getCourses()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, false, classTable, hashSet, this.getAssignment() != null, this.getAssignment() != null, checkDeadlines, currentDateIndex, onlineOnlyFilter, this.isCanRequirePreferences(), helper);
            }
            if (student.getRequests().isEmpty() && !CONSTANTS.allowEmptySchedule()) {
                throw new SectioningException(MSG.exceptionNoCourse());
            }
            for (CourseRequestInterface.Request c : this.getRequest().getAlternatives()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, false, classTable, hashSet, this.getAssignment() != null, this.getAssignment() != null, checkDeadlines, currentDateIndex, onlineOnlyFilter, this.isCanRequirePreferences(), helper);
            }
            if (helper.isAlternativeCourseEnabled()) {
                for (Request r : student.getRequests()) {
                    XOffering x;
                    XCourse ci;
                    Iterator<Long> course;
                    Long l;
                    if (r.isAlternative() || !(r instanceof CourseRequest) || (cr = (CourseRequest)r).getCourses().size() != 1 || (l = (course = server.getCourse(((Course)cr.getCourses().get(0)).getId())) == null ? null : ((XCourse)((Object)course)).getAlternativeCourseId()) == null) continue;
                    boolean hasCourse = false;
                    block10: for (Request x2 : student.getRequests()) {
                        if (!(x2 instanceof CourseRequest)) continue;
                        for (Course c : ((CourseRequest)x2).getCourses()) {
                            if (c.getId() != l.longValue()) continue;
                            hasCourse = true;
                            continue block10;
                        }
                    }
                    if (hasCourse || (ci = server.getCourse(l)) == null || (x = server.getOffering(ci.getOfferingId())) == null) continue;
                    cr.getCourses().add(FindAssignmentAction.clone(x, server.getEnrollments(x.getOfferingId()), ci.getCourseId(), student.getId(), original, classTable, server, (StudentSectioningModel)model, this.getAssignment() != null, checkDeadlines, currentDateIndex, onlineOnlyFilter, helper));
                    hashSet.addAll(x.getDistributions());
                }
            }
            if (providedUnavailabilities != null) {
                for (GetAssignment.CourseSection cs : providedUnavailabilities) {
                    if (cs.getSection().isCancelled() || cs.getSection().getTime() == null) continue;
                    Unavailability ua = new Unavailability(student, new Section(cs.getSection().getSectionId().longValue(), cs.getSection().getLimit(), cs.getCourse().getCourseName() + " " + cs.getSection().getSubpartName() + " " + cs.getSection().getName(cs.getCourse().getCourseId()), null, cs.getSection().toPlacement(0), null, new Instructor[0]), cs.isAllowOverlap());
                    ua.setTeachingAssignment(cs.isTeachingAssignment());
                    ua.setCourseId(cs.getCourse().getCourseId());
                }
            }
            if (this.getRequest().areTimeConflictsAllowed() || this.getRequest().areSpaceConflictsAllowed() || this.getRequest().areLinkedConflictsAllowed() || this.getSpecialRegistration() != null) {
                for (Request r : student.getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    cr = (CourseRequest)r;
                    for (Course course : cr.getCourses()) {
                        Object res22;
                        XCourse xc = server.getCourse(course.getId());
                        boolean time = this.getRequest().areTimeConflictsAllowed() && xc.areTimeConflictOverridesAllowed();
                        boolean space = this.getRequest().areSpaceConflictsAllowed() && xc.areSpaceConflictOverridesAllowed();
                        boolean linked = this.getRequest().areLinkedConflictsAllowed() && xc.areLinkedConflictOverridesAllowed();
                        boolean hasNeverIncludedReservation = false;
                        if (!server.getConfig().getPropertyBoolean("Reservations.NeverIncludedAllowOverride", false)) {
                            for (Object res22 : course.getOffering().getReservations()) {
                                if (!res22.neverIncluded()) continue;
                                hasNeverIncludedReservation = true;
                            }
                        }
                        if (!hasNeverIncludedReservation && (time || space || linked || this.getSpecialRegistration() != null)) {
                            OnlineReservation dummy = new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), -100, space, 1, true, true, time, true, true);
                            dummy.setBreakLinkedSections(linked);
                            res22 = course.getOffering().getConfigs().iterator();
                            while (res22.hasNext()) {
                                Config g = (Config)res22.next();
                                dummy.addConfig(g);
                                for (Subpart s : g.getSubparts()) {
                                    for (Section x : s.getSections()) {
                                        dummy.addSection(x, false);
                                    }
                                }
                            }
                        }
                        if (!time && !space && !linked || !server.getConfig().getPropertyBoolean("Restrictions.AllowOverride", false) || !course.getOffering().hasRestrictions()) continue;
                        IndividualRestriction restriction = new IndividualRestriction(-3L, course.getOffering(), new Long[]{student.getId()});
                        res22 = course.getOffering().getConfigs().iterator();
                        while (res22.hasNext()) {
                            Config c = (Config)res22.next();
                            restriction.addConfig(c);
                        }
                    }
                }
            }
            model.addStudent(student);
            model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
            for (XDistribution link : hashSet) {
                if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> sections = new ArrayList<Section>();
                for (Long l : link.getSectionIds()) {
                    Section x = (Section)classTable.get(l);
                    if (x == null) continue;
                    sections.add(x);
                }
                if (sections.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, sections);
            }
        }
        finally {
            readLock.release();
        }
        Hashtable<CourseRequest, Object> preferredSectionsForCourse = new Hashtable<CourseRequest, Object>();
        Hashtable<CourseRequest, Object> requiredOrSavedSectionsForCourse = new Hashtable<CourseRequest, Object>();
        Hashtable<CourseRequest, Set<Section>> requiredSectionsForCourse = new Hashtable<CourseRequest, Set<Section>>();
        HashSet<FreeTimeRequest> pinnedFreeTimes = new HashSet<FreeTimeRequest>();
        HashSet<FreeTimeRequest> requiredFreeTimes = new HashSet<FreeTimeRequest>();
        HashSet<CourseRequest> hashSet = new HashSet<CourseRequest>();
        boolean bl = false;
        double selectedPenalty = 0.0;
        if (this.getAssignment() != null && !this.getAssignment().isEmpty()) {
            OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
            requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
            for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                if (a == null || !a.isAssigned()) continue;
                requested.addSection(OnlineSectioningHelper.toProto(a));
            }
            action.addEnrollment(requested);
            Enrollment[] enrollmentArray = new Enrollment[student.getRequests().size()];
            int idx = 0;
            for (Request r : student.getRequests()) {
                OnlineSectioningLog.Request.Builder rq = OnlineSectioningHelper.toProto(r);
                if (r instanceof CourseRequest) {
                    Object s;
                    Section section;
                    CourseRequest cr = (CourseRequest)r;
                    HashSet preferredSections = new HashSet();
                    HashSet<Section> requiredSections = new HashSet<Section>();
                    HashSet requiredOrSavedSections = new HashSet();
                    HashSet<CourseRequest> allowOverlaps = new HashSet<CourseRequest>();
                    boolean conflict = false;
                    boolean assigned = false;
                    ArrayList<ClassAssignmentInterface.ClassAssignment> specRegAdds = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
                    Iterator<Long> specRegDrops = new HashSet();
                    if (this.getSpecialRegistration() != null) {
                        for (ClassAssignmentInterface.ClassAssignment b : this.getSpecialRegistration()) {
                            if (cr.getCourse(b.getCourseId().longValue()) == null) continue;
                            if (b.isCourseAssigned()) {
                                specRegAdds.add(b);
                                continue;
                            }
                            specRegDrops.add(b.getClassId());
                        }
                    }
                    for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                        if (a == null || a.isFreeTime() || cr.getCourse(a.getCourseId().longValue()) == null || a.getClassId() == null) continue;
                        assigned = true;
                        section = cr.getSection(a.getClassId().longValue());
                        if (section == null || section.getLimit() == 0) continue;
                        if (specRegDrops.contains(a.getClassId())) {
                            rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(OnlineSectioningLog.Section.Preference.DROP));
                            continue;
                        }
                        if (a.isPinned()) {
                            requiredSections.add(section);
                        }
                        if (a.isPinned() || this.getSpecialRegistration() == null && a.isSaved() || this.getRequest().isNoChange()) {
                            if (!conflict) {
                                Iterator iterator = requiredOrSavedSections.iterator();
                                while (iterator.hasNext()) {
                                    s = (Section)iterator.next();
                                    if (!s.isOverlapping((SctAssignment)section) && !HardDistanceConflicts.inConflict((StudentQuality)model.getStudentQuality(), (Section)s, (Section)section)) continue;
                                    conflict = true;
                                    break;
                                }
                                boolean allowOverlap22 = false;
                                for (Reservation reservation : cr.getReservations(cr.getCourse(a.getCourseId().longValue()))) {
                                    if (!reservation.isAllowOverlap()) continue;
                                    allowOverlap22 = true;
                                    break;
                                }
                                if (allowOverlap22) {
                                    allowOverlaps.add(cr);
                                } else {
                                    for (Map.Entry entry : requiredOrSavedSectionsForCourse.entrySet()) {
                                        if (!allowOverlaps.contains(entry.getKey())) {
                                            for (Section s2 : (Set)entry.getValue()) {
                                                if (!s2.isOverlapping((SctAssignment)section) && !HardDistanceConflicts.inConflict((StudentQuality)model.getStudentQuality(), (Section)s2, (Section)section)) continue;
                                                conflict = true;
                                                break;
                                            }
                                        }
                                        if (!conflict) continue;
                                        break;
                                    }
                                }
                            }
                            if (!conflict) {
                                requiredOrSavedSections.add(section);
                            }
                        }
                        selectedPenalty += model.getOverExpected((Assignment)assignment, enrollmentArray, idx, section, (Request)cr);
                        preferredSections.add(section);
                        rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(a.isPinned() || a.isSaved() || this.getRequest().isNoChange() ? OnlineSectioningLog.Section.Preference.REQUIRED : OnlineSectioningLog.Section.Preference.PREFERRED));
                    }
                    if (!assigned && this.getRequest().isNoChange()) {
                        hashSet.add(cr);
                    } else if (!(this.getSpecialRegistration() == null || specRegDrops.isEmpty() && assigned || !specRegAdds.isEmpty())) {
                        hashSet.add(cr);
                    }
                    if (!specRegAdds.isEmpty()) {
                        for (ClassAssignmentInterface.ClassAssignment a : specRegAdds) {
                            section = cr.getSection(a.getClassId().longValue());
                            if (section == null) continue;
                            selectedPenalty += model.getOverExpected((Assignment)assignment, enrollmentArray, idx, section, (Request)cr);
                            preferredSections.add(section);
                            if (a.isPinned()) {
                                requiredSections.add(section);
                            }
                            if (!conflict && a.isPinned()) {
                                if (section.getLimit() == 0 && !this.getRequest().areSpaceConflictsAllowed()) {
                                    conflict = true;
                                }
                                Iterator allowOverlap22 = requiredOrSavedSections.iterator();
                                while (allowOverlap22.hasNext()) {
                                    s = (Section)allowOverlap22.next();
                                    if (!s.isOverlapping((SctAssignment)section) && !HardDistanceConflicts.inConflict((StudentQuality)model.getStudentQuality(), (Section)s, (Section)section)) continue;
                                    conflict = true;
                                    break;
                                }
                                boolean allowOverlap = false;
                                for (Reservation reservation : cr.getReservations(cr.getCourse(a.getCourseId().longValue()))) {
                                    if (!reservation.isAllowOverlap()) continue;
                                    allowOverlap = true;
                                    break;
                                }
                                if (allowOverlap) {
                                    allowOverlaps.add(cr);
                                } else {
                                    for (Map.Entry entry : requiredOrSavedSectionsForCourse.entrySet()) {
                                        if (!allowOverlaps.contains(entry.getKey())) {
                                            for (Section s2 : (Set)entry.getValue()) {
                                                if (!s2.isOverlapping((SctAssignment)section) && !HardDistanceConflicts.inConflict((StudentQuality)model.getStudentQuality(), (Section)s2, (Section)section)) continue;
                                                conflict = true;
                                                break;
                                            }
                                        }
                                        if (!conflict) continue;
                                        break;
                                    }
                                }
                                if (!conflict) {
                                    requiredOrSavedSections.add(section);
                                }
                            }
                            rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(OnlineSectioningLog.Section.Preference.ADD));
                        }
                    }
                    if (preferredSections.isEmpty()) {
                        ++var21_38;
                    }
                    preferredSectionsForCourse.put(cr, preferredSections);
                    requiredSectionsForCourse.put(cr, requiredSections);
                    if (!conflict) {
                        requiredOrSavedSectionsForCourse.put(cr, requiredOrSavedSections);
                    }
                    if (!preferredSections.isEmpty()) {
                        Object section2 = (Section)preferredSections.iterator().next();
                        enrollmentArray[idx] = new Enrollment((Request)cr, 0, section2.getSubpart().getConfig(), (Set)preferredSections, (Assignment)assignment);
                    }
                } else {
                    FreeTimeRequest ft = (FreeTimeRequest)r;
                    for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                        if (a == null || !a.isFreeTime() || !a.isPinned() && !this.getRequest().isNoChange() || ft.getTime() == null || ft.getTime().getStartSlot() != a.getStart() || ft.getTime().getLength() != a.getLength() || ft.getTime().getDayCode() != DayCode.toInt(DayCode.toDayCodes(a.getDays()))) continue;
                        if (a.isPinned()) {
                            pinnedFreeTimes.add(ft);
                        }
                        requiredFreeTimes.add(ft);
                        for (OnlineSectioningLog.Time.Builder ftb : rq.getFreeTimeBuilderList()) {
                            ftb.setPreference(OnlineSectioningLog.Section.Preference.REQUIRED);
                        }
                    }
                }
                action.addRequest(rq);
                ++idx;
            }
        } else {
            Iterator e = student.getRequests().iterator();
            while (e.hasNext()) {
                action.addRequest(OnlineSectioningHelper.toProto((Request)e.next()));
            }
        }
        long t1 = System.currentTimeMillis();
        boolean avoidOverExpected = server.getAcademicSession().isSectioningEnabled();
        if (avoidOverExpected && helper.getUser() != null && helper.getUser().hasType() && helper.getUser().getType() != OnlineSectioningLog.Entity.EntityType.STUDENT) {
            avoidOverExpected = false;
        }
        if ((override = ApplicationProperty.OnlineSchedulingAllowOverExpected.value()) != null) {
            avoidOverExpected = "false".equalsIgnoreCase(override);
        }
        double maxOverExpected = -1.0;
        if (avoidOverExpected && !(model.getOverExpectedCriterion() instanceof NeverOverExpected)) {
            if (var21_38 == false && this.getAssignment() != null && !this.getAssignment().isEmpty()) {
                maxOverExpected = selectedPenalty;
            } else {
                long x0 = System.currentTimeMillis();
                MultiCriteriaBranchAndBoundSelection selection = new MultiCriteriaBranchAndBoundSelection(model.getProperties());
                selection.setModel(model);
                selection.setPreferredSections(preferredSectionsForCourse);
                selection.setRequiredSections(requiredSectionsForCourse);
                selection.setRequiredFreeTimes(requiredFreeTimes);
                selection.setTimeout(100);
                Enrollment[] neighbour = selection.select((Assignment)assignment, student, (MultiCriteriaBranchAndBoundSelection.SelectionCriterion)new BestPenaltyCriterion(student, model));
                long x1 = System.currentTimeMillis();
                if (neighbour != null) {
                    maxOverExpected = 0.0;
                    for (int i = 0; i < neighbour.getAssignment().length; ++i) {
                        Enrollment enrollment = neighbour.getAssignment()[i];
                        if (enrollment == null || enrollment.getAssignments() == null || !enrollment.isCourseRequest()) continue;
                        for (Section section2 : enrollment.getSections()) {
                            maxOverExpected += model.getOverExpected((Assignment)assignment, neighbour.getAssignment(), i, section2, enrollment.getRequest());
                        }
                    }
                    if (maxOverExpected < selectedPenalty) {
                        maxOverExpected = selectedPenalty;
                    }
                    helper.debug("Maximum number of over-expected sections limited to " + maxOverExpected + " (computed in " + (x1 - x0) + " ms).");
                }
            }
        }
        Object selection = null;
        selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
        selection.setModel(model);
        selection.setPreferredSections(preferredSectionsForCourse);
        selection.setRequiredSections(requiredOrSavedSectionsForCourse);
        selection.setRequiredFreeTimes(requiredFreeTimes);
        selection.setRequiredUnassinged(hashSet);
        if (maxOverExpected >= 0.0) {
            selection.setMaxOverExpected(maxOverExpected);
        }
        BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, student);
        boolean assigned = false;
        if (neighbour != null) {
            for (Enrollment e : neighbour.getAssignment()) {
                if (e == null) continue;
                assigned = true;
                break;
            }
        }
        if (!assigned) {
            selection.setRequiredSections(new Hashtable());
            selection.setRequiredFreeTimes(new HashSet());
            neighbour = selection.select((Assignment)assignment, student);
        }
        if (neighbour == null && student.getRequests().isEmpty()) {
            neighbour = new BranchBoundSelection.BranchBoundNeighbour(student, 0.0, new Enrollment[0]);
        }
        if (neighbour == null) {
            throw new SectioningException(MSG.exceptionNoSolution());
        }
        helper.debug("Using " + (server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? "multi-criteria " : "") + (server.getConfig().getPropertyBoolean("StudentWeights.PriorityWeighting", true) ? "priority" : "equal") + " weighting model with " + server.getConfig().getPropertyInt("Neighbour.BranchAndBoundTimeout", 1000) + " ms time limit.");
        neighbour.assign((Assignment)assignment, 0L);
        helper.debug("Solution: " + ToolBox.dict2string((Map)model.getInfo((Assignment)assignment), (int)2));
        OnlineSectioningLog.Enrollment.Builder solution = OnlineSectioningLog.Enrollment.newBuilder();
        solution.setType(OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED);
        solution.setValue(-neighbour.value((Assignment)assignment));
        for (Enrollment e : neighbour.getAssignment()) {
            if (e == null || e.getAssignments() == null) continue;
            for (Object section2 : e.getAssignments()) {
                solution.addSection(OnlineSectioningHelper.toProto((SctAssignment)section2, e));
            }
        }
        action.addEnrollment(solution);
        long t2 = System.currentTimeMillis();
        ClassAssignmentInterface ret = this.convert(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, neighbour, requiredSectionsForCourse, pinnedFreeTimes, enrolled);
        if (unavailabilities != null) {
            for (ClassAssignmentInterface.CourseAssignment ca : unavailabilities.getCourseAssignments()) {
                ret.getCourseAssignments().add(0, ca);
            }
        }
        long t3 = System.currentTimeMillis();
        helper.debug("Sectioning took " + (t3 - t0) + "ms (model " + (t1 - t0) + "ms, sectioning " + (t2 - t1) + "ms, conversion " + (t3 - t2) + "ms)");
        if (this.getRequest().isNoChange() && this.getAssignment() != null && ret != null) {
            for (ClassAssignmentInterface.CourseAssignment course : ret.getCourseAssignments()) {
                if (course.isFreeTime() || course.isTeachingAssignment()) continue;
                for (ClassAssignmentInterface.ClassAssignment ca : course.getClassAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment classAssignment : this.getAssignment()) {
                        if (classAssignment == null || !ca.getClassId().equals(classAssignment.getClassId())) continue;
                        if (classAssignment.hasError()) {
                            ca.setError(classAssignment.getError());
                        }
                        if (classAssignment.hasWarn()) {
                            ca.setWarn(classAssignment.getWarn());
                        }
                        if (!classAssignment.hasInfo()) continue;
                        ca.setInfo(classAssignment.getInfo());
                    }
                }
            }
        }
        ArrayList<ClassAssignmentInterface> rets = new ArrayList<ClassAssignmentInterface>(1);
        rets.add(ret);
        return rets;
    }

    public static Course clone(XOffering offering, XEnrollments enrollments, Long courseId, long studentId, XStudent originalStudent, Map<Long, Section> sections, OnlineSectioningServer server, StudentSectioningModel model, boolean hasAssignment, boolean checkDeadlines, Integer currentDateIndex, boolean onlineOnlyFilter, OnlineSectioningHelper helper) {
        boolean bl;
        boolean hasMustUse;
        Hashtable<Long, OnlineConfig> configs;
        Course clonedCourse;
        Offering clonedOffering;
        block79: {
            String filter;
            XCourse course;
            block80: {
                clonedOffering = new Offering(offering.getOfferingId().longValue(), offering.getName());
                clonedOffering.setModel((Model)model);
                XExpectations expectations = server.getExpectations(offering.getOfferingId());
                course = offering.getCourse(courseId);
                int courseLimit = course.getLimit();
                boolean courseEnrolled = false;
                if (courseLimit >= 0) {
                    if ((courseLimit -= enrollments.countEnrollmentsForCourse(courseId)) < 0) {
                        courseLimit = 0;
                    }
                    for (XEnrollment enrollment2 : enrollments.getEnrollmentsForCourse(courseId)) {
                        if (!enrollment2.getStudentId().equals(studentId)) continue;
                        ++courseLimit;
                        courseEnrolled = true;
                        break;
                    }
                }
                clonedCourse = new Course(courseId.longValue(), course.getSubjectArea(), course.getCourseNumber(), clonedOffering, courseLimit, course.getProjected());
                clonedCourse.setNote(course.getNote());
                clonedCourse.setType(course.getType());
                clonedCourse.setTitle(course.getTitle());
                clonedCourse.setCreditValue(course.getMinCredit());
                OnlineSectioningServer.CourseDeadlines deadline = null;
                if (checkDeadlines) {
                    deadline = server.getCourseDeadlines(courseId);
                }
                configs = new Hashtable<Long, OnlineConfig>();
                Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
                for (XConfig xConfig : offering.getConfigs()) {
                    int configLimit = xConfig.getLimit();
                    int configEnrl = enrollments.countEnrollmentsForConfig(xConfig.getConfigId());
                    boolean configStudent = false;
                    if (studentId >= 0L) {
                        for (XEnrollment xEnrollment : enrollments.getEnrollmentsForConfig(xConfig.getConfigId())) {
                            if (!xEnrollment.getStudentId().equals(studentId)) continue;
                            --configEnrl;
                            configStudent = true;
                            break;
                        }
                    }
                    if (configLimit >= 0) {
                        if ((configLimit -= configEnrl) < 0) {
                            configLimit = 0;
                        }
                        if (configStudent && configLimit == 0) {
                            configLimit = 1;
                        }
                    }
                    OnlineConfig onlineConfig = new OnlineConfig(xConfig.getConfigId().longValue(), configLimit, xConfig.getName(), clonedOffering);
                    if (xConfig.getInstructionalMethod() != null) {
                        onlineConfig.setInstructionalMethodId(xConfig.getInstructionalMethod().getUniqueId());
                        onlineConfig.setInstructionalMethodName(xConfig.getInstructionalMethod().getLabel());
                        onlineConfig.setInstructionalMethodReference(xConfig.getInstructionalMethod().getReference());
                    }
                    onlineConfig.setEnrollment(configEnrl);
                    configs.put(xConfig.getConfigId(), onlineConfig);
                    for (XSubpart xSubpart : xConfig.getSubparts()) {
                        Subpart subpart = new Subpart(xSubpart.getSubpartId().longValue(), xSubpart.getInstructionalType(), xSubpart.getName(), (Config)onlineConfig, xSubpart.getParentId() == null ? null : (Subpart)subparts.get(xSubpart.getParentId()));
                        subpart.setAllowOverlap(xSubpart.isAllowOverlap());
                        subpart.setCredit(xSubpart.getCredit(courseId));
                        subparts.put(xSubpart.getSubpartId(), subpart);
                        for (XSection section : xSubpart.getSections()) {
                            int limit = section.getLimit();
                            int enrl = enrollments.countEnrollmentsForSection(section.getSectionId());
                            boolean student = false;
                            if (studentId >= 0L) {
                                for (XEnrollment xEnrollment : enrollments.getEnrollmentsForSection(section.getSectionId())) {
                                    if (!xEnrollment.getStudentId().equals(studentId)) continue;
                                    --enrl;
                                    student = true;
                                    break;
                                }
                            }
                            if (limit >= 0) {
                                if ((limit -= enrl) < 0) {
                                    limit = 0;
                                }
                                if (student && limit == 0) {
                                    limit = 1;
                                }
                            }
                            ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>();
                            for (XRoom r : section.getRooms()) {
                                rooms.add(new RoomLocation(r.getUniqueId(), r.getName(), null, 0, 0, r.getX(), r.getY(), r.getIgnoreTooFar(), null));
                            }
                            Placement placement = section.getTime() == null ? null : new Placement(new Lecture(section.getSectionId(), null, section.getSubpartId(), section.getName(), new ArrayList(), new ArrayList(), section.getNrRooms(), null, section.getLimit(), section.getLimit(), 1.0), new TimeLocation(section.getTime().getDays(), section.getTime().getSlot(), section.getTime().getLength(), 0, 0.0, section.getTime().getDatePatternId(), section.getTime().getDatePatternName(), section.getTime().getWeeks(), section.getTime().getBreakTime()), rooms);
                            OnlineSection clonedSection = new OnlineSection(section.getSectionId().longValue(), limit, section.getName(course.getCourseId()), subpart, placement, section.toInstructors(), section.getParentId() == null ? null : sections.get(section.getParentId()));
                            clonedSection.setName(-1L, section.getName(-1L));
                            clonedSection.setNote(section.getNote());
                            clonedSection.setSpaceExpected(expectations.getExpectedSpace(section.getSectionId()).doubleValue());
                            clonedSection.setEnrollment(enrl);
                            clonedSection.setCancelled(section.isCancelled());
                            clonedSection.setEnabled(section.isEnabledForScheduling());
                            clonedSection.setAlwaysEnabled(student);
                            clonedSection.setOnline(section.isOnline());
                            clonedSection.setPast(section.isPast());
                            if (deadline != null && !deadline.checkDeadline(section.getTime(), courseEnrolled ? OnlineSectioningServer.Deadline.CHANGE : OnlineSectioningServer.Deadline.NEW)) {
                                clonedSection.setEnabled(false);
                            }
                            if (section.getTime() != null && currentDateIndex != null && !(server instanceof StudentSolver)) {
                                clonedSection.setPast(section.getTime().isPast(currentDateIndex, server.getAcademicSession()));
                            }
                            for (XDistribution distribution : offering.getDistributions()) {
                                if (distribution.getDistributionType() != XDistributionType.IngoreConflicts || !distribution.hasSection(section.getSectionId())) continue;
                                for (Long id : distribution.getSectionIds()) {
                                    if (id.equals(section.getSectionId())) continue;
                                    clonedSection.addIgnoreConflictWith(id.longValue());
                                }
                            }
                            if (limit > 0) {
                                double available = Math.round(clonedSection.getSpaceExpected() - (double)limit);
                                clonedSection.setPenalty(available / (double)section.getLimit());
                            }
                            sections.put(section.getSectionId(), (Section)clonedSection);
                        }
                    }
                }
                hasMustUse = false;
                for (XReservation reservation : offering.getReservations()) {
                    boolean applicable;
                    int reservationLimit = Math.round(reservation.getLimit());
                    if (reservationLimit >= 0) {
                        if ((reservationLimit -= enrollments.countEnrollmentsForReservation(reservation.getReservationId())) < 0) {
                            reservationLimit = 0;
                        }
                        for (XEnrollment xEnrollment : enrollments.getEnrollmentsForReservation(reservation.getReservationId())) {
                            if (!xEnrollment.getStudentId().equals(studentId)) continue;
                            ++reservationLimit;
                            break;
                        }
                        if (reservationLimit <= 0 && (!reservation.mustBeUsed() || reservation.isExpired())) continue;
                    }
                    boolean bl2 = applicable = originalStudent != null && reservation.isApplicable(originalStudent, course);
                    if (reservation instanceof XCourseReservation) {
                        applicable = ((XCourseReservation)reservation).getCourseId().equals(courseId);
                    }
                    if (reservation instanceof XDummyReservation) {
                        for (XEnrollment xEnrollment : enrollments.getEnrollmentsForCourse(courseId)) {
                            if (!xEnrollment.getStudentId().equals(studentId)) continue;
                            applicable = true;
                            break;
                        }
                    }
                    if (applicable && reservation.mustBeUsed() && (reservation.isOverride() || !reservation.isExpired())) {
                        hasMustUse = true;
                    }
                    if (!applicable && reservation.isExpired()) continue;
                    OnlineReservation onlineReservation = new OnlineReservation(reservation.getType().ordinal(), reservation.getReservationId().longValue(), clonedOffering, reservation.getPriority(), reservation.canAssignOverLimit(), reservationLimit, applicable, reservation.mustBeUsed(), reservation.isAllowOverlap(), reservation.isExpired(), reservation.isOverride());
                    onlineReservation.setAllowDisabled(reservation.isAllowDisabled());
                    onlineReservation.setNeverIncluded(reservation.neverIncluded());
                    onlineReservation.setBreakLinkedSections(reservation.canBreakLinkedSections());
                    for (Long l : reservation.getConfigsIds()) {
                        onlineReservation.addConfig((Config)configs.get(l));
                    }
                    for (Map.Entry<Long, Set<Long>> entry : reservation.getSections().entrySet()) {
                        HashSet<Section> hashSet = new HashSet<Section>();
                        for (Long sectionId : entry.getValue()) {
                            hashSet.add(sections.get(sectionId));
                        }
                        onlineReservation.getSections().put((Subpart)subparts.get(entry.getKey()), hashSet);
                    }
                }
                for (XRestriction restriction : offering.getRestrictions()) {
                    boolean applicable = originalStudent != null && restriction.isApplicable(originalStudent, course);
                    if (!applicable) continue;
                    IndividualRestriction clonnedRestriction = new IndividualRestriction(restriction.getRestrictionId().longValue(), clonedOffering, new Long[]{originalStudent.getStudentId()});
                    for (Long l : restriction.getConfigsIds()) {
                        clonnedRestriction.addConfig((Config)configs.get(l));
                    }
                    for (Map.Entry<Long, Set<Long>> entry : restriction.getSections().entrySet()) {
                        HashSet<Section> hashSet = new HashSet<Section>();
                        for (Long sectionId : entry.getValue()) {
                            hashSet.add(sections.get(sectionId));
                        }
                        clonnedRestriction.getSections().put((Subpart)subparts.get(entry.getKey()), hashSet);
                    }
                }
                if (server instanceof StudentSolver || originalStudent == null) break block79;
                XSchedulingRule xSchedulingRule = server.getSchedulingRule(originalStudent, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
                if (xSchedulingRule == null) break block80;
                if (xSchedulingRule.isDisjunctive().booleanValue()) {
                    if (!(xSchedulingRule.hasCourseName() && xSchedulingRule.matchesCourseName(course.getCourseName()) || xSchedulingRule.hasCourseType() && xSchedulingRule.matchesCourseType(course.getType()))) {
                        if (xSchedulingRule.hasInstructionalMethod()) {
                            ArrayList<Config> matchingConfigs = new ArrayList<Config>();
                            for (Config config : clonedOffering.getConfigs()) {
                                if (!xSchedulingRule.matchesInstructionalMethod(config.getInstructionalMethodReference())) continue;
                                matchingConfigs.add(config);
                            }
                            if (matchingConfigs.size() != clonedOffering.getConfigs().size()) {
                                IndividualRestriction clonnedRestriction = new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                                for (Config config : matchingConfigs) {
                                    clonnedRestriction.addConfig(config);
                                }
                            }
                        } else {
                            new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                        }
                    }
                } else if (!xSchedulingRule.matchesCourseName(course.getCourseName()) || !xSchedulingRule.matchesCourseType(course.getType())) {
                    new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                } else if (xSchedulingRule.hasInstructionalMethod()) {
                    ArrayList<Config> matchingConfigs = new ArrayList<Config>();
                    for (Config config : clonedOffering.getConfigs()) {
                        if (!xSchedulingRule.matchesInstructionalMethod(config.getInstructionalMethodReference())) continue;
                        matchingConfigs.add(config);
                    }
                    if (matchingConfigs.size() != clonedOffering.getConfigs().size()) {
                        IndividualRestriction clonnedRestriction = new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                        for (Config config : matchingConfigs) {
                            clonnedRestriction.addConfig(config);
                        }
                    }
                }
                break block79;
            }
            if (onlineOnlyFilter && (filter = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null)) != null && !filter.isEmpty()) {
                if (new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(originalStudent, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    String cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    String im = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                    if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                        new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                    } else if (im != null) {
                        ArrayList<Config> arrayList = new ArrayList<Config>();
                        for (Config config : clonedOffering.getConfigs()) {
                            if (im.isEmpty()) {
                                if (config.getInstructionalMethodReference() != null && !config.getInstructionalMethodReference().isEmpty()) continue;
                                arrayList.add(config);
                                continue;
                            }
                            if (config.getInstructionalMethodReference() == null || !config.getInstructionalMethodReference().matches(im)) continue;
                            arrayList.add(config);
                        }
                        if (arrayList.size() != clonedOffering.getConfigs().size()) {
                            IndividualRestriction individualRestriction = new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                            for (Config config : arrayList) {
                                individualRestriction.addConfig(config);
                            }
                        }
                    }
                } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                    String cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    String im = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                    if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                        new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                    } else if (im != null) {
                        ArrayList<Config> arrayList = new ArrayList<Config>();
                        for (Config config : clonedOffering.getConfigs()) {
                            if (im.isEmpty()) {
                                if (config.getInstructionalMethodReference() != null && !config.getInstructionalMethodReference().isEmpty()) continue;
                                arrayList.add(config);
                                continue;
                            }
                            if (config.getInstructionalMethodReference() == null || !config.getInstructionalMethodReference().matches(im)) continue;
                            arrayList.add(config);
                        }
                        if (arrayList.size() != clonedOffering.getConfigs().size()) {
                            IndividualRestriction individualRestriction = new IndividualRestriction(-1L, clonedOffering, new Long[]{originalStudent.getStudentId()});
                            for (Config config : arrayList) {
                                individualRestriction.addConfig(config);
                            }
                        }
                    }
                }
            }
        }
        boolean bl3 = false;
        if (offering.hasLinkedSections() && hasAssignment) {
            for (XDistribution link : offering.getDistributions()) {
                if (link.getDistributionType() != XDistributionType.LinkedSections || !link.isViolated(originalStudent, server)) continue;
                bl = true;
                break;
            }
        }
        if ((clonedOffering.hasReservations() || bl) && hasAssignment) {
            for (XEnrollment enrollment : enrollments.getEnrollmentsForCourse(courseId)) {
                if (!enrollment.getStudentId().equals(studentId)) continue;
                OnlineReservation clonedReservation = new OnlineReservation(XReservationType.Dummy.ordinal(), -2L, clonedOffering, 1000, false, 1, true, hasMustUse, false, true, true);
                clonedReservation.addConfig((Config)configs.get(enrollment.getConfigId()));
                for (Long l : enrollment.getSectionIds()) {
                    clonedReservation.addSection(sections.get(l));
                }
                clonedReservation.setBreakLinkedSections(bl);
                break;
            }
        }
        if (clonedOffering.hasRestrictions() && hasAssignment) {
            for (XEnrollment enrollment : enrollments.getEnrollmentsForCourse(courseId)) {
                if (!enrollment.getStudentId().equals(studentId)) continue;
                IndividualRestriction clonnerRestriction = new IndividualRestriction(-2L, clonedOffering, new Long[]{studentId});
                clonnerRestriction.addConfig((Config)configs.get(enrollment.getConfigId()));
                for (Long l : enrollment.getSectionIds()) {
                    clonnerRestriction.addSection(sections.get(l));
                }
            }
        }
        return clonedCourse;
    }

    public static void addRequest(OnlineSectioningServer server, StudentSectioningModel model, Assignment<Request, Enrollment> assignment, Student student, XStudent originalStudent, CourseRequestInterface.Request request, boolean alternative, boolean updateFromCache, Map<Long, Section> classTable, Set<XDistribution> distributions, boolean hasAssignment, boolean onlineOnlyFilter, OnlineSectioningHelper helper) {
        FindAssignmentAction.addRequest(server, model, assignment, student, originalStudent, request, alternative, updateFromCache, classTable, distributions, hasAssignment, false, false, null, onlineOnlyFilter, true, helper);
    }

    public static void addRequest(OnlineSectioningServer server, StudentSectioningModel model, Assignment<Request, Enrollment> assignment, Student student, XStudent originalStudent, CourseRequestInterface.Request request, boolean alternative, boolean updateFromCache, Map<Long, Section> classTable, Set<XDistribution> distributions, boolean hasAssignment, boolean onlineOnlyFilter, boolean allowRequiredPrefs, OnlineSectioningHelper helper) {
        FindAssignmentAction.addRequest(server, model, assignment, student, originalStudent, request, alternative, updateFromCache, classTable, distributions, hasAssignment, false, false, null, onlineOnlyFilter, allowRequiredPrefs, helper);
    }

    public static void addRequest(OnlineSectioningServer server, StudentSectioningModel model, Assignment<Request, Enrollment> assignment, Student student, XStudent originalStudent, CourseRequestInterface.Request request, boolean alternative, boolean updateFromCache, Map<Long, Section> classTable, Set<XDistribution> distributions, boolean hasAssignment, boolean excludeInactive, boolean checkDeadline, Integer currentDateIndex, boolean onlineOnlyFilter, boolean allowRequiredPrefs, OnlineSectioningHelper helper) {
        if (request.hasRequestedCourse()) {
            Vector<Course> cr = new Vector<Course>();
            HashSet<Choice> selChoices = new HashSet<Choice>();
            HashSet<Choice> reqChoices = new HashSet<Choice>();
            for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                if (rc.isFreeTime()) {
                    for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                        int dayCode = 0;
                        for (DayCode d : DayCode.values()) {
                            if (!freeTime.getDays().contains(d.getIndex())) continue;
                            dayCode |= d.getCode();
                        }
                        TimeLocation freeTimeLoc = new TimeLocation(dayCode, freeTime.getStart(), freeTime.getLength(), 0, 0.0, Long.valueOf(-1L), "", server.getAcademicSession().getFreeTimePattern(), 0);
                        new FreeTimeRequest((long)(student.getRequests().size() + 1), student.getRequests().size(), alternative, student, freeTimeLoc);
                    }
                    continue;
                }
                if (!rc.isCourse() || excludeInactive && rc.isInactive()) continue;
                XCourseId courseInfo = server.getCourse(rc.getCourseId(), rc.getCourseName());
                XOffering offering = null;
                if (courseInfo != null) {
                    offering = server.getOffering(courseInfo.getOfferingId());
                }
                if (offering == null) continue;
                Course course = FindAssignmentAction.clone(offering, server.getEnrollments(offering.getOfferingId()), courseInfo.getCourseId(), student.getId(), originalStudent, classTable, server, model, hasAssignment, checkDeadline, currentDateIndex, onlineOnlyFilter, helper);
                cr.add(course);
                if (rc.hasSelectedIntructionalMethods()) {
                    for (Config config : course.getOffering().getConfigs()) {
                        if (config.getInstructionalMethodId() == null || !rc.isSelectedIntructionalMethod(config.getInstructionalMethodId())) continue;
                        selChoices.add(new Choice(config));
                        if (!allowRequiredPrefs || !rc.isSelectedIntructionalMethod(config.getInstructionalMethodId(), true)) continue;
                        reqChoices.add(new Choice(config));
                    }
                }
                if (rc.hasSelectedClasses()) {
                    for (Config config : course.getOffering().getConfigs()) {
                        for (Subpart subpart : config.getSubparts()) {
                            for (Section section : subpart.getSections()) {
                                if (!rc.isSelectedClass(section.getId())) continue;
                                selChoices.add(new Choice(section));
                                if (!allowRequiredPrefs || !rc.isSelectedClass(section.getId(), true)) continue;
                                for (Section s = section; s != null; s = s.getParent()) {
                                    reqChoices.add(new Choice(s));
                                }
                                reqChoices.add(new Choice(section.getSubpart().getConfig()));
                            }
                        }
                    }
                }
                distributions.addAll(offering.getDistributions());
            }
            if (!cr.isEmpty()) {
                CourseRequest clonnedRequest = new CourseRequest((long)(student.getRequests().size() + 1), student.getRequests().size(), alternative, student, cr, request.isWaitList() || request.isNoSub(), null);
                clonnedRequest.getSelectedChoices().addAll(selChoices);
                clonnedRequest.getRequiredChoices().addAll(reqChoices);
                if (originalStudent != null) {
                    block8: for (XRequest originalRequest : originalStudent.getRequests()) {
                        XEnrollment originalEnrollment = originalRequest instanceof XCourseRequest ? ((XCourseRequest)originalRequest).getEnrollment() : null;
                        for (Course clonnedCourse : clonnedRequest.getCourses()) {
                            boolean needReservation;
                            if (originalEnrollment == null || !originalEnrollment.getCourseId().equals(clonnedCourse.getId())) continue;
                            if (!clonnedRequest.getRequiredChoices().isEmpty()) {
                                boolean config = false;
                                for (Long originalSectionId : originalEnrollment.getSectionIds()) {
                                    Section clonnedSection = classTable.get(originalSectionId);
                                    clonnedRequest.getRequiredChoices().add(new Choice(clonnedSection));
                                    if (config) continue;
                                    clonnedRequest.getRequiredChoices().add(new Choice(clonnedSection.getSubpart().getConfig()));
                                    config = true;
                                }
                            }
                            if (!clonnedCourse.getOffering().hasReservations()) continue block8;
                            boolean bl = needReservation = clonnedCourse.getOffering().getUnreservedSpace(assignment, (Request)clonnedRequest) < 1.0;
                            if (!needReservation) {
                                boolean configChecked = false;
                                for (Long originalSectionId : originalEnrollment.getSectionIds()) {
                                    Section clonnedSection = classTable.get(originalSectionId);
                                    if (clonnedSection.getUnreservedSpace(assignment, (Request)clonnedRequest) < 1.0) {
                                        needReservation = true;
                                        break;
                                    }
                                    if (!configChecked && clonnedSection.getSubpart().getConfig().getUnreservedSpace(assignment, (Request)clonnedRequest) < 1.0) {
                                        needReservation = true;
                                        break;
                                    }
                                    configChecked = true;
                                }
                            }
                            if (!needReservation) continue block8;
                            OnlineReservation reservation = new OnlineReservation(XReservationType.Dummy.ordinal(), -originalStudent.getStudentId().longValue(), clonnedCourse.getOffering(), 1000, false, 1, true, false, false, true);
                            for (Long originalSectionId : originalEnrollment.getSectionIds()) {
                                reservation.addSection(classTable.get(originalSectionId));
                            }
                            continue block8;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ClassAssignmentInterface convert(OnlineSectioningServer server, Assignment<Request, Enrollment> assignment, Enrollment[] enrollments, Hashtable<CourseRequest, Set<Section>> requiredSectionsForCourse, HashSet<FreeTimeRequest> requiredFreeTimes, boolean computeOverlaps, StudentQuality sq, Set<IdPair> savedClasses) throws SectioningException {
        DistanceMetric m = server.getDistanceMetric();
        OverExpectedCriterion overExp = server.getOverExpectedCriterion();
        ClassAssignmentInterface ret = new ClassAssignmentInterface();
        int nrUnassignedCourses = 0;
        int nrAssignedAlt = 0;
        float assignedCredit = 0.0f;
        for (Enrollment enrollment : enrollments) {
            if (enrollment == null || enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty()) continue;
            assignedCredit += enrollment.getCredit();
        }
        for (Enrollment enrollment : enrollments) {
            CourseRequest r;
            ClassAssignmentInterface.ClassAssignment a;
            if (enrollment == null || enrollment.getRequest().isAlternative() && nrAssignedAlt >= nrUnassignedCourses && (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty())) continue;
            if (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty()) {
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                if (enrollment.getRequest() instanceof CourseRequest) {
                    CourseRequest r2 = (CourseRequest)enrollment.getRequest();
                    Enrollment[] course = enrollment.getCourse();
                    if (server.isOfferingLocked(course.getOffering().getId())) {
                        ca.setLocked(true);
                    }
                    ca.setAssigned(false);
                    ca.setCourseId(course.getId());
                    ca.setSubject(course.getSubjectArea());
                    ca.setCourseNbr(course.getCourseNumber());
                    XOffering offering = server.getOffering(course.getOffering().getId());
                    ca.setTitle(offering.getCourse(course.getId()).getTitle());
                    ca.setHasCrossList(course.getOffering().getCourses().size() > 1);
                    ca.setCanWaitList(offering.isWaitList());
                    if (!r2.isWaitlist()) {
                        ++nrUnassignedCourses;
                    }
                    if (computeOverlaps) {
                        if (r2.isWaitlist()) {
                            XStudent original;
                            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                                @Override
                                public int compare(Enrollment e1, Enrollment e2) {
                                    return e1.getRequest().compareTo(e2.getRequest());
                                }
                            });
                            TreeSet<String> other = new TreeSet<String>();
                            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                            List enrls = r2.getEnrollmentsSkipSameTime(assignment);
                            Enrollment noConfEnrl = null;
                            CourseRequestInterface.RequestPriority rp = this.iRequest == null ? null : this.iRequest.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getId(), course.getName()));
                            Long swapCourseId = rp == null ? null : rp.getRequest().getWaitListSwapWithCourseOfferingId();
                            int nbrEnrl = 0;
                            for (Enrollment enrollment2 : enrls) {
                                if (!course.equals((Object)enrollment2.getCourse())) continue;
                                ++nbrEnrl;
                                boolean overlaps = false;
                                for (Enrollment x : enrollments) {
                                    if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty() || x == enrollment || x.getRequest() instanceof FreeTimeRequest && x.getRequest().getPriority() > r2.getPriority() || swapCourseId != null && x.getCourse() != null && swapCourseId.equals(x.getCourse().getId())) continue;
                                    for (SctAssignment a2 : x.getAssignments()) {
                                        if (!a2.isOverlapping(enrollment2.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)sq, (SctAssignment)a2, (Enrollment)enrollment2)) continue;
                                        overlaps = true;
                                        overlap.add(x);
                                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                                        CourseRequest cr = (CourseRequest)x.getRequest();
                                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                        if (ss == null) {
                                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                            overlapingSections.put(cr, ss);
                                        }
                                        ss.add((Section)a2);
                                    }
                                }
                                block5: for (Unavailability unavailability : r2.getStudent().getUnavailabilities()) {
                                    for (SctAssignment section : enrollment2.getAssignments()) {
                                        if (!HardDistanceConflicts.inConflict((StudentQuality)sq, (Section)((Section)section), (Unavailability)unavailability)) continue;
                                        overlaps = true;
                                        String ov = MSG.teachingAssignment(unavailability.getSection().getName());
                                        other.add(ov);
                                        continue block5;
                                    }
                                }
                                if (overlaps || noConfEnrl != null) continue;
                                noConfEnrl = enrollment2;
                            }
                            if (noConfEnrl == null) {
                                for (Enrollment enrollment3 : overlap) {
                                    if (enrollment3.getRequest() instanceof FreeTimeRequest) {
                                        ca.addOverlap(OnlineSectioningHelper.toString((FreeTimeRequest)enrollment3.getRequest()));
                                        continue;
                                    }
                                    CourseRequest cr = (CourseRequest)enrollment3.getRequest();
                                    Course o = enrollment3.getCourse();
                                    String ov = o.getSubjectArea() + " " + o.getCourseNumber();
                                    if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                        Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                        while (i.hasNext()) {
                                            Section s = (Section)i.next();
                                            ov = ov + " " + s.getSubpart().getName();
                                            if (!i.hasNext()) continue;
                                            ov = ov + ",";
                                        }
                                    }
                                    ca.addOverlap(ov);
                                }
                                for (String string : other) {
                                    ca.addOverlap(string);
                                }
                                if (nbrEnrl == 0) {
                                    block10: for (Unavailability unavailability : enrollment.getStudent().getUnavailabilities()) {
                                        for (Config config : course.getOffering().getConfigs()) {
                                            for (Subpart subpart : config.getSubparts()) {
                                                for (Section section : subpart.getSections()) {
                                                    if (!unavailability.isOverlapping((SctAssignment)section)) continue;
                                                    ca.addOverlap(MSG.teachingAssignment(unavailability.getSection().getName()));
                                                    continue block10;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (r2.getAvaiableEnrollments(assignment).isEmpty()) {
                                ca.setNotAvailable(true);
                                ca.setFull(course.getLimit() == 0);
                                ca.setHasIncompReqs(SectioningRequest.hasInconsistentRequirements(r2, course.getId()));
                            }
                            if (r2.getStudent().hasMaxCredit()) {
                                Float minCred = null;
                                for (Course c : r2.getCourses()) {
                                    if (!c.hasCreditValue() || minCred != null && !(minCred.floatValue() > c.getCreditValue().floatValue())) continue;
                                    minCred = c.getCreditValue();
                                }
                                if (minCred != null && assignedCredit + minCred.floatValue() > r2.getStudent().getMaxCredit()) {
                                    ca.setOverMaxCredit(Float.valueOf(r2.getStudent().getMaxCredit()));
                                }
                            } else if (r2.getStudent().getId() >= 0L && !(server instanceof StudentSolver) && (original = server.getStudent(r2.getStudent().getId())) != null && original.hasMaxCredit()) {
                                void var32_71;
                                Object var32_70 = null;
                                for (Course c : r2.getCourses()) {
                                    if (!c.hasCreditValue() || var32_71 != null && !(var32_71.floatValue() > c.getCreditValue().floatValue())) continue;
                                    Float f = c.getCreditValue();
                                }
                                if (var32_71 != null && assignedCredit + var32_71.floatValue() > original.getMaxCredit().floatValue()) {
                                    ca.setOverMaxCredit(original.getMaxCredit());
                                }
                            }
                        } else {
                            XStudent original;
                            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                                @Override
                                public int compare(Enrollment e1, Enrollment e2) {
                                    return e1.getRequest().compareTo(e2.getRequest());
                                }
                            });
                            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                            List avEnrls = r2.getAvaiableEnrollmentsSkipSameTime(assignment);
                            for (Enrollment enrl : avEnrls) {
                                for (Enrollment x : enrollments) {
                                    if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty() || x == enrollment) continue;
                                    for (SctAssignment a3 : x.getAssignments()) {
                                        if (!a3.isOverlapping(enrl.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)sq, (SctAssignment)a3, (Enrollment)enrl)) continue;
                                        overlap.add(x);
                                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                                        CourseRequest cr = (CourseRequest)x.getRequest();
                                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                        if (ss == null) {
                                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                            overlapingSections.put(cr, ss);
                                        }
                                        ss.add((Section)a3);
                                    }
                                }
                                block19: for (Unavailability unavailability : enrollment.getStudent().getUnavailabilities()) {
                                    for (SctAssignment section : enrl.getAssignments()) {
                                        if (!HardDistanceConflicts.inConflict((StudentQuality)sq, (Section)((Section)section), (Unavailability)unavailability)) continue;
                                        ca.addOverlap(MSG.teachingAssignment(unavailability.getSection().getName()));
                                        continue block19;
                                    }
                                }
                            }
                            for (Enrollment q : overlap) {
                                if (q.getRequest() instanceof FreeTimeRequest) {
                                    ca.addOverlap(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                    continue;
                                }
                                CourseRequest cr = (CourseRequest)q.getRequest();
                                Course o = q.getCourse();
                                String ov = o.getSubjectArea() + " " + o.getCourseNumber();
                                if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                    Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                    while (i.hasNext()) {
                                        Section section = (Section)i.next();
                                        ov = ov + " " + section.getSubpart().getName();
                                        if (!i.hasNext()) continue;
                                        ov = ov + ",";
                                    }
                                }
                                ca.addOverlap(ov);
                            }
                            block23: for (Enrollment[] unavailability : enrollment.getStudent().getUnavailabilities()) {
                                for (Config config : course.getOffering().getConfigs()) {
                                    for (Subpart subpart : config.getSubparts()) {
                                        for (Section section : subpart.getSections()) {
                                            if (section.getLimit() <= 0 || !unavailability.isOverlapping((SctAssignment)section)) continue;
                                            ca.addOverlap(MSG.teachingAssignment(unavailability.getSection().getName()));
                                            continue block23;
                                        }
                                    }
                                }
                            }
                            int alt = nrUnassignedCourses;
                            for (Enrollment x : enrollments) {
                                if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty() || x == enrollment || !x.getRequest().isAlternative() || !(x.getRequest() instanceof CourseRequest) || --alt != 0) continue;
                                Course o = x.getCourse();
                                ca.setInstead(o.getSubjectArea() + " " + o.getCourseNumber());
                                break;
                            }
                            if (avEnrls.isEmpty()) {
                                ca.setNotAvailable(true);
                                ca.setFull(course.getLimit() == 0);
                                ca.setHasIncompReqs(SectioningRequest.hasInconsistentRequirements(r2, course.getId()));
                            }
                            if (r2.getStudent().hasMaxCredit()) {
                                Float minCred = null;
                                for (Course c : r2.getCourses()) {
                                    if (!c.hasCreditValue() || minCred != null && !(minCred.floatValue() > c.getCreditValue().floatValue())) continue;
                                    minCred = c.getCreditValue();
                                }
                                if (minCred != null && assignedCredit + minCred.floatValue() > r2.getStudent().getMaxCredit()) {
                                    ca.setOverMaxCredit(Float.valueOf(r2.getStudent().getMaxCredit()));
                                }
                            } else if (r2.getStudent().getId() >= 0L && !(server instanceof StudentSolver) && (original = server.getStudent(r2.getStudent().getId())) != null && original.hasMaxCredit()) {
                                Float minCred = null;
                                for (Course c : r2.getCourses()) {
                                    if (!c.hasCreditValue() || minCred != null && !(minCred.floatValue() > c.getCreditValue().floatValue())) continue;
                                    minCred = c.getCreditValue();
                                }
                                if (minCred != null && assignedCredit + minCred.floatValue() > original.getMaxCredit().floatValue()) {
                                    ca.setOverMaxCredit(original.getMaxCredit());
                                }
                            }
                        }
                    }
                    if (r2.isWaitlist()) {
                        CourseRequestInterface.RequestPriority rp = this.iRequest == null ? null : this.iRequest.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getId(), course.getName()));
                        ca.setWaitListedDate(rp == null ? null : rp.getRequest().getWaitListedTimeStamp());
                    }
                    ret.add(ca);
                    continue;
                }
                FreeTimeRequest r2 = (FreeTimeRequest)enrollment.getRequest();
                ca.setAssigned(false);
                ca.setCourseId(null);
                if (computeOverlaps) {
                    for (Enrollment x : enrollments) {
                        if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty() || x == enrollment) continue;
                        for (SctAssignment a4 : x.getAssignments()) {
                            if (!r2.isOverlapping(a4) || !(x.getRequest() instanceof CourseRequest)) continue;
                            Course o = x.getCourse();
                            Section s = (Section)a4;
                            ca.addOverlap(o.getSubjectArea() + " " + o.getCourseNumber() + " " + s.getSubpart().getName());
                        }
                    }
                }
                if (ca.getOverlaps() == null) {
                    ca.setAssigned(true);
                }
                a = ca.addClassAssignment();
                a.setAlternative(r2.isAlternative());
                for (DayCode d : DayCode.toDayCodes(r2.getTime().getDayCode())) {
                    a.addDay(d.getIndex());
                }
                a.setStart(r2.getTime().getStartSlot());
                a.setLength(r2.getTime().getLength());
                ret.add(ca);
                continue;
            }
            if (enrollment.getRequest() instanceof CourseRequest) {
                r = (CourseRequest)enrollment.getRequest();
                Set<Section> requiredSections = null;
                if (requiredSectionsForCourse != null) {
                    requiredSections = requiredSectionsForCourse.get(r);
                }
                if (r.isAlternative() && assignment.getValue((Variable)r) != null) {
                    ++nrAssignedAlt;
                }
                TreeSet<Section> sections = new TreeSet<Section>(new EnrollmentSectionComparator());
                sections.addAll(enrollment.getSections());
                Course course = enrollment.getCourse();
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                if (server.isOfferingLocked(course.getOffering().getId())) {
                    ca.setLocked(true);
                }
                ca.setAssigned(true);
                ca.setCourseId(course.getId());
                ca.setSubject(course.getSubjectArea());
                ca.setCourseNbr(course.getCourseNumber());
                ca.setHasCrossList(course.getOffering().getCourses().size() > 1);
                boolean hasAlt = false;
                if (r.getCourses().size() > 1) {
                    hasAlt = true;
                } else if (course.getOffering().getConfigs().size() > 1) {
                    hasAlt = true;
                } else {
                    for (Subpart s : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                        if (s.getSections().size() <= 1) continue;
                        hasAlt = true;
                        break;
                    }
                }
                XOffering offering = server.getOffering(course.getOffering().getId());
                ca.setCanWaitList(offering.isWaitList());
                ca.setTitle(offering.getCourse(course.getId()).getTitle());
                XEnrollments enrl = server.getEnrollments(offering.getOfferingId());
                for (Section section : sections) {
                    int n;
                    XSubpart xSubpart;
                    Float credit;
                    Object x;
                    ClassAssignmentInterface.ClassAssignment a5 = ca.addClassAssignment();
                    a5.setAlternative(r.isAlternative());
                    a5.setClassId(section.getId());
                    a5.setSubpart(section.getSubpart().getName());
                    a5.setSection(section.getName(course.getId()));
                    a5.setExternalId(offering.getSection(section.getId()).getExternalId(course.getId()));
                    a5.setClassNumber(section.getName(-1L));
                    a5.setCancelled(section.isCancelled());
                    a5.setLimit(new int[]{enrl.countEnrollmentsForSection(section.getId()), offering.getSection(section.getId()).getLimit()});
                    if (section.getLimit() == 0) {
                        a5.setOverlapNote(MSG.sectionIsFull());
                    }
                    if (section.getTime() != null) {
                        for (DayCode d : DayCode.toDayCodes(section.getTime().getDayCode())) {
                            a5.addDay(d.getIndex());
                        }
                        a5.setStart(section.getTime().getStartSlot());
                        a5.setLength(section.getTime().getLength());
                        a5.setBreakTime(section.getTime().getBreakTime());
                        a5.setDatePattern(section.getTime().getDatePatternName());
                    } else {
                        x = offering.getSection(section.getId());
                        if (x != null && ((XSection)x).getTime() != null) {
                            a5.setDatePattern(((XSection)x).getTime().getDatePatternName());
                        }
                    }
                    if (section.getRooms() != null) {
                        for (Object rm : section.getRooms()) {
                            a5.addRoom(rm.getId(), rm.getName());
                        }
                    } else {
                        x = offering.getSection(section.getId());
                        if (x != null) {
                            Object rm;
                            rm = ((XSection)x).getRooms().iterator();
                            while (rm.hasNext()) {
                                XRoom xRoom = (XRoom)rm.next();
                                a5.addRoom(xRoom.getUniqueId(), xRoom.getName());
                            }
                        }
                    }
                    if (section.hasInstructors()) {
                        for (Instructor instructor : section.getInstructors()) {
                            a5.addInstructor(instructor.getName());
                            a5.addInstructoEmail(instructor.getEmail());
                        }
                    }
                    if (section.getParent() != null) {
                        a5.setParentSection(section.getParent().getName(course.getId()));
                    }
                    if (requiredSections != null && requiredSections.contains(section)) {
                        a5.setPinned(true);
                    }
                    a5.setSubpartId(section.getSubpart().getId());
                    a5.setHasAlternatives(hasAlt);
                    a5.addNote(course.getNote());
                    a5.addNote(section.getNote());
                    a5.setCredit(section.getSubpart().getCredit());
                    XSection xSection = offering.getSection(section.getId());
                    if (xSection != null && (credit = xSection.getCreditOverride(course.getId())) != null) {
                        a5.setCredit(FixedCreditUnitConfig.formatCredit(credit.floatValue()));
                    }
                    if ((xSubpart = offering.getSubpart(section.getSubpart().getId())) != null) {
                        a5.setCreditRange(Float.valueOf(xSubpart.getCreditMin(course.getId())), Float.valueOf(xSubpart.getCreditMax(course.getId())));
                    }
                    boolean bl = false;
                    Object from = null;
                    TreeSet<String> overlap = new TreeSet<String>();
                    for (Enrollment x2 : enrollments) {
                        if (x2 == null || !x2.isCourseRequest() || x2.getAssignments() == null || x2.getAssignments().isEmpty()) continue;
                        for (Section s : x2.getSections()) {
                            int n2;
                            if (s == section || s.getTime() == null) continue;
                            int d = this.distance(m, s, section);
                            if (d > n2) {
                                n2 = d;
                                from = "";
                                Iterator k = s.getRooms().iterator();
                                while (k.hasNext()) {
                                    from = (String)from + ((RoomLocation)k.next()).getName() + (k.hasNext() ? ", " : "");
                                }
                                from = (String)from + " (" + x2.getCourse().getName() + " " + s.getSubpart().getName() + " " + s.getName(x2.getCourse().getId()) + ")";
                            }
                            if (sq.hasDistanceConflict(enrollment.getStudent(), s, section) && s.getTime().getStartSlot() < section.getTime().getStartSlot()) {
                                a5.setDistanceConflict(true);
                                a5.setLongDistanceConflict(sq.getStudentQualityContext().getDistanceInMinutes(s.getPlacement(), section.getPlacement()) >= sq.getStudentQualityContext().getDistanceMetric().getDistanceLongLimitInMinutes());
                            }
                            if (section.getTime() == null || !section.getTime().hasIntersection(s.getTime()) || section.isToIgnoreStudentConflictsWith(s.getId())) continue;
                            overlap.add(MSG.clazz(x2.getCourse().getSubjectArea(), x2.getCourse().getCourseNumber(), s.getSubpart().getName(), s.getName(x2.getCourse().getId())));
                        }
                    }
                    for (Unavailability unavailability : enrollment.getStudent().getUnavailabilities()) {
                        if (section.getTime() != null && unavailability.getTime() != null && section.getTime().hasIntersection(unavailability.getTime())) {
                            overlap.add(unavailability.getSection().getName());
                            continue;
                        }
                        if (!StudentQuality.Type.UnavailabilityDistance.inConflict(sq.getStudentQualityContext(), (SctAssignment)section, (SctAssignment)unavailability)) continue;
                        a5.setDistanceConflict(true);
                        int d = sq.getStudentQualityContext().getUnavailabilityDistanceInMinutes(section.getPlacement(), unavailability);
                        a5.setLongDistanceConflict(d >= sq.getStudentQualityContext().getUnavailabilityDistanceMetric().getDistanceLongLimitInMinutes());
                        if (d <= n) continue;
                        n = d;
                        from = "";
                        Iterator k = unavailability.getRooms().iterator();
                        while (k.hasNext()) {
                            from = (String)from + ((RoomLocation)k.next()).getName() + (k.hasNext() ? ", " : "");
                        }
                        from = (String)from + " (" + unavailability.getCourseName() + " " + unavailability.getSectionName() + ")";
                    }
                    if (!overlap.isEmpty()) {
                        Object note = null;
                        Iterator j = overlap.iterator();
                        while (j.hasNext()) {
                            String n3 = (String)j.next();
                            if (note == null) {
                                if (section.getLimit() == 0) {
                                    note = MSG.noteFullSectionOverlapFirst(n3);
                                    continue;
                                }
                                note = MSG.noteAllowedOverlapFirst(n3);
                                continue;
                            }
                            if (j.hasNext()) {
                                note = (String)note + MSG.noteAllowedOverlapMiddle(n3);
                                continue;
                            }
                            note = (String)note + MSG.noteAllowedOverlapLast(n3);
                        }
                        a5.setOverlapNote((String)note);
                    }
                    a5.setBackToBackDistance(n);
                    a5.setBackToBackRooms((String)from);
                    if (savedClasses != null && savedClasses.contains(new IdPair(course.getId(), section.getId()))) {
                        a5.setSaved(true);
                    }
                    if (a5.getParentSection() == null) {
                        a5.setParentSection(server.getCourse(course.getId()).getConsentLabel());
                    }
                    a5.setExpected(overExp.getExpected(section.getLimit(), section.getSpaceExpected()));
                    if (this.getSpecialRegistration() == null) continue;
                    for (ClassAssignmentInterface.ClassAssignment b : this.getSpecialRegistration()) {
                        if (!b.getClassId().equals(a5.getClassId())) continue;
                        a5.setSpecRegStatus(b.getSpecRegStatus());
                        a5.setSpecRegOperation(b.getSpecRegOperation());
                        if (b.hasError()) {
                            a5.setError(b.getError());
                        }
                        if (b.hasWarn()) {
                            a5.setWarn(b.getWarn());
                        }
                        if (!b.hasInfo()) continue;
                        a5.setInfo(b.getInfo());
                    }
                }
                if (r.isWaitlist()) {
                    CourseRequestInterface.RequestPriority rp = this.iRequest == null ? null : this.iRequest.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getId(), course.getName()));
                    ca.setWaitListedDate(rp == null ? null : rp.getRequest().getWaitListedTimeStamp());
                }
                ret.add(ca);
                continue;
            }
            r = (FreeTimeRequest)enrollment.getRequest();
            ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
            ca.setAssigned(true);
            ca.setCourseId(null);
            a = ca.addClassAssignment();
            a.setAlternative(r.isAlternative());
            for (DayCode d : DayCode.toDayCodes(r.getTime().getDayCode())) {
                a.addDay(d.getIndex());
            }
            a.setStart(r.getTime().getStartSlot());
            a.setLength(r.getTime().getLength());
            if (requiredFreeTimes != null && requiredFreeTimes.contains(r)) {
                a.setPinned(true);
            }
            ret.add(ca);
        }
        return ret;
    }

    private ClassAssignmentInterface convert(OnlineSectioningServer server, StudentSectioningModel model, Assignment<Request, Enrollment> assignment, Student student, BranchBoundSelection.BranchBoundNeighbour neighbour, Hashtable<CourseRequest, Set<Section>> requiredSectionsForCourse, HashSet<FreeTimeRequest> requiredFreeTimes, Set<IdPair> savedClasses) throws SectioningException {
        Enrollment[] enrollments = neighbour.getAssignment();
        if (enrollments == null || enrollments.length < student.getRequests().size()) {
            throw new SectioningException(MSG.exceptionNoSolution());
        }
        int idx = 0;
        for (Request r : student.getRequests()) {
            if (enrollments[idx] == null) {
                Config c = null;
                if (r instanceof CourseRequest) {
                    c = (Config)((Course)((CourseRequest)r).getCourses().get(0)).getOffering().getConfigs().get(0);
                }
                enrollments[idx] = new Enrollment(r, 0, c, null, assignment);
            }
            ++idx;
        }
        ClassAssignmentInterface ret = this.convert(server, assignment, enrollments, requiredSectionsForCourse, requiredFreeTimes, true, model.getStudentQuality(), savedClasses);
        ret.setValue(-neighbour.value(assignment));
        return ret;
    }

    @Override
    public String name() {
        return "section";
    }

    public int distance(DistanceMetric m, Section s1, Section s2) {
        TimeLocation t2;
        if (s1.getPlacement() == null || s2.getPlacement() == null) {
            return 0;
        }
        TimeLocation t1 = s1.getTime();
        if (!t1.shareDays(t2 = s2.getTime()) || !t1.shareWeeks(t2)) {
            return 0;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            int dist;
            if (a1 + t1.getNrSlotsPerMeeting() <= a2 && (dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)s1.getPlacement(), (Placement)s2.getPlacement())) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength())) {
                return dist;
            }
        } else if (a1 + t1.getNrSlotsPerMeeting() == a2) {
            return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)s1.getPlacement(), (Placement)s2.getPlacement());
        }
        return 0;
    }

    public boolean isRequired(Enrollment enrollment, CourseRequestInterface.Request request) {
        CourseRequestInterface.RequestedCourse rc = request.getRequestedCourse(enrollment.getCourse().getId());
        if (rc == null || !rc.hasSelectedClasses() && !rc.hasSelectedIntructionalMethods()) {
            return true;
        }
        for (Section section : enrollment.getSections()) {
            boolean hasConfig = false;
            boolean hasMatchingConfig = false;
            boolean hasSubpart = false;
            boolean hasMatchingSection = false;
            boolean hasSectionReq = false;
            if (rc.hasSelectedIntructionalMethods()) {
                for (CourseRequestInterface.Preference choice : rc.getSelectedIntructionalMethods()) {
                    if (!choice.isRequired()) continue;
                    hasConfig = true;
                    if (!choice.getId().equals(section.getSubpart().getConfig().getInstructionalMethodId())) continue;
                    hasMatchingConfig = true;
                }
            }
            if (rc.hasSelectedClasses()) {
                block2: for (CourseRequestInterface.Preference choice : rc.getSelectedClasses()) {
                    if (!choice.isRequired()) continue;
                    Section reqSection = section.getSubpart().getConfig().getOffering().getSection(choice.getId().longValue());
                    hasSectionReq = true;
                    if (reqSection.getSubpart().equals((Object)section.getSubpart())) {
                        hasSubpart = true;
                        if (!reqSection.equals((Object)section)) continue;
                        hasMatchingSection = true;
                        continue;
                    }
                    if (hasMatchingConfig) continue;
                    for (Subpart subpart : section.getSubpart().getConfig().getSubparts()) {
                        if (!reqSection.getSubpart().equals((Object)subpart)) continue;
                        hasMatchingConfig = true;
                        continue block2;
                    }
                }
            }
            if (hasConfig && !hasMatchingConfig) {
                return false;
            }
            if (hasSubpart && !hasMatchingSection) {
                return false;
            }
            if (hasMatchingConfig || hasMatchingSection || !hasSectionReq) continue;
            return false;
        }
        return true;
    }

    public static class IdPair {
        private Long iId1;
        private Long iId2;

        public IdPair(Long id1, Long id2) {
            this.iId1 = id1;
            this.iId2 = id2;
        }

        public Long getId1() {
            return this.iId1;
        }

        public Long getId2() {
            return this.iId2;
        }

        public int hashCode() {
            return this.iId1.hashCode() ^ this.iId2.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof IdPair)) {
                return false;
            }
            return this.iId1.equals(((IdPair)o).iId1) && this.iId2.equals(((IdPair)o).iId2);
        }
    }

    public static class EnrollmentSectionComparator
    implements Comparator<Section> {
        public boolean isParent(Section s1, Section s2) {
            Section p1 = s1.getParent();
            if (p1 == null) {
                return false;
            }
            if (p1.equals((Object)s2)) {
                return true;
            }
            return this.isParent(p1, s2);
        }

        @Override
        public int compare(Section a, Section b) {
            if (this.isParent(a, b)) {
                return 1;
            }
            if (this.isParent(b, a)) {
                return -1;
            }
            int cmp = a.getSubpart().getInstructionalType().compareToIgnoreCase(b.getSubpart().getInstructionalType());
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(a.getId(), b.getId());
        }
    }
}

