/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.match;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseMatcherProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.SkipDisabledCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XInstructionalMethod;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

public class RuleCheckingCourseMatcherProvider
implements CourseMatcherProvider {
    @Override
    public CourseMatcher getCourseMatcher(OnlineSectioningServer server, SessionContext context, Long studentId) {
        if (server != null && !(server instanceof DatabaseServer)) {
            XSchedulingRule rule = server.getSchedulingRule(studentId, StudentSchedulingRule.Mode.Filter, context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdvisor, new Qualifiable[0]), context.hasPermissionAnySession((Object)server.getAcademicSession(), Right.StudentSchedulingAdmin, new Qualifiable[0]));
            if (rule != null) {
                return new SchedulingRuleCourseMatcher(rule);
            }
        } else {
            StudentSchedulingRule rule = StudentSchedulingRule.getRuleFilter(studentId, server, context);
            if (rule != null) {
                return new SchedulingRuleCourseMatcher(rule);
            }
        }
        return new FallbackCourseMatcher();
    }

    public static class SchedulingRuleCourseMatcher
    extends FallbackCourseMatcher {
        private static final long serialVersionUID = 1L;
        private String iCourseName;
        private String iCourseType;
        private String iInstructonalMethod;
        private Boolean iDisjunctive;

        public SchedulingRuleCourseMatcher(StudentSchedulingRule rule) {
            this.iCourseName = rule.getCourseName();
            this.iCourseType = rule.getCourseType();
            this.iInstructonalMethod = rule.getInstructonalMethod();
            this.iDisjunctive = rule.isDisjunctive();
        }

        public SchedulingRuleCourseMatcher(XSchedulingRule rule) {
            this.iCourseName = rule.getCourseName();
            this.iCourseType = rule.getCourseType();
            this.iInstructonalMethod = rule.getInstructonalMethod();
            this.iDisjunctive = rule.isDisjunctive();
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public String getCourseType() {
            return this.iCourseType;
        }

        public String getInstructonalMethod() {
            return this.iInstructonalMethod;
        }

        public Boolean isDisjunctive() {
            return this.iDisjunctive;
        }

        public boolean hasInstructionalMethod() {
            return this.getInstructonalMethod() != null && !this.getInstructonalMethod().isEmpty();
        }

        public boolean matchesInstructionalMethod(String im) {
            if (!this.hasInstructionalMethod()) {
                return true;
            }
            if (this.getInstructonalMethod().startsWith("!")) {
                return im != null && !im.matches(this.getInstructonalMethod().substring(1));
            }
            return im != null && im.matches(this.getInstructonalMethod());
        }

        public boolean matchesInstructionalMethod(InstructionalMethod im) {
            return this.matchesInstructionalMethod(im == null ? null : im.getReference());
        }

        public boolean matchesInstructionalMethod(XInstructionalMethod im) {
            return this.matchesInstructionalMethod(im == null ? null : im.getReference());
        }

        public boolean hasCourseName() {
            return this.getCourseName() != null && !this.getCourseName().isEmpty();
        }

        public boolean matchesCourseName(String cn) {
            if (!this.hasCourseName()) {
                return true;
            }
            if (this.getCourseName().startsWith("!")) {
                return cn != null && !cn.matches(this.getCourseName().substring(1));
            }
            return cn != null && cn.matches(this.getCourseName());
        }

        public boolean hasCourseType() {
            return this.getCourseType() != null && !this.getCourseType().isEmpty();
        }

        public boolean matchesCourseType(String ct) {
            if (!this.hasCourseType()) {
                return true;
            }
            if (this.getCourseType().startsWith("!")) {
                return ct != null && !ct.matches(this.getCourseType().substring(1));
            }
            return ct != null && ct.matches(this.getCourseType());
        }

        public boolean matchesCourseType(CourseType ct) {
            return this.matchesCourseType(ct == null ? null : ct.getReference());
        }

        public boolean matchesCourse(XCourseId course) {
            if (this.getServer() != null && !(this.getServer() instanceof DatabaseServer)) {
                if (this.isDisjunctive().booleanValue()) {
                    XOffering offering;
                    if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                        return true;
                    }
                    if (this.hasCourseType() && this.matchesCourseType(course.getType())) {
                        return true;
                    }
                    if (this.hasInstructionalMethod() && (offering = this.getServer().getOffering(course.getOfferingId())) != null) {
                        for (XConfig config : offering.getConfigs()) {
                            if (!this.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                            return true;
                        }
                    }
                    return false;
                }
                if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
                    return false;
                }
                if (this.hasCourseType() && !this.matchesCourseType(course.getType())) {
                    return false;
                }
                if (this.hasInstructionalMethod()) {
                    XOffering offering = this.getServer().getOffering(course.getOfferingId());
                    boolean hasMatchingConfig = false;
                    if (offering != null) {
                        for (XConfig config : offering.getConfigs()) {
                            if (!this.matchesInstructionalMethod(config.getInstructionalMethod())) continue;
                            hasMatchingConfig = true;
                            break;
                        }
                    }
                    if (!hasMatchingConfig) {
                        return false;
                    }
                }
                return true;
            }
            if (this.isDisjunctive().booleanValue()) {
                InstructionalOffering offering;
                if (this.hasCourseName() && this.matchesCourseName(course.getCourseName())) {
                    return true;
                }
                if (this.hasCourseType() && this.matchesCourseType(course.getType())) {
                    return true;
                }
                if (this.hasInstructionalMethod() && (offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId())) != null) {
                    for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                        if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                        return true;
                    }
                }
                return false;
            }
            if (this.hasCourseName() && !this.matchesCourseName(course.getCourseName())) {
                return false;
            }
            if (this.hasCourseType() && !this.matchesCourseType(course.getType())) {
                return false;
            }
            if (this.hasInstructionalMethod()) {
                InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId());
                boolean hasMatchingConfig = false;
                if (offering != null) {
                    for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                        if (!this.matchesInstructionalMethod(config.getEffectiveInstructionalMethod())) continue;
                        hasMatchingConfig = true;
                        break;
                    }
                }
                if (!hasMatchingConfig) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean match(XCourseId course) {
            if (!this.matchesCourse(course)) {
                return false;
            }
            return this.iShowDisabled || this.isEnabledForStudentScheduling(course);
        }
    }

    public static class FallbackCourseMatcher
    extends SkipDisabledCourseMatcher {
        private static final long serialVersionUID = 1L;
        protected boolean iShowDisabled = "true".equalsIgnoreCase(ApplicationProperty.OnlineSchedulingParameter.value("Filter.ShowDisabled", "true"));

        @Override
        protected boolean isEnabledForStudentScheduling(InstrOfferingConfig config) {
            if (this.iShowDisabledWhenNotLoaded) {
                return true;
            }
            return super.isEnabledForStudentScheduling(config);
        }

        @Override
        public boolean match(XCourseId course) {
            return this.iShowDisabled || this.isEnabledForStudentScheduling(course);
        }
    }
}

