/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import jakarta.activation.DataHandler;
import org.unitime.commons.Email;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.StudentEmailProvider;

public class BoilerConnectEmailAddress
implements StudentEmailProvider {
    @Override
    public Email createEmail(OnlineSectioningServer server, OnlineSectioningHelper helper, Boolean optional, String operation) throws Exception {
        if (optional == null) {
            if (this.isAlwaysUse(operation)) {
                return new BoilerConnectEmail(helper.getAction(), operation);
            }
            return Email.createEmail();
        }
        if (optional.booleanValue()) {
            return new BoilerConnectEmail(helper.getAction(), operation);
        }
        return Email.createEmail();
    }

    @Override
    public String getToggleCaptionIfOptional() {
        return ApplicationProperties.getProperty("purdue.boilerconnect.toggleCaption", "Send via BoilerConnect (<i>user@boilerconnect.purdue.edu</i> email address)");
    }

    @Override
    public boolean isOptionCheckedByDefault() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.boilerconnect.toggleDefault", "true"));
    }

    public boolean isAlwaysUse(String operation) {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.boilerconnect." + operation + ".enabled", ApplicationProperties.getProperty("purdue.boilerconnect.isAlwaysUse", "false")));
    }

    @Override
    public Boolean isPlainText(OnlineSectioningServer server, OnlineSectioningHelper helper, Boolean optional, String operation) {
        if (optional == null) {
            if (this.isAlwaysUse(operation)) {
                return true;
            }
            return null;
        }
        if (optional.booleanValue()) {
            return true;
        }
        return null;
    }

    static class BoilerConnectEmail
    extends Email {
        Email iEmail = Email.createEmail();
        String iReplyToEmail = null;
        String iReplyToName = null;
        String iRecipientEmail = null;
        String iRecipientName = null;
        String iSuffix = ApplicationProperties.getProperty("purdue.boilerconnect.oldSuffix", "@purdue.edu");
        String iOperation;
        OnlineSectioningLog.Action.Builder iAction;

        BoilerConnectEmail(OnlineSectioningLog.Action.Builder action, String operation) throws Exception {
            this.iAction = action;
            this.iOperation = operation;
        }

        @Override
        public void setReplyTo(String email, String name) throws Exception {
            if (email.endsWith(this.iSuffix)) {
                this.iReplyToEmail = email;
                this.iReplyToName = name;
            }
            this.iEmail.setReplyTo(email, name);
        }

        @Override
        public void addRecipient(String email, String name) throws Exception {
            if (this.iRecipientEmail == null && email.endsWith(this.iSuffix)) {
                this.iRecipientEmail = email;
                this.iRecipientName = name;
            } else {
                this.iEmail.addRecipient(email, name);
            }
        }

        protected String getSenderName() {
            return ApplicationProperties.getProperty("purdue.boilerconnect.senderName");
        }

        protected String getSenderEmail() {
            return ApplicationProperties.getProperty("purdue.boilerconnect.senderEmail");
        }

        @Override
        public void send() throws Exception {
            if (this.iRecipientEmail != null && this.iReplyToEmail != null && (this.iOperation == null || this.iOperation.startsWith("user-"))) {
                String email = this.iRecipientEmail.replace(this.iSuffix, ApplicationProperties.getProperty("purdue.boilerconnect.newSuffix", "@boilerconnect.purdue.edu"));
                this.iEmail.addRecipient(email, this.iRecipientName);
                this.setFrom(this.iReplyToEmail, this.iReplyToName);
                if (this.iAction != null) {
                    this.iAction.addOptionBuilder().setKey("bc-email").setValue(email);
                    this.iAction.addOptionBuilder().setKey("bc-sender").setValue(this.iReplyToEmail);
                }
            } else if (this.iRecipientEmail != null && this.iOperation != null && !this.iOperation.startsWith("user-")) {
                String sender;
                String email = this.iRecipientEmail.replace(this.iSuffix, ApplicationProperties.getProperty("purdue.boilerconnect.newSuffix", "@boilerconnect.purdue.edu"));
                this.iEmail.addRecipient(email, this.iRecipientName);
                if (this.iAction != null) {
                    this.iAction.addOptionBuilder().setKey("bc-email").setValue(email);
                }
                if ((sender = this.getSenderEmail()) != null && !sender.isEmpty()) {
                    this.setFrom(sender, this.getSenderName());
                    if (this.iAction != null) {
                        this.iAction.addOptionBuilder().setKey("bc-sender").setValue(sender);
                    }
                }
            } else if (this.iRecipientEmail != null) {
                this.iEmail.addRecipient(this.iRecipientEmail, this.iRecipientName);
            }
            this.iEmail.send();
        }

        @Override
        public void setSubject(String subject) throws Exception {
            this.iEmail.setSubject(subject);
        }

        @Override
        public void setFrom(String email, String name) throws Exception {
            this.iEmail.setFrom(email, name);
        }

        @Override
        public void addReplyTo(String email, String name) throws Exception {
            this.iEmail.addReplyTo(email, name);
        }

        @Override
        public void addRecipientCC(String email, String name) throws Exception {
            this.iEmail.addRecipientCC(email, name);
        }

        @Override
        public void addRecipientBCC(String email, String name) throws Exception {
            this.iEmail.addRecipientBCC(email, name);
        }

        @Override
        public void setBody(String message, String type) throws Exception {
            this.iEmail.setBody(message, type);
        }

        @Override
        public void addAttachment(String name, DataHandler data) throws Exception {
            this.iEmail.addAttachment(name, data);
        }

        @Override
        public void setInReplyTo(String messageId) throws Exception {
            this.iEmail.setInReplyTo(messageId);
        }

        @Override
        public String getMessageId() throws Exception {
            return this.iEmail.getMessageId();
        }
    }
}

