/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.dao.CurriculumCourseDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;

public class AGHCourseDetailsProvider
implements CourseDetailsProvider,
CourseUrlProvider {
    private static Log sLog = LogFactory.getLog(AGHCourseDetailsProvider.class);
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private static final long serialVersionUID = 1L;

    @Override
    public URL getCourseUrl(AcademicSessionInfo session, String subject, String courseNbr) throws SectioningException {
        CourseOffering course = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(session.getUniqueId(), subject, courseNbr);
        if (course == null) {
            throw new SectioningException("Course not found: " + subject + " " + courseNbr);
        }
        try {
            String years = this.findYears(session, subject, courseNbr);
            String url = ApplicationProperty.CustomizationDefaultCourseUrl.value();
            String externalId = course.getExternalUniqueId();
            if (years == null || years.isEmpty()) {
                return null;
            }
            if (externalId == null || externalId.isEmpty()) {
                return null;
            }
            if (url == null || url.isEmpty()) {
                return null;
            }
            return new URL(url.replace(":years", URLEncoder.encode(years, "utf-8")).replace(":term", URLEncoder.encode(session.getTerm(), "utf-8")).replace(":courseNbr", URLEncoder.encode(externalId, "utf-8")));
        }
        catch (Exception e) {
            throw new SectioningException("Failed to get course URL: " + e.getMessage(), e);
        }
    }

    private String findClassificationBySessionSubjAreaAbbvCourseNbr(Long sessionId, String subject, String courseNbr) {
        return (String)CurriculumCourseDAO.getInstance().createNewSession().createQuery("select min(cu.classification.academicClassification.code) from CurriculumCourse as cu where cu.course.subjectAreaAbbv = :subjArea and cu.course.courseNbr = :crsNbr and cu.course.instructionalOffering.session.uniqueId = :acadSessionId", String.class).setParameter("crsNbr", (Object)courseNbr).setParameter("subjArea", (Object)subject).setParameter("acadSessionId", (Object)sessionId).setMaxResults(1).uniqueResult();
    }

    @Override
    public String getDetails(AcademicSessionInfo session, String subject, String courseNbr) throws SectioningException {
        CourseOffering course = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(session.getUniqueId(), subject, courseNbr);
        if (ApplicationProperty.CustomizationDefaultCourseDetailsDownload.isTrue()) {
            URL url = this.getApiUrl(session, subject, courseNbr);
            URL courseUrl = this.getCourseUrl(session, subject, courseNbr);
            if (url != null) {
                return this.downloadDetails(url, courseUrl, course);
            }
        }
        if (course == null) {
            return MSG.infoCourseDetailsNotAvailable(subject, courseNbr);
        }
        try {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
            cfg.setClassForTemplateLoading(AGHCourseDetailsProvider.class, "");
            cfg.setLocale(Localization.getJavaLocale());
            cfg.setOutputEncoding("utf-8");
            Template template = cfg.getTemplate("details.ftl");
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("msg", MSG);
            input.put("const", CONST);
            input.put("session", session);
            input.put("course", course);
            StringWriter s = new StringWriter();
            template.process(input, (Writer)new PrintWriter(s));
            s.flush();
            s.close();
            return s.toString();
        }
        catch (TemplateException e) {
            throw new SectioningException(MSG.failedLoadCourseDetails(e.getMessage()));
        }
        catch (IOException e) {
            throw new SectioningException(MSG.failedLoadCourseDetails(e.getMessage()));
        }
    }

    private URL getApiUrl(AcademicSessionInfo session, String subject, String courseNbr) {
        CourseOffering course = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(session.getUniqueId(), subject, courseNbr);
        if (course == null) {
            throw new SectioningException("Course not found: " + subject + " " + courseNbr);
        }
        try {
            String url = ApplicationProperties.getConfigProperties().getProperty("unitime.custom.default.course_api_url", "http://syllabuskrk.agh.edu.pl/api/:years/modules/:courseNbr");
            String externalId = course.getExternalUniqueId();
            if (externalId == null || externalId.isEmpty()) {
                return null;
            }
            if (url == null || url.isEmpty()) {
                return null;
            }
            String years = this.findYears(session, subject, courseNbr);
            if (years == null || years.isEmpty()) {
                return null;
            }
            return new URL(url.replace(":years", URLEncoder.encode(years, "utf-8")).replace(":term", URLEncoder.encode(session.getTerm(), "utf-8")).replace(":courseNbr", URLEncoder.encode(externalId, "utf-8")));
        }
        catch (Exception e) {
            throw new SectioningException("Failed to get course URL: " + e.getMessage(), e);
        }
    }

    private String findYears(AcademicSessionInfo session, String subject, String courseNbr) {
        String years = null;
        try {
            String classificationSt = this.findClassificationBySessionSubjAreaAbbvCourseNbr(session.getUniqueId(), subject, courseNbr);
            Integer classification = Integer.valueOf(classificationSt.substring(classificationSt.length() - 1));
            years = this.syllabusLink(Integer.valueOf(session.getYear()), session.getTerm(), classification);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return years;
    }

    public String syllabusLink(Integer year, String term, Integer classification) {
        Integer yearShift = 0;
        Integer academicShift = 0;
        Boolean winterApplication = false;
        Object syllabusLinkRw = "current_annual";
        winterApplication = term.toLowerCase().endsWith("zimowy") ? (classification % 2 == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)) : (classification % 2 == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false));
        academicShift = winterApplication != false ? Integer.valueOf(1) : Integer.valueOf(0);
        yearShift = (classification + academicShift) / 2;
        Integer yearLink = year - yearShift;
        syllabusLinkRw = yearLink.toString() + "-" + Integer.valueOf(yearLink + 1).toString();
        return syllabusLinkRw;
    }

    private String downloadDetails(URL url, URL courseUrl, CourseOffering utCourse) throws SectioningException {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Accept-Language", "pl");
            Gson gson = new Gson();
            InputStream is = con.getInputStream();
            InputStreamReader reader = new InputStreamReader(is);
            JsonObject syllabusCourse = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            JsonObject owner = syllabusCourse.get("owner").getAsJsonObject();
            JsonArray modules = syllabusCourse.get("module_activities").getAsJsonArray();
            JsonArray instructors = syllabusCourse.get("lecturers").getAsJsonArray();
            ArrayList<JsonObject> cList = new ArrayList<JsonObject>();
            for (int i = 0; i < modules.size(); ++i) {
                cList.add(modules.get(i).getAsJsonObject());
            }
            ArrayList<JsonObject> iList = new ArrayList<JsonObject>();
            for (int i = 0; i < instructors.size(); ++i) {
                iList.add(instructors.get(i).getAsJsonObject());
            }
            JsonArray study_plans = syllabusCourse.get("study_plans").getAsJsonArray();
            ArrayList<JsonObject> pList = new ArrayList<JsonObject>();
            for (int i = 0; i < study_plans.size(); ++i) {
                pList.add(study_plans.get(i).getAsJsonObject());
            }
            try {
                DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_23);
                SimpleSequence classList = new SimpleSequence(cList, (ObjectWrapper)builder.build());
                SimpleSequence instructorsList = new SimpleSequence(iList, (ObjectWrapper)builder.build());
                SimpleSequence plansList = new SimpleSequence(pList, (ObjectWrapper)builder.build());
                Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
                cfg.setClassForTemplateLoading(AGHCourseDetailsProvider.class, "");
                cfg.setLocale(Localization.getJavaLocale());
                cfg.setOutputEncoding("utf-8");
                Template template = cfg.getTemplate("agh_details.ftl");
                HashMap<String, Object> input = new HashMap<String, Object>();
                input.put("msg", MSG);
                input.put("const", CONST);
                input.put("url", courseUrl.toString());
                input.put("syllabusCourse", syllabusCourse);
                input.put("utCourse", utCourse);
                input.put("owner", owner);
                input.put("classList", classList);
                input.put("instructorsList", instructorsList);
                input.put("plansList", plansList);
                StringWriter s = new StringWriter();
                template.process(input, (Writer)new PrintWriter(s));
                s.flush();
                s.close();
                return s.toString();
            }
            catch (TemplateException e) {
                throw new SectioningException(MSG.failedLoadCourseDetails(e.getMessage()));
            }
            catch (IOException e) {
                throw new SectioningException(MSG.failedLoadCourseDetails(e.getMessage()));
            }
        }
        catch (IOException e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(MSG.exceptionCustomCourseDetailsFailed("unable to read <a href='" + String.valueOf(url) + "'>course detail page</a>"), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SectioningException(MSG.exceptionCustomCourseDetailsFailed("unable to read <a href='" + String.valueOf(url) + "'>course detail page</a>"), e);
        }
    }

    public static void main(String[] args) {
        try {
            Debug.info(" - Initializing Hibernate ... ");
            HibernateUtil.initialize();
            ApplicationProperties.getConfigProperties().setProperty(ApplicationProperty.CustomizationDefaultCourseUrl.key(), "http://syllabuskrk.agh.edu.pl/:years/pl/magnesite/modules/:courseNbr");
            ApplicationProperties.getConfigProperties().setProperty("unitime.custom.default.course_api_url", "http://syllabuskrk.agh.edu.pl/api/:years/modules/:courseNbr");
            ApplicationProperties.getDefaultProperties().setProperty(ApplicationProperty.CustomizationDefaultCourseDetailsDownload.key(), "true");
            System.out.println("URL:" + String.valueOf(new AGHCourseDetailsProvider().getCourseUrl(new AcademicSessionInfo(231379L, "2015", "Semestr zimowy", "AGH"), "BAND", "101")));
            System.out.println("Details:\n" + new AGHCourseDetailsProvider().getDetails(new AcademicSessionInfo(231379L, "2015", "Semestr zimowy", "AGH"), "BAND", "101"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

