/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Comparator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;

public class InstructionalOfferingComparator
implements Comparator {
    private Long subjectUID;

    public InstructionalOfferingComparator(Long subjectUID) {
        this.subjectUID = subjectUID;
    }

    public int compare(Object o1, Object o2) {
        InstructionalOffering i1 = (InstructionalOffering)o1;
        InstructionalOffering i2 = (InstructionalOffering)o2;
        if (i1.getCourseOfferings() == null || i1.getCourseOfferings().isEmpty()) {
            throw new IndexOutOfBoundsException("i1 - Instructional Offering must have at least on Course Offering");
        }
        if (i2.getCourseOfferings() == null || i2.getCourseOfferings().isEmpty()) {
            throw new IndexOutOfBoundsException("i2 - Instructional Offering must have at least on Course Offering");
        }
        if (i1.getUniqueId().equals(i2.getUniqueId())) {
            return 0;
        }
        CourseOffering co1 = i1.findSortCourseOfferingForSubjectArea(this.getSubjectUID());
        CourseOffering co2 = i2.findSortCourseOfferingForSubjectArea(this.getSubjectUID());
        int cmp = co1.getSubjectAreaAbbv().compareTo(co2.getSubjectAreaAbbv());
        if (cmp != 0) {
            return cmp;
        }
        cmp = co1.getCourseNbr().compareTo(co2.getCourseNbr());
        if (cmp != 0) {
            return cmp;
        }
        return co1.getUniqueId().compareTo(co2.getUniqueId());
    }

    public Long getSubjectUID() {
        return this.subjectUID;
    }

    public void setSubjectUID(Long subjectUID) {
        this.subjectUID = subjectUID;
    }
}

